/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.monitor.internal.preprocessor;

import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.common.api.LoggerUtils;
import pro.taskana.common.api.exceptions.InvalidArgumentException;
import pro.taskana.common.internal.util.DaysToWorkingDaysConverter;
import pro.taskana.monitor.api.reports.header.TimeIntervalColumnHeader;

public class DaysToWorkingDaysReportConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(DaysToWorkingDaysReportConverter.class);
    private List<Integer> positiveDaysToWorkingDays;
    private List<Integer> negativeDaysToWorkingDays;
    private DaysToWorkingDaysConverter daysToWorkingDaysConverter;

    DaysToWorkingDaysReportConverter(List<? extends TimeIntervalColumnHeader> columnHeaders, DaysToWorkingDaysConverter daysToWorkingDaysConverter) {
        this.daysToWorkingDaysConverter = daysToWorkingDaysConverter;
        this.positiveDaysToWorkingDays = this.generatePositiveDaysToWorkingDays(columnHeaders, daysToWorkingDaysConverter.getReferenceDate());
        this.negativeDaysToWorkingDays = this.generateNegativeDaysToWorkingDays(columnHeaders, daysToWorkingDaysConverter.getReferenceDate());
    }

    public static DaysToWorkingDaysReportConverter initialize(List<? extends TimeIntervalColumnHeader> columnHeaders) throws InvalidArgumentException {
        return DaysToWorkingDaysReportConverter.initialize(columnHeaders, Instant.now());
    }

    public static DaysToWorkingDaysReportConverter initialize(List<? extends TimeIntervalColumnHeader> columnHeaders, Instant referenceDate) throws InvalidArgumentException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Initialize DaysToWorkingDaysConverter with columnHeaders: {}", (Object)LoggerUtils.listToString(columnHeaders));
        }
        if (columnHeaders == null) {
            throw new InvalidArgumentException("TimeIntervalColumnHeaders can\u00b4t be used as NULL-Parameter");
        }
        if (referenceDate == null) {
            throw new InvalidArgumentException("ReferenceDate can\u00b4t be used as NULL-Parameter");
        }
        DaysToWorkingDaysConverter daysToWorkingDaysConverter = DaysToWorkingDaysConverter.initialize(referenceDate);
        return new DaysToWorkingDaysReportConverter(columnHeaders, daysToWorkingDaysConverter);
    }

    public int convertDaysToWorkingDays(int ageInDays) {
        int minDay = -(this.negativeDaysToWorkingDays.size() - 1);
        int maxDay = this.positiveDaysToWorkingDays.size() - 1;
        if (ageInDays >= minDay && ageInDays <= 0) {
            return this.negativeDaysToWorkingDays.get(-ageInDays);
        }
        if (ageInDays > 0 && ageInDays <= maxDay) {
            return this.positiveDaysToWorkingDays.get(ageInDays);
        }
        return ageInDays;
    }

    public ArrayList<Integer> convertWorkingDaysToDays(int ageInWorkingDays) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        int minWorkingDay = this.negativeDaysToWorkingDays.get(this.negativeDaysToWorkingDays.size() - 1);
        int maxWorkingDay = this.positiveDaysToWorkingDays.get(this.positiveDaysToWorkingDays.size() - 1);
        if (ageInWorkingDays >= minWorkingDay && ageInWorkingDays < 0) {
            for (int ageInDays = 0; ageInDays < this.negativeDaysToWorkingDays.size(); ++ageInDays) {
                if (this.negativeDaysToWorkingDays.get(ageInDays) != ageInWorkingDays) continue;
                list.add(-ageInDays);
            }
            return list;
        }
        if (ageInWorkingDays > 0 && ageInWorkingDays <= maxWorkingDay) {
            for (int ageInDays = 0; ageInDays < this.positiveDaysToWorkingDays.size(); ++ageInDays) {
                if (this.positiveDaysToWorkingDays.get(ageInDays) != ageInWorkingDays) continue;
                list.add(ageInDays);
            }
            return list;
        }
        if (ageInWorkingDays == 0) {
            int ageInDays;
            list.add(0);
            for (ageInDays = 1; ageInDays < this.positiveDaysToWorkingDays.size(); ++ageInDays) {
                if (this.positiveDaysToWorkingDays.get(ageInDays) != ageInWorkingDays) continue;
                list.add(ageInDays);
            }
            for (ageInDays = 1; ageInDays < this.negativeDaysToWorkingDays.size(); ++ageInDays) {
                if (this.negativeDaysToWorkingDays.get(ageInDays) != ageInWorkingDays) continue;
                list.add(-ageInDays);
            }
            return list;
        }
        list.add(ageInWorkingDays);
        return list;
    }

    protected List<Integer> generateNegativeDaysToWorkingDays(List<? extends TimeIntervalColumnHeader> columnHeaders, Instant referenceDate) {
        int minUpperLimit = TimeIntervalColumnHeader.getSmallestUpperLimit(columnHeaders);
        ArrayList<Integer> daysToWorkingDays = new ArrayList<Integer>();
        daysToWorkingDays.add(0);
        int day = -1;
        int workingDay = 0;
        while (workingDay > minUpperLimit) {
            daysToWorkingDays.add(workingDay -= this.daysToWorkingDaysConverter.isWorkingDay(day--, referenceDate) ? 1 : 0);
        }
        return daysToWorkingDays;
    }

    protected List<Integer> generatePositiveDaysToWorkingDays(List<? extends TimeIntervalColumnHeader> columnHeaders, Instant referenceDate) {
        int maxLowerLimit = TimeIntervalColumnHeader.getLargestLowerLimit(columnHeaders);
        ArrayList<Integer> daysToWorkingDays = new ArrayList<Integer>();
        daysToWorkingDays.add(0);
        int day = 1;
        int workingDay = 0;
        while (workingDay < maxLowerLimit) {
            daysToWorkingDays.add(workingDay += this.daysToWorkingDaysConverter.isWorkingDay(day++, referenceDate) ? 1 : 0);
        }
        return daysToWorkingDays;
    }

    public String toString() {
        return "DaysToWorkingDaysReportConverter [positiveDaysToWorkingDays=" + this.positiveDaysToWorkingDays + ", negativeDaysToWorkingDays=" + this.negativeDaysToWorkingDays + ", daysToWorkingDaysConverter=" + this.daysToWorkingDaysConverter + "]";
    }
}

