/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.task.api;

import java.util.List;
import java.util.Map;
import pro.taskana.classification.api.exceptions.ClassificationNotFoundException;
import pro.taskana.common.api.BulkOperationResults;
import pro.taskana.common.api.exceptions.ConcurrencyException;
import pro.taskana.common.api.exceptions.InvalidArgumentException;
import pro.taskana.common.api.exceptions.NotAuthorizedException;
import pro.taskana.common.api.exceptions.TaskanaException;
import pro.taskana.task.api.CallbackState;
import pro.taskana.task.api.TaskQuery;
import pro.taskana.task.api.exceptions.AttachmentPersistenceException;
import pro.taskana.task.api.exceptions.InvalidOwnerException;
import pro.taskana.task.api.exceptions.InvalidStateException;
import pro.taskana.task.api.exceptions.TaskAlreadyExistException;
import pro.taskana.task.api.exceptions.TaskNotFoundException;
import pro.taskana.task.api.models.Attachment;
import pro.taskana.task.api.models.ObjectReference;
import pro.taskana.task.api.models.Task;
import pro.taskana.workbasket.api.exceptions.WorkbasketNotFoundException;

public interface TaskService {
    public Task claim(String var1) throws TaskNotFoundException, InvalidStateException, InvalidOwnerException, NotAuthorizedException;

    public Task forceClaim(String var1) throws TaskNotFoundException, InvalidStateException, InvalidOwnerException, NotAuthorizedException;

    public Task cancelClaim(String var1) throws TaskNotFoundException, InvalidStateException, InvalidOwnerException, NotAuthorizedException;

    public Task forceCancelClaim(String var1) throws TaskNotFoundException, InvalidStateException, InvalidOwnerException, NotAuthorizedException;

    public Task completeTask(String var1) throws TaskNotFoundException, InvalidOwnerException, InvalidStateException, NotAuthorizedException;

    public Task forceCompleteTask(String var1) throws TaskNotFoundException, InvalidOwnerException, InvalidStateException, NotAuthorizedException;

    public Task createTask(Task var1) throws NotAuthorizedException, WorkbasketNotFoundException, ClassificationNotFoundException, TaskAlreadyExistException, InvalidArgumentException;

    public Task getTask(String var1) throws TaskNotFoundException, NotAuthorizedException;

    public Task transfer(String var1, String var2) throws TaskNotFoundException, WorkbasketNotFoundException, NotAuthorizedException, InvalidStateException;

    public Task transfer(String var1, String var2, String var3) throws TaskNotFoundException, WorkbasketNotFoundException, NotAuthorizedException, InvalidStateException;

    public Task setTaskRead(String var1, boolean var2) throws TaskNotFoundException, NotAuthorizedException;

    public TaskQuery createTaskQuery();

    public Task newTask();

    public Task newTask(String var1);

    public Task newTask(String var1, String var2);

    public Attachment newAttachment();

    public Task updateTask(Task var1) throws InvalidArgumentException, TaskNotFoundException, ConcurrencyException, ClassificationNotFoundException, NotAuthorizedException, AttachmentPersistenceException, InvalidStateException;

    public BulkOperationResults<String, TaskanaException> transferTasks(String var1, List<String> var2) throws NotAuthorizedException, InvalidArgumentException, WorkbasketNotFoundException;

    public BulkOperationResults<String, TaskanaException> transferTasks(String var1, String var2, List<String> var3) throws NotAuthorizedException, InvalidArgumentException, WorkbasketNotFoundException;

    public void deleteTask(String var1) throws TaskNotFoundException, InvalidStateException, NotAuthorizedException;

    public void forceDeleteTask(String var1) throws TaskNotFoundException, InvalidStateException, NotAuthorizedException;

    public BulkOperationResults<String, TaskanaException> deleteTasks(List<String> var1) throws InvalidArgumentException;

    public BulkOperationResults<String, TaskanaException> completeTasks(List<String> var1) throws InvalidArgumentException;

    public List<String> updateTasks(ObjectReference var1, Map<String, String> var2) throws InvalidArgumentException;

    public List<String> updateTasks(List<String> var1, Map<String, String> var2) throws InvalidArgumentException;

    public BulkOperationResults<String, TaskanaException> setCallbackStateForTasks(List<String> var1, CallbackState var2);
}

