/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.common.api;

import java.time.Instant;
import java.util.Objects;

public class TimeInterval {
    private Instant begin;
    private Instant end;

    public TimeInterval(Instant begin, Instant end) {
        this.begin = begin;
        this.end = end;
    }

    public boolean contains(Instant i) {
        if (i == null) {
            return false;
        }
        boolean isAfterBegin = this.begin == null || !i.isBefore(this.begin);
        boolean isBeforeEnd = this.end == null || !i.isAfter(this.end);
        return isAfterBegin && isBeforeEnd;
    }

    public boolean isValid() {
        boolean isValid;
        boolean bl = isValid = this.begin != null || this.end != null;
        if (this.begin != null && this.end != null && this.begin.isAfter(this.end)) {
            isValid = false;
        }
        return isValid;
    }

    public Instant getBegin() {
        return this.begin;
    }

    public void setBegin(Instant begin) {
        this.begin = begin;
    }

    public Instant getEnd() {
        return this.end;
    }

    public void setEnd(Instant end) {
        this.end = end;
    }

    public int hashCode() {
        return Objects.hash(this.begin, this.end);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TimeInterval)) {
            return false;
        }
        TimeInterval other = (TimeInterval)obj;
        return Objects.equals(this.begin, other.begin) && Objects.equals(this.end, other.end);
    }

    public String toString() {
        return "TimeInterval [begin=" + this.begin + ", end=" + this.end + "]";
    }
}

