/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.common.internal.util;

import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import pro.taskana.common.api.exceptions.InvalidArgumentException;

public final class DaysToWorkingDaysConverter {
    private static boolean germanHolidaysEnabled;
    private static Set<LocalDate> customHolidays;
    private Instant referenceDate;
    private LocalDate easterSunday;

    private DaysToWorkingDaysConverter(Instant referenceDate) {
        this.easterSunday = DaysToWorkingDaysConverter.getEasterSunday(LocalDateTime.ofInstant(referenceDate, ZoneId.systemDefault()).getYear());
        this.referenceDate = referenceDate;
    }

    public Instant getReferenceDate() {
        return this.referenceDate;
    }

    public static DaysToWorkingDaysConverter initialize() throws InvalidArgumentException {
        return DaysToWorkingDaysConverter.initialize(Instant.now());
    }

    public static DaysToWorkingDaysConverter initialize(Instant referenceDate) throws InvalidArgumentException {
        if (referenceDate == null) {
            throw new InvalidArgumentException("ReferenceDate can\u00b4t be used as NULL-Parameter");
        }
        return new DaysToWorkingDaysConverter(referenceDate);
    }

    public static void setGermanPublicHolidaysEnabled(boolean germanPublicHolidaysEnabled) {
        germanHolidaysEnabled = germanPublicHolidaysEnabled;
    }

    public static void setCustomHolidays(List<LocalDate> holidays) {
        customHolidays = new HashSet(holidays == null ? Collections.emptyList() : holidays);
    }

    public long convertWorkingDaysToDays(Instant startTime, long numberOfDays) {
        int direction = numberOfDays >= 0L ? 1 : -1;
        long limit = Math.abs(numberOfDays);
        return LongStream.iterate(0L, i -> i + (long)direction).filter(day -> this.isWorkingDay(day, startTime)).skip(limit).findFirst().orElse(0L);
    }

    public boolean isWorkingDay(long day, Instant referenceDate) {
        LocalDateTime dateToCheck = LocalDateTime.ofInstant(referenceDate, ZoneId.systemDefault()).plusDays(day);
        return !this.isWeekend(dateToCheck) && !this.isHoliday(dateToCheck.toLocalDate());
    }

    public boolean isWeekend(LocalDateTime dateToCheck) {
        return dateToCheck.getDayOfWeek().equals(DayOfWeek.SATURDAY) || dateToCheck.getDayOfWeek().equals(DayOfWeek.SUNDAY);
    }

    public boolean isHoliday(LocalDate date) {
        if (germanHolidaysEnabled && this.isGermanHoliday(date)) {
            return true;
        }
        return customHolidays.contains(date);
    }

    public boolean isGermanHoliday(LocalDate date) {
        if (Stream.of(GermanFixHolidays.values()).anyMatch(day -> day.matches(date))) {
            return true;
        }
        long diffFromEasterSunday = ChronoUnit.DAYS.between(this.easterSunday, date);
        long goodFriday = -2L;
        long easterMonday = 1L;
        long ascensionDay = 39L;
        long whitMonday = 50L;
        return LongStream.of(goodFriday, easterMonday, ascensionDay, whitMonday).anyMatch(diff -> diff == diffFromEasterSunday);
    }

    static LocalDate getEasterSunday(int year) {
        int a = year % 19;
        int b = year % 4;
        int c = year % 7;
        int k = year / 100;
        int p = (13 + 8 * k) / 25;
        int q = k / 4;
        int m = (15 - p + k - q) % 30;
        int n = (4 + k - q) % 7;
        int d = (19 * a + m) % 30;
        int e = (2 * b + 4 * c + 6 * d + n) % 7;
        if (d == 29 && e == 6) {
            return LocalDate.of(year, 3, 15).plusDays(d + e);
        }
        if (d == 28 && e == 6 && (11 * m + 11) % 30 < 19) {
            return LocalDate.of(year, 3, 15).plusDays(d + e);
        }
        return LocalDate.of(year, 3, 22).plusDays(d + e);
    }

    public String toString() {
        return "DaysToWorkingDaysConverter{dateCreated=" + this.referenceDate + ", easterSunday=" + this.easterSunday + '}';
    }

    static {
        customHolidays = new HashSet<LocalDate>();
    }

    private static enum GermanFixHolidays {
        NEWYEAR(1, 1),
        LABOURDAY(5, 1),
        GERMANUNITY(10, 3),
        CHRISTMAS1(12, 25),
        CHRISTMAS2(12, 26);

        private int month;
        private int day;

        private GermanFixHolidays(int month, int day) {
            this.month = month;
            this.day = day;
        }

        public boolean matches(LocalDate date) {
            return date.getDayOfMonth() == this.day && date.getMonthValue() == this.month;
        }
    }
}

