/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.task.internal;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.ibatis.exceptions.PersistenceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.classification.api.ClassificationService;
import pro.taskana.classification.api.exceptions.ClassificationNotFoundException;
import pro.taskana.classification.api.models.Classification;
import pro.taskana.classification.api.models.ClassificationSummary;
import pro.taskana.common.api.BulkOperationResults;
import pro.taskana.common.api.LoggerUtils;
import pro.taskana.common.api.TaskanaRole;
import pro.taskana.common.api.exceptions.ConcurrencyException;
import pro.taskana.common.api.exceptions.InvalidArgumentException;
import pro.taskana.common.api.exceptions.NotAuthorizedException;
import pro.taskana.common.api.exceptions.SystemException;
import pro.taskana.common.api.exceptions.TaskanaException;
import pro.taskana.common.internal.CustomPropertySelector;
import pro.taskana.common.internal.InternalTaskanaEngine;
import pro.taskana.common.internal.security.CurrentUserContext;
import pro.taskana.common.internal.util.DaysToWorkingDaysConverter;
import pro.taskana.common.internal.util.IdGenerator;
import pro.taskana.common.internal.util.Pair;
import pro.taskana.spi.history.api.events.task.ClaimCancelledEvent;
import pro.taskana.spi.history.api.events.task.ClaimedEvent;
import pro.taskana.spi.history.api.events.task.CompletedEvent;
import pro.taskana.spi.history.api.events.task.CreatedEvent;
import pro.taskana.spi.history.internal.HistoryEventProducer;
import pro.taskana.task.api.CallbackState;
import pro.taskana.task.api.TaskQuery;
import pro.taskana.task.api.TaskService;
import pro.taskana.task.api.TaskState;
import pro.taskana.task.api.exceptions.AttachmentPersistenceException;
import pro.taskana.task.api.exceptions.InvalidOwnerException;
import pro.taskana.task.api.exceptions.InvalidStateException;
import pro.taskana.task.api.exceptions.TaskAlreadyExistException;
import pro.taskana.task.api.exceptions.TaskNotFoundException;
import pro.taskana.task.api.exceptions.UpdateFailedException;
import pro.taskana.task.api.models.Attachment;
import pro.taskana.task.api.models.ObjectReference;
import pro.taskana.task.api.models.Task;
import pro.taskana.task.api.models.TaskSummary;
import pro.taskana.task.internal.AttachmentMapper;
import pro.taskana.task.internal.ServiceLevelHandler;
import pro.taskana.task.internal.TaskMapper;
import pro.taskana.task.internal.TaskQueryImpl;
import pro.taskana.task.internal.TaskTransferrer;
import pro.taskana.task.internal.models.AttachmentImpl;
import pro.taskana.task.internal.models.AttachmentSummaryImpl;
import pro.taskana.task.internal.models.MinimalTaskSummary;
import pro.taskana.task.internal.models.TaskImpl;
import pro.taskana.task.internal.models.TaskSummaryImpl;
import pro.taskana.workbasket.api.WorkbasketPermission;
import pro.taskana.workbasket.api.WorkbasketService;
import pro.taskana.workbasket.api.exceptions.WorkbasketNotFoundException;
import pro.taskana.workbasket.api.models.Workbasket;
import pro.taskana.workbasket.api.models.WorkbasketSummary;
import pro.taskana.workbasket.internal.WorkbasketQueryImpl;
import pro.taskana.workbasket.internal.models.WorkbasketSummaryImpl;

public class TaskServiceImpl
implements TaskService {
    private static final String IS_ALREADY_CLAIMED_BY = " is already claimed by ";
    private static final String IS_ALREADY_COMPLETED = " is already completed.";
    private static final String TASK_WITH_ID_IS_NOT_READY = "Task with id %s is in state %s and not in state ready.";
    private static final String TASK_WITH_ID_WAS_NOT_FOUND = "Task with id %s was not found.";
    private static final String TASK_WITH_ID_CALLBACK_NOT_PROCESSED = "Task wit Id %s cannot be deleted because its callback is not yet processed";
    private static final String WAS_NOT_FOUND2 = " was not found.";
    private static final String WAS_NOT_FOUND = " was not found";
    private static final String TASK_WITH_ID = "Task with id ";
    private static final String WAS_MARKED_FOR_DELETION = " was marked for deletion";
    private static final String THE_WORKBASKET = "The workbasket ";
    private static final String TASK = "Task";
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskServiceImpl.class);
    private static final String ID_PREFIX_ATTACHMENT = "TAI";
    private static final String ID_PREFIX_TASK = "TKI";
    private static final String ID_PREFIX_EXT_TASK_ID = "ETI";
    private static final String ID_PREFIX_BUSINESS_PROCESS = "BPI";
    private static final String MUST_NOT_BE_EMPTY = " must not be empty";
    private static final Set<String> ALLOWED_KEYS = IntStream.rangeClosed(1, 16).mapToObj(String::valueOf).collect(Collectors.toSet());
    private static final Duration MAX_DURATION = Duration.ofSeconds(Long.MAX_VALUE, 999999999L);
    private DaysToWorkingDaysConverter converter;
    private InternalTaskanaEngine taskanaEngine;
    private WorkbasketService workbasketService;
    private ClassificationService classificationService;
    private TaskMapper taskMapper;
    private AttachmentMapper attachmentMapper;
    private HistoryEventProducer historyEventProducer;
    private TaskTransferrer taskTransferrer;
    private ServiceLevelHandler serviceLevelHander;

    public TaskServiceImpl(InternalTaskanaEngine taskanaEngine, TaskMapper taskMapper, AttachmentMapper attachmentMapper) {
        try {
            this.converter = DaysToWorkingDaysConverter.initialize();
        }
        catch (InvalidArgumentException e) {
            throw new SystemException("Internal error. Cannot initialize DaysToWorkingDaysConverter", e.getCause());
        }
        this.taskanaEngine = taskanaEngine;
        this.taskMapper = taskMapper;
        this.workbasketService = taskanaEngine.getEngine().getWorkbasketService();
        this.attachmentMapper = attachmentMapper;
        this.classificationService = taskanaEngine.getEngine().getClassificationService();
        this.historyEventProducer = taskanaEngine.getHistoryEventProducer();
        this.taskTransferrer = new TaskTransferrer(taskanaEngine, taskMapper, this);
        this.serviceLevelHander = new ServiceLevelHandler(taskanaEngine, taskMapper, attachmentMapper);
    }

    @Override
    public Task claim(String taskId) throws TaskNotFoundException, InvalidStateException, InvalidOwnerException, NotAuthorizedException {
        return this.claim(taskId, false);
    }

    @Override
    public Task forceClaim(String taskId) throws TaskNotFoundException, InvalidStateException, InvalidOwnerException, NotAuthorizedException {
        return this.claim(taskId, true);
    }

    @Override
    public Task cancelClaim(String taskId) throws TaskNotFoundException, InvalidStateException, InvalidOwnerException, NotAuthorizedException {
        return this.cancelClaim(taskId, false);
    }

    @Override
    public Task forceCancelClaim(String taskId) throws TaskNotFoundException, InvalidStateException, InvalidOwnerException, NotAuthorizedException {
        return this.cancelClaim(taskId, true);
    }

    @Override
    public Task completeTask(String taskId) throws TaskNotFoundException, InvalidOwnerException, InvalidStateException, NotAuthorizedException {
        return this.completeTask(taskId, false);
    }

    @Override
    public Task forceCompleteTask(String taskId) throws TaskNotFoundException, InvalidOwnerException, InvalidStateException, NotAuthorizedException {
        return this.completeTask(taskId, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Task createTask(Task taskToCreate) throws NotAuthorizedException, WorkbasketNotFoundException, ClassificationNotFoundException, TaskAlreadyExistException, InvalidArgumentException {
        LOGGER.debug("entry to createTask(task = {})", (Object)taskToCreate);
        TaskImpl task = (TaskImpl)taskToCreate;
        try {
            Workbasket workbasket;
            this.taskanaEngine.openConnection();
            if (task.getId() != null && !task.getId().equals("")) {
                throw new TaskAlreadyExistException(task.getId());
            }
            LOGGER.debug("Task {} cannot be found, so it can be created.", (Object)task.getId());
            if (task.getWorkbasketSummary().getId() != null) {
                workbasket = this.workbasketService.getWorkbasket(task.getWorkbasketSummary().getId());
            } else if (task.getWorkbasketKey() != null) {
                workbasket = this.workbasketService.getWorkbasket(task.getWorkbasketKey(), task.getDomain());
            } else {
                String workbasketId = this.taskanaEngine.getTaskRoutingManager().determineWorkbasketId(task);
                if (workbasketId != null) {
                    workbasket = this.workbasketService.getWorkbasket(workbasketId);
                    task.setWorkbasketSummary(workbasket.asSummary());
                } else {
                    throw new InvalidArgumentException("Cannot create a task outside a workbasket");
                }
            }
            if (workbasket.isMarkedForDeletion()) {
                throw new WorkbasketNotFoundException(workbasket.getId(), THE_WORKBASKET + workbasket.getId() + WAS_MARKED_FOR_DELETION);
            }
            task.setWorkbasketSummary(workbasket.asSummary());
            task.setDomain(workbasket.getDomain());
            this.workbasketService.checkAuthorization(task.getWorkbasketSummary().getId(), WorkbasketPermission.APPEND);
            String classificationKey = task.getClassificationKey();
            if (classificationKey == null || classificationKey.length() == 0) {
                throw new InvalidArgumentException("classificationKey of task must not be empty");
            }
            Classification classification = this.classificationService.getClassification(classificationKey, workbasket.getDomain());
            task.setClassificationSummary(classification.asSummary());
            this.validateObjectReference(task.getPrimaryObjRef(), "primary ObjectReference", TASK);
            PrioDurationHolder prioDurationFromAttachments = this.handleAttachments(task);
            this.standardSettings(task, classification, prioDurationFromAttachments);
            this.setCallbackStateOnTaskCreation(task);
            try {
                this.taskMapper.insert(task);
                LOGGER.debug("Method createTask() created Task '{}'.", (Object)task.getId());
                if (HistoryEventProducer.isHistoryEnabled()) {
                    this.historyEventProducer.createEvent(new CreatedEvent(task, CurrentUserContext.getUserid()));
                }
            }
            catch (PersistenceException e) {
                String msg;
                String string = msg = e.getMessage() != null ? e.getMessage().toLowerCase() : null;
                if (msg != null && (msg.contains("violation") || msg.contains("violates")) && msg.contains("external_id")) {
                    throw new TaskAlreadyExistException("Task with external id " + task.getExternalId() + " already exists");
                }
                throw e;
            }
            TaskImpl taskImpl = task;
            return taskImpl;
        }
        finally {
            this.taskanaEngine.returnConnection();
            LOGGER.debug("exit from createTask(task = {})", (Object)task);
        }
    }

    @Override
    public Task getTask(String id) throws TaskNotFoundException, NotAuthorizedException {
        LOGGER.debug("entry to getTaskById(id = {})", (Object)id);
        TaskImpl resultTask = null;
        try {
            this.taskanaEngine.openConnection();
            resultTask = this.taskMapper.findById(id);
            if (resultTask != null) {
                WorkbasketQueryImpl query = (WorkbasketQueryImpl)this.workbasketService.createWorkbasketQuery();
                query.setUsedToAugmentTasks(true);
                String workbasketId = resultTask.getWorkbasketSummary().getId();
                List workbaskets = query.idIn(workbasketId).list();
                if (workbaskets.isEmpty()) {
                    String currentUser = CurrentUserContext.getUserid();
                    throw new NotAuthorizedException("The current user " + currentUser + " has no read permission for workbasket " + workbasketId, CurrentUserContext.getUserid());
                }
                resultTask.setWorkbasketSummary((WorkbasketSummary)workbaskets.get(0));
                List<AttachmentImpl> attachmentImpls = this.attachmentMapper.findAttachmentsByTaskId(resultTask.getId());
                if (attachmentImpls == null) {
                    attachmentImpls = new ArrayList<AttachmentImpl>();
                }
                List<ClassificationSummary> classifications = this.findClassificationForTaskImplAndAttachments(resultTask, attachmentImpls);
                List<Attachment> attachments = this.addClassificationSummariesToAttachments(attachmentImpls, classifications);
                resultTask.setAttachments(attachments);
                String classificationId = resultTask.getClassificationSummary().getId();
                ClassificationSummary classification = classifications.stream().filter(c -> c.getId().equals(classificationId)).findFirst().orElse(null);
                if (classification == null) {
                    throw new SystemException("Could not find a Classification for task " + resultTask.getId());
                }
                resultTask.setClassificationSummary(classification);
                TaskImpl taskImpl = resultTask;
                return taskImpl;
            }
            throw new TaskNotFoundException(id, TASK_WITH_ID + id + WAS_NOT_FOUND);
        }
        finally {
            this.taskanaEngine.returnConnection();
            LOGGER.debug("exit from getTaskById(). Returning result {} ", (Object)resultTask);
        }
    }

    @Override
    public Task transfer(String taskId, String destinationWorkbasketId) throws TaskNotFoundException, WorkbasketNotFoundException, NotAuthorizedException, InvalidStateException {
        return this.taskTransferrer.transfer(taskId, destinationWorkbasketId);
    }

    @Override
    public Task transfer(String taskId, String workbasketKey, String domain) throws TaskNotFoundException, WorkbasketNotFoundException, NotAuthorizedException, InvalidStateException {
        return this.taskTransferrer.transfer(taskId, workbasketKey, domain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Task setTaskRead(String taskId, boolean isRead) throws TaskNotFoundException, NotAuthorizedException {
        LOGGER.debug("entry to setTaskRead(taskId = {}, isRead = {})", (Object)taskId, (Object)isRead);
        TaskImpl task = null;
        try {
            this.taskanaEngine.openConnection();
            task = (TaskImpl)this.getTask(taskId);
            task.setRead(isRead);
            task.setModified(Instant.now());
            this.taskMapper.update(task);
            LOGGER.debug("Method setTaskRead() set read property of Task '{}' to {} ", (Object)task, (Object)isRead);
            TaskImpl taskImpl = task;
            return taskImpl;
        }
        finally {
            this.taskanaEngine.returnConnection();
            LOGGER.debug("exit from setTaskRead(taskId, isRead). Returning result {} ", (Object)task);
        }
    }

    @Override
    public TaskQuery createTaskQuery() {
        return new TaskQueryImpl(this.taskanaEngine);
    }

    @Override
    public Task newTask() {
        return this.newTask(null);
    }

    @Override
    public Task newTask(String workbasketId) {
        TaskImpl task = new TaskImpl();
        WorkbasketSummaryImpl wb = new WorkbasketSummaryImpl();
        wb.setId(workbasketId);
        task.setWorkbasketSummary(wb);
        task.setCallbackState(CallbackState.NONE);
        return task;
    }

    @Override
    public Task newTask(String workbasketKey, String domain) {
        LOGGER.debug("entry to newTask(workbasketKey = {}, domain = {})", (Object)workbasketKey, (Object)domain);
        TaskImpl task = new TaskImpl();
        WorkbasketSummaryImpl wb = new WorkbasketSummaryImpl();
        wb.setKey(workbasketKey);
        wb.setDomain(domain);
        task.setWorkbasketSummary(wb);
        LOGGER.debug("exit from newTask(), returning {}", (Object)task);
        return task;
    }

    @Override
    public Attachment newAttachment() {
        return new AttachmentImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Task updateTask(Task task) throws InvalidArgumentException, TaskNotFoundException, ConcurrencyException, ClassificationNotFoundException, NotAuthorizedException, AttachmentPersistenceException, InvalidStateException {
        String userId = CurrentUserContext.getUserid();
        LOGGER.debug("entry to updateTask(task = {}, userId = {})", (Object)task, (Object)userId);
        TaskImpl newTaskImpl = (TaskImpl)task;
        try {
            this.taskanaEngine.openConnection();
            TaskImpl oldTaskImpl = (TaskImpl)this.getTask(newTaskImpl.getId());
            PrioDurationHolder prioDurationFromAttachments = this.handleAttachmentsOnTaskUpdate(oldTaskImpl, newTaskImpl);
            this.standardUpdateActions(oldTaskImpl, newTaskImpl, prioDurationFromAttachments);
            this.taskMapper.update(newTaskImpl);
            LOGGER.debug("Method updateTask() updated task '{}' for user '{}'.", (Object)task.getId(), (Object)userId);
        }
        finally {
            this.taskanaEngine.returnConnection();
            LOGGER.debug("exit from claim()");
        }
        return task;
    }

    @Override
    public BulkOperationResults<String, TaskanaException> transferTasks(String destinationWorkbasketId, List<String> taskIds) throws NotAuthorizedException, InvalidArgumentException, WorkbasketNotFoundException {
        return this.taskTransferrer.transferTasks(destinationWorkbasketId, taskIds);
    }

    @Override
    public BulkOperationResults<String, TaskanaException> transferTasks(String destinationWorkbasketKey, String destinationWorkbasketDomain, List<String> taskIds) throws NotAuthorizedException, InvalidArgumentException, WorkbasketNotFoundException {
        return this.taskTransferrer.transferTasks(destinationWorkbasketKey, destinationWorkbasketDomain, taskIds);
    }

    @Override
    public void deleteTask(String taskId) throws TaskNotFoundException, InvalidStateException, NotAuthorizedException {
        this.deleteTask(taskId, false);
    }

    @Override
    public void forceDeleteTask(String taskId) throws TaskNotFoundException, InvalidStateException, NotAuthorizedException {
        this.deleteTask(taskId, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BulkOperationResults<String, TaskanaException> deleteTasks(List<String> taskIds) throws InvalidArgumentException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("entry to deleteTasks(tasks = {})", (Object)LoggerUtils.listToString(taskIds));
        }
        try {
            this.taskanaEngine.openConnection();
            if (taskIds == null) {
                throw new InvalidArgumentException("List of TaskIds must not be null.");
            }
            BulkOperationResults<String, TaskanaException> bulkLog = new BulkOperationResults<String, TaskanaException>();
            if (taskIds.isEmpty()) {
                BulkOperationResults<String, TaskanaException> bulkOperationResults = bulkLog;
                return bulkOperationResults;
            }
            List<MinimalTaskSummary> taskSummaries = this.taskMapper.findExistingTasks(taskIds, null);
            Iterator<String> taskIdIterator = taskIds.iterator();
            while (taskIdIterator.hasNext()) {
                this.removeSingleTaskForTaskDeletionById(bulkLog, taskSummaries, taskIdIterator);
            }
            if (!taskIds.isEmpty()) {
                this.taskMapper.deleteMultiple(taskIds);
            }
            BulkOperationResults<String, TaskanaException> bulkOperationResults = bulkLog;
            return bulkOperationResults;
        }
        finally {
            LOGGER.debug("exit from deleteTasks()");
            this.taskanaEngine.returnConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BulkOperationResults<String, TaskanaException> completeTasks(List<String> taskIdsToBeCompleted) throws InvalidArgumentException {
        try {
            LOGGER.debug("entry to completeTasks(taskIds = {})", taskIdsToBeCompleted);
            this.taskanaEngine.openConnection();
            if (taskIdsToBeCompleted == null || taskIdsToBeCompleted.isEmpty()) {
                throw new InvalidArgumentException("TaskIds can\u00b4t be used as NULL-Parameter.");
            }
            BulkOperationResults<String, TaskanaException> bulkLog = new BulkOperationResults<String, TaskanaException>();
            ArrayList<String> taskIds = new ArrayList<String>(taskIdsToBeCompleted);
            this.removeNonExistingTasksFromTaskIdList(taskIds, bulkLog);
            List<TaskSummary> taskSummaries = this.createTaskQuery().idIn(taskIds.toArray(new String[0])).list();
            this.checkIfTasksMatchCompleteCriteria(taskIds, taskSummaries, bulkLog);
            this.updateTasksToBeCompleted(taskIds, taskSummaries);
            BulkOperationResults<String, TaskanaException> bulkOperationResults = bulkLog;
            return bulkOperationResults;
        }
        finally {
            this.taskanaEngine.returnConnection();
            LOGGER.debug("exit from to completeTasks(taskIds = {})", taskIdsToBeCompleted);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> updateTasks(ObjectReference selectionCriteria, Map<String, String> customFieldsToUpdate) throws InvalidArgumentException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("entry to updateTasks(selectionCriteria = {}, customFieldsToUpdate = {})", (Object)selectionCriteria, customFieldsToUpdate);
        }
        this.validateObjectReference(selectionCriteria, "ObjectReference", "updateTasks call");
        this.validateCustomFields(customFieldsToUpdate);
        CustomPropertySelector fieldSelector = new CustomPropertySelector();
        TaskImpl updated = this.initUpdatedTask(customFieldsToUpdate, fieldSelector);
        try {
            this.taskanaEngine.openConnection();
            List<TaskSummary> taskSummaries = this.getTasksToChange(selectionCriteria);
            List<String> changedTasks = new ArrayList<String>();
            if (!taskSummaries.isEmpty()) {
                changedTasks = taskSummaries.stream().map(TaskSummary::getId).collect(Collectors.toList());
                this.taskMapper.updateTasks(changedTasks, updated, fieldSelector);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("updateTasks() updated the following tasks: {} ", (Object)LoggerUtils.listToString(changedTasks));
                }
            } else {
                LOGGER.debug("updateTasks() found no tasks for update ");
            }
            ArrayList<String> arrayList = changedTasks;
            return arrayList;
        }
        finally {
            LOGGER.debug("exit from updateTasks().");
            this.taskanaEngine.returnConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> updateTasks(List<String> taskIds, Map<String, String> customFieldsToUpdate) throws InvalidArgumentException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("entry to updateTasks(taskIds = {}, customFieldsToUpdate = {})", taskIds, customFieldsToUpdate);
        }
        this.validateCustomFields(customFieldsToUpdate);
        CustomPropertySelector fieldSelector = new CustomPropertySelector();
        TaskImpl updatedTask = this.initUpdatedTask(customFieldsToUpdate, fieldSelector);
        try {
            this.taskanaEngine.openConnection();
            List<TaskSummary> taskSummaries = this.getTasksToChange(taskIds);
            List<String> changedTasks = new ArrayList<String>();
            if (!taskSummaries.isEmpty()) {
                changedTasks = taskSummaries.stream().map(TaskSummary::getId).collect(Collectors.toList());
                this.taskMapper.updateTasks(changedTasks, updatedTask, fieldSelector);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("updateTasks() updated the following tasks: {} ", (Object)LoggerUtils.listToString(changedTasks));
                }
            } else {
                LOGGER.debug("updateTasks() found no tasks for update ");
            }
            ArrayList<String> arrayList = changedTasks;
            return arrayList;
        }
        finally {
            LOGGER.debug("exit from updateTasks().");
            this.taskanaEngine.returnConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BulkOperationResults<String, TaskanaException> setCallbackStateForTasks(List<String> externalIds, CallbackState state) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("entry to setCallbackStateForTasks(externalIds = {})", (Object)LoggerUtils.listToString(externalIds));
        }
        try {
            this.taskanaEngine.openConnection();
            BulkOperationResults<String, TaskanaException> bulkLog = new BulkOperationResults<String, TaskanaException>();
            if (externalIds == null || externalIds.isEmpty()) {
                BulkOperationResults<String, TaskanaException> bulkOperationResults = bulkLog;
                return bulkOperationResults;
            }
            List<MinimalTaskSummary> taskSummaries = this.taskMapper.findExistingTasks(null, externalIds);
            Iterator<String> taskIdIterator = externalIds.iterator();
            while (taskIdIterator.hasNext()) {
                this.removeSingleTaskForCallbackStateByExternalId(bulkLog, taskSummaries, taskIdIterator, state);
            }
            if (!externalIds.isEmpty()) {
                this.taskMapper.setCallbackStateMultiple(externalIds, state);
            }
            BulkOperationResults<String, TaskanaException> bulkOperationResults = bulkLog;
            return bulkOperationResults;
        }
        finally {
            LOGGER.debug("exit from setCallbckStateForTasks()");
            this.taskanaEngine.returnConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BulkOperationResults<String, TaskanaException> setOwnerOfTasks(String owner, List<String> argTaskIds) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("entry to setOwnerOfTasks(owner = {}, tasks = {})", (Object)owner, (Object)LoggerUtils.listToString(argTaskIds));
        }
        BulkOperationResults<String, TaskanaException> bulkLog = new BulkOperationResults<String, TaskanaException>();
        if (argTaskIds == null || argTaskIds.isEmpty()) {
            return bulkLog;
        }
        List<String> taskIds = argTaskIds.stream().distinct().collect(Collectors.toList());
        int requestSize = taskIds.size();
        try {
            this.taskanaEngine.openConnection();
            Pair<List<String>, BulkOperationResults<String, TaskanaException>> resultsPair = this.filterForAuthorizedTasks(taskIds);
            taskIds = resultsPair.getLeft();
            bulkLog.addAllErrors(resultsPair.getRight());
            if (taskIds.isEmpty()) {
                BulkOperationResults<String, TaskanaException> bulkOperationResults = bulkLog;
                return bulkOperationResults;
            }
            int numberOfAffectedTasks = this.taskMapper.setOwnerOfTasks(owner, taskIds, Instant.now());
            if (numberOfAffectedTasks == taskIds.size()) {
                BulkOperationResults<String, TaskanaException> bulkOperationResults = bulkLog;
                return bulkOperationResults;
            }
            List<MinimalTaskSummary> existingMinimalTaskSummaries = this.taskMapper.findExistingTasks(taskIds, null);
            bulkLog.addAllErrors(this.serviceLevelHander.addExceptionsForNonExistingTasks(taskIds, existingMinimalTaskSummaries));
            bulkLog.addAllErrors(this.addExceptionsForTasksWhoseOwnerWasNotSet(owner, existingMinimalTaskSummaries));
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Received the Request to set owner on {} tasks, actually modified tasks = {}, could not set owner on {} tasks.", new Object[]{requestSize, numberOfAffectedTasks, bulkLog.getFailedIds().size()});
            }
            BulkOperationResults<String, TaskanaException> bulkOperationResults = bulkLog;
            return bulkOperationResults;
        }
        finally {
            LOGGER.debug("exit from setOwnerOfTasks()");
            this.taskanaEngine.returnConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BulkOperationResults<String, TaskanaException> setPlannedPropertyOfTasks(Instant planned, List<String> argTaskIds) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("entry to setPlannedPropertyOfTasks(planned = {}, tasks = {})", (Object)planned, (Object)LoggerUtils.listToString(argTaskIds));
        }
        try {
            this.taskanaEngine.openConnection();
            BulkOperationResults<String, TaskanaException> bulkOperationResults = this.serviceLevelHander.setPlannedPropertyOfTasksImpl(planned, argTaskIds);
            return bulkOperationResults;
        }
        finally {
            LOGGER.debug("exit from setPlannedPropertyOfTasks");
            this.taskanaEngine.returnConnection();
        }
    }

    public Set<String> findTasksIdsAffectedByClassificationChange(String classificationId) {
        LOGGER.debug("entry to findTasksIdsAffectedByClassificationChange(classificationId = {})", (Object)classificationId);
        List tasks = this.createTaskQuery().classificationIdIn(classificationId).stateIn(TaskState.READY, TaskState.CLAIMED).list();
        List<String> taskIdsFromAttachments = this.attachmentMapper.findTaskIdsAffectedByClassificationChange(classificationId);
        List<Object> filteredTaskIdsFromAttachments = taskIdsFromAttachments.isEmpty() ? new ArrayList() : this.taskMapper.filterTaskIdsForNotCompleted(taskIdsFromAttachments);
        HashSet<String> affectedTaskIds = new HashSet<String>(filteredTaskIdsFromAttachments);
        for (TaskSummary task : tasks) {
            affectedTaskIds.add(task.getId());
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("the following tasks are affected by the update of classification {} : {}", (Object)classificationId, (Object)LoggerUtils.setToString(affectedTaskIds));
        }
        LOGGER.debug("exit from findTasksIdsAffectedByClassificationChange(). ");
        return affectedTaskIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshPriorityAndDueDate(String taskId) throws ClassificationNotFoundException {
        LOGGER.debug("entry to refreshPriorityAndDueDate(taskId = {})", (Object)taskId);
        BulkOperationResults<String, Exception> bulkLog = new BulkOperationResults<String, Exception>();
        try {
            this.taskanaEngine.openConnection();
            if (taskId == null || taskId.isEmpty()) {
                return;
            }
            TaskImpl task = this.taskMapper.findById(taskId);
            List<AttachmentImpl> attachmentImpls = this.attachmentMapper.findAttachmentsByTaskId(task.getId());
            if (attachmentImpls == null) {
                attachmentImpls = new ArrayList<AttachmentImpl>();
            }
            List<Attachment> attachments = this.augmentAttachmentsByClassification(attachmentImpls, bulkLog);
            task.setAttachments(attachments);
            Classification classification = this.classificationService.getClassification(task.getClassificationSummary().getId());
            task.setClassificationSummary(classification.asSummary());
            PrioDurationHolder prioDurationFromAttachments = this.handleAttachmentsOnClassificationUpdate(task);
            this.updatePrioDueDateOnClassificationUpdate(task, prioDurationFromAttachments);
            task.setModified(Instant.now());
            this.taskMapper.update(task);
        }
        finally {
            this.taskanaEngine.returnConnection();
            LOGGER.debug("exit from refreshPriorityAndDueDate(). ");
        }
    }

    void removeNonExistingTasksFromTaskIdList(List<String> taskIds, BulkOperationResults<String, TaskanaException> bulkLog) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("entry to removeNonExistingTasksFromTaskIdList(targetWbId = {}, taskIds = {})", taskIds, bulkLog);
        }
        Iterator<String> taskIdIterator = taskIds.iterator();
        while (taskIdIterator.hasNext()) {
            String currentTaskId = taskIdIterator.next();
            if (currentTaskId != null && !currentTaskId.equals("")) continue;
            bulkLog.addError("", new InvalidArgumentException("IDs with EMPTY or NULL value are not allowed."));
            taskIdIterator.remove();
        }
        LOGGER.debug("exit from removeNonExistingTasksFromTaskIdList()");
    }

    private Duration calculateDuration(PrioDurationHolder prioDurationFromAttachments, ClassificationSummary newClassificationSummary) {
        if (newClassificationSummary.getServiceLevel() == null) {
            return null;
        }
        Duration minDuration = (Duration)prioDurationFromAttachments.getLeft();
        Duration durationFromClassification = Duration.parse(newClassificationSummary.getServiceLevel());
        if (minDuration != null) {
            if (minDuration.compareTo(durationFromClassification) > 0) {
                minDuration = durationFromClassification;
            }
        } else {
            minDuration = durationFromClassification;
        }
        return minDuration;
    }

    List<TaskSummary> augmentTaskSummariesByContainedSummaries(List<TaskSummaryImpl> taskSummaries) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("entry to augmentTaskSummariesByContainedSummaries(taskSummaries= {})", (Object)LoggerUtils.listToString(taskSummaries));
        }
        ArrayList<TaskSummary> result = new ArrayList<TaskSummary>();
        if (taskSummaries == null || taskSummaries.isEmpty()) {
            return result;
        }
        String[] taskIdArray = (String[])taskSummaries.stream().map(TaskSummaryImpl::getId).distinct().toArray(String[]::new);
        if (taskIdArray.length == 0) {
            taskIdArray = null;
        }
        LOGGER.debug("augmentTaskSummariesByContainedSummaries() about to query for attachmentSummaries ");
        List<AttachmentSummaryImpl> attachmentSummaries = this.attachmentMapper.findAttachmentSummariesByTaskIds(taskIdArray);
        List<ClassificationSummary> classifications = this.findClassificationsForTasksAndAttachments(taskSummaries, attachmentSummaries);
        this.addClassificationSummariesToTaskSummaries(taskSummaries, classifications);
        this.addWorkbasketSummariesToTaskSummaries(taskSummaries);
        this.addAttachmentSummariesToTaskSummaries(taskSummaries, attachmentSummaries, classifications);
        result.addAll(taskSummaries);
        LOGGER.debug("exit from to augmentTaskSummariesByContainedSummaries()");
        return result;
    }

    private BulkOperationResults<String, TaskanaException> addExceptionsForTasksWhoseOwnerWasNotSet(String owner, List<MinimalTaskSummary> existingMinimalTaskSummaries) {
        BulkOperationResults<String, TaskanaException> bulkLog = new BulkOperationResults<String, TaskanaException>();
        for (MinimalTaskSummary taskSummary : existingMinimalTaskSummaries) {
            if (owner.equals(taskSummary.getOwner())) continue;
            if (!taskSummary.getTaskState().equals((Object)TaskState.READY)) {
                bulkLog.addError(taskSummary.getTaskId(), new InvalidStateException(String.format(TASK_WITH_ID_IS_NOT_READY, new Object[]{taskSummary.getTaskId(), taskSummary.getTaskState()})));
                continue;
            }
            bulkLog.addError(taskSummary.getTaskId(), new UpdateFailedException(String.format("Could not set owner of Task %s .", taskSummary.getTaskId())));
        }
        return bulkLog;
    }

    private Pair<List<String>, BulkOperationResults<String, TaskanaException>> filterForAuthorizedTasks(List<String> taskIds) {
        BulkOperationResults<String, NotAuthorizedException> bulkLog = new BulkOperationResults<String, NotAuthorizedException>();
        List<String> accessIds = CurrentUserContext.getAccessIds();
        ArrayList<String> tasksAuthorizedFor = new ArrayList<String>(taskIds);
        if (!this.taskanaEngine.getEngine().isUserInRole(TaskanaRole.ADMIN)) {
            List<String> tasksNotAuthorizedFor = this.taskMapper.filterTaskIdsNotAuthorizedFor(taskIds, accessIds);
            tasksAuthorizedFor.removeAll(tasksNotAuthorizedFor);
            String currentUserId = CurrentUserContext.getUserid();
            for (String taskId : tasksNotAuthorizedFor) {
                bulkLog.addError(taskId, new NotAuthorizedException(String.format("Current user not authorized for task %s.", taskId), currentUserId));
            }
        }
        return new Pair<List<String>, BulkOperationResults<String, TaskanaException>>(tasksAuthorizedFor, bulkLog);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Task claim(String taskId, boolean forceClaim) throws TaskNotFoundException, InvalidStateException, InvalidOwnerException, NotAuthorizedException {
        TaskImpl task;
        String userId = CurrentUserContext.getUserid();
        LOGGER.debug("entry to claim(id = {}, userId = {}, forceClaim = {})", new Object[]{taskId, userId, forceClaim});
        try {
            this.taskanaEngine.openConnection();
            task = (TaskImpl)this.getTask(taskId);
            TaskState state = task.getState();
            if (state == TaskState.COMPLETED) {
                throw new InvalidStateException(TASK_WITH_ID + taskId + IS_ALREADY_COMPLETED);
            }
            if (state == TaskState.CLAIMED && !forceClaim && !task.getOwner().equals(userId)) {
                throw new InvalidOwnerException(TASK_WITH_ID + taskId + IS_ALREADY_CLAIMED_BY + task.getOwner() + ".");
            }
            Instant now = Instant.now();
            task.setOwner(userId);
            task.setModified(now);
            task.setClaimed(now);
            task.setRead(true);
            task.setState(TaskState.CLAIMED);
            this.taskMapper.update(task);
            LOGGER.debug("Task '{}' claimed by user '{}'.", (Object)taskId, (Object)userId);
            if (HistoryEventProducer.isHistoryEnabled()) {
                this.historyEventProducer.createEvent(new ClaimedEvent(task, CurrentUserContext.getUserid()));
            }
        }
        finally {
            this.taskanaEngine.returnConnection();
            LOGGER.debug("exit from claim()");
        }
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Task cancelClaim(String taskId, boolean forceUnclaim) throws TaskNotFoundException, InvalidStateException, InvalidOwnerException, NotAuthorizedException {
        TaskImpl task;
        String userId = CurrentUserContext.getUserid();
        LOGGER.debug("entry to cancelClaim(taskId = {}), userId = {}, forceUnclaim = {})", new Object[]{taskId, userId, forceUnclaim});
        try {
            this.taskanaEngine.openConnection();
            task = (TaskImpl)this.getTask(taskId);
            TaskState state = task.getState();
            if (state == TaskState.COMPLETED) {
                throw new InvalidStateException(TASK_WITH_ID + taskId + IS_ALREADY_COMPLETED);
            }
            if (state == TaskState.CLAIMED && !forceUnclaim && !userId.equals(task.getOwner())) {
                throw new InvalidOwnerException(TASK_WITH_ID + taskId + IS_ALREADY_CLAIMED_BY + task.getOwner() + ".");
            }
            Instant now = Instant.now();
            task.setOwner(null);
            task.setModified(now);
            task.setClaimed(null);
            task.setRead(true);
            task.setState(TaskState.READY);
            this.taskMapper.update(task);
            LOGGER.debug("Task '{}' unclaimed by user '{}'.", (Object)taskId, (Object)userId);
            if (HistoryEventProducer.isHistoryEnabled()) {
                this.historyEventProducer.createEvent(new ClaimCancelledEvent(task, CurrentUserContext.getUserid()));
            }
        }
        finally {
            this.taskanaEngine.returnConnection();
            LOGGER.debug("exit from cancelClaim()");
        }
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Task completeTask(String taskId, boolean isForced) throws TaskNotFoundException, InvalidOwnerException, InvalidStateException, NotAuthorizedException {
        TaskImpl task;
        String userId = CurrentUserContext.getUserid();
        LOGGER.debug("entry to completeTask(id = {}, userId = {}, isForced = {})", new Object[]{taskId, userId, isForced});
        try {
            this.taskanaEngine.openConnection();
            task = (TaskImpl)this.getTask(taskId);
            if (task.getState() == TaskState.COMPLETED) {
                TaskImpl taskImpl = task;
                return taskImpl;
            }
            if (!isForced) {
                if (task.getClaimed() == null || task.getState() != TaskState.CLAIMED) {
                    throw new InvalidStateException(TASK_WITH_ID + taskId + " has to be claimed before.");
                }
                if (!CurrentUserContext.getAccessIds().contains(task.getOwner())) {
                    throw new InvalidOwnerException(String.format("Owner of task %s is %s, but current user is %s ", taskId, task.getOwner(), userId));
                }
            } else if (task.getClaimed() == null || task.getState() != TaskState.CLAIMED) {
                task = (TaskImpl)this.forceClaim(taskId);
            }
            Instant now = Instant.now();
            task.setCompleted(now);
            task.setModified(now);
            task.setState(TaskState.COMPLETED);
            task.setOwner(userId);
            this.taskMapper.update(task);
            LOGGER.debug("Task '{}' completed by user '{}'.", (Object)taskId, (Object)userId);
            if (HistoryEventProducer.isHistoryEnabled()) {
                this.historyEventProducer.createEvent(new CompletedEvent(task, CurrentUserContext.getUserid()));
            }
        }
        finally {
            this.taskanaEngine.returnConnection();
            LOGGER.debug("exit from completeTask()");
        }
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteTask(String taskId, boolean forceDelete) throws TaskNotFoundException, InvalidStateException, NotAuthorizedException {
        LOGGER.debug("entry to deleteTask(taskId = {} , forceDelete = {})", (Object)taskId, (Object)forceDelete);
        this.taskanaEngine.getEngine().checkRoleMembership(TaskanaRole.ADMIN);
        try {
            this.taskanaEngine.openConnection();
            TaskImpl task = (TaskImpl)this.getTask(taskId);
            if (!TaskState.COMPLETED.equals((Object)task.getState()) && !forceDelete) {
                throw new InvalidStateException("Cannot delete Task " + taskId + " because it is not completed.");
            }
            if (CallbackState.CALLBACK_PROCESSING_REQUIRED.equals((Object)task.getCallbackState())) {
                throw new InvalidStateException(String.format(TASK_WITH_ID_CALLBACK_NOT_PROCESSED, taskId));
            }
            this.taskMapper.delete(taskId);
            LOGGER.debug("Task {} deleted.", (Object)taskId);
        }
        finally {
            this.taskanaEngine.returnConnection();
            LOGGER.debug("exit from deleteTask().");
        }
    }

    private void removeSingleTaskForTaskDeletionById(BulkOperationResults<String, TaskanaException> bulkLog, List<MinimalTaskSummary> taskSummaries, Iterator<String> taskIdIterator) {
        LOGGER.debug("entry to removeSingleTask()");
        String currentTaskId = taskIdIterator.next();
        if (currentTaskId == null || currentTaskId.equals("")) {
            bulkLog.addError("", new InvalidArgumentException("IDs with EMPTY or NULL value are not allowed."));
            taskIdIterator.remove();
        } else {
            MinimalTaskSummary foundSummary = taskSummaries.stream().filter(taskSummary -> currentTaskId.equals(taskSummary.getTaskId())).findFirst().orElse(null);
            if (foundSummary == null) {
                bulkLog.addError(currentTaskId, new TaskNotFoundException(currentTaskId, TASK_WITH_ID + currentTaskId + WAS_NOT_FOUND2));
                taskIdIterator.remove();
            } else if (!TaskState.COMPLETED.equals((Object)foundSummary.getTaskState())) {
                bulkLog.addError(currentTaskId, new InvalidStateException(currentTaskId));
                taskIdIterator.remove();
            } else if (CallbackState.CALLBACK_PROCESSING_REQUIRED.equals((Object)foundSummary.getCallbackState())) {
                bulkLog.addError(currentTaskId, new InvalidStateException(String.format(TASK_WITH_ID_CALLBACK_NOT_PROCESSED, currentTaskId)));
                taskIdIterator.remove();
            }
        }
        LOGGER.debug("exit from removeSingleTask()");
    }

    private void removeSingleTaskForCallbackStateByExternalId(BulkOperationResults<String, TaskanaException> bulkLog, List<MinimalTaskSummary> taskSummaries, Iterator<String> externalIdIterator, CallbackState desiredCallbackState) {
        LOGGER.debug("entry to removeSingleTask()");
        String currentExternalId = externalIdIterator.next();
        if (currentExternalId == null || currentExternalId.equals("")) {
            bulkLog.addError("", new InvalidArgumentException("IDs with EMPTY or NULL value are not allowed."));
            externalIdIterator.remove();
        } else {
            MinimalTaskSummary foundSummary = taskSummaries.stream().filter(taskSummary -> currentExternalId.equals(taskSummary.getExternalId())).findFirst().orElse(null);
            if (foundSummary == null) {
                bulkLog.addError(currentExternalId, new TaskNotFoundException(currentExternalId, TASK_WITH_ID + currentExternalId + WAS_NOT_FOUND2));
                externalIdIterator.remove();
            } else if (!this.desiredCallbackStateCanBeSetForFoundSummary(foundSummary, desiredCallbackState)) {
                bulkLog.addError(currentExternalId, new InvalidStateException(currentExternalId));
                externalIdIterator.remove();
            }
        }
        LOGGER.debug("exit from removeSingleTask()");
    }

    private boolean desiredCallbackStateCanBeSetForFoundSummary(MinimalTaskSummary foundSummary, CallbackState desiredCallbackState) {
        CallbackState currentTaskCallbackState = foundSummary.getCallbackState();
        TaskState currentTaskState = foundSummary.getTaskState();
        switch (desiredCallbackState) {
            case CALLBACK_PROCESSING_COMPLETED: {
                return currentTaskState.equals((Object)TaskState.COMPLETED);
            }
            case CLAIMED: {
                if (!currentTaskState.equals((Object)TaskState.CLAIMED)) {
                    return false;
                }
                return currentTaskCallbackState.equals((Object)CallbackState.CALLBACK_PROCESSING_REQUIRED);
            }
            case CALLBACK_PROCESSING_REQUIRED: {
                return !currentTaskCallbackState.equals((Object)CallbackState.CALLBACK_PROCESSING_COMPLETED);
            }
        }
        return false;
    }

    private void standardSettings(TaskImpl task, Classification classification, PrioDurationHolder prioDurationFromAttachments) throws InvalidArgumentException {
        List<Attachment> attachments;
        LOGGER.debug("entry to standardSettings()");
        Instant now = Instant.now();
        task.setId(IdGenerator.generateWithPrefix(ID_PREFIX_TASK));
        if (task.getExternalId() == null) {
            task.setExternalId(IdGenerator.generateWithPrefix(ID_PREFIX_EXT_TASK_ID));
        }
        task.setState(TaskState.READY);
        task.setCreated(now);
        task.setModified(now);
        task.setRead(false);
        task.setTransferred(false);
        String creator = CurrentUserContext.getUserid();
        if (this.taskanaEngine.getEngine().getConfiguration().isSecurityEnabled() && creator == null) {
            throw new SystemException("TaskanaSecurity is enabled, but the current UserId is NULL while creating a Task.");
        }
        task.setCreator(creator);
        if (task.getBusinessProcessId() == null) {
            task.setBusinessProcessId(IdGenerator.generateWithPrefix(ID_PREFIX_BUSINESS_PROCESS));
        }
        if (classification == null) {
            if (task.getPlanned() == null) {
                task.setPlanned(now);
            }
        } else {
            PrioDurationHolder finalPrioDuration = this.getNewPrioDuration(prioDurationFromAttachments, classification.getPriority(), classification.getServiceLevel());
            Duration finalDuration = (Duration)finalPrioDuration.getLeft();
            if (finalDuration != null && !MAX_DURATION.equals(finalDuration)) {
                long days;
                if (task.getDue() != null) {
                    days = this.converter.convertWorkingDaysToDays(task.getDue(), -finalDuration.toDays());
                    Instant planned = task.getDue().plus(Duration.ofDays(days));
                    if (task.getPlanned() != null && !task.getPlanned().equals(planned)) {
                        throw new InvalidArgumentException("Cannot create a task with given planned and due date not matching the service level");
                    }
                    task.setPlanned(planned);
                } else {
                    task.setPlanned(task.getPlanned() == null ? now : task.getPlanned());
                    days = this.converter.convertWorkingDaysToDays(task.getPlanned(), finalDuration.toDays());
                    Instant due = task.getPlanned().plus(Duration.ofDays(days));
                    task.setDue(due);
                }
            }
            task.setPriority((Integer)finalPrioDuration.getRight());
        }
        if (task.getName() == null && classification != null) {
            task.setName(classification.getName());
        }
        if (task.getDescription() == null && classification != null) {
            task.setDescription(classification.getDescription());
        }
        if ((attachments = task.getAttachments()) != null) {
            for (Attachment attachment : attachments) {
                AttachmentImpl attachmentImpl = (AttachmentImpl)attachment;
                attachmentImpl.setId(IdGenerator.generateWithPrefix(ID_PREFIX_ATTACHMENT));
                attachmentImpl.setTaskId(task.getId());
                attachmentImpl.setCreated(now);
                attachmentImpl.setModified(now);
                this.attachmentMapper.insert(attachmentImpl);
            }
        }
        LOGGER.debug("exit from standardSettings()");
    }

    private void setCallbackStateOnTaskCreation(TaskImpl task) throws InvalidArgumentException {
        String value;
        Map<String, String> callbackInfo = task.getCallbackInfo();
        if (callbackInfo != null && callbackInfo.containsKey("callbackState") && (value = callbackInfo.get("callbackState")) != null && !value.isEmpty()) {
            try {
                CallbackState state = CallbackState.valueOf(value);
                task.setCallbackState(state);
            }
            catch (Exception e) {
                LOGGER.warn("Attempted to determine callback state from {} and caught {}", (Object)value, (Object)e);
                throw new InvalidArgumentException("Attempted to set callback state for task " + task.getId(), e);
            }
        }
    }

    private void checkIfTasksMatchCompleteCriteria(List<String> taskIds, List<TaskSummary> taskSummaries, BulkOperationResults<String, TaskanaException> bulkLog) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("entry to checkIfTasksMatchCompleteCriteria(taskIds = {}, taskSummaries = {}, bulkLog = {})", new Object[]{LoggerUtils.listToString(taskIds), LoggerUtils.listToString(taskSummaries), bulkLog});
        }
        Instant now = Instant.now();
        Iterator<String> taskIdIterator = taskIds.iterator();
        while (taskIdIterator.hasNext()) {
            String currentTaskId = taskIdIterator.next();
            TaskSummaryImpl taskSummary = taskSummaries.stream().filter(ts -> currentTaskId.equals(ts.getId())).findFirst().orElse(null);
            if (taskSummary == null) {
                bulkLog.addError(currentTaskId, new TaskNotFoundException(currentTaskId, String.format(TASK_WITH_ID_WAS_NOT_FOUND, currentTaskId)));
                taskIdIterator.remove();
                continue;
            }
            if (taskSummary.getClaimed() == null || taskSummary.getState() != TaskState.CLAIMED) {
                bulkLog.addError(currentTaskId, new InvalidStateException(currentTaskId));
                taskIdIterator.remove();
                continue;
            }
            if (!CurrentUserContext.getAccessIds().contains(taskSummary.getOwner())) {
                bulkLog.addError(currentTaskId, new InvalidOwnerException(String.format("TaskOwner is %s, but currentUser is %s.", taskSummary.getOwner(), CurrentUserContext.getUserid())));
                taskIdIterator.remove();
                continue;
            }
            taskSummary.setCompleted(now);
            taskSummary.setModified(now);
            taskSummary.setState(TaskState.COMPLETED);
        }
        LOGGER.debug("exit from checkIfTasksMatchCompleteCriteria()");
    }

    private void updateTasksToBeCompleted(List<String> taskIds, List<TaskSummary> taskSummaries) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("entry to updateTasksToBeCompleted(taskIds = {}, taskSummaries = {})", (Object)LoggerUtils.listToString(taskIds), (Object)LoggerUtils.listToString(taskSummaries));
        }
        if (!taskIds.isEmpty() && !taskSummaries.isEmpty()) {
            this.taskMapper.updateCompleted(taskIds, (TaskSummaryImpl)taskSummaries.get(0));
            if (HistoryEventProducer.isHistoryEnabled()) {
                this.createTasksCompletedEvents(taskSummaries);
            }
        }
        LOGGER.debug("exit from updateTasksToBeCompleted()");
    }

    private void addClassificationSummariesToTaskSummaries(List<TaskSummaryImpl> tasks, List<ClassificationSummary> classifications) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("entry to addClassificationSummariesToTaskSummaries(tasks = {}, classifications = {})", (Object)LoggerUtils.listToString(tasks), (Object)LoggerUtils.listToString(classifications));
        }
        if (tasks == null || tasks.isEmpty()) {
            LOGGER.debug("exit from addClassificationSummariesToTaskSummaries()");
            return;
        }
        for (TaskSummaryImpl task : tasks) {
            String classificationId = task.getClassificationSummary().getId();
            ClassificationSummary classificationSummary = classifications.stream().filter(c -> c.getId().equals(classificationId)).findFirst().orElse(null);
            if (classificationSummary == null) {
                throw new SystemException("Did not find a Classification for task (Id=" + task.getId() + ",classification=" + task.getClassificationSummary().getId() + ")");
            }
            task.setClassificationSummary(classificationSummary);
        }
        LOGGER.debug("exit from addClassificationSummariesToTaskSummaries()");
    }

    private List<ClassificationSummary> findClassificationsForTasksAndAttachments(List<TaskSummaryImpl> taskSummaries, List<AttachmentSummaryImpl> attachmentSummaries) {
        LOGGER.debug("entry to findClassificationsForTasksAndAttachments()");
        if (taskSummaries == null || taskSummaries.isEmpty()) {
            return new ArrayList<ClassificationSummary>();
        }
        Set<String> classificationIdSet = taskSummaries.stream().map(t -> t.getClassificationSummary().getId()).collect(Collectors.toSet());
        if (attachmentSummaries != null && !attachmentSummaries.isEmpty()) {
            for (AttachmentSummaryImpl att : attachmentSummaries) {
                classificationIdSet.add(att.getClassificationSummary().getId());
            }
        }
        LOGGER.debug("exit from findClassificationsForTasksAndAttachments()");
        return this.queryClassificationsForTasksAndAttachments(classificationIdSet);
    }

    private List<ClassificationSummary> findClassificationForTaskImplAndAttachments(TaskImpl task, List<AttachmentImpl> attachmentImpls) {
        LOGGER.debug("entry to transferBulk()");
        HashSet<String> classificationIdSet = new HashSet<String>(Collections.singletonList(task.getClassificationSummary().getId()));
        if (attachmentImpls != null && !attachmentImpls.isEmpty()) {
            for (AttachmentImpl att : attachmentImpls) {
                classificationIdSet.add(att.getClassificationSummary().getId());
            }
        }
        LOGGER.debug("exit from findClassificationForTaskImplAndAttachments()");
        return this.queryClassificationsForTasksAndAttachments(classificationIdSet);
    }

    private List<ClassificationSummary> queryClassificationsForTasksAndAttachments(Set<String> classificationIdSet) {
        String[] classificationIdArray = classificationIdSet.toArray(new String[0]);
        LOGGER.debug("getClassificationsForTasksAndAttachments() about to query classifications and exit");
        return this.classificationService.createClassificationQuery().idIn(classificationIdArray).list();
    }

    private void addWorkbasketSummariesToTaskSummaries(List<TaskSummaryImpl> taskSummaries) {
        LOGGER.debug("entry to addWorkbasketSummariesToTaskSummaries()");
        if (taskSummaries == null || taskSummaries.isEmpty()) {
            return;
        }
        String[] workbasketIdArray = (String[])taskSummaries.stream().map(t -> t.getWorkbasketSummary().getId()).distinct().toArray(String[]::new);
        LOGGER.debug("addWorkbasketSummariesToTaskSummaries() about to query workbaskets");
        WorkbasketQueryImpl query = (WorkbasketQueryImpl)this.workbasketService.createWorkbasketQuery();
        query.setUsedToAugmentTasks(true);
        List workbaskets = query.idIn(workbasketIdArray).list();
        Iterator<TaskSummaryImpl> taskIterator = taskSummaries.iterator();
        while (taskIterator.hasNext()) {
            TaskSummaryImpl task = taskIterator.next();
            String workbasketId = task.getWorkbasketSummaryImpl().getId();
            WorkbasketSummary workbasketSummary = workbaskets.stream().filter(x -> workbasketId != null && workbasketId.equals(x.getId())).findFirst().orElse(null);
            if (workbasketSummary == null) {
                LOGGER.warn("Could not find a Workbasket for task {}.", (Object)task.getId());
                taskIterator.remove();
                continue;
            }
            task.setWorkbasketSummary(workbasketSummary);
        }
        LOGGER.debug("exit from addWorkbasketSummariesToTaskSummaries()");
    }

    private void addAttachmentSummariesToTaskSummaries(List<TaskSummaryImpl> taskSummaries, List<AttachmentSummaryImpl> attachmentSummaries, List<ClassificationSummary> classifications) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("entry to addAttachmentSummariesToTaskSummaries(taskSummaries = {}, attachmentSummaries = {}, classifications = {})", new Object[]{LoggerUtils.listToString(taskSummaries), LoggerUtils.listToString(attachmentSummaries), LoggerUtils.listToString(classifications)});
        }
        if (taskSummaries == null || taskSummaries.isEmpty()) {
            return;
        }
        this.addClassificationSummariesToAttachmentSummaries(attachmentSummaries, taskSummaries, classifications);
        for (TaskSummaryImpl task : taskSummaries) {
            for (AttachmentSummaryImpl attachment : attachmentSummaries) {
                if (attachment.getTaskId() == null || !attachment.getTaskId().equals(task.getId())) continue;
                task.addAttachmentSummary(attachment);
            }
        }
        LOGGER.debug("exit from addAttachmentSummariesToTaskSummaries()");
    }

    private void addClassificationSummariesToAttachmentSummaries(List<AttachmentSummaryImpl> attachmentSummaries, List<TaskSummaryImpl> taskSummaries, List<ClassificationSummary> classifications) {
        LOGGER.debug("entry to addClassificationSummariesToAttachmentSummaries()");
        if (attachmentSummaries == null || attachmentSummaries.isEmpty() || taskSummaries == null || taskSummaries.isEmpty()) {
            LOGGER.debug("exit from addClassificationSummariesToAttachmentSummaries()");
            return;
        }
        for (AttachmentSummaryImpl att : attachmentSummaries) {
            String classificationId = att.getClassificationSummary().getId();
            ClassificationSummary classificationSummary = classifications.stream().filter(x -> classificationId != null && classificationId.equals(x.getId())).findFirst().orElse(null);
            if (classificationSummary == null) {
                throw new SystemException("Could not find a Classification for attachment " + att);
            }
            att.setClassificationSummary(classificationSummary);
        }
        LOGGER.debug("exit from addClassificationSummariesToAttachmentSummaries()");
    }

    private List<Attachment> addClassificationSummariesToAttachments(List<AttachmentImpl> attachmentImpls, List<ClassificationSummary> classifications) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("entry to addClassificationSummariesToAttachments(targetWbId = {}, taskIds = {})", (Object)LoggerUtils.listToString(attachmentImpls), (Object)LoggerUtils.listToString(classifications));
        }
        if (attachmentImpls == null || attachmentImpls.isEmpty()) {
            LOGGER.debug("exit from addClassificationSummariesToAttachments()");
            return new ArrayList<Attachment>();
        }
        ArrayList<Attachment> result = new ArrayList<Attachment>();
        for (AttachmentImpl att : attachmentImpls) {
            ClassificationSummary classificationSummary = classifications.stream().filter(c -> c != null && c.getId().equals(att.getClassificationSummary().getId())).findFirst().orElse(null);
            if (classificationSummary == null) {
                throw new SystemException("Could not find a Classification for attachment " + att);
            }
            att.setClassificationSummary(classificationSummary);
            result.add(att);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("exit from addClassificationSummariesToAttachments(), returning {}", result);
        }
        return result;
    }

    private TaskImpl initUpdatedTask(Map<String, String> customFieldsToUpdate, CustomPropertySelector fieldSelector) throws InvalidArgumentException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("entry to initUpdatedTask(customFieldsToUpdate = {}, fieldSelector = {})", (Object)LoggerUtils.mapToString(customFieldsToUpdate), (Object)fieldSelector);
        }
        TaskImpl newTask = new TaskImpl();
        newTask.setModified(Instant.now());
        for (Map.Entry<String, String> entry : customFieldsToUpdate.entrySet()) {
            String key = entry.getKey();
            fieldSelector.setCustomProperty(key, true);
            newTask.setCustomAttribute(key, entry.getValue());
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("exit from initUpdatedTask(), returning {}", (Object)newTask);
        }
        return newTask;
    }

    private void validateCustomFields(Map<String, String> customFieldsToUpdate) throws InvalidArgumentException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("entry to validateCustomFields(customFieldsToUpdate = {})", (Object)LoggerUtils.mapToString(customFieldsToUpdate));
        }
        if (customFieldsToUpdate == null || customFieldsToUpdate.isEmpty()) {
            throw new InvalidArgumentException("The customFieldsToUpdate argument to updateTasks must not be empty.");
        }
        for (Map.Entry<String, String> entry : customFieldsToUpdate.entrySet()) {
            String key = entry.getKey();
            if (ALLOWED_KEYS.contains(key)) continue;
            throw new InvalidArgumentException("The customFieldsToUpdate argument to updateTasks contains invalid key " + key);
        }
        LOGGER.debug("exit from validateCustomFields()");
    }

    private List<TaskSummary> getTasksToChange(List<String> taskIds) {
        return this.createTaskQuery().idIn(taskIds.toArray(new String[0])).list();
    }

    private List<TaskSummary> getTasksToChange(ObjectReference selectionCriteria) {
        return this.createTaskQuery().primaryObjectReferenceCompanyIn(selectionCriteria.getCompany()).primaryObjectReferenceSystemIn(selectionCriteria.getSystem()).primaryObjectReferenceSystemInstanceIn(selectionCriteria.getSystemInstance()).primaryObjectReferenceTypeIn(selectionCriteria.getType()).primaryObjectReferenceValueIn(selectionCriteria.getValue()).list();
    }

    private void validateObjectReference(ObjectReference objRef, String objRefType, String objName) throws InvalidArgumentException {
        LOGGER.debug("entry to validateObjectReference()");
        if (objRef == null) {
            throw new InvalidArgumentException(objRefType + " of " + objName + " must not be null");
        }
        if (objRef.getCompany() == null || objRef.getCompany().length() == 0) {
            throw new InvalidArgumentException("Company of " + objRefType + " of " + objName + MUST_NOT_BE_EMPTY);
        }
        if (objRef.getSystem() == null || objRef.getSystem().length() == 0) {
            throw new InvalidArgumentException("System of " + objRefType + " of " + objName + MUST_NOT_BE_EMPTY);
        }
        if (objRef.getSystemInstance() == null || objRef.getSystemInstance().length() == 0) {
            throw new InvalidArgumentException("SystemInstance of " + objRefType + " of " + objName + MUST_NOT_BE_EMPTY);
        }
        if (objRef.getType() == null || objRef.getType().length() == 0) {
            throw new InvalidArgumentException("Type of " + objRefType + " of " + objName + MUST_NOT_BE_EMPTY);
        }
        if (objRef.getValue() == null || objRef.getValue().length() == 0) {
            throw new InvalidArgumentException("Value of" + objRefType + " of " + objName + MUST_NOT_BE_EMPTY);
        }
        LOGGER.debug("exit from validateObjectReference()");
    }

    private PrioDurationHolder handleAttachments(TaskImpl task) throws InvalidArgumentException {
        List<Attachment> attachments;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("entry to handleAttachments(task = {})", (Object)task);
        }
        if ((attachments = task.getAttachments()) == null || attachments.isEmpty()) {
            return new PrioDurationHolder(null, Integer.MIN_VALUE);
        }
        PrioDurationHolder actualPrioDuration = new PrioDurationHolder(MAX_DURATION, Integer.MIN_VALUE);
        Iterator<Attachment> i = attachments.iterator();
        while (i.hasNext()) {
            Attachment attachment = i.next();
            if (attachment == null) {
                i.remove();
                continue;
            }
            actualPrioDuration = this.handleNonNullAttachment(actualPrioDuration, attachment);
        }
        if (MAX_DURATION.equals(actualPrioDuration.getLeft())) {
            actualPrioDuration = new PrioDurationHolder(null, (Integer)actualPrioDuration.getRight());
        }
        LOGGER.debug("exit from handleAttachments(), returning {}", (Object)actualPrioDuration);
        return actualPrioDuration;
    }

    private PrioDurationHolder handleNonNullAttachment(PrioDurationHolder actualPrioDuration, Attachment attachment) throws InvalidArgumentException {
        ObjectReference objRef = attachment.getObjectReference();
        this.validateObjectReference(objRef, "ObjectReference", "Attachment");
        if (attachment.getClassificationSummary() == null) {
            throw new InvalidArgumentException("Classification of attachment " + attachment + " must not be null");
        }
        ClassificationSummary classificationSummary = attachment.getClassificationSummary();
        if (classificationSummary != null) {
            actualPrioDuration = this.getNewPrioDuration(actualPrioDuration, classificationSummary.getPriority(), classificationSummary.getServiceLevel());
        }
        return actualPrioDuration;
    }

    private void standardUpdateActions(TaskImpl oldTaskImpl, TaskImpl newTaskImpl, PrioDurationHolder prioDurationFromAttachments) throws InvalidArgumentException, ConcurrencyException, ClassificationNotFoundException, InvalidStateException {
        boolean isOwnerChanged;
        this.validateObjectReference(newTaskImpl.getPrimaryObjRef(), "primary ObjectReference", TASK);
        if (oldTaskImpl.getModified() != null && !oldTaskImpl.getModified().equals(newTaskImpl.getModified()) || oldTaskImpl.getClaimed() != null && !oldTaskImpl.getClaimed().equals(newTaskImpl.getClaimed()) || oldTaskImpl.getState() != null && !oldTaskImpl.getState().equals((Object)newTaskImpl.getState())) {
            throw new ConcurrencyException("The task has already been updated by another user");
        }
        if (oldTaskImpl.getExternalId() == null || !oldTaskImpl.getExternalId().equals(newTaskImpl.getExternalId())) {
            throw new InvalidArgumentException("A task's external Id cannot be changed via update of the task");
        }
        String newWorkbasketKey = newTaskImpl.getWorkbasketKey();
        if (newWorkbasketKey != null && !newWorkbasketKey.equals(oldTaskImpl.getWorkbasketKey())) {
            throw new InvalidArgumentException("A task's Workbasket cannot be changed via update of the task");
        }
        if (newTaskImpl.getPlanned() == null) {
            newTaskImpl.setPlanned(oldTaskImpl.getPlanned());
        }
        if (newTaskImpl.getBusinessProcessId() == null) {
            newTaskImpl.setBusinessProcessId(oldTaskImpl.getBusinessProcessId());
        }
        boolean bl = isOwnerChanged = !Objects.equals(newTaskImpl.getOwner(), oldTaskImpl.getOwner());
        if (isOwnerChanged && oldTaskImpl.getState() != TaskState.READY) {
            throw new InvalidStateException(String.format(TASK_WITH_ID_IS_NOT_READY, new Object[]{oldTaskImpl.getId(), oldTaskImpl.getState()}));
        }
        this.updateClassificationRelatedProperties(oldTaskImpl, newTaskImpl, prioDurationFromAttachments);
        newTaskImpl.setModified(Instant.now());
    }

    private void updateClassificationRelatedProperties(TaskImpl oldTaskImpl, TaskImpl newTaskImpl, PrioDurationHolder prioDurationFromAttachments) throws ClassificationNotFoundException {
        LOGGER.debug("entry to updateClassificationRelatedProperties()");
        ClassificationSummary oldClassificationSummary = oldTaskImpl.getClassificationSummary();
        ClassificationSummary newClassificationSummary = newTaskImpl.getClassificationSummary();
        if (newClassificationSummary == null) {
            newClassificationSummary = oldClassificationSummary;
        }
        if (newClassificationSummary == null) {
            this.updateTaskPrioDurationFromAttachments(newTaskImpl, prioDurationFromAttachments);
        } else {
            this.updateTaskPrioDurationFromClassification(newTaskImpl, prioDurationFromAttachments, oldClassificationSummary, newClassificationSummary);
        }
        LOGGER.debug("exit from updateClassificationRelatedProperties()");
    }

    private void updateTaskPrioDurationFromClassification(TaskImpl newTaskImpl, PrioDurationHolder prioDurationFromAttachments, ClassificationSummary oldClassificationSummary, ClassificationSummary newClassificationSummary) throws ClassificationNotFoundException {
        Duration minDuration;
        LOGGER.debug("entry to updateTaskPrioDurationFromClassification()");
        Classification newClassification = null;
        if (!oldClassificationSummary.getKey().equals(newClassificationSummary.getKey())) {
            newClassification = this.classificationService.getClassification(newClassificationSummary.getKey(), newTaskImpl.getWorkbasketSummary().getDomain());
            newClassificationSummary = newClassification.asSummary();
            newTaskImpl.setClassificationSummary(newClassificationSummary);
        }
        if ((minDuration = this.calculateDuration(prioDurationFromAttachments, newClassificationSummary)) != null) {
            long days = this.converter.convertWorkingDaysToDays(newTaskImpl.getPlanned(), minDuration.toDays());
            Instant due = newTaskImpl.getPlanned().plus(Duration.ofDays(days));
            newTaskImpl.setDue(due);
        }
        if (newTaskImpl.getName() == null) {
            newTaskImpl.setName(newClassificationSummary.getName());
        }
        if (newTaskImpl.getDescription() == null && newClassification != null) {
            newTaskImpl.setDescription(newClassification.getDescription());
        }
        int newPriority = Math.max(newClassificationSummary.getPriority(), (Integer)prioDurationFromAttachments.getRight());
        newTaskImpl.setPriority(newPriority);
        LOGGER.debug("exit from updateTaskPrioDurationFromClassification()");
    }

    private PrioDurationHolder handleAttachmentsOnTaskUpdate(TaskImpl oldTaskImpl, TaskImpl newTaskImpl) throws AttachmentPersistenceException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("entry to handleAttachmentsOnTaskUpdate(oldTaskImpl = {}, newTaskImpl = {})", (Object)oldTaskImpl, (Object)newTaskImpl);
        }
        PrioDurationHolder prioDuration = new PrioDurationHolder(MAX_DURATION, Integer.MIN_VALUE);
        Iterator<Attachment> i = newTaskImpl.getAttachments().iterator();
        while (i.hasNext()) {
            Attachment attachment = i.next();
            if (attachment != null) {
                prioDuration = this.handlePrioDurationOfOneAttachmentOnTaskUpdate(oldTaskImpl, newTaskImpl, prioDuration, attachment);
                continue;
            }
            i.remove();
        }
        this.deleteAttachmentOnTaskUpdate(oldTaskImpl, newTaskImpl);
        if (MAX_DURATION.equals(prioDuration.getLeft())) {
            prioDuration = new PrioDurationHolder(null, (Integer)prioDuration.getRight());
        }
        LOGGER.debug("exit from handleAttachmentsOnTaskUpdate()");
        return prioDuration;
    }

    private void deleteAttachmentOnTaskUpdate(TaskImpl oldTaskImpl, TaskImpl newTaskImpl) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("entry to deleteAttachmentOnTaskUpdate(oldTaskImpl = {}, newTaskImpl = {})", (Object)oldTaskImpl, (Object)newTaskImpl);
        }
        for (Attachment oldAttachment : oldTaskImpl.getAttachments()) {
            if (oldAttachment == null) continue;
            boolean isRepresented = false;
            for (Attachment newAttachment : newTaskImpl.getAttachments()) {
                if (newAttachment == null || !oldAttachment.getId().equals(newAttachment.getId())) continue;
                isRepresented = true;
                break;
            }
            if (isRepresented) continue;
            this.attachmentMapper.deleteAttachment(oldAttachment.getId());
            LOGGER.debug("TaskService.updateTask() for TaskId={} DELETED an Attachment={}.", (Object)newTaskImpl.getId(), (Object)oldAttachment);
        }
        LOGGER.debug("exit from deleteAttachmentOnTaskUpdate()");
    }

    private PrioDurationHolder handlePrioDurationOfOneAttachmentOnTaskUpdate(TaskImpl oldTaskImpl, TaskImpl newTaskImpl, PrioDurationHolder prioDuration, Attachment attachment) throws AttachmentPersistenceException {
        LOGGER.debug("entry to handlePrioDurationOfOneAttachmentOnTaskUpdate()");
        boolean wasAlreadyPresent = false;
        if (attachment.getId() != null) {
            for (Attachment oldAttachment : oldTaskImpl.getAttachments()) {
                if (oldAttachment == null || !attachment.getId().equals(oldAttachment.getId())) continue;
                wasAlreadyPresent = true;
                if (attachment.equals(oldAttachment)) continue;
                prioDuration = this.handlePrioDurationOfOneNewAttachmentOnTaskUpdate(newTaskImpl, prioDuration, attachment);
                break;
            }
        }
        if (!wasAlreadyPresent) {
            prioDuration = this.handleNewAttachmentOnTaskUpdate(newTaskImpl, prioDuration, attachment);
        }
        LOGGER.debug("exit from handlePrioDurationOfOneAttachmentOnTaskUpdate(), returning {}", (Object)prioDuration);
        return prioDuration;
    }

    private PrioDurationHolder handlePrioDurationOfOneNewAttachmentOnTaskUpdate(TaskImpl newTaskImpl, PrioDurationHolder prioDuration, Attachment attachment) {
        LOGGER.debug("entry to handlePrioDurationOfOneNewAttachmentOnTaskUpdate()");
        AttachmentImpl temp = (AttachmentImpl)attachment;
        ClassificationSummary classification = attachment.getClassificationSummary();
        if (classification != null) {
            prioDuration = this.getNewPrioDuration(prioDuration, classification.getPriority(), classification.getServiceLevel());
        }
        temp.setModified(Instant.now());
        this.attachmentMapper.update(temp);
        LOGGER.debug("TaskService.updateTask() for TaskId={} UPDATED an Attachment={}.", (Object)newTaskImpl.getId(), (Object)attachment);
        LOGGER.debug("exit from handlePrioDurationOfOneNewAttachmentOnTaskUpdate(), returning {}", (Object)prioDuration);
        return prioDuration;
    }

    private PrioDurationHolder handleNewAttachmentOnTaskUpdate(TaskImpl newTaskImpl, PrioDurationHolder prioDuration, Attachment attachment) throws AttachmentPersistenceException {
        LOGGER.debug("entry to handleNewAttachmentOnTaskUpdate()");
        AttachmentImpl attachmentImpl = (AttachmentImpl)attachment;
        this.initAttachment(attachmentImpl, newTaskImpl);
        ClassificationSummary classification = attachment.getClassificationSummary();
        if (classification != null) {
            prioDuration = this.getNewPrioDuration(prioDuration, classification.getPriority(), classification.getServiceLevel());
        }
        try {
            this.attachmentMapper.insert(attachmentImpl);
            LOGGER.debug("TaskService.updateTask() for TaskId={} INSERTED an Attachment={}.", (Object)newTaskImpl.getId(), (Object)attachmentImpl);
        }
        catch (PersistenceException e) {
            throw new AttachmentPersistenceException("Cannot insert the Attachement " + attachmentImpl.getId() + " for Task " + newTaskImpl.getId() + " because it already exists.", e.getCause());
        }
        LOGGER.debug("exit from handleNewAttachmentOnTaskUpdate(), returning {}", (Object)prioDuration);
        return prioDuration;
    }

    private PrioDurationHolder handleAttachmentsOnClassificationUpdate(Task task) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("entry to handleAttachmentsOnClassificationUpdate(task = {})", (Object)task);
        }
        PrioDurationHolder prioDuration = new PrioDurationHolder(MAX_DURATION, Integer.MIN_VALUE);
        for (Attachment attachment : task.getAttachments()) {
            ClassificationSummary classification;
            if (attachment == null || (classification = attachment.getClassificationSummary()) == null) continue;
            prioDuration = this.getNewPrioDuration(prioDuration, classification.getPriority(), classification.getServiceLevel());
        }
        if (MAX_DURATION.equals(prioDuration.getLeft())) {
            prioDuration = new PrioDurationHolder(null, (Integer)prioDuration.getRight());
        }
        LOGGER.debug("exit from handleAttachmentsOnClassificationUpdate(), returning {}", (Object)prioDuration);
        return prioDuration;
    }

    private PrioDurationHolder getNewPrioDuration(PrioDurationHolder prioDurationHolder, int prioFromClassification, String serviceLevelFromClassification) {
        LOGGER.debug("entry to getNewPrioDuration(prioDurationHolder = {}, prioFromClassification = {}, serviceLevelFromClassification = {})", new Object[]{prioDurationHolder, prioFromClassification, serviceLevelFromClassification});
        Duration minDuration = (Duration)prioDurationHolder.getLeft();
        int maxPrio = (Integer)prioDurationHolder.getRight();
        if (serviceLevelFromClassification != null) {
            Duration currentDuration = Duration.parse(serviceLevelFromClassification);
            if (prioDurationHolder.getLeft() != null) {
                if (((Duration)prioDurationHolder.getLeft()).compareTo(currentDuration) > 0) {
                    minDuration = currentDuration;
                }
            } else {
                minDuration = currentDuration;
            }
        }
        if (prioFromClassification > maxPrio) {
            maxPrio = prioFromClassification;
        }
        PrioDurationHolder pair = new PrioDurationHolder(minDuration, maxPrio);
        LOGGER.debug("exit from getNewPrioDuration(), returning {}", (Object)pair);
        return pair;
    }

    private void initAttachment(AttachmentImpl attachment, Task newTask) {
        LOGGER.debug("entry to initAttachment()");
        if (attachment.getId() == null) {
            attachment.setId(IdGenerator.generateWithPrefix(ID_PREFIX_ATTACHMENT));
        }
        if (attachment.getCreated() == null) {
            attachment.setCreated(Instant.now());
        }
        if (attachment.getModified() == null) {
            attachment.setModified(attachment.getCreated());
        }
        if (attachment.getTaskId() == null) {
            attachment.setTaskId(newTask.getId());
        }
        LOGGER.debug("exit from initAttachment()");
    }

    private void updatePrioDueDateOnClassificationUpdate(TaskImpl task, PrioDurationHolder prioDurationFromAttachments) {
        LOGGER.debug("entry to updatePrioDueDateOnClassificationUpdate()");
        ClassificationSummary classificationSummary = task.getClassificationSummary();
        if (classificationSummary == null) {
            this.updateTaskPrioDurationFromAttachments(task, prioDurationFromAttachments);
        } else {
            this.updateTaskPrioDurationFromClassificationAndAttachments(task, prioDurationFromAttachments, classificationSummary);
        }
        LOGGER.debug("exit from updatePrioDueDateOnClassificationUpdate()");
    }

    private void updateTaskPrioDurationFromClassificationAndAttachments(TaskImpl task, PrioDurationHolder prioDurationFromAttachments, ClassificationSummary classificationSummary) {
        LOGGER.debug("entry to updateTaskPrioDurationFromClassificationAndAttachments()");
        Duration minDuration = this.calculateDuration(prioDurationFromAttachments, classificationSummary);
        if (minDuration != null) {
            long days = this.converter.convertWorkingDaysToDays(task.getPlanned(), minDuration.toDays());
            Instant due = task.getPlanned().plus(Duration.ofDays(days));
            task.setDue(due);
        }
        int newPriority = Math.max(classificationSummary.getPriority(), (Integer)prioDurationFromAttachments.getRight());
        task.setPriority(newPriority);
        LOGGER.debug("exit from updateTaskPrioDurationFromClassificationAndAttachments()");
    }

    private void updateTaskPrioDurationFromAttachments(TaskImpl task, PrioDurationHolder prioDurationFromAttachments) {
        LOGGER.debug("entry to updateTaskPrioDurationFromAttachments()");
        if (prioDurationFromAttachments.getLeft() != null) {
            long days = this.converter.convertWorkingDaysToDays(task.getPlanned(), ((Duration)prioDurationFromAttachments.getLeft()).toDays());
            Instant due = task.getPlanned().plus(Duration.ofDays(days));
            task.setDue(due);
        }
        if ((Integer)prioDurationFromAttachments.getRight() > Integer.MIN_VALUE) {
            task.setPriority((Integer)prioDurationFromAttachments.getRight());
        }
        LOGGER.debug("exit from updateTaskPrioDurationFromAttachments()");
    }

    private List<Attachment> augmentAttachmentsByClassification(List<AttachmentImpl> attachmentImpls, BulkOperationResults<String, Exception> bulkLog) {
        LOGGER.debug("entry to augmentAttachmentsByClassification()");
        ArrayList<Attachment> result = new ArrayList<Attachment>();
        if (attachmentImpls == null || attachmentImpls.isEmpty()) {
            return result;
        }
        List classifications = this.classificationService.createClassificationQuery().idIn((String[])attachmentImpls.stream().map(t -> t.getClassificationSummary().getId()).distinct().toArray(String[]::new)).list();
        for (AttachmentImpl att : attachmentImpls) {
            ClassificationSummary classificationSummary = classifications.stream().filter(cl -> cl.getId().equals(att.getClassificationSummary().getId())).findFirst().orElse(null);
            if (classificationSummary == null) {
                String id = att.getClassificationSummary().getId();
                bulkLog.addError(att.getClassificationSummary().getId(), new ClassificationNotFoundException(id, String.format("When processing task updates due to change of classification, the classification with id %s was not found", id)));
                continue;
            }
            att.setClassificationSummary(classificationSummary);
            result.add(att);
        }
        LOGGER.debug("exit from augmentAttachmentsByClassification()");
        return result;
    }

    private void createTasksCompletedEvents(List<TaskSummary> taskSummaries) {
        taskSummaries.forEach(task -> this.historyEventProducer.createEvent(new CompletedEvent((TaskSummary)task, CurrentUserContext.getUserid())));
    }

    private static class PrioDurationHolder
    extends Pair<Duration, Integer> {
        PrioDurationHolder(Duration left, Integer right) {
            super(left, right);
        }
    }
}

