/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.monitor.internal.preprocessor;

import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.common.api.LoggerUtils;
import pro.taskana.common.api.exceptions.InvalidArgumentException;
import pro.taskana.common.internal.util.WorkingDaysToDaysConverter;
import pro.taskana.monitor.api.reports.header.TimeIntervalColumnHeader;

public class WorkingDaysToDaysReportConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkingDaysToDaysReportConverter.class);
    private WorkingDaysToDaysConverter daysToWorkingDaysConverter;
    private Map<Integer, Integer> cacheDaysToWorkingDays;

    WorkingDaysToDaysReportConverter(List<? extends TimeIntervalColumnHeader> columnHeaders, WorkingDaysToDaysConverter daysToWorkingDaysConverter) {
        this.daysToWorkingDaysConverter = daysToWorkingDaysConverter;
        this.cacheDaysToWorkingDays = this.generateDaysToWorkingDays(columnHeaders, daysToWorkingDaysConverter.getReferenceDate());
    }

    public static WorkingDaysToDaysReportConverter initialize(List<? extends TimeIntervalColumnHeader> columnHeaders) throws InvalidArgumentException {
        return WorkingDaysToDaysReportConverter.initialize(columnHeaders, Instant.now());
    }

    public static WorkingDaysToDaysReportConverter initialize(List<? extends TimeIntervalColumnHeader> columnHeaders, Instant referenceDate) throws InvalidArgumentException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Initialize WorkingDaysToDaysConverter with columnHeaders: {}", (Object)LoggerUtils.listToString(columnHeaders));
        }
        if (columnHeaders == null) {
            throw new InvalidArgumentException("TimeIntervalColumnHeaders can\u00b4t be used as NULL-Parameter");
        }
        if (referenceDate == null) {
            throw new InvalidArgumentException("ReferenceDate can\u00b4t be used as NULL-Parameter");
        }
        WorkingDaysToDaysConverter workingDaysToDaysConverter = WorkingDaysToDaysConverter.initialize(referenceDate);
        return new WorkingDaysToDaysReportConverter(columnHeaders, workingDaysToDaysConverter);
    }

    public int convertDaysToWorkingDays(int amountOfDays) {
        return this.cacheDaysToWorkingDays.getOrDefault(amountOfDays, amountOfDays);
    }

    public List<Integer> convertWorkingDaysToDays(int amountOfWorkdays) {
        List<Integer> listOfAllMatchingDays = this.cacheDaysToWorkingDays.entrySet().stream().filter(entry -> (Integer)entry.getValue() == amountOfWorkdays).map(Map.Entry::getKey).collect(Collectors.toList());
        if (listOfAllMatchingDays.isEmpty()) {
            return Collections.singletonList(amountOfWorkdays);
        }
        return listOfAllMatchingDays;
    }

    protected Map<Integer, Integer> generateDaysToWorkingDays(List<? extends TimeIntervalColumnHeader> columnHeaders, Instant referenceDate) {
        HashMap<Integer, Integer> cacheDaysToWorkingDays = new HashMap<Integer, Integer>();
        cacheDaysToWorkingDays.put(0, 0);
        int positiveWorkdayLimit = TimeIntervalColumnHeader.getLargestLowerLimit(columnHeaders);
        this.calculateFutureDaysToWorkingDays(cacheDaysToWorkingDays, referenceDate, positiveWorkdayLimit);
        int negativeWorkdayLimit = TimeIntervalColumnHeader.getSmallestUpperLimit(columnHeaders);
        this.calculateNegativeDaysToWorkingDays(cacheDaysToWorkingDays, referenceDate, negativeWorkdayLimit);
        return cacheDaysToWorkingDays;
    }

    private void calculateFutureDaysToWorkingDays(HashMap<Integer, Integer> cacheDaysToWorkingDays, Instant referenceDate, int workdayLimit) {
        this.calculateDaysToWorkingDays(cacheDaysToWorkingDays, referenceDate, workdayLimit, 1);
    }

    private void calculateNegativeDaysToWorkingDays(HashMap<Integer, Integer> cacheDaysToWorkingDays, Instant referenceDate, int workdayLimit) {
        this.calculateDaysToWorkingDays(cacheDaysToWorkingDays, referenceDate, workdayLimit, -1);
    }

    private void calculateDaysToWorkingDays(HashMap<Integer, Integer> cacheDaysToWorkingDays, Instant referenceDate, int workdayLimit, int direction) {
        int amountOfDays = 0;
        int amountOfWorkdays = 0;
        while (Math.abs(amountOfWorkdays) < Math.abs(workdayLimit)) {
            cacheDaysToWorkingDays.put(amountOfDays, amountOfWorkdays += this.daysToWorkingDaysConverter.isWorkingDay(amountOfDays += direction, referenceDate) ? direction : 0);
        }
    }

    public String toString() {
        return "DaysToWorkingDaysReportConverter [cacheDaysToWorkingDays=" + this.cacheDaysToWorkingDays + ", daysToWorkingDaysConverter=" + this.daysToWorkingDaysConverter + "]";
    }
}

