/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.task.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.common.api.TaskanaEngine;
import pro.taskana.common.internal.util.LogSanitizer;
import pro.taskana.spi.routing.api.TaskRoutingProvider;
import pro.taskana.task.api.models.Task;

public final class TaskRoutingManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskRoutingManager.class);
    private static TaskRoutingManager singleton;
    private boolean enabled = false;
    private List<TaskRoutingProvider> theTaskRoutingProviders = new ArrayList<TaskRoutingProvider>();
    private ServiceLoader<TaskRoutingProvider> serviceLoader = ServiceLoader.load(TaskRoutingProvider.class);

    private TaskRoutingManager(TaskanaEngine taskanaEngine) {
        for (TaskRoutingProvider router : this.serviceLoader) {
            router.initialize(taskanaEngine);
            this.theTaskRoutingProviders.add(router);
            LOGGER.info("Registered TaskRouter provider: {}", (Object)router.getClass().getName());
        }
        if (this.theTaskRoutingProviders.isEmpty()) {
            LOGGER.info("No TaskRouter provider found. Running without Task Routing.");
        } else {
            this.enabled = true;
        }
    }

    public static synchronized TaskRoutingManager getInstance(TaskanaEngine taskanaEngine) {
        if (singleton == null) {
            singleton = new TaskRoutingManager(taskanaEngine);
        }
        return singleton;
    }

    public static boolean isTaskRoutingEnabled() {
        return Objects.nonNull(singleton) && TaskRoutingManager.singleton.enabled;
    }

    public String determineWorkbasketId(Task task) {
        LOGGER.debug("entry to routeToWorkbasket. TaskRouterr is enabled {}, task = {}", (Object)TaskRoutingManager.isTaskRoutingEnabled(), (Object)task);
        String workbasketId = null;
        if (TaskRoutingManager.isTaskRoutingEnabled()) {
            Set workbasketIds = this.theTaskRoutingProviders.stream().map(rtr -> rtr.determineWorkbasketId(task)).filter(Objects::nonNull).collect(Collectors.toSet());
            if (workbasketIds.isEmpty()) {
                if (LOGGER.isErrorEnabled()) {
                    LOGGER.error("No TaskRouter determined a workbasket for task {}.", (Object)LogSanitizer.stripLineBreakingChars(task));
                }
            } else if (workbasketIds.size() > 1) {
                if (LOGGER.isErrorEnabled()) {
                    LOGGER.error("The TaskRouters determined more than one workbasket for task {}", (Object)LogSanitizer.stripLineBreakingChars(task));
                }
            } else {
                workbasketId = workbasketIds.stream().findFirst().orElse(null);
            }
        }
        LOGGER.debug("exit from routeToWorkbasketId. Destination WorkbasketId = {}", workbasketId);
        return workbasketId;
    }
}

