/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.SQLException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.ibatis.datasource.pooled.PooledDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.common.api.CustomHoliday;
import pro.taskana.common.api.TaskanaEngine;
import pro.taskana.common.api.TaskanaRole;
import pro.taskana.common.api.exceptions.SystemException;
import pro.taskana.common.api.exceptions.WrongCustomHolidayFormatException;
import pro.taskana.common.internal.TaskanaEngineImpl;
import pro.taskana.common.internal.configuration.DB;
import pro.taskana.common.internal.configuration.DbSchemaCreator;
import pro.taskana.common.internal.configuration.SecurityVerifier;

public class TaskanaEngineConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskanaEngineConfiguration.class);
    private static final String TASKANA_SCHEMA_VERSION = "3.0.0";
    private static final String TASKANA_PROPERTIES = "/taskana.properties";
    private static final String TASKANA_PROPERTY_SEPARATOR = "|";
    private static final String TASKANA_JOB_BATCH_SIZE = "taskana.jobs.batchSize";
    private static final String TASKANA_JOB_RETRIES = "taskana.jobs.maxRetries";
    private static final String TASKANA_JOB_CLEANUP_RUN_EVERY = "taskana.jobs.cleanup.runEvery";
    private static final String TASKANA_JOB_CLEANUP_FIRST_RUN = "taskana.jobs.cleanup.firstRunAt";
    private static final String TASKANA_JOB_CLEANUP_MINIMUM_AGE = "taskana.jobs.cleanup.minimumAge";
    private static final String TASKANA_JOB_TASK_CLEANUP_ALL_COMPLETED_SAME_PARENT_BUSINESS = "taskana.jobs.cleanup.allCompletedSameParentBusiness";
    private static final String TASKANA_DOMAINS_PROPERTY = "taskana.domains";
    private static final String TASKANA_CLASSIFICATION_TYPES_PROPERTY = "taskana.classification.types";
    private static final String TASKANA_CLASSIFICATION_CATEGORIES_PROPERTY = "taskana.classification.categories";
    private static final String TASKANA_GERMAN_HOLIDAYS_ENABLED = "taskana.german.holidays.enabled";
    private static final String TASKANA_GERMAN_HOLIDAYS_CORPUS_CHRISTI_ENABLED = "taskana.german.holidays.corpus-christi.enabled";
    private static final String TASKANA_CUSTOM_HOLIDAY = "taskana.custom.holidays";
    private static final String TASKANA_CUSTOM_HOLIDAY_DAY_MONTH_SEPARATOR = ".";
    private static final String DEFAULT_SCHEMA_NAME = "TASKANA";
    private final List<CustomHoliday> customHolidays = new ArrayList<CustomHoliday>();
    protected String propertiesFileName = "/taskana.properties";
    protected DataSource dataSource;
    protected DbSchemaCreator dbSchemaCreator;
    protected String schemaName;
    protected String propertiesSeparator = "|";
    protected Map<TaskanaRole, Set<String>> roleMap = new HashMap<TaskanaRole, Set<String>>();
    protected boolean securityEnabled;
    protected SecurityVerifier securityVerifier;
    protected boolean useManagedTransactions;
    protected List<String> domains = new ArrayList<String>();
    protected List<String> classificationTypes = new ArrayList<String>();
    protected Map<String, List<String>> classificationCategoriesByTypeMap = new HashMap<String, List<String>>();
    private boolean germanPublicHolidaysEnabled;
    private boolean corpusChristiEnabled;
    private int jobBatchSize = 100;
    private int maxNumberOfJobRetries = 3;
    private Instant cleanupJobFirstRun = Instant.parse("2018-01-01T00:00:00Z");
    private Duration cleanupJobRunEvery = Duration.parse("P1D");
    private Duration cleanupJobMinimumAge = Duration.parse("P14D");
    private boolean taskCleanupJobAllCompletedSameParentBusiness = true;

    public TaskanaEngineConfiguration(DataSource dataSource, boolean useManagedTransactions, String schemaName) throws SQLException {
        this(dataSource, useManagedTransactions, true, schemaName);
    }

    public TaskanaEngineConfiguration(DataSource dataSource, boolean useManagedTransactions, boolean securityEnabled, String schemaName) throws SQLException {
        this(dataSource, useManagedTransactions, securityEnabled, null, null, schemaName);
    }

    public TaskanaEngineConfiguration(DataSource dataSource, boolean useManagedTransactions, boolean securityEnabled, String propertiesFileName, String propertySeparator, String schemaName) throws SQLException {
        this.useManagedTransactions = useManagedTransactions;
        this.securityEnabled = securityEnabled;
        if (propertiesFileName != null) {
            this.propertiesFileName = propertiesFileName;
        }
        if (propertySeparator != null) {
            this.propertiesSeparator = propertySeparator;
        }
        this.dataSource = dataSource != null ? dataSource : TaskanaEngineConfiguration.createDefaultDataSource();
        this.initSchemaName(schemaName);
        this.initTaskanaProperties(this.propertiesFileName, this.propertiesSeparator);
        this.dbSchemaCreator = new DbSchemaCreator(this.dataSource, this.getSchemaName());
        this.dbSchemaCreator.run();
        if (!this.dbSchemaCreator.isValidSchemaVersion(TASKANA_SCHEMA_VERSION)) {
            throw new SystemException("The Database Schema Version doesn't match the expected version 3.0.0");
        }
        this.securityVerifier = new SecurityVerifier(this.dataSource, this.getSchemaName());
        this.securityVerifier.checkSecureAccess(securityEnabled);
    }

    public void initTaskanaProperties(String propertiesFile, String rolesSeparator) {
        LOGGER.debug("Reading taskana configuration from {} with role separator {}", (Object)propertiesFile, (Object)rolesSeparator);
        Properties props = this.readPropertiesFromFile(propertiesFile);
        this.initTaskanaRoles(props, rolesSeparator);
        this.initJobParameters(props);
        this.initDomains(props);
        this.initClassificationTypes(props);
        this.initClassificationCategories(props);
        this.initGermanHolidaysEnabled(props);
        this.initCorpusChristiEnabled(props);
        this.initCustomHolidays(props);
    }

    public static DataSource createDefaultDataSource() {
        String driverClass = "org.h2.Driver";
        String jdbcUrl = "jdbc:h2:mem:taskana;IGNORECASE=TRUE;LOCK_MODE=0;INIT=CREATE SCHEMA IF NOT EXISTS TASKANA\\;SET COLLATION DEFAULT_de_DE";
        String username = "sa";
        String password = "sa";
        LOGGER.info("No datasource is provided. An in-memory db is used: '{}', '{}', '{}', '{}'", new Object[]{driverClass, jdbcUrl, username, password});
        return TaskanaEngineConfiguration.createDatasource(driverClass, jdbcUrl, username, password);
    }

    public TaskanaEngine buildTaskanaEngine() {
        return TaskanaEngineImpl.createTaskanaEngine(this);
    }

    public static DataSource createDatasource(String driver, String jdbcUrl, String username, String password) {
        return new PooledDataSource(driver, jdbcUrl, username, password);
    }

    public boolean isSecurityEnabled() {
        return this.securityEnabled;
    }

    public DataSource getDatasource() {
        return this.dataSource;
    }

    public boolean getUseManagedTransactions() {
        return this.useManagedTransactions;
    }

    public String getPropertiesFileName() {
        return this.propertiesFileName;
    }

    public void setPropertiesFileName(String propertiesFileName) {
        this.propertiesFileName = propertiesFileName;
    }

    public int getMaxNumberOfUpdatesPerTransaction() {
        return this.jobBatchSize;
    }

    public int getMaxNumberOfJobRetries() {
        return this.maxNumberOfJobRetries;
    }

    public String getPropertiesSeparator() {
        return this.propertiesSeparator;
    }

    public void setPropertiesSeparator(String propertiesSeparator) {
        this.propertiesSeparator = propertiesSeparator;
    }

    public boolean isCorpusChristiEnabled() {
        return this.corpusChristiEnabled;
    }

    public void setCorpusChristiEnabled(boolean corpusChristiEnabled) {
        this.corpusChristiEnabled = corpusChristiEnabled;
    }

    public boolean isGermanPublicHolidaysEnabled() {
        return this.germanPublicHolidaysEnabled;
    }

    public void setGermanPublicHolidaysEnabled(boolean germanPublicHolidaysEnabled) {
        this.germanPublicHolidaysEnabled = germanPublicHolidaysEnabled;
    }

    public List<CustomHoliday> getCustomHolidays() {
        return this.customHolidays;
    }

    public void addCustomHolidays(List<CustomHoliday> customHolidays) {
        this.customHolidays.addAll(customHolidays);
    }

    public Map<TaskanaRole, Set<String>> getRoleMap() {
        return this.roleMap;
    }

    public void setRoleMap(Map<TaskanaRole, Set<String>> roleMap) {
        this.roleMap = roleMap;
    }

    public List<String> getDomains() {
        return this.domains;
    }

    public void setDomains(List<String> domains) {
        this.domains = domains;
    }

    public List<String> getClassificationTypes() {
        return this.classificationTypes;
    }

    public void setClassificationTypes(List<String> classificationTypes) {
        this.classificationTypes = classificationTypes;
    }

    public List<String> getAllClassificationCategories() {
        ArrayList<String> classificationCategories = new ArrayList<String>();
        for (Map.Entry<String, List<String>> type : this.classificationCategoriesByTypeMap.entrySet()) {
            classificationCategories.addAll((Collection<String>)type.getValue());
        }
        return classificationCategories;
    }

    public Map<String, List<String>> getClassificationCategoriesByTypeMap() {
        return this.classificationCategoriesByTypeMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new ArrayList((Collection)e.getValue())));
    }

    public List<String> getClassificationCategoriesByType(String type) {
        return this.classificationCategoriesByTypeMap.getOrDefault(type, Collections.emptyList());
    }

    public void setClassificationCategoriesByType(Map<String, List<String>> classificationCategoriesByType) {
        this.classificationCategoriesByTypeMap = classificationCategoriesByType;
    }

    public Instant getCleanupJobFirstRun() {
        return this.cleanupJobFirstRun;
    }

    public Duration getCleanupJobRunEvery() {
        return this.cleanupJobRunEvery;
    }

    public Duration getCleanupJobMinimumAge() {
        return this.cleanupJobMinimumAge;
    }

    public boolean isTaskCleanupJobAllCompletedSameParentBusiness() {
        return this.taskCleanupJobAllCompletedSameParentBusiness;
    }

    public void setTaskCleanupJobAllCompletedSameParentBusiness(boolean taskCleanupJobAllCompletedSameParentBusiness) {
        this.taskCleanupJobAllCompletedSameParentBusiness = taskCleanupJobAllCompletedSameParentBusiness;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public static boolean shouldUseLowerCaseForAccessIds() {
        return true;
    }

    private void initGermanHolidaysEnabled(Properties props) {
        String enabled = props.getProperty(TASKANA_GERMAN_HOLIDAYS_ENABLED);
        this.germanPublicHolidaysEnabled = enabled != null && !enabled.isEmpty() ? Boolean.parseBoolean(enabled) : false;
        LOGGER.debug("GermanPublicHolidaysEnabled = {}", (Object)this.germanPublicHolidaysEnabled);
    }

    private void initCorpusChristiEnabled(Properties props) {
        String enabled = props.getProperty(TASKANA_GERMAN_HOLIDAYS_CORPUS_CHRISTI_ENABLED);
        this.corpusChristiEnabled = enabled != null && !enabled.isEmpty() ? Boolean.parseBoolean(enabled) : false;
        LOGGER.debug("CorpusChristiEnabled = {}", (Object)this.corpusChristiEnabled);
    }

    private void initJobParameters(Properties props) {
        String taskCleanupJobAllCompletedSameParentBusinessProperty;
        String taskCleanupJobMinimumAgeProperty;
        String taskCleanupJobRunEveryProperty;
        String taskCleanupJobFirstRunProperty;
        String maxNumberOfJobRetriesProperty;
        String jobBatchSizeProperty = props.getProperty(TASKANA_JOB_BATCH_SIZE);
        if (jobBatchSizeProperty != null && !jobBatchSizeProperty.isEmpty()) {
            try {
                this.jobBatchSize = Integer.parseInt(jobBatchSizeProperty);
            }
            catch (Exception e) {
                LOGGER.warn("Could not parse jobBatchSizeProperty ({}). Using default. Exception: {} ", (Object)jobBatchSizeProperty, (Object)e.getMessage());
            }
        }
        if ((maxNumberOfJobRetriesProperty = props.getProperty(TASKANA_JOB_RETRIES)) != null && !maxNumberOfJobRetriesProperty.isEmpty()) {
            try {
                this.maxNumberOfJobRetries = Integer.parseInt(maxNumberOfJobRetriesProperty);
            }
            catch (Exception e) {
                LOGGER.warn("Could not parse maxNumberOfJobRetriesProperty ({}). Using default. Exception: {} ", (Object)maxNumberOfJobRetriesProperty, (Object)e.getMessage());
            }
        }
        if ((taskCleanupJobFirstRunProperty = props.getProperty(TASKANA_JOB_CLEANUP_FIRST_RUN)) != null && !taskCleanupJobFirstRunProperty.isEmpty()) {
            try {
                this.cleanupJobFirstRun = Instant.parse(taskCleanupJobFirstRunProperty);
            }
            catch (Exception e) {
                LOGGER.warn("Could not parse taskCleanupJobFirstRunProperty ({}). Using default. Exception: {} ", (Object)taskCleanupJobFirstRunProperty, (Object)e.getMessage());
            }
        }
        if ((taskCleanupJobRunEveryProperty = props.getProperty(TASKANA_JOB_CLEANUP_RUN_EVERY)) != null && !taskCleanupJobRunEveryProperty.isEmpty()) {
            try {
                this.cleanupJobRunEvery = Duration.parse(taskCleanupJobRunEveryProperty);
            }
            catch (Exception e) {
                LOGGER.warn("Could not parse taskCleanupJobRunEveryProperty ({}). Using default. Exception: {} ", (Object)taskCleanupJobRunEveryProperty, (Object)e.getMessage());
            }
        }
        if ((taskCleanupJobMinimumAgeProperty = props.getProperty(TASKANA_JOB_CLEANUP_MINIMUM_AGE)) != null && !taskCleanupJobMinimumAgeProperty.isEmpty()) {
            try {
                this.cleanupJobMinimumAge = Duration.parse(taskCleanupJobMinimumAgeProperty);
            }
            catch (Exception e) {
                LOGGER.warn("Could not parse taskCleanupJobMinimumAgeProperty ({}). Using default. Exception: {} ", (Object)taskCleanupJobMinimumAgeProperty, (Object)e.getMessage());
            }
        }
        if ((taskCleanupJobAllCompletedSameParentBusinessProperty = props.getProperty(TASKANA_JOB_TASK_CLEANUP_ALL_COMPLETED_SAME_PARENT_BUSINESS)) != null && !taskCleanupJobAllCompletedSameParentBusinessProperty.isEmpty()) {
            try {
                this.taskCleanupJobAllCompletedSameParentBusiness = Boolean.parseBoolean(taskCleanupJobAllCompletedSameParentBusinessProperty);
            }
            catch (Exception e) {
                LOGGER.warn("Could not parse taskCleanupJobAllCompletedSameParentBusinessProperty ({}). Using default. Exception: {} ", (Object)taskCleanupJobAllCompletedSameParentBusinessProperty, (Object)e.getMessage());
            }
        }
        LOGGER.debug("Configured number of task and workbasket updates per transaction: {}", (Object)this.jobBatchSize);
        LOGGER.debug("Number of retries of failed task updates: {}", (Object)this.maxNumberOfJobRetries);
        LOGGER.debug("CleanupJob configuration: first run at {}", (Object)this.cleanupJobFirstRun);
        LOGGER.debug("CleanupJob configuration: runs every {}", (Object)this.cleanupJobRunEvery);
        LOGGER.debug("CleanupJob configuration: minimum age of tasks to be cleanup up is {}", (Object)this.cleanupJobMinimumAge);
        LOGGER.debug("TaskCleanupJob configuration: all completed task with the same parent business property id {}", (Object)this.taskCleanupJobAllCompletedSameParentBusiness);
    }

    private void initDomains(Properties props) {
        String domainNames = props.getProperty(TASKANA_DOMAINS_PROPERTY);
        if (domainNames != null && !domainNames.isEmpty()) {
            StringTokenizer st = new StringTokenizer(domainNames, ",");
            while (st.hasMoreTokens()) {
                this.domains.add(st.nextToken().trim().toUpperCase());
            }
        }
        LOGGER.debug("Configured domains: {}", this.domains);
    }

    private void initClassificationTypes(Properties props) {
        String classificationTypesNames = props.getProperty(TASKANA_CLASSIFICATION_TYPES_PROPERTY);
        if (classificationTypesNames != null && !classificationTypesNames.isEmpty()) {
            StringTokenizer st = new StringTokenizer(classificationTypesNames, ",");
            while (st.hasMoreTokens()) {
                this.classificationTypes.add(st.nextToken().trim().toUpperCase());
            }
        } else {
            LOGGER.warn("Configuration issue. Classification type is missing");
        }
        LOGGER.debug("Configured classificationTypes: {}", this.classificationTypes);
    }

    private void initClassificationCategories(Properties props) {
        if (this.classificationTypes != null && !this.classificationTypes.isEmpty()) {
            for (String type : this.classificationTypes) {
                ArrayList<String> classificationCategoriesAux = new ArrayList<String>();
                String classificationCategoryNames = props.getProperty("taskana.classification.categories." + type.toLowerCase());
                if (classificationCategoryNames != null && !classificationCategoryNames.isEmpty()) {
                    StringTokenizer st = new StringTokenizer(classificationCategoryNames, ",");
                    while (st.hasMoreTokens()) {
                        classificationCategoriesAux.add(st.nextToken().trim().toUpperCase());
                    }
                    this.classificationCategoriesByTypeMap.put(type, classificationCategoriesAux);
                    continue;
                }
                LOGGER.warn("Configuration issue. Classification categories by type is missing");
            }
        }
        LOGGER.debug("Configured classification categories : {}", this.domains);
    }

    private void initSchemaName(String schemaName) {
        if (schemaName != null && !schemaName.isEmpty()) {
            this.setSchemaName(schemaName);
        } else {
            this.setSchemaName(DEFAULT_SCHEMA_NAME);
        }
        try (Connection connection = this.dataSource.getConnection();){
            String databaseProductName = connection.getMetaData().getDatabaseProductName();
            this.schemaName = DB.isPostgreSql(databaseProductName) ? this.schemaName.toLowerCase() : this.schemaName.toUpperCase();
        }
        catch (SQLException ex) {
            LOGGER.error("Caught exception when attempting to initialize the schema name", (Throwable)ex);
        }
        LOGGER.debug("Using schema name {}", (Object)this.getSchemaName());
    }

    private void initTaskanaRoles(Properties props, String rolesSeparator) {
        List<String> validPropertyNames = TaskanaRole.getValidPropertyNames();
        props.keySet().stream().map(String::valueOf).filter(propertyName -> validPropertyNames.contains(propertyName.toLowerCase().trim())).forEach(validPropertyName -> {
            Set cfr_ignored_0 = this.roleMap.put(TaskanaRole.fromPropertyName(validPropertyName), this.getTokensWithCollection(props.getProperty((String)validPropertyName), rolesSeparator));
        });
        this.ensureRoleMapIsFullyInitialized();
        if (LOGGER.isDebugEnabled()) {
            this.roleMap.forEach((k, v) -> LOGGER.debug("Found Taskana RoleConfig {} : {} ", (Object)k, v));
        }
    }

    private void initCustomHolidays(Properties props) {
        if (props.getProperty(TASKANA_CUSTOM_HOLIDAY) != null) {
            Arrays.asList(props.getProperty(TASKANA_CUSTOM_HOLIDAY).split(Pattern.quote(this.propertiesSeparator))).forEach(entry -> {
                try {
                    this.customHolidays.add(this.createCustomHolidayFromPropsEntry((String)entry));
                }
                catch (WrongCustomHolidayFormatException e) {
                    LOGGER.warn(e.getMessage());
                }
            });
        }
    }

    private CustomHoliday createCustomHolidayFromPropsEntry(String customHolidayEntry) throws WrongCustomHolidayFormatException {
        String[] parts = customHolidayEntry.split(Pattern.quote(TASKANA_CUSTOM_HOLIDAY_DAY_MONTH_SEPARATOR));
        if (parts.length == 2) {
            return CustomHoliday.of(Integer.valueOf(parts[0]), Integer.valueOf(parts[1]));
        }
        throw new WrongCustomHolidayFormatException(String.format("Wrong format for custom holiday entry %s! The format should be 'dd.MM' i.e. 01.05 for the first of may. The value will be ignored!", customHolidayEntry));
    }

    private HashSet<String> getTokensWithCollection(String str, String rolesSeparator) {
        return Collections.list(new StringTokenizer(str, rolesSeparator)).stream().map(token -> String.valueOf(token).toLowerCase().trim()).collect(Collectors.toCollection(HashSet::new));
    }

    private Properties readPropertiesFromFile(String propertiesFile) {
        Properties props = new Properties();
        boolean loadFromClasspath = this.loadFromClasspath(propertiesFile);
        try {
            if (loadFromClasspath) {
                InputStream inputStream = TaskanaEngineConfiguration.class.getResourceAsStream(propertiesFile);
                if (inputStream == null) {
                    LOGGER.error("taskana properties file {} was not found on classpath.", (Object)propertiesFile);
                } else {
                    props.load(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
                    LOGGER.debug("Role properties were loaded from file {} from classpath.", (Object)propertiesFile);
                }
            } else {
                props.load(new FileInputStream(propertiesFile));
                LOGGER.debug("Role properties were loaded from file {}.", (Object)propertiesFile);
            }
        }
        catch (IOException e) {
            LOGGER.error("caught IOException when processing properties file {}.", (Object)propertiesFile);
            throw new SystemException("internal System error when processing properties file " + propertiesFile, e.getCause());
        }
        return props;
    }

    private boolean loadFromClasspath(String propertiesFile) {
        boolean loadFromClasspath = true;
        File f = new File(propertiesFile);
        if (f.exists() && !f.isDirectory()) {
            loadFromClasspath = false;
        }
        return loadFromClasspath;
    }

    private void ensureRoleMapIsFullyInitialized() {
        Arrays.stream(TaskanaRole.values()).forEach(role -> {
            Set cfr_ignored_0 = this.roleMap.putIfAbsent((TaskanaRole)((Object)role), new HashSet());
        });
    }
}

