/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.task.internal;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.classification.api.models.ClassificationSummary;
import pro.taskana.common.api.BulkOperationResults;
import pro.taskana.common.api.exceptions.InvalidArgumentException;
import pro.taskana.common.api.exceptions.TaskanaException;
import pro.taskana.common.internal.InternalTaskanaEngine;
import pro.taskana.common.internal.util.WorkingDaysToDaysConverter;
import pro.taskana.task.api.exceptions.UpdateFailedException;
import pro.taskana.task.api.models.AttachmentSummary;
import pro.taskana.task.api.models.Task;
import pro.taskana.task.internal.AttachmentMapper;
import pro.taskana.task.internal.TaskMapper;
import pro.taskana.task.internal.models.AttachmentSummaryImpl;
import pro.taskana.task.internal.models.MinimalTaskSummary;
import pro.taskana.task.internal.models.TaskImpl;

class ServiceLevelHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceLevelHandler.class);
    private static final Duration MAX_DURATION = Duration.ofSeconds(Long.MAX_VALUE, 999999999L);
    private final InternalTaskanaEngine taskanaEngine;
    private final TaskMapper taskMapper;
    private final AttachmentMapper attachmentMapper;
    private final WorkingDaysToDaysConverter converter;

    ServiceLevelHandler(InternalTaskanaEngine taskanaEngine, TaskMapper taskMapper, AttachmentMapper attachmentMapper) {
        this.taskanaEngine = taskanaEngine;
        this.taskMapper = taskMapper;
        this.attachmentMapper = attachmentMapper;
        WorkingDaysToDaysConverter.setGermanPublicHolidaysEnabled(taskanaEngine.getEngine().getConfiguration().isGermanPublicHolidaysEnabled());
        WorkingDaysToDaysConverter.setCorpusChristiEnabled(taskanaEngine.getEngine().getConfiguration().isCorpusChristiEnabled());
        this.converter = WorkingDaysToDaysConverter.initialize();
    }

    public void refreshPriorityAndDueDatesOfTasks(List<MinimalTaskSummary> tasks, boolean serviceLevelChanged, boolean priorityChanged) {
        List<AttachmentSummaryImpl> attachments = this.getAttachmentSummaries(tasks);
        List<ClassificationSummary> allInvolvedClassifications = this.findAllClassificationsReferencedByTasksAndAttachments(tasks, attachments);
        if (serviceLevelChanged) {
            List<ClassificationWithServiceLevelResolved> allInvolvedClassificationsWithDuration = this.resolveDurationsInClassifications(allInvolvedClassifications);
            this.updateTaskDueDatesOnClassificationUpdate(tasks, attachments, allInvolvedClassificationsWithDuration);
        }
        if (priorityChanged) {
            this.updateTaskPriorityOnClassificationUpdate(tasks, attachments, allInvolvedClassifications);
        }
    }

    BulkLog setPlannedPropertyOfTasksImpl(Instant planned, List<MinimalTaskSummary> tasks) {
        BulkLog bulkLog = new BulkLog();
        List<AttachmentSummaryImpl> attachments = this.getAttachmentSummaries(tasks);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("found attachments {}.", attachments);
        }
        List<ClassificationSummary> allInvolvedClassifications = this.findAllClassificationsReferencedByTasksAndAttachments(tasks, attachments);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("found involved classifications {}.", allInvolvedClassifications);
        }
        List<ClassificationWithServiceLevelResolved> allInvolvedClassificationsWithDuration = this.resolveDurationsInClassifications(allInvolvedClassifications);
        Map<Duration, List<String>> durationToTaskIdsMap = this.getDurationToTaskIdsMap(tasks, attachments, allInvolvedClassificationsWithDuration);
        BulkLog updateResult = this.updatePlannedPropertyOfAffectedTasks(planned, durationToTaskIdsMap);
        bulkLog.addAllErrors(updateResult);
        return bulkLog;
    }

    TaskImpl updatePrioPlannedDueOfTask(TaskImpl newTaskImpl, TaskImpl oldTaskImpl, boolean forRefreshOnClassificationUpdate) throws InvalidArgumentException {
        boolean onlyPriority = false;
        if (newTaskImpl.getClassificationSummary() == null || newTaskImpl.getClassificationSummary().getServiceLevel() == null) {
            newTaskImpl = this.setPlannedDueOnMissingServiceLevel(newTaskImpl);
            onlyPriority = true;
        }
        if (this.isPriorityAndDurationAlreadyCorrect(newTaskImpl, oldTaskImpl)) {
            return newTaskImpl;
        }
        if (newTaskImpl.getPlanned() == null && newTaskImpl.getDue() == null) {
            newTaskImpl.setPlanned(Instant.now());
        }
        DurationPrioHolder durationPrioHolder = this.determineTaskPrioDuration(newTaskImpl, onlyPriority);
        newTaskImpl.setPriority(durationPrioHolder.getPriority());
        if (onlyPriority) {
            return newTaskImpl;
        }
        if (forRefreshOnClassificationUpdate) {
            newTaskImpl.setDue(this.getFollowingWorkingDays(newTaskImpl.getPlanned(), durationPrioHolder.getDuration()));
            return newTaskImpl;
        }
        if (oldTaskImpl == null) {
            return this.updatePlannedDueOnCreationOfNewTask(newTaskImpl, durationPrioHolder);
        }
        return this.updatePlannedDueOnTaskUpdate(newTaskImpl, oldTaskImpl, durationPrioHolder);
    }

    DurationPrioHolder determineTaskPrioDuration(TaskImpl newTaskImpl, boolean onlyPriority) {
        Set<ClassificationSummary> classificationsInvolved = this.getClassificationsReferencedByATask(newTaskImpl);
        ArrayList<ClassificationWithServiceLevelResolved> resolvedClassifications = new ArrayList();
        if (onlyPriority) {
            for (ClassificationSummary c : classificationsInvolved) {
                resolvedClassifications.add(new ClassificationWithServiceLevelResolved(c.getId(), MAX_DURATION, 0));
            }
        } else {
            resolvedClassifications = this.resolveDurationsInClassifications(new ArrayList<ClassificationSummary>(classificationsInvolved));
        }
        return this.getFinalPrioDurationOfTask(resolvedClassifications, onlyPriority);
    }

    private TaskImpl setPlannedDueOnMissingServiceLevel(TaskImpl task) {
        Instant now = Instant.now();
        if (task.getDue() == null && task.getPlanned() == null) {
            task.setDue(now);
            task.setPlanned(now);
        } else if (task.getDue() == null) {
            task.setDue(task.getPlanned());
        } else {
            task.setPlanned(task.getDue());
        }
        return task;
    }

    private void updateTaskPriorityOnClassificationUpdate(List<MinimalTaskSummary> existingTasks, List<AttachmentSummaryImpl> attachments, List<ClassificationSummary> allInvolvedClassifications) {
        Map<Integer, List<String>> priorityToTaskIdsMap = this.getPriorityToTasksIdsMap(existingTasks, attachments, allInvolvedClassifications);
        TaskImpl referenceTask = new TaskImpl();
        referenceTask.setModified(Instant.now());
        priorityToTaskIdsMap.forEach((prio, taskIdList) -> {
            referenceTask.setPriority((int)prio);
            if (!taskIdList.isEmpty()) {
                this.taskMapper.updatePriorityOfTasks((List<String>)taskIdList, referenceTask);
            }
        });
    }

    private Map<Integer, List<String>> getPriorityToTasksIdsMap(List<MinimalTaskSummary> existingTasks, List<AttachmentSummaryImpl> attachments, List<ClassificationSummary> allInvolvedClassifications) {
        Map<String, Integer> classificationIdToPriorityMap = allInvolvedClassifications.stream().collect(Collectors.toMap(ClassificationSummary::getId, ClassificationSummary::getPriority));
        Map<String, Set<String>> taskIdToClassificationIdsMap = this.getTaskIdToClassificationsMap(existingTasks, attachments);
        List taskIdPriorities = existingTasks.stream().map(t -> new TaskIdPriority(t.getTaskId(), this.determinePriorityForATask((MinimalTaskSummary)t, classificationIdToPriorityMap, taskIdToClassificationIdsMap))).collect(Collectors.toList());
        return taskIdPriorities.stream().collect(Collectors.groupingBy(TaskIdPriority::getPriority, Collectors.mapping(TaskIdPriority::getTaskId, Collectors.toList())));
    }

    private int determinePriorityForATask(MinimalTaskSummary minimalTaskSummary, Map<String, Integer> classificationIdToPriorityMap, Map<String, Set<String>> taskIdToClassificationIdsMap) {
        int actualPriority = 0;
        for (String classificationId : taskIdToClassificationIdsMap.get(minimalTaskSummary.getTaskId())) {
            int prio = classificationIdToPriorityMap.get(classificationId);
            if (prio <= actualPriority) continue;
            actualPriority = prio;
        }
        return actualPriority;
    }

    private BulkLog updateTaskDueDatesOnClassificationUpdate(List<MinimalTaskSummary> existingTasks, List<AttachmentSummaryImpl> attachments, List<ClassificationWithServiceLevelResolved> allInvolvedClassificationsWithDuration) {
        Map<InstantDurationHolder, List<TaskDuration>> tasksPerPlannedAndDuration = this.getTasksPerPlannedAndDuration(existingTasks, attachments, allInvolvedClassificationsWithDuration);
        return this.updateDuePropertyOfAffectedTasks(tasksPerPlannedAndDuration);
    }

    private TaskImpl updatePlannedDueOnTaskUpdate(TaskImpl newTaskImpl, TaskImpl oldTaskImpl, DurationPrioHolder durationPrioHolder) throws InvalidArgumentException {
        if (newTaskImpl.getPlanned() == null && newTaskImpl.getDue() == null) {
            newTaskImpl.setPlanned(oldTaskImpl.getPlanned());
        }
        if (oldTaskImpl.getDue().equals(newTaskImpl.getDue()) && oldTaskImpl.getPlanned().equals(newTaskImpl.getPlanned())) {
            newTaskImpl.setDue(this.getFollowingWorkingDays(newTaskImpl.getPlanned(), durationPrioHolder.getDuration()));
        } else if (this.dueIsUnchangedOrNull(newTaskImpl, oldTaskImpl) && newTaskImpl.getPlanned() != null) {
            newTaskImpl.setPlanned(this.getFollowingWorkingDays(newTaskImpl.getPlanned(), Duration.ofDays(0L)));
            newTaskImpl.setDue(this.getFollowingWorkingDays(newTaskImpl.getPlanned(), durationPrioHolder.getDuration()));
        } else {
            Instant calcDue = this.getPrecedingWorkingDays(newTaskImpl.getDue(), Duration.ofDays(0L));
            Instant calcPlanned = this.getPrecedingWorkingDays(calcDue, durationPrioHolder.getDuration());
            if (this.plannedHasChanged(newTaskImpl, oldTaskImpl)) {
                this.ensureServiceLevelIsNotViolated(newTaskImpl, durationPrioHolder.getDuration(), calcPlanned);
            }
            newTaskImpl.setPlanned(calcPlanned);
            newTaskImpl.setDue(calcDue);
        }
        return newTaskImpl;
    }

    private boolean dueIsUnchangedOrNull(Task newTask, Task oldTask) {
        return newTask.getDue() == null || oldTask.getDue().equals(newTask.getDue());
    }

    private boolean plannedHasChanged(Task newTask, Task oldTask) {
        return newTask.getPlanned() != null && !oldTask.getPlanned().equals(newTask.getPlanned());
    }

    private Instant getPrecedingWorkingDays(Instant instant, Duration days) {
        return this.converter.subtractWorkingDaysFromInstant(instant, days);
    }

    private Instant getFollowingWorkingDays(Instant instant, Duration days) {
        return this.converter.addWorkingDaysToInstant(instant, days);
    }

    private void ensureServiceLevelIsNotViolated(TaskImpl task, Duration duration, Instant calcPlanned) throws InvalidArgumentException {
        if (task.getPlanned() != null && !task.getPlanned().equals(calcPlanned) && (this.converter.isWorkingDay(0L, task.getPlanned()) || this.converter.hasWorkingDaysInBetween(task.getPlanned(), calcPlanned))) {
            throw new InvalidArgumentException(String.format("Cannot update a task with given planned %s and due date %s not matching the service level %s.", task.getPlanned(), task.getDue(), duration));
        }
    }

    private TaskImpl updatePlannedDueOnCreationOfNewTask(TaskImpl newTask, DurationPrioHolder durationPrioHolder) throws InvalidArgumentException {
        if (newTask.getDue() != null) {
            Instant calcDue = this.getPrecedingWorkingDays(newTask.getDue(), Duration.ofDays(0L));
            Instant calcPlanned = this.getPrecedingWorkingDays(calcDue, durationPrioHolder.getDuration());
            this.ensureServiceLevelIsNotViolated(newTask, durationPrioHolder.getDuration(), calcPlanned);
            newTask.setDue(calcDue);
            newTask.setPlanned(calcPlanned);
        } else {
            newTask.setPlanned(this.getFollowingWorkingDays(newTask.getPlanned(), Duration.ofDays(0L)));
            newTask.setDue(this.getFollowingWorkingDays(newTask.getPlanned(), durationPrioHolder.getDuration()));
        }
        return newTask;
    }

    private BulkLog updateDuePropertyOfAffectedTasks(Map<InstantDurationHolder, List<TaskDuration>> tasksPerPlannedAndDuration) {
        BulkLog bulkLog = new BulkLog();
        tasksPerPlannedAndDuration.forEach((instDurHld, taskDurationList) -> bulkLog.addAllErrors(this.updateDuePropertyOfTasksWithIdenticalDueDate((InstantDurationHolder)instDurHld, (List<TaskDuration>)taskDurationList)));
        return bulkLog;
    }

    private BulkOperationResults<String, TaskanaException> updateDuePropertyOfTasksWithIdenticalDueDate(InstantDurationHolder durationHolder, List<TaskDuration> taskDurationList) {
        BulkLog bulkLog = new BulkLog();
        TaskImpl referenceTask = new TaskImpl();
        referenceTask.setPlanned(durationHolder.getPlanned());
        referenceTask.setModified(Instant.now());
        referenceTask.setDue(this.getFollowingWorkingDays(referenceTask.getPlanned(), durationHolder.getDuration()));
        List<String> taskIdsToUpdate = taskDurationList.stream().map(TaskDuration::getTaskId).collect(Collectors.toList());
        long numTasksUpdated = this.taskMapper.updateTaskDueDates(taskIdsToUpdate, referenceTask);
        if (numTasksUpdated != (long)taskIdsToUpdate.size()) {
            BulkLog checkResult = this.checkResultsOfTasksUpdateAndAddErrorsToBulkLog(taskIdsToUpdate, referenceTask, numTasksUpdated);
            bulkLog.addAllErrors(checkResult);
        }
        return bulkLog;
    }

    private BulkLog updatePlannedPropertyOfAffectedTasks(Instant planned, Map<Duration, List<String>> durationToTaskIdsMap) {
        BulkLog bulkLog = new BulkLog();
        TaskImpl referenceTask = new TaskImpl();
        referenceTask.setPlanned(planned);
        referenceTask.setModified(Instant.now());
        for (Map.Entry<Duration, List<String>> entry : durationToTaskIdsMap.entrySet()) {
            List<String> taskIdsToUpdate = entry.getValue();
            referenceTask.setDue(this.getFollowingWorkingDays(referenceTask.getPlanned(), entry.getKey()));
            long numTasksUpdated = this.taskMapper.updateTaskDueDates(taskIdsToUpdate, referenceTask);
            if (numTasksUpdated == (long)taskIdsToUpdate.size()) continue;
            BulkLog checkResult = this.checkResultsOfTasksUpdateAndAddErrorsToBulkLog(taskIdsToUpdate, referenceTask, numTasksUpdated);
            bulkLog.addAllErrors(checkResult);
        }
        return bulkLog;
    }

    private BulkLog checkResultsOfTasksUpdateAndAddErrorsToBulkLog(List<String> taskIdsToUpdate, TaskImpl referenceTask, long numTasksUpdated) {
        BulkLog bulkLog = new BulkLog();
        long numErrors = (long)taskIdsToUpdate.size() - numTasksUpdated;
        long numErrorsLogged = 0L;
        if (numErrors > 0L) {
            List<MinimalTaskSummary> taskSummaries = this.taskMapper.findExistingTasks(taskIdsToUpdate, null);
            for (MinimalTaskSummary task : taskSummaries) {
                if (referenceTask.getDue() == task.getDue()) continue;
                bulkLog.addError(task.getTaskId(), new UpdateFailedException(String.format("Could not set Due Date of Task with Id %s. ", task.getTaskId())));
                ++numErrorsLogged;
            }
            long numErrorsNotLogged = numErrors - numErrorsLogged;
            if (numErrorsNotLogged != 0L) {
                int i = 1;
                while ((long)i <= numErrorsNotLogged) {
                    bulkLog.addError(String.format("UnknownTaskId: %d", i), new UpdateFailedException("Update of unknown task failed"));
                    ++i;
                }
            }
        }
        return bulkLog;
    }

    private Map<Duration, List<String>> getDurationToTaskIdsMap(List<MinimalTaskSummary> minimalTaskSummariesAuthorizedFor, List<AttachmentSummaryImpl> attachments, List<ClassificationWithServiceLevelResolved> allInvolvedClassificationsWithServiceLevelResolved) {
        ArrayList<TaskDuration> resultingTaskDurations = new ArrayList<TaskDuration>();
        Map<String, Set<String>> taskIdToClassificationIdsMap = this.getTaskIdToClassificationsMap(minimalTaskSummariesAuthorizedFor, attachments);
        Map<String, Duration> classificationIdToDurationMap = allInvolvedClassificationsWithServiceLevelResolved.stream().collect(Collectors.toMap(ClassificationWithServiceLevelResolved::getClassificationId, ClassificationWithServiceLevelResolved::getDurationFromClassification));
        for (MinimalTaskSummary task : minimalTaskSummariesAuthorizedFor) {
            Duration duration = this.determineMinimalDurationForATask(taskIdToClassificationIdsMap.get(task.getTaskId()), classificationIdToDurationMap);
            TaskDuration taskDuration = new TaskDuration(task.getTaskId(), duration, task.getPlanned());
            resultingTaskDurations.add(taskDuration);
        }
        return resultingTaskDurations.stream().collect(Collectors.groupingBy(TaskDuration::getDuration, Collectors.mapping(TaskDuration::getTaskId, Collectors.toList())));
    }

    private Map<InstantDurationHolder, List<TaskDuration>> getTasksPerPlannedAndDuration(List<MinimalTaskSummary> minimalTaskSummaries, List<AttachmentSummaryImpl> attachments, List<ClassificationWithServiceLevelResolved> allInvolvedClassificationsWithServiceLevelResolved) {
        Map<String, Duration> durationPerClassificationId = this.getClassificationIdToDurationMap(allInvolvedClassificationsWithServiceLevelResolved);
        ArrayList<TaskDuration> resultingTaskDurations = new ArrayList<TaskDuration>();
        Map<String, Set<String>> taskIdClassificationIdsMap = this.getTaskIdToClassificationsMap(minimalTaskSummaries, attachments);
        for (MinimalTaskSummary task : minimalTaskSummaries) {
            Duration duration = this.determineMinimalDurationForATask(taskIdClassificationIdsMap.get(task.getTaskId()), durationPerClassificationId);
            TaskDuration taskDuration = new TaskDuration(task.getTaskId(), duration, task.getPlanned());
            resultingTaskDurations.add(taskDuration);
        }
        return resultingTaskDurations.stream().collect(Collectors.groupingBy(TaskDuration::getPlannedDuration));
    }

    private Map<String, Duration> getClassificationIdToDurationMap(List<ClassificationWithServiceLevelResolved> allInvolvedClassificationsWithServiceLevelResolved) {
        return allInvolvedClassificationsWithServiceLevelResolved.stream().collect(Collectors.toMap(ClassificationWithServiceLevelResolved::getClassificationId, ClassificationWithServiceLevelResolved::getDurationFromClassification));
    }

    private Duration determineMinimalDurationForATask(Set<String> classificationIds, Map<String, Duration> classificationIdDurationMap) {
        Duration result = MAX_DURATION;
        for (String classificationId : classificationIds) {
            Duration actualDuration = classificationIdDurationMap.get(classificationId);
            if (result.compareTo(actualDuration) <= 0) continue;
            result = actualDuration;
        }
        return result;
    }

    private Map<String, Set<String>> getTaskIdToClassificationsMap(List<MinimalTaskSummary> minimalTaskSummaries, List<AttachmentSummaryImpl> attachments) {
        HashMap<String, Set<String>> resultingTaskIdToClassificationIdsMap = new HashMap<String, Set<String>>();
        for (MinimalTaskSummary task : minimalTaskSummaries) {
            Set classificationIds = attachments.stream().filter(a -> task.getTaskId().equals(a.getTaskId())).map(AttachmentSummaryImpl::getClassificationSummary).map(ClassificationSummary::getId).collect(Collectors.toSet());
            classificationIds.add(task.getClassificationId());
            resultingTaskIdToClassificationIdsMap.put(task.getTaskId(), classificationIds);
        }
        return resultingTaskIdToClassificationIdsMap;
    }

    private List<ClassificationWithServiceLevelResolved> resolveDurationsInClassifications(List<ClassificationSummary> allInvolvedClassifications) {
        ArrayList<ClassificationWithServiceLevelResolved> result = new ArrayList<ClassificationWithServiceLevelResolved>();
        for (ClassificationSummary classification : allInvolvedClassifications) {
            Duration serviceLevel = Duration.parse(classification.getServiceLevel());
            result.add(new ClassificationWithServiceLevelResolved(classification.getId(), serviceLevel, classification.getPriority()));
        }
        return result;
    }

    private List<AttachmentSummaryImpl> getAttachmentSummaries(List<MinimalTaskSummary> existingTasksAuthorizedFor) {
        List<String> existingTaskIdsAuthorizedFor = existingTasksAuthorizedFor.stream().map(MinimalTaskSummary::getTaskId).collect(Collectors.toList());
        return existingTaskIdsAuthorizedFor.isEmpty() ? new ArrayList() : this.attachmentMapper.findAttachmentSummariesByTaskIds(existingTaskIdsAuthorizedFor);
    }

    private List<ClassificationSummary> findAllClassificationsReferencedByTasksAndAttachments(List<MinimalTaskSummary> existingTasksAuthorizedFor, List<AttachmentSummaryImpl> attachments) {
        Set<String> classificationIds = attachments.stream().map(AttachmentSummaryImpl::getClassificationSummary).map(ClassificationSummary::getId).collect(Collectors.toSet());
        Set classificationIdsFromTasks = existingTasksAuthorizedFor.stream().map(MinimalTaskSummary::getClassificationId).collect(Collectors.toSet());
        classificationIds.addAll(classificationIdsFromTasks);
        if (classificationIds.isEmpty()) {
            return new ArrayList<ClassificationSummary>();
        }
        String[] idsArrayForQuery = new String[classificationIds.size()];
        idsArrayForQuery = classificationIds.toArray(idsArrayForQuery);
        return this.taskanaEngine.getEngine().getClassificationService().createClassificationQuery().idIn(idsArrayForQuery).list();
    }

    private DurationPrioHolder getFinalPrioDurationOfTask(List<ClassificationWithServiceLevelResolved> cl, boolean onlyPriority) {
        Duration duration = MAX_DURATION;
        int priority = Integer.MIN_VALUE;
        for (ClassificationWithServiceLevelResolved classification : cl) {
            Duration actualDuration = classification.getDurationFromClassification();
            if (!onlyPriority && duration.compareTo(actualDuration) > 0) {
                duration = actualDuration;
            }
            if (classification.getPriority() <= priority) continue;
            priority = classification.getPriority();
        }
        return new DurationPrioHolder(duration, priority);
    }

    private Set<ClassificationSummary> getClassificationsReferencedByATask(TaskImpl taskImpl) {
        HashSet<ClassificationSummary> classifications = taskImpl.getAttachments() == null ? new HashSet<ClassificationSummary>() : taskImpl.getAttachments().stream().map(AttachmentSummary::getClassificationSummary).collect(Collectors.toSet());
        classifications.add(taskImpl.getClassificationSummary());
        return classifications;
    }

    private boolean isPriorityAndDurationAlreadyCorrect(TaskImpl newTaskImpl, TaskImpl oldTaskImpl) {
        if (oldTaskImpl != null) {
            boolean isClassificationKeyChanged = newTaskImpl.getClassificationKey() != null && (oldTaskImpl.getClassificationKey() == null || !newTaskImpl.getClassificationKey().equals(oldTaskImpl.getClassificationKey()));
            boolean isClassificationIdChanged = newTaskImpl.getClassificationId() != null && (oldTaskImpl.getClassificationId() == null || !newTaskImpl.getClassificationId().equals(oldTaskImpl.getClassificationId()));
            return oldTaskImpl.getPlanned().equals(newTaskImpl.getPlanned()) && oldTaskImpl.getDue().equals(newTaskImpl.getDue()) && !isClassificationKeyChanged && !isClassificationIdChanged && this.areAttachmentsUnchanged(newTaskImpl, oldTaskImpl);
        }
        return false;
    }

    private boolean areAttachmentsUnchanged(TaskImpl newTaskImpl, TaskImpl oldTaskImpl) {
        List oldAttachmentIds = oldTaskImpl.getAttachments().stream().map(AttachmentSummary::getId).collect(Collectors.toList());
        List newAttachmentIds = newTaskImpl.getAttachments().stream().map(AttachmentSummary::getId).collect(Collectors.toList());
        Set oldClassificationIds = oldTaskImpl.getAttachments().stream().map(AttachmentSummary::getClassificationSummary).map(ClassificationSummary::getId).collect(Collectors.toSet());
        Set newClassificationIds = newTaskImpl.getAttachments().stream().map(AttachmentSummary::getClassificationSummary).map(ClassificationSummary::getId).collect(Collectors.toSet());
        return oldAttachmentIds.size() == newAttachmentIds.size() && newAttachmentIds.containsAll(oldAttachmentIds) && oldClassificationIds.size() == newClassificationIds.size() && newClassificationIds.containsAll(oldClassificationIds);
    }

    private static final class ClassificationWithServiceLevelResolved {
        private final int priority;
        private final String classificationId;
        private final Duration duration;

        ClassificationWithServiceLevelResolved(String id, Duration serviceLevel, int priority) {
            this.classificationId = id;
            this.duration = serviceLevel;
            this.priority = priority;
        }

        String getClassificationId() {
            return this.classificationId;
        }

        Duration getDurationFromClassification() {
            return this.duration;
        }

        int getPriority() {
            return this.priority;
        }
    }

    private static final class InstantDurationHolder {
        private Instant planned;
        private Duration duration;

        InstantDurationHolder(Instant planned, Duration duration) {
            this.planned = planned;
            this.duration = duration;
        }

        public Instant getPlanned() {
            return this.planned;
        }

        public void setPlanned(Instant planned) {
            this.planned = planned;
        }

        public Duration getDuration() {
            return this.duration;
        }

        public void setDuration(Duration duration) {
            this.duration = duration;
        }

        public int hashCode() {
            return Objects.hash(this.planned, this.duration);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            InstantDurationHolder other = (InstantDurationHolder)obj;
            return Objects.equals(this.planned, other.planned) && Objects.equals(this.duration, other.duration);
        }
    }

    private static final class TaskIdPriority {
        private String taskId;
        private int priority;

        TaskIdPriority(String taskId, int priority) {
            this.taskId = taskId;
            this.priority = priority;
        }

        public String getTaskId() {
            return this.taskId;
        }

        public void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        public Integer getPriority() {
            return this.priority;
        }

        public void setPriority(int priority) {
            this.priority = priority;
        }
    }

    private static final class TaskDuration {
        private final String taskId;
        private final Duration duration;
        private final Instant planned;

        TaskDuration(String id, Duration serviceLevel, Instant planned) {
            this.taskId = id;
            this.duration = serviceLevel;
            this.planned = planned;
        }

        String getTaskId() {
            return this.taskId;
        }

        Duration getDuration() {
            return this.duration;
        }

        Instant getPlanned() {
            return this.planned;
        }

        InstantDurationHolder getPlannedDuration() {
            return new InstantDurationHolder(this.planned, this.duration);
        }
    }

    static final class DurationPrioHolder {
        private Duration duration;
        private int priority;

        DurationPrioHolder(Duration duration, int priority) {
            this.duration = duration;
            this.priority = priority;
        }

        Duration getDuration() {
            return this.duration;
        }

        int getPriority() {
            return this.priority;
        }
    }

    static class BulkLog
    extends BulkOperationResults<String, TaskanaException> {
        BulkLog() {
        }
    }
}

