/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.task.internal.models;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import pro.taskana.classification.internal.models.ClassificationSummaryImpl;
import pro.taskana.common.api.exceptions.InvalidArgumentException;
import pro.taskana.task.api.CallbackState;
import pro.taskana.task.api.models.Attachment;
import pro.taskana.task.api.models.AttachmentSummary;
import pro.taskana.task.api.models.Task;
import pro.taskana.task.api.models.TaskSummary;
import pro.taskana.task.internal.models.TaskSummaryImpl;
import pro.taskana.workbasket.internal.models.WorkbasketSummaryImpl;

public class TaskImpl
extends TaskSummaryImpl
implements Task {
    private static final String NOT_A_VALID_NUMBER_SET = "Argument '%s' of setCustomAttribute() cannot be converted to a number between 1 and 16";
    private Map<String, String> customAttributes = Collections.emptyMap();
    private Map<String, String> callbackInfo = Collections.emptyMap();
    private CallbackState callbackState;
    private List<Attachment> attachments = new ArrayList<Attachment>();

    public TaskImpl() {
    }

    private TaskImpl(TaskImpl copyFrom) {
        super(copyFrom);
        this.customAttributes = new HashMap<String, String>(copyFrom.customAttributes);
        this.callbackInfo = new HashMap<String, String>(copyFrom.callbackInfo);
        this.callbackState = copyFrom.callbackState;
        this.attachments = copyFrom.attachments.stream().map(Attachment::copy).collect(Collectors.toList());
    }

    public String getClassificationId() {
        return this.classificationSummary == null ? null : this.classificationSummary.getId();
    }

    @Override
    public TaskImpl copy() {
        return new TaskImpl(this);
    }

    public String getClassificationKey() {
        return this.classificationSummary == null ? null : this.classificationSummary.getKey();
    }

    @Override
    public void setClassificationKey(String classificationKey) {
        if (this.classificationSummary == null) {
            this.classificationSummary = new ClassificationSummaryImpl();
        }
        ((ClassificationSummaryImpl)this.classificationSummary).setKey(classificationKey);
    }

    @Override
    public String getWorkbasketKey() {
        return this.workbasketSummary == null ? null : this.workbasketSummary.getKey();
    }

    public void setWorkbasketKey(String workbasketKey) {
        if (this.workbasketSummary == null) {
            this.workbasketSummary = new WorkbasketSummaryImpl();
        }
        ((WorkbasketSummaryImpl)this.workbasketSummary).setKey(workbasketKey);
    }

    @Override
    public Map<String, String> getCustomAttributes() {
        return this.customAttributes;
    }

    @Override
    public void setCustomAttributes(Map<String, String> customAttributes) {
        this.customAttributes = customAttributes;
    }

    public CallbackState getCallbackState() {
        return this.callbackState;
    }

    public void setCallbackState(CallbackState callbackState) {
        this.callbackState = callbackState;
    }

    @Override
    public Map<String, String> getCallbackInfo() {
        if (this.callbackInfo == null) {
            this.callbackInfo = new HashMap<String, String>();
        }
        return this.callbackInfo;
    }

    @Override
    public void setCallbackInfo(Map<String, String> callbackInfo) {
        this.callbackInfo = callbackInfo;
    }

    @Override
    public void setCustomAttribute(String number, String value) throws InvalidArgumentException {
        int num;
        try {
            num = Integer.parseInt(number);
        }
        catch (NumberFormatException e) {
            throw new InvalidArgumentException(String.format(NOT_A_VALID_NUMBER_SET, number), e.getCause());
        }
        switch (num) {
            case 1: {
                this.custom1 = value;
                break;
            }
            case 2: {
                this.custom2 = value;
                break;
            }
            case 3: {
                this.custom3 = value;
                break;
            }
            case 4: {
                this.custom4 = value;
                break;
            }
            case 5: {
                this.custom5 = value;
                break;
            }
            case 6: {
                this.custom6 = value;
                break;
            }
            case 7: {
                this.custom7 = value;
                break;
            }
            case 8: {
                this.custom8 = value;
                break;
            }
            case 9: {
                this.custom9 = value;
                break;
            }
            case 10: {
                this.custom10 = value;
                break;
            }
            case 11: {
                this.custom11 = value;
                break;
            }
            case 12: {
                this.custom12 = value;
                break;
            }
            case 13: {
                this.custom13 = value;
                break;
            }
            case 14: {
                this.custom14 = value;
                break;
            }
            case 15: {
                this.custom15 = value;
                break;
            }
            case 16: {
                this.custom16 = value;
                break;
            }
            default: {
                throw new InvalidArgumentException(String.format(NOT_A_VALID_NUMBER_SET, number));
            }
        }
    }

    @Override
    public void addAttachment(Attachment attachmentToAdd) {
        if (this.attachments == null) {
            this.attachments = new ArrayList<Attachment>();
        }
        if (attachmentToAdd != null) {
            if (attachmentToAdd.getId() != null) {
                this.attachments.removeIf(attachment -> attachmentToAdd.getId().equals(attachment.getId()));
            }
            this.attachments.add(attachmentToAdd);
        }
    }

    @Override
    public List<Attachment> getAttachments() {
        if (this.attachments == null) {
            this.attachments = new ArrayList<Attachment>();
        }
        return this.attachments;
    }

    public void setAttachments(List<Attachment> attachments) {
        if (attachments != null) {
            this.attachments = attachments;
        } else if (this.attachments == null) {
            this.attachments = new ArrayList<Attachment>();
        }
    }

    @Override
    public TaskSummary asSummary() {
        TaskSummaryImpl taskSummary = new TaskSummaryImpl();
        ArrayList<AttachmentSummary> attSummaries = new ArrayList<AttachmentSummary>();
        for (Attachment att : this.attachments) {
            attSummaries.add(att.asSummary());
        }
        taskSummary.setAttachmentSummaries(attSummaries);
        taskSummary.setBusinessProcessId(this.businessProcessId);
        taskSummary.setClaimed(this.claimed);
        if (this.classificationSummary != null) {
            taskSummary.setClassificationSummary(this.classificationSummary);
        }
        taskSummary.setExternalId(this.externalId);
        taskSummary.setCompleted(this.completed);
        taskSummary.setCreated(this.created);
        taskSummary.setCustom1(this.custom1);
        taskSummary.setCustom2(this.custom2);
        taskSummary.setCustom3(this.custom3);
        taskSummary.setCustom4(this.custom4);
        taskSummary.setCustom5(this.custom5);
        taskSummary.setCustom6(this.custom6);
        taskSummary.setCustom7(this.custom7);
        taskSummary.setCustom8(this.custom8);
        taskSummary.setCustom9(this.custom9);
        taskSummary.setCustom10(this.custom10);
        taskSummary.setCustom11(this.custom11);
        taskSummary.setCustom12(this.custom12);
        taskSummary.setCustom13(this.custom13);
        taskSummary.setCustom14(this.custom14);
        taskSummary.setCustom15(this.custom15);
        taskSummary.setCustom16(this.custom16);
        taskSummary.setDue(this.due);
        taskSummary.setId(this.id);
        taskSummary.setModified(this.modified);
        taskSummary.setName(this.name);
        taskSummary.setCreator(this.creator);
        taskSummary.setNote(this.note);
        taskSummary.setDescription(this.description);
        taskSummary.setOwner(this.owner);
        taskSummary.setParentBusinessProcessId(this.parentBusinessProcessId);
        taskSummary.setPlanned(this.planned);
        taskSummary.setPrimaryObjRef(this.primaryObjRef);
        taskSummary.setPriority(this.priority);
        taskSummary.setRead(this.isRead);
        taskSummary.setState(this.state);
        taskSummary.setTransferred(this.isTransferred);
        taskSummary.setWorkbasketSummary(this.workbasketSummary);
        return taskSummary;
    }

    @Override
    public Attachment removeAttachment(String attachmentId) {
        Attachment result = null;
        for (Attachment attachment : this.attachments) {
            if (!attachment.getId().equals(attachmentId) || !this.attachments.remove(attachment)) continue;
            result = attachment;
            break;
        }
        return result;
    }

    @Override
    public String getClassificationCategory() {
        return this.classificationSummary == null ? null : this.classificationSummary.getCategory();
    }

    public void setClassificationCategory(String classificationCategory) {
        if (this.classificationSummary == null) {
            this.classificationSummary = new ClassificationSummaryImpl();
        }
        ((ClassificationSummaryImpl)this.classificationSummary).setCategory(classificationCategory);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TaskImpl;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.id, this.customAttributes, this.callbackInfo, this.callbackState, this.attachments});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TaskImpl)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        TaskImpl other = (TaskImpl)obj;
        if (!other.canEqual(this)) {
            return false;
        }
        return Objects.equals(this.id, other.id) && Objects.equals(this.customAttributes, other.customAttributes) && Objects.equals(this.callbackInfo, other.callbackInfo) && this.callbackState == other.callbackState && Objects.equals(this.attachments, other.attachments);
    }

    @Override
    public String toString() {
        return "TaskImpl [id=" + this.id + ", externalId=" + this.externalId + ", created=" + this.created + ", claimed=" + this.claimed + ", completed=" + this.completed + ", modified=" + this.modified + ", planned=" + this.planned + ", due=" + this.due + ", name=" + this.name + ", creator=" + this.creator + ", description=" + this.description + ", note=" + this.note + ", priority=" + this.priority + ", state=" + (Object)((Object)this.state) + ", classificationSummary=" + this.classificationSummary + ", workbasketSummary=" + this.workbasketSummary + ", businessProcessId=" + this.businessProcessId + ", parentBusinessProcessId=" + this.parentBusinessProcessId + ", owner=" + this.owner + ", primaryObjRef=" + this.primaryObjRef + ", isRead=" + this.isRead + ", isTransferred=" + this.isTransferred + ", customAttributes=" + this.customAttributes + ", callbackInfo=" + this.callbackInfo + ", callbackState=" + (Object)((Object)this.callbackState) + ", attachments=" + this.attachments + ", custom1=" + this.custom1 + ", custom2=" + this.custom2 + ", custom3=" + this.custom3 + ", custom4=" + this.custom4 + ", custom5=" + this.custom5 + ", custom6=" + this.custom6 + ", custom7=" + this.custom7 + ", custom8=" + this.custom8 + ", custom9=" + this.custom9 + ", custom10=" + this.custom10 + ", custom11=" + this.custom11 + ", custom12=" + this.custom12 + ", custom13=" + this.custom13 + ", custom14=" + this.custom14 + ", custom15=" + this.custom15 + ", custom16=" + this.custom16 + "]";
    }
}

