/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.common.internal.jobs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import pro.taskana.classification.internal.jobs.ClassificationChangedJob;
import pro.taskana.common.api.ScheduledJob;
import pro.taskana.common.api.TaskanaEngine;
import pro.taskana.common.api.exceptions.TaskanaException;
import pro.taskana.common.internal.TaskanaEngineImpl;
import pro.taskana.common.internal.jobs.TaskanaJob;
import pro.taskana.common.internal.transaction.TaskanaTransactionProvider;
import pro.taskana.task.internal.jobs.TaskCleanupJob;
import pro.taskana.task.internal.jobs.TaskRefreshJob;
import pro.taskana.workbasket.internal.jobs.WorkbasketCleanupJob;

public abstract class AbstractTaskanaJob
implements TaskanaJob {
    protected TaskanaEngineImpl taskanaEngineImpl;
    protected TaskanaTransactionProvider<Object> txProvider;
    protected ScheduledJob scheduledJob;

    public AbstractTaskanaJob(TaskanaEngine taskanaEngine, TaskanaTransactionProvider<Object> txProvider, ScheduledJob job) {
        this.taskanaEngineImpl = (TaskanaEngineImpl)taskanaEngine;
        this.txProvider = txProvider;
        this.scheduledJob = job;
    }

    public static TaskanaJob createFromScheduledJob(TaskanaEngine engine, TaskanaTransactionProvider<Object> txProvider, ScheduledJob job) throws TaskanaException {
        switch (job.getType()) {
            case CLASSIFICATIONCHANGEDJOB: {
                return new ClassificationChangedJob(engine, txProvider, job);
            }
            case UPDATETASKSJOB: {
                return new TaskRefreshJob(engine, txProvider, job);
            }
            case TASKCLEANUPJOB: {
                return new TaskCleanupJob(engine, txProvider, job);
            }
            case WORKBASKETCLEANUPJOB: {
                return new WorkbasketCleanupJob(engine, txProvider, job);
            }
        }
        throw new TaskanaException("No matching job found for " + (Object)((Object)job.getType()) + " of ScheduledJob " + job.getJobId() + ".");
    }

    protected <T> List<List<T>> partition(Collection<T> members, int maxSize) {
        ArrayList<List<T>> result = new ArrayList<List<T>>();
        ArrayList<T> internal = new ArrayList<T>();
        for (T member : members) {
            internal.add(member);
            if (internal.size() != maxSize) continue;
            result.add(internal);
            internal = new ArrayList();
        }
        if (!internal.isEmpty()) {
            result.add(internal);
        }
        return result;
    }
}

