/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.monitor.internal.preprocessor;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.common.api.WorkingDaysToDaysConverter;
import pro.taskana.common.api.exceptions.InvalidArgumentException;
import pro.taskana.monitor.api.reports.header.TimeIntervalColumnHeader;

public class WorkingDaysToDaysReportConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkingDaysToDaysReportConverter.class);
    private final WorkingDaysToDaysConverter daysToWorkingDaysConverter;
    private final Map<Integer, Integer> cacheDaysToWorkingDays;

    WorkingDaysToDaysReportConverter(List<? extends TimeIntervalColumnHeader> columnHeaders, WorkingDaysToDaysConverter daysToWorkingDaysConverter, Instant referenceDate) {
        this.daysToWorkingDaysConverter = daysToWorkingDaysConverter;
        this.cacheDaysToWorkingDays = this.generateDaysToWorkingDays(columnHeaders, referenceDate);
    }

    public static WorkingDaysToDaysReportConverter initialize(List<? extends TimeIntervalColumnHeader> columnHeaders, WorkingDaysToDaysConverter converter) throws InvalidArgumentException {
        return WorkingDaysToDaysReportConverter.initialize(columnHeaders, converter, Instant.now());
    }

    public static WorkingDaysToDaysReportConverter initialize(List<? extends TimeIntervalColumnHeader> columnHeaders, WorkingDaysToDaysConverter converter, Instant referenceDate) throws InvalidArgumentException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Initialize WorkingDaysToDaysConverter with columnHeaders: {}", columnHeaders);
        }
        if (converter == null) {
            throw new InvalidArgumentException("WorkingDaysToDaysConverter can't be null");
        }
        if (columnHeaders == null) {
            throw new InvalidArgumentException("TimeIntervalColumnHeaders can't be null");
        }
        if (referenceDate == null) {
            throw new InvalidArgumentException("ReferenceDate can't be null");
        }
        return new WorkingDaysToDaysReportConverter(columnHeaders, converter, referenceDate);
    }

    public int convertDaysToWorkingDays(int amountOfDays) {
        return this.cacheDaysToWorkingDays.getOrDefault(amountOfDays, amountOfDays);
    }

    public List<Integer> convertWorkingDaysToDays(int amountOfWorkdays) {
        List<Integer> listOfAllMatchingDays = this.cacheDaysToWorkingDays.entrySet().stream().filter(entry -> (Integer)entry.getValue() == amountOfWorkdays).map(Map.Entry::getKey).collect(Collectors.toList());
        if (listOfAllMatchingDays.isEmpty()) {
            return Collections.singletonList(amountOfWorkdays);
        }
        return listOfAllMatchingDays;
    }

    protected Map<Integer, Integer> generateDaysToWorkingDays(List<? extends TimeIntervalColumnHeader> columnHeaders, Instant referenceDate) {
        HashMap<Integer, Integer> daysToWorkingDaysMap = new HashMap<Integer, Integer>();
        daysToWorkingDaysMap.put(0, 0);
        int positiveWorkdayLimit = TimeIntervalColumnHeader.getLargestLowerLimit(columnHeaders);
        this.calculateFutureDaysToWorkingDays(daysToWorkingDaysMap, referenceDate, positiveWorkdayLimit);
        int negativeWorkdayLimit = TimeIntervalColumnHeader.getSmallestUpperLimit(columnHeaders);
        this.calculateNegativeDaysToWorkingDays(daysToWorkingDaysMap, referenceDate, negativeWorkdayLimit);
        return daysToWorkingDaysMap;
    }

    private void calculateFutureDaysToWorkingDays(HashMap<Integer, Integer> daysToWorkingDaysMap, Instant referenceDate, int workdayLimit) {
        this.calculateDaysToWorkingDays(daysToWorkingDaysMap, referenceDate, workdayLimit, 1);
    }

    private void calculateNegativeDaysToWorkingDays(HashMap<Integer, Integer> daysToWorkingDaysMap, Instant referenceDate, int workdayLimit) {
        this.calculateDaysToWorkingDays(daysToWorkingDaysMap, referenceDate, workdayLimit, -1);
    }

    private void calculateDaysToWorkingDays(HashMap<Integer, Integer> daysToWorkingDaysMap, Instant referenceDate, int workdayLimit, int direction) {
        int amountOfDays = 0;
        int amountOfWorkdays = 0;
        while (Math.abs(amountOfWorkdays) < Math.abs(workdayLimit)) {
            if (this.daysToWorkingDaysConverter.isWorkingDay(referenceDate.plus((long)(amountOfDays += direction), ChronoUnit.DAYS))) {
                amountOfWorkdays += direction;
            }
            daysToWorkingDaysMap.put(amountOfDays, amountOfWorkdays);
        }
    }

    public String toString() {
        return "DaysToWorkingDaysReportConverter [cacheDaysToWorkingDays=" + this.cacheDaysToWorkingDays + ", daysToWorkingDaysConverter=" + this.daysToWorkingDaysConverter + "]";
    }
}

