/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.spi.history.internal;

import java.util.Objects;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.TaskanaEngineConfiguration;
import pro.taskana.spi.history.api.TaskanaHistory;
import pro.taskana.spi.history.api.events.TaskanaHistoryEvent;

public final class HistoryEventProducer {
    private static final Logger LOGGER = LoggerFactory.getLogger(HistoryEventProducer.class);
    private static HistoryEventProducer singleton;
    private boolean enabled = false;
    private ServiceLoader<TaskanaHistory> serviceLoader = ServiceLoader.load(TaskanaHistory.class);

    private HistoryEventProducer(TaskanaEngineConfiguration taskanaEngineConfiguration) {
        for (TaskanaHistory history : this.serviceLoader) {
            history.initialize(taskanaEngineConfiguration);
            LOGGER.info("Registered history provider: {}", (Object)history.getClass().getName());
            this.enabled = true;
        }
        if (!this.enabled) {
            LOGGER.info("No history provider found. Running without history.");
        }
    }

    public static synchronized HistoryEventProducer getInstance(TaskanaEngineConfiguration taskanaEngineConfiguration) {
        if (singleton == null) {
            singleton = new HistoryEventProducer(taskanaEngineConfiguration);
        }
        return singleton;
    }

    public static boolean isHistoryEnabled() {
        return Objects.nonNull(singleton) && HistoryEventProducer.singleton.enabled;
    }

    public void createEvent(TaskanaHistoryEvent event) {
        LOGGER.debug("Sending event to history service providers: {}", (Object)event);
        this.serviceLoader.forEach(historyProvider -> historyProvider.create(event));
    }
}

