/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.workbasket.internal.jobs;

import java.time.Duration;
import java.time.Instant;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.common.api.BaseQuery;
import pro.taskana.common.api.BulkOperationResults;
import pro.taskana.common.api.ScheduledJob;
import pro.taskana.common.api.TaskanaEngine;
import pro.taskana.common.api.exceptions.InvalidArgumentException;
import pro.taskana.common.api.exceptions.NotAuthorizedException;
import pro.taskana.common.api.exceptions.TaskanaException;
import pro.taskana.common.internal.jobs.AbstractTaskanaJob;
import pro.taskana.common.internal.transaction.TaskanaTransactionProvider;
import pro.taskana.workbasket.api.WorkbasketQueryColumnName;

public class WorkbasketCleanupJob
extends AbstractTaskanaJob {
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkbasketCleanupJob.class);
    private final Instant firstRun;
    private final Duration runEvery;
    private final int batchSize;

    public WorkbasketCleanupJob(TaskanaEngine taskanaEngine, TaskanaTransactionProvider<Object> txProvider, ScheduledJob job) {
        super(taskanaEngine, txProvider, job);
        this.firstRun = taskanaEngine.getConfiguration().getCleanupJobFirstRun();
        this.runEvery = taskanaEngine.getConfiguration().getCleanupJobRunEvery();
        this.batchSize = taskanaEngine.getConfiguration().getMaxNumberOfUpdatesPerTransaction();
    }

    @Override
    public void run() throws TaskanaException {
        LOGGER.info("Running job to delete all workbaskets marked for deletion");
        try {
            List<String> workbasketsMarkedForDeletion = this.getWorkbasketsMarkedForDeletion();
            int totalNumberOfWorkbasketDeleted = 0;
            while (workbasketsMarkedForDeletion.size() > 0) {
                int upperLimit = this.batchSize;
                if (upperLimit > workbasketsMarkedForDeletion.size()) {
                    upperLimit = workbasketsMarkedForDeletion.size();
                }
                totalNumberOfWorkbasketDeleted += this.deleteWorkbasketsTransactionally(workbasketsMarkedForDeletion.subList(0, upperLimit));
                workbasketsMarkedForDeletion.subList(0, upperLimit).clear();
            }
            LOGGER.info("Job ended successfully. {} workbaskets deleted.", (Object)totalNumberOfWorkbasketDeleted);
        }
        catch (Exception e) {
            throw new TaskanaException("Error while processing WorkbasketCleanupJob.", e);
        }
        finally {
            this.scheduleNextCleanupJob();
        }
    }

    public static void initializeSchedule(TaskanaEngine taskanaEngine) {
        WorkbasketCleanupJob job = new WorkbasketCleanupJob(taskanaEngine, null, null);
        job.scheduleNextCleanupJob();
    }

    private List<String> getWorkbasketsMarkedForDeletion() {
        return this.taskanaEngineImpl.getWorkbasketService().createWorkbasketQuery().markedForDeletion(true).listValues(WorkbasketQueryColumnName.ID, BaseQuery.SortDirection.ASCENDING);
    }

    private int deleteWorkbasketsTransactionally(List<String> workbasketsToBeDeleted) {
        int deletedWorkbasketsCount = 0;
        if (this.txProvider != null) {
            return (Integer)this.txProvider.executeInTransaction(() -> {
                try {
                    return this.deleteWorkbaskets(workbasketsToBeDeleted);
                }
                catch (Exception e) {
                    LOGGER.warn("Could not delete workbaskets.", (Throwable)e);
                    return 0;
                }
            });
        }
        try {
            deletedWorkbasketsCount = this.deleteWorkbaskets(workbasketsToBeDeleted);
        }
        catch (Exception e) {
            LOGGER.warn("Could not delete workbaskets.", (Throwable)e);
        }
        return deletedWorkbasketsCount;
    }

    private int deleteWorkbaskets(List<String> workbasketsToBeDeleted) throws InvalidArgumentException, NotAuthorizedException {
        BulkOperationResults<String, TaskanaException> results = this.taskanaEngineImpl.getWorkbasketService().deleteWorkbaskets(workbasketsToBeDeleted);
        LOGGER.debug("{} workbasket deleted.", (Object)(workbasketsToBeDeleted.size() - results.getFailedIds().size()));
        for (String failedId : results.getFailedIds()) {
            LOGGER.warn("Workbasket with id {} could not be deleted. Reason:", (Object)failedId, (Object)results.getErrorForId(failedId));
        }
        return workbasketsToBeDeleted.size() - results.getFailedIds().size();
    }

    private void scheduleNextCleanupJob() {
        LOGGER.debug("Entry to scheduleNextCleanupJob.");
        ScheduledJob job = new ScheduledJob();
        job.setType(ScheduledJob.Type.WORKBASKETCLEANUPJOB);
        job.setDue(this.getNextDueForWorkbasketCleanupJob());
        this.taskanaEngineImpl.getJobService().createJob(job);
        LOGGER.debug("Exit from scheduleNextCleanupJob.");
    }

    private Instant getNextDueForWorkbasketCleanupJob() {
        Instant nextRunAt = this.firstRun;
        while (nextRunAt.isBefore(Instant.now())) {
            nextRunAt = nextRunAt.plus(this.runEvery);
        }
        LOGGER.info("Scheduling next run of the WorkbasketCleanupJob for {}", (Object)nextRunAt);
        return nextRunAt;
    }
}

