/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.monitor.api.reports.row;

import java.util.Map;
import pro.taskana.monitor.api.reports.item.QueryItem;
import pro.taskana.monitor.api.reports.row.Row;

public class SingleRow<I extends QueryItem>
implements Row<I> {
    private final int[] cells;
    private final String key;
    private int total = 0;
    private String displayName;

    public SingleRow(String key, int columnCount) {
        this.key = key;
        this.displayName = key;
        this.cells = new int[columnCount];
    }

    @Override
    public void addItem(I item, int index) throws IndexOutOfBoundsException {
        this.total += item.getValue();
        int n = index;
        this.cells[n] = this.cells[n] + item.getValue();
    }

    @Override
    public void updateTotalValue(I item) {
        this.total += item.getValue();
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public void setDisplayName(Map<String, String> displayMap) {
        this.displayName = displayMap.getOrDefault(this.key, this.key);
    }

    @Override
    public final int getTotalValue() {
        return this.total;
    }

    @Override
    public final int[] getCells() {
        return (int[])this.cells.clone();
    }
}

