/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.task.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.ibatis.exceptions.PersistenceException;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.common.api.BaseQuery;
import pro.taskana.common.api.exceptions.TaskanaRuntimeException;
import pro.taskana.common.internal.InternalTaskanaEngine;
import pro.taskana.task.api.ObjectReferenceQuery;
import pro.taskana.task.api.ObjectReferenceQueryColumnName;
import pro.taskana.task.api.models.ObjectReference;

public class ObjectReferenceQueryImpl
implements ObjectReferenceQuery {
    private static final String LINK_TO_MAPPER = "pro.taskana.task.internal.TaskQueryMapper.queryObjectReferences";
    private static final String LINK_TO_COUNTER = "pro.taskana.task.internal.TaskQueryMapper.countQueryObjectReferences";
    private static final String LINK_TO_VALUEMAPPER = "pro.taskana.task.internal.TaskQueryMapper.queryObjectReferenceColumnValues";
    private static final Logger LOGGER = LoggerFactory.getLogger(ObjectReferenceQueryImpl.class);
    private final InternalTaskanaEngine taskanaEngine;
    private final List<String> orderBy;
    private ObjectReferenceQueryColumnName columnName;
    private String[] company;
    private String[] system;
    private String[] systemInstance;
    private String[] type;
    private String[] value;

    ObjectReferenceQueryImpl(InternalTaskanaEngine taskanaEngine) {
        this.taskanaEngine = taskanaEngine;
        this.orderBy = new ArrayList<String>();
    }

    @Override
    public ObjectReferenceQuery companyIn(String ... companies) {
        this.company = companies;
        return this;
    }

    @Override
    public ObjectReferenceQuery systemIn(String ... systems) {
        this.system = systems;
        return this;
    }

    @Override
    public ObjectReferenceQuery systemInstanceIn(String ... systemInstances) {
        this.systemInstance = systemInstances;
        return this;
    }

    @Override
    public ObjectReferenceQuery typeIn(String ... types) {
        this.type = types;
        return this;
    }

    @Override
    public ObjectReferenceQuery valueIn(String ... values) {
        this.value = values;
        return this;
    }

    @Override
    public List<ObjectReference> list() {
        LOGGER.debug("entry to list(), this = {}", (Object)this);
        List<ObjectReference> result = new ArrayList();
        try {
            this.taskanaEngine.openConnection();
            List<ObjectReference> list = result = this.taskanaEngine.getSqlSession().selectList(LINK_TO_MAPPER, (Object)this);
            return list;
        }
        finally {
            this.taskanaEngine.returnConnection();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("exit from list(). Returning {} resulting Objects: {} ", (Object)result.size(), result);
            }
        }
    }

    @Override
    public List<ObjectReference> list(int offset, int limit) {
        LOGGER.debug("entry to list(offset = {}, limit = {}), this = {}", new Object[]{offset, limit, this});
        ArrayList<ObjectReference> result = new ArrayList();
        try {
            this.taskanaEngine.openConnection();
            RowBounds rowBounds = new RowBounds(offset, limit);
            ArrayList<ObjectReference> arrayList = result = this.taskanaEngine.getSqlSession().selectList(LINK_TO_MAPPER, (Object)this, rowBounds);
            return arrayList;
        }
        catch (PersistenceException e) {
            if (e.getMessage().contains("ERRORCODE=-4470")) {
                TaskanaRuntimeException ex = new TaskanaRuntimeException("The offset beginning was set over the amount of result-rows.", e.getCause());
                ex.setStackTrace(e.getStackTrace());
                throw ex;
            }
            throw e;
        }
        finally {
            this.taskanaEngine.returnConnection();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("exit from list(offset,limit). Returning {} resulting Objects: {} ", (Object)result.size(), result);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> listValues(ObjectReferenceQueryColumnName columnName, BaseQuery.SortDirection sortDirection) {
        LOGGER.debug("Entry to listValues(dbColumnName={}) this = {}", (Object)columnName, (Object)this);
        ArrayList<String> result = new ArrayList();
        try {
            this.taskanaEngine.openConnection();
            this.columnName = columnName;
            this.orderBy.clear();
            this.addOrderCriteria(columnName.toString(), sortDirection);
            ArrayList<String> arrayList = result = this.taskanaEngine.getSqlSession().selectList(LINK_TO_VALUEMAPPER, (Object)this);
            return arrayList;
        }
        finally {
            this.taskanaEngine.returnConnection();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Exit from listValues. Returning {} resulting Objects: {} ", (Object)result.size(), result);
            }
        }
    }

    @Override
    public ObjectReference single() {
        ObjectReference objectReference;
        LOGGER.debug("entry to single(), this = {}", (Object)this);
        ObjectReference result = null;
        try {
            this.taskanaEngine.openConnection();
            objectReference = result = (ObjectReference)this.taskanaEngine.getSqlSession().selectOne(LINK_TO_MAPPER, (Object)this);
            this.taskanaEngine.returnConnection();
        }
        catch (Throwable throwable) {
            this.taskanaEngine.returnConnection();
            LOGGER.debug("exit from single(). Returning result {} ", result);
            throw throwable;
        }
        LOGGER.debug("exit from single(). Returning result {} ", (Object)result);
        return objectReference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long count() {
        long l;
        LOGGER.debug("entry to count(), this = {}", (Object)this);
        Long rowCount = null;
        try {
            this.taskanaEngine.openConnection();
            rowCount = (Long)this.taskanaEngine.getSqlSession().selectOne(LINK_TO_COUNTER, (Object)this);
            l = rowCount == null ? 0L : rowCount;
            this.taskanaEngine.returnConnection();
        }
        catch (Throwable throwable) {
            this.taskanaEngine.returnConnection();
            LOGGER.debug("exit from count(). Returning result {} ", rowCount);
            throw throwable;
        }
        LOGGER.debug("exit from count(). Returning result {} ", (Object)rowCount);
        return l;
    }

    public String[] getCompany() {
        return this.company;
    }

    public void setCompany(String[] company) {
        this.company = company;
    }

    public String[] getSystem() {
        return this.system;
    }

    public void setSystem(String[] system) {
        this.system = system;
    }

    public String[] getSystemInstance() {
        return this.systemInstance;
    }

    public void setSystemInstance(String[] systemInstance) {
        this.systemInstance = systemInstance;
    }

    public String[] getType() {
        return this.type;
    }

    public void setType(String[] type) {
        this.type = type;
    }

    public String[] getValue() {
        return this.value;
    }

    public void setValue(String[] value) {
        this.value = value;
    }

    public ObjectReferenceQueryColumnName getColumnName() {
        return this.columnName;
    }

    private ObjectReferenceQuery addOrderCriteria(String colName, BaseQuery.SortDirection sortDirection) {
        String orderByDirection = " " + (Object)((Object)(sortDirection == null ? BaseQuery.SortDirection.ASCENDING : sortDirection));
        this.orderBy.add(colName + orderByDirection);
        return this;
    }

    public String toString() {
        return "ObjectReferenceQueryImpl [taskanaEngine=" + this.taskanaEngine + ", columnName=" + this.columnName + ", company=" + Arrays.toString(this.company) + ", system=" + Arrays.toString(this.system) + ", systemInstance=" + Arrays.toString(this.systemInstance) + ", type=" + Arrays.toString(this.type) + ", value=" + Arrays.toString(this.value) + ", orderBy=" + this.orderBy + "]";
    }
}

