/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.task.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import org.apache.ibatis.exceptions.PersistenceException;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.common.api.BaseQuery;
import pro.taskana.common.api.KeyDomain;
import pro.taskana.common.api.TaskanaRole;
import pro.taskana.common.api.TimeInterval;
import pro.taskana.common.api.exceptions.InvalidArgumentException;
import pro.taskana.common.api.exceptions.NotAuthorizedException;
import pro.taskana.common.api.exceptions.SystemException;
import pro.taskana.common.api.exceptions.TaskanaRuntimeException;
import pro.taskana.common.internal.InternalTaskanaEngine;
import pro.taskana.common.internal.configuration.DB;
import pro.taskana.common.internal.security.CurrentUserContext;
import pro.taskana.task.api.CallbackState;
import pro.taskana.task.api.ObjectReferenceQuery;
import pro.taskana.task.api.TaskCustomField;
import pro.taskana.task.api.TaskQuery;
import pro.taskana.task.api.TaskQueryColumnName;
import pro.taskana.task.api.TaskState;
import pro.taskana.task.api.WildcardSearchField;
import pro.taskana.task.api.models.TaskSummary;
import pro.taskana.task.internal.ObjectReferenceQueryImpl;
import pro.taskana.task.internal.TaskServiceImpl;
import pro.taskana.task.internal.models.TaskSummaryImpl;
import pro.taskana.workbasket.api.WorkbasketPermission;
import pro.taskana.workbasket.api.exceptions.NotAuthorizedToQueryWorkbasketException;
import pro.taskana.workbasket.api.exceptions.WorkbasketNotFoundException;
import pro.taskana.workbasket.internal.WorkbasketQueryImpl;

public class TaskQueryImpl
implements TaskQuery {
    private static final String LINK_TO_MAPPER = "pro.taskana.task.internal.TaskQueryMapper.queryTaskSummaries";
    private static final String LINK_TO_MAPPER_DB2 = "pro.taskana.task.internal.TaskQueryMapper.queryTaskSummariesDb2";
    private static final String LINK_TO_COUNTER = "pro.taskana.task.internal.TaskQueryMapper.countQueryTasks";
    private static final String LINK_TO_COUNTER_DB2 = "pro.taskana.task.internal.TaskQueryMapper.countQueryTasksDb2";
    private static final String LINK_TO_VALUE_MAPPER = "pro.taskana.task.internal.TaskQueryMapper.queryTaskColumnValues";
    private static final String TIME_INTERVAL = "TimeInterval ";
    private static final String IS_INVALID = " is invalid.";
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskQueryImpl.class);
    private final InternalTaskanaEngine taskanaEngine;
    private final TaskServiceImpl taskService;
    private final List<String> orderBy;
    private final List<String> orderColumns;
    private TaskQueryColumnName columnName;
    private String[] nameIn;
    private String[] nameLike;
    private String[] externalIdIn;
    private String[] externalIdLike;
    private String[] creatorIn;
    private String[] creatorLike;
    private String[] taskIds;
    private String[] description;
    private String[] note;
    private String[] noteLike;
    private int[] priority;
    private KeyDomain[] workbasketKeyDomainIn;
    private String[] workbasketIdIn;
    private TaskState[] stateIn;
    private String[] classificationIdIn;
    private String[] classificationKeyIn;
    private String[] classificationKeyLike;
    private String[] classificationKeyNotIn;
    private String[] classificationCategoryIn;
    private String[] classificationCategoryLike;
    private String[] classificationNameIn;
    private String[] classificationNameLike;
    private String[] ownerIn;
    private String[] ownerLike;
    private Boolean isRead;
    private Boolean isTransferred;
    private String[] porCompanyIn;
    private String[] porCompanyLike;
    private String[] porSystemIn;
    private String[] porSystemLike;
    private String[] porSystemInstanceIn;
    private String[] porSystemInstanceLike;
    private String[] porTypeIn;
    private String[] porTypeLike;
    private String[] porValueIn;
    private String[] porValueLike;
    private String[] parentBusinessProcessIdIn;
    private String[] parentBusinessProcessIdLike;
    private String[] businessProcessIdIn;
    private String[] businessProcessIdLike;
    private CallbackState[] callbackStateIn;
    private String[] custom1In;
    private String[] custom1Like;
    private String[] custom2In;
    private String[] custom2Like;
    private String[] custom3In;
    private String[] custom3Like;
    private String[] custom4In;
    private String[] custom4Like;
    private String[] custom5In;
    private String[] custom5Like;
    private String[] custom6In;
    private String[] custom6Like;
    private String[] custom7In;
    private String[] custom7Like;
    private String[] custom8In;
    private String[] custom8Like;
    private String[] custom9In;
    private String[] custom9Like;
    private String[] custom10In;
    private String[] custom10Like;
    private String[] custom11In;
    private String[] custom11Like;
    private String[] custom12In;
    private String[] custom12Like;
    private String[] custom13In;
    private String[] custom13Like;
    private String[] custom14In;
    private String[] custom14Like;
    private String[] custom15In;
    private String[] custom15Like;
    private String[] custom16In;
    private String[] custom16Like;
    private String[] attachmentClassificationKeyIn;
    private String[] attachmentClassificationKeyLike;
    private String[] attachmentClassificationIdIn;
    private String[] attachmentClassificationIdLike;
    private String[] attachmentClassificationNameIn;
    private String[] attachmentClassificationNameLike;
    private String[] attachmentChannelIn;
    private String[] attachmentChannelLike;
    private String[] attachmentReferenceIn;
    private String[] attachmentReferenceLike;
    private TimeInterval[] attachmentReceivedIn;
    private String[] accessIdIn;
    private boolean filterByAccessIdIn;
    private TimeInterval[] createdIn;
    private TimeInterval[] claimedIn;
    private TimeInterval[] completedIn;
    private TimeInterval[] modifiedIn;
    private TimeInterval[] plannedIn;
    private TimeInterval[] dueIn;
    private WildcardSearchField[] wildcardSearchFieldIn;
    private String wildcardSearchValueLike;
    private boolean selectAndClaim;
    private boolean useDistinctKeyword = false;
    private boolean joinWithAttachments = false;
    private boolean joinWithClassifications = false;
    private boolean joinWithAttachmentClassifications = false;
    private boolean addAttachmentColumnsToSelectClauseForOrdering = false;
    private boolean addClassificationNameToSelectClauseForOrdering = false;
    private boolean addAttachmentClassificationNameToSelectClauseForOrdering = false;

    TaskQueryImpl(InternalTaskanaEngine taskanaEngine) {
        this.taskanaEngine = taskanaEngine;
        this.taskService = (TaskServiceImpl)taskanaEngine.getEngine().getTaskService();
        this.orderBy = new ArrayList<String>();
        this.orderColumns = new ArrayList<String>();
        this.filterByAccessIdIn = true;
    }

    @Override
    public TaskQuery nameIn(String ... names) {
        this.nameIn = names;
        return this;
    }

    @Override
    public TaskQuery nameLike(String ... names) {
        this.nameLike = this.toUpperCopy(names);
        return this;
    }

    @Override
    public TaskQuery externalIdIn(String ... externalIds) {
        this.externalIdIn = externalIds;
        return this;
    }

    @Override
    public TaskQuery externalIdLike(String ... externalIds) {
        this.externalIdLike = this.toUpperCopy(externalIds);
        return this;
    }

    @Override
    public TaskQuery creatorIn(String ... creators) {
        this.creatorIn = creators;
        return this;
    }

    @Override
    public TaskQuery creatorLike(String ... creators) {
        this.creatorLike = this.toUpperCopy(creators);
        return this;
    }

    @Override
    public TaskQuery descriptionLike(String ... description) {
        this.description = this.toUpperCopy(description);
        return this;
    }

    @Override
    public TaskQuery noteLike(String ... note) {
        this.noteLike = this.toUpperCopy(note);
        return this;
    }

    @Override
    public TaskQuery priorityIn(int ... priorities) {
        this.priority = priorities;
        return this;
    }

    @Override
    public TaskQuery stateIn(TaskState ... states) {
        this.stateIn = states;
        return this;
    }

    @Override
    public TaskQuery stateNotIn(TaskState ... states) {
        this.stateIn = EnumSet.complementOf(EnumSet.copyOf(Arrays.asList(states))).toArray(new TaskState[0]);
        return this;
    }

    @Override
    public TaskQuery classificationKeyIn(String ... classificationKey) {
        this.classificationKeyIn = classificationKey;
        return this;
    }

    @Override
    public TaskQuery classificationKeyNotIn(String ... classificationKeys) {
        this.classificationKeyNotIn = classificationKeys;
        return this;
    }

    @Override
    public TaskQuery classificationKeyLike(String ... classificationKeys) {
        this.classificationKeyLike = this.toUpperCopy(classificationKeys);
        return this;
    }

    @Override
    public TaskQuery classificationIdIn(String ... classificationId) {
        this.classificationIdIn = classificationId;
        return this;
    }

    @Override
    public TaskQuery classificationCategoryIn(String ... classificationCategories) {
        this.classificationCategoryIn = classificationCategories;
        return this;
    }

    @Override
    public TaskQuery classificationCategoryLike(String ... classificationCategories) {
        this.classificationCategoryLike = this.toUpperCopy(classificationCategories);
        return this;
    }

    @Override
    public TaskQuery classificationNameIn(String ... classificationNames) {
        this.joinWithClassifications = true;
        this.classificationNameIn = classificationNames;
        return this;
    }

    @Override
    public TaskQuery classificationNameLike(String ... classificationNames) {
        this.joinWithClassifications = true;
        this.classificationNameLike = this.toUpperCopy(classificationNames);
        return this;
    }

    @Override
    public TaskQuery workbasketKeyDomainIn(KeyDomain ... workbasketIdentifiers) {
        this.workbasketKeyDomainIn = workbasketIdentifiers;
        return this;
    }

    @Override
    public TaskQuery workbasketIdIn(String ... workbasketIds) {
        this.workbasketIdIn = workbasketIds;
        return this;
    }

    @Override
    public TaskQuery ownerIn(String ... owners) {
        this.ownerIn = owners;
        return this;
    }

    @Override
    public TaskQuery ownerLike(String ... owners) {
        this.ownerLike = this.toUpperCopy(owners);
        return this;
    }

    @Override
    public TaskQuery primaryObjectReferenceCompanyIn(String ... companies) {
        this.porCompanyIn = companies;
        return this;
    }

    @Override
    public TaskQuery primaryObjectReferenceCompanyLike(String ... company) {
        this.porCompanyLike = this.toUpperCopy(company);
        return this;
    }

    @Override
    public TaskQuery primaryObjectReferenceSystemIn(String ... systems) {
        this.porSystemIn = systems;
        return this;
    }

    @Override
    public TaskQuery primaryObjectReferenceSystemLike(String ... system) {
        this.porSystemLike = this.toUpperCopy(system);
        return this;
    }

    @Override
    public TaskQuery primaryObjectReferenceSystemInstanceIn(String ... systemInstances) {
        this.porSystemInstanceIn = systemInstances;
        return this;
    }

    @Override
    public TaskQuery primaryObjectReferenceSystemInstanceLike(String ... systemInstance) {
        this.porSystemInstanceLike = this.toUpperCopy(systemInstance);
        return this;
    }

    @Override
    public TaskQuery primaryObjectReferenceTypeIn(String ... types) {
        this.porTypeIn = types;
        return this;
    }

    @Override
    public TaskQuery primaryObjectReferenceTypeLike(String ... type) {
        this.porTypeLike = this.toUpperCopy(type);
        return this;
    }

    @Override
    public TaskQuery primaryObjectReferenceValueLike(String ... value) {
        this.porValueLike = this.toUpperCopy(value);
        return this;
    }

    @Override
    public TaskQuery primaryObjectReferenceValueIn(String ... values) {
        this.porValueIn = values;
        return this;
    }

    @Override
    public TaskQuery createdWithin(TimeInterval ... intervals) {
        this.createdIn = intervals;
        for (TimeInterval ti : intervals) {
            if (ti.isValid()) continue;
            throw new IllegalArgumentException(TIME_INTERVAL + ti + IS_INVALID);
        }
        return this;
    }

    @Override
    public TaskQuery claimedWithin(TimeInterval ... intervals) {
        this.claimedIn = intervals;
        for (TimeInterval ti : intervals) {
            if (ti.isValid()) continue;
            throw new IllegalArgumentException(TIME_INTERVAL + ti + IS_INVALID);
        }
        return this;
    }

    @Override
    public TaskQuery completedWithin(TimeInterval ... intervals) {
        this.completedIn = intervals;
        for (TimeInterval ti : intervals) {
            if (ti.isValid()) continue;
            throw new IllegalArgumentException(TIME_INTERVAL + ti + IS_INVALID);
        }
        return this;
    }

    @Override
    public TaskQuery modifiedWithin(TimeInterval ... intervals) {
        this.modifiedIn = intervals;
        for (TimeInterval ti : intervals) {
            if (ti.isValid()) continue;
            throw new IllegalArgumentException(TIME_INTERVAL + ti + IS_INVALID);
        }
        return this;
    }

    @Override
    public TaskQuery plannedWithin(TimeInterval ... intervals) {
        this.plannedIn = intervals;
        for (TimeInterval ti : intervals) {
            if (ti.isValid()) continue;
            throw new IllegalArgumentException(TIME_INTERVAL + ti + IS_INVALID);
        }
        return this;
    }

    @Override
    public TaskQuery dueWithin(TimeInterval ... intervals) {
        this.dueIn = intervals;
        for (TimeInterval ti : intervals) {
            if (ti.isValid()) continue;
            throw new IllegalArgumentException(TIME_INTERVAL + ti + IS_INVALID);
        }
        return this;
    }

    @Override
    public TaskQuery readEquals(Boolean isRead) {
        this.isRead = isRead;
        return this;
    }

    @Override
    public TaskQuery transferredEquals(Boolean isTransferred) {
        this.isTransferred = isTransferred;
        return this;
    }

    public TaskQuery selectAndClaimEquals(boolean selectAndClaim) {
        this.selectAndClaim = selectAndClaim;
        return this;
    }

    @Override
    public TaskQuery parentBusinessProcessIdIn(String ... parentBusinessProcessIds) {
        this.parentBusinessProcessIdIn = parentBusinessProcessIds;
        return this;
    }

    @Override
    public TaskQuery parentBusinessProcessIdLike(String ... parentBusinessProcessId) {
        this.parentBusinessProcessIdLike = this.toUpperCopy(parentBusinessProcessId);
        return this;
    }

    @Override
    public TaskQuery businessProcessIdIn(String ... businessProcessIds) {
        this.businessProcessIdIn = businessProcessIds;
        return this;
    }

    @Override
    public TaskQuery businessProcessIdLike(String ... businessProcessIds) {
        this.businessProcessIdLike = this.toUpperCopy(businessProcessIds);
        return this;
    }

    @Override
    public TaskQuery customAttributeIn(TaskCustomField customField, String ... strings) throws InvalidArgumentException {
        if (strings.length == 0) {
            throw new InvalidArgumentException("At least one string has to be provided as a search parameter");
        }
        switch (customField) {
            case CUSTOM_1: {
                this.custom1In = strings;
                break;
            }
            case CUSTOM_2: {
                this.custom2In = strings;
                break;
            }
            case CUSTOM_3: {
                this.custom3In = strings;
                break;
            }
            case CUSTOM_4: {
                this.custom4In = strings;
                break;
            }
            case CUSTOM_5: {
                this.custom5In = strings;
                break;
            }
            case CUSTOM_6: {
                this.custom6In = strings;
                break;
            }
            case CUSTOM_7: {
                this.custom7In = strings;
                break;
            }
            case CUSTOM_8: {
                this.custom8In = strings;
                break;
            }
            case CUSTOM_9: {
                this.custom9In = strings;
                break;
            }
            case CUSTOM_10: {
                this.custom10In = strings;
                break;
            }
            case CUSTOM_11: {
                this.custom11In = strings;
                break;
            }
            case CUSTOM_12: {
                this.custom12In = strings;
                break;
            }
            case CUSTOM_13: {
                this.custom13In = strings;
                break;
            }
            case CUSTOM_14: {
                this.custom14In = strings;
                break;
            }
            case CUSTOM_15: {
                this.custom15In = strings;
                break;
            }
            case CUSTOM_16: {
                this.custom16In = strings;
                break;
            }
            default: {
                throw new SystemException("Unknown custom attribute '" + (Object)((Object)customField) + "'");
            }
        }
        return this;
    }

    @Override
    public TaskQuery customAttributeLike(TaskCustomField customField, String ... strings) throws InvalidArgumentException {
        if (strings.length == 0) {
            throw new InvalidArgumentException("At least one string has to be provided as a search parameter");
        }
        switch (customField) {
            case CUSTOM_1: {
                this.custom1Like = this.toUpperCopy(strings);
                break;
            }
            case CUSTOM_2: {
                this.custom2Like = this.toUpperCopy(strings);
                break;
            }
            case CUSTOM_3: {
                this.custom3Like = this.toUpperCopy(strings);
                break;
            }
            case CUSTOM_4: {
                this.custom4Like = this.toUpperCopy(strings);
                break;
            }
            case CUSTOM_5: {
                this.custom5Like = this.toUpperCopy(strings);
                break;
            }
            case CUSTOM_6: {
                this.custom6Like = this.toUpperCopy(strings);
                break;
            }
            case CUSTOM_7: {
                this.custom7Like = this.toUpperCopy(strings);
                break;
            }
            case CUSTOM_8: {
                this.custom8Like = this.toUpperCopy(strings);
                break;
            }
            case CUSTOM_9: {
                this.custom9Like = this.toUpperCopy(strings);
                break;
            }
            case CUSTOM_10: {
                this.custom10Like = this.toUpperCopy(strings);
                break;
            }
            case CUSTOM_11: {
                this.custom11Like = this.toUpperCopy(strings);
                break;
            }
            case CUSTOM_12: {
                this.custom12Like = this.toUpperCopy(strings);
                break;
            }
            case CUSTOM_13: {
                this.custom13Like = this.toUpperCopy(strings);
                break;
            }
            case CUSTOM_14: {
                this.custom14Like = this.toUpperCopy(strings);
                break;
            }
            case CUSTOM_15: {
                this.custom15Like = this.toUpperCopy(strings);
                break;
            }
            case CUSTOM_16: {
                this.custom16Like = this.toUpperCopy(strings);
                break;
            }
            default: {
                throw new SystemException("Unknown custom field '" + (Object)((Object)customField) + "'");
            }
        }
        return this;
    }

    @Override
    public TaskQuery attachmentClassificationKeyIn(String ... attachmentClassificationKeys) {
        this.joinWithAttachments = true;
        this.attachmentClassificationKeyIn = attachmentClassificationKeys;
        return this;
    }

    @Override
    public TaskQuery attachmentClassificationKeyLike(String ... attachmentClassificationKey) {
        this.joinWithAttachments = true;
        this.attachmentClassificationKeyLike = this.toUpperCopy(attachmentClassificationKey);
        return this;
    }

    @Override
    public TaskQuery attachmentClassificationIdIn(String ... attachmentClassificationId) {
        this.joinWithAttachments = true;
        this.attachmentClassificationIdIn = attachmentClassificationId;
        return this;
    }

    @Override
    public TaskQuery attachmentClassificationIdLike(String ... attachmentClassificationId) {
        this.joinWithAttachments = true;
        this.attachmentClassificationIdLike = this.toUpperCopy(attachmentClassificationId);
        return this;
    }

    @Override
    public TaskQuery attachmentClassificationNameIn(String ... attachmentClassificationName) {
        this.joinWithAttachmentClassifications = true;
        this.attachmentClassificationNameIn = attachmentClassificationName;
        return this;
    }

    @Override
    public TaskQuery attachmentClassificationNameLike(String ... attachmentClassificationName) {
        this.joinWithAttachmentClassifications = true;
        this.attachmentClassificationNameLike = this.toUpperCopy(attachmentClassificationName);
        return this;
    }

    @Override
    public TaskQuery attachmentChannelIn(String ... attachmentChannel) {
        this.joinWithAttachments = true;
        this.attachmentChannelIn = attachmentChannel;
        return this;
    }

    @Override
    public TaskQuery attachmentChannelLike(String ... attachmentChannel) {
        this.joinWithAttachments = true;
        this.attachmentChannelLike = this.toUpperCopy(attachmentChannel);
        return this;
    }

    @Override
    public TaskQuery attachmentReferenceValueIn(String ... referenceValue) {
        this.joinWithAttachments = true;
        this.attachmentReferenceIn = referenceValue;
        return this;
    }

    @Override
    public TaskQuery attachmentReferenceValueLike(String ... referenceValue) {
        this.joinWithAttachments = true;
        this.attachmentReferenceLike = this.toUpperCopy(referenceValue);
        return this;
    }

    @Override
    public TaskQuery attachmentReceivedWithin(TimeInterval ... receivedIn) {
        this.joinWithAttachments = true;
        this.attachmentReceivedIn = receivedIn;
        for (TimeInterval ti : receivedIn) {
            if (ti.isValid()) continue;
            throw new IllegalArgumentException(TIME_INTERVAL + ti + IS_INVALID);
        }
        return this;
    }

    @Override
    public TaskQuery callbackStateIn(CallbackState ... states) {
        this.callbackStateIn = states;
        return this;
    }

    @Override
    public ObjectReferenceQuery createObjectReferenceQuery() {
        return new ObjectReferenceQueryImpl(this.taskanaEngine);
    }

    @Override
    public TaskQuery orderByBusinessProcessId(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("BUSINESS_PROCESS_ID", sortDirection);
    }

    @Override
    public TaskQuery orderByClaimed(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("CLAIMED", sortDirection);
    }

    @Override
    public TaskQuery orderByClassificationKey(BaseQuery.SortDirection sortDirection) {
        return DB.DB2.dbProductId.equals(this.getDatabaseId()) ? this.addOrderCriteria("TCLASSIFICATION_KEY", sortDirection) : this.addOrderCriteria("t.CLASSIFICATION_KEY", sortDirection);
    }

    @Override
    public TaskQuery orderByClassificationName(BaseQuery.SortDirection sortDirection) {
        this.joinWithClassifications = true;
        this.addClassificationNameToSelectClauseForOrdering = true;
        return DB.DB2.dbProductId.equals(this.getDatabaseId()) ? this.addOrderCriteria("CNAME", sortDirection) : this.addOrderCriteria("c.NAME", sortDirection);
    }

    @Override
    public TaskQuery wildcardSearchValueLike(String wildcardSearchValue) {
        this.wildcardSearchValueLike = wildcardSearchValue;
        return this;
    }

    @Override
    public TaskQuery wildcardSearchFieldsIn(WildcardSearchField ... wildcardSearchFields) {
        this.wildcardSearchFieldIn = wildcardSearchFields;
        return this;
    }

    @Override
    public TaskQuery orderByCompleted(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("COMPLETED", sortDirection);
    }

    @Override
    public TaskQuery orderByCreated(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("CREATED", sortDirection);
    }

    @Override
    public TaskQuery orderByDomain(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("DOMAIN", sortDirection);
    }

    @Override
    public TaskQuery orderByDue(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("DUE", sortDirection);
    }

    @Override
    public TaskQuery orderByTaskId(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("ID", sortDirection);
    }

    @Override
    public TaskQuery orderByModified(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("MODIFIED", sortDirection);
    }

    @Override
    public TaskQuery orderByName(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("NAME", sortDirection);
    }

    @Override
    public TaskQuery orderByCreator(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("CREATOR", sortDirection);
    }

    @Override
    public TaskQuery orderByNote(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("NOTE", sortDirection);
    }

    @Override
    public TaskQuery orderByOwner(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("OWNER", sortDirection);
    }

    @Override
    public TaskQuery orderByParentBusinessProcessId(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("PARENT_BUSINESS_PROCESS_ID", sortDirection);
    }

    @Override
    public TaskQuery orderByPlanned(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("PLANNED", sortDirection);
    }

    @Override
    public TaskQuery orderByPrimaryObjectReferenceCompany(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("POR_COMPANY", sortDirection);
    }

    @Override
    public TaskQuery orderByPrimaryObjectReferenceSystem(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("POR_SYSTEM", sortDirection);
    }

    @Override
    public TaskQuery orderByPrimaryObjectReferenceSystemInstance(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("POR_INSTANCE", sortDirection);
    }

    @Override
    public TaskQuery orderByPrimaryObjectReferenceType(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("POR_TYPE", sortDirection);
    }

    @Override
    public TaskQuery orderByPrimaryObjectReferenceValue(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("POR_VALUE", sortDirection);
    }

    @Override
    public TaskQuery orderByPriority(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("PRIORITY", sortDirection);
    }

    @Override
    public TaskQuery orderByState(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("STATE", sortDirection);
    }

    @Override
    public TaskQuery orderByWorkbasketKey(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("WORKBASKET_KEY", sortDirection);
    }

    @Override
    public TaskQuery orderByCustomAttribute(TaskCustomField customField, BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria(customField.name(), sortDirection);
    }

    @Override
    public TaskQuery idIn(String ... taskIds) {
        this.taskIds = taskIds;
        return this;
    }

    @Override
    public TaskQuery orderByWorkbasketId(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("WORKBASKET_ID", sortDirection);
    }

    @Override
    public TaskQuery orderByAttachmentClassificationKey(BaseQuery.SortDirection sortDirection) {
        this.joinWithAttachments = true;
        this.addAttachmentColumnsToSelectClauseForOrdering = true;
        return DB.DB2.dbProductId.equals(this.getDatabaseId()) ? this.addOrderCriteria("ACLASSIFICATION_KEY", sortDirection) : this.addOrderCriteria("a.CLASSIFICATION_KEY", sortDirection);
    }

    @Override
    public TaskQuery orderByAttachmentClassificationName(BaseQuery.SortDirection sortDirection) {
        this.joinWithAttachments = true;
        this.addAttachmentClassificationNameToSelectClauseForOrdering = true;
        return DB.DB2.dbProductId.equals(this.getDatabaseId()) ? this.addOrderCriteria("ACNAME", sortDirection) : this.addOrderCriteria("ac.NAME", sortDirection);
    }

    @Override
    public TaskQuery orderByAttachmentClassificationId(BaseQuery.SortDirection sortDirection) {
        this.joinWithAttachments = true;
        this.addAttachmentColumnsToSelectClauseForOrdering = true;
        return DB.DB2.dbProductId.equals(this.getDatabaseId()) ? this.addOrderCriteria("ACLASSIFICATION_ID", sortDirection) : this.addOrderCriteria("a.CLASSIFICATION_ID", sortDirection);
    }

    @Override
    public TaskQuery orderByAttachmentChannel(BaseQuery.SortDirection sortDirection) {
        this.joinWithAttachments = true;
        this.addAttachmentColumnsToSelectClauseForOrdering = true;
        return this.addOrderCriteria("CHANNEL", sortDirection);
    }

    @Override
    public TaskQuery orderByAttachmentReference(BaseQuery.SortDirection sortDirection) {
        this.joinWithAttachments = true;
        this.addAttachmentColumnsToSelectClauseForOrdering = true;
        return this.addOrderCriteria("REF_VALUE", sortDirection);
    }

    @Override
    public TaskQuery orderByAttachmentReceived(BaseQuery.SortDirection sortDirection) {
        this.joinWithAttachments = true;
        this.addAttachmentColumnsToSelectClauseForOrdering = true;
        return this.addOrderCriteria("RECEIVED", sortDirection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TaskSummary> list() {
        ArrayList<TaskSummary> result = new ArrayList();
        try {
            LOGGER.debug("entry to list(), this = {}", (Object)this);
            this.taskanaEngine.openConnection();
            this.checkForIllegalParamCombinations();
            this.checkOpenAndReadPermissionForSpecifiedWorkbaskets();
            this.setupJoinAndOrderParameters();
            this.setupAccessIds();
            List tasks = this.taskanaEngine.getSqlSession().selectList(this.getLinkToMapperScript(), (Object)this);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("mapper returned {} resulting Objects: {} ", (Object)tasks.size(), (Object)tasks);
            }
            ArrayList<TaskSummary> arrayList = result = this.taskService.augmentTaskSummariesByContainedSummaries(tasks);
            return arrayList;
        }
        finally {
            this.taskanaEngine.returnConnection();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("exit from list(). Returning {} resulting Objects: {} ", (Object)result.size(), result);
            }
        }
    }

    @Override
    public List<TaskSummary> list(int offset, int limit) {
        LOGGER.debug("entry to list(offset = {}, limit = {}), this = {}", new Object[]{offset, limit, this});
        ArrayList<TaskSummary> result = new ArrayList();
        try {
            this.taskanaEngine.openConnection();
            this.checkForIllegalParamCombinations();
            this.checkOpenAndReadPermissionForSpecifiedWorkbaskets();
            this.setupAccessIds();
            this.setupJoinAndOrderParameters();
            RowBounds rowBounds = new RowBounds(offset, limit);
            List tasks = this.taskanaEngine.getSqlSession().selectList(this.getLinkToMapperScript(), (Object)this, rowBounds);
            ArrayList<TaskSummary> arrayList = result = this.taskService.augmentTaskSummariesByContainedSummaries(tasks);
            return arrayList;
        }
        catch (PersistenceException e) {
            if (e.getMessage().contains("ERRORCODE=-4470")) {
                TaskanaRuntimeException ex = new TaskanaRuntimeException("The offset beginning was set over the amount of result-rows.", e.getCause());
                ex.setStackTrace(e.getStackTrace());
                throw ex;
            }
            throw e;
        }
        finally {
            this.taskanaEngine.returnConnection();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("exit from list(offset,limit). Returning {} resulting Objects: {} ", (Object)result.size(), result);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> listValues(TaskQueryColumnName columnName, BaseQuery.SortDirection sortDirection) {
        LOGGER.debug("Entry to listValues(dbColumnName={}) this = {}", (Object)columnName, (Object)this);
        ArrayList<String> result = new ArrayList();
        try {
            this.taskanaEngine.openConnection();
            this.columnName = columnName;
            this.orderBy.clear();
            this.addOrderCriteria(columnName.toString(), sortDirection);
            this.checkForIllegalParamCombinations();
            this.checkOpenAndReadPermissionForSpecifiedWorkbaskets();
            this.setupAccessIds();
            if (columnName.equals(TaskQueryColumnName.CLASSIFICATION_NAME)) {
                this.joinWithClassifications = true;
            }
            if (columnName.equals(TaskQueryColumnName.A_CLASSIFICATION_NAME)) {
                this.joinWithAttachmentClassifications = true;
            }
            if (columnName.isAttachmentColumn()) {
                this.joinWithAttachments = true;
            }
            this.setupJoinAndOrderParameters();
            ArrayList<String> arrayList = result = this.taskanaEngine.getSqlSession().selectList(LINK_TO_VALUE_MAPPER, (Object)this);
            return arrayList;
        }
        finally {
            this.taskanaEngine.returnConnection();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Exit from listValues. Returning {} resulting Objects: {} ", (Object)result.size(), result);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaskSummary single() {
        TaskSummaryImpl taskSummaryImpl;
        TaskSummary result;
        block3: {
            TaskSummary taskSummary;
            LOGGER.debug("entry to single(), this = {}", (Object)this);
            result = null;
            try {
                this.taskanaEngine.openConnection();
                this.checkOpenAndReadPermissionForSpecifiedWorkbaskets();
                this.setupAccessIds();
                this.setupJoinAndOrderParameters();
                taskSummaryImpl = (TaskSummaryImpl)this.taskanaEngine.getSqlSession().selectOne(this.getLinkToMapperScript(), (Object)this);
                if (taskSummaryImpl != null) break block3;
                taskSummary = null;
                this.taskanaEngine.returnConnection();
            }
            catch (Throwable throwable) {
                this.taskanaEngine.returnConnection();
                LOGGER.debug("exit from single(). Returning result {} ", result);
                throw throwable;
            }
            LOGGER.debug("exit from single(). Returning result {} ", result);
            return taskSummary;
        }
        ArrayList<TaskSummaryImpl> tasks = new ArrayList<TaskSummaryImpl>();
        tasks.add(taskSummaryImpl);
        List<TaskSummary> augmentedList = this.taskService.augmentTaskSummariesByContainedSummaries(tasks);
        TaskSummary taskSummary = result = augmentedList.get(0);
        this.taskanaEngine.returnConnection();
        LOGGER.debug("exit from single(). Returning result {} ", (Object)result);
        return taskSummary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long count() {
        long l;
        LOGGER.debug("entry to count(), this = {}", (Object)this);
        Long rowCount = null;
        try {
            this.taskanaEngine.openConnection();
            this.checkOpenAndReadPermissionForSpecifiedWorkbaskets();
            this.setupAccessIds();
            this.setupJoinAndOrderParameters();
            rowCount = (Long)this.taskanaEngine.getSqlSession().selectOne(this.getLinkToCounterTaskScript(), (Object)this);
            l = rowCount == null ? 0L : rowCount;
            this.taskanaEngine.returnConnection();
        }
        catch (Throwable throwable) {
            this.taskanaEngine.returnConnection();
            LOGGER.debug("exit from count(). Returning result {} ", rowCount);
            throw throwable;
        }
        LOGGER.debug("exit from count(). Returning result {} ", (Object)rowCount);
        return l;
    }

    public String getLinkToMapperScript() {
        if (DB.DB2.dbProductId.equals(this.getDatabaseId()) && !this.selectAndClaim) {
            return LINK_TO_MAPPER_DB2;
        }
        return LINK_TO_MAPPER;
    }

    public String getLinkToCounterTaskScript() {
        return DB.DB2.dbProductId.equals(this.getDatabaseId()) ? LINK_TO_COUNTER_DB2 : LINK_TO_COUNTER;
    }

    public boolean isUseDistinctKeyword() {
        return this.useDistinctKeyword;
    }

    public void setUseDistinctKeyword(boolean useDistinctKeyword) {
        this.useDistinctKeyword = useDistinctKeyword;
    }

    public boolean isJoinWithAttachments() {
        return this.joinWithAttachments;
    }

    public void setJoinWithAttachments(boolean joinWithAttachments) {
        this.joinWithAttachments = joinWithAttachments;
    }

    public boolean isJoinWithClassifications() {
        return this.joinWithClassifications;
    }

    public void setJoinWithClassifications(boolean joinWithClassifications) {
        this.joinWithClassifications = joinWithClassifications;
    }

    public boolean isJoinWithAttachmentsClassifications() {
        return this.joinWithAttachmentClassifications;
    }

    public void setJoinWithAttachmentsClassifications(boolean joinWithAttachmentsClassifications) {
        this.joinWithAttachmentClassifications = joinWithAttachmentsClassifications;
    }

    public boolean isAddAttachmentColumnsToSelectClauseForOrdering() {
        return this.addAttachmentColumnsToSelectClauseForOrdering;
    }

    public void setAddAttachmentColumnsToSelectClauseForOrdering(boolean addAttachmentColumnsToSelectClauseForOrdering) {
        this.addAttachmentColumnsToSelectClauseForOrdering = addAttachmentColumnsToSelectClauseForOrdering;
    }

    public String[] getTaskIds() {
        return this.taskIds;
    }

    public String[] getNameIn() {
        return this.nameIn;
    }

    public String[] getExternalIdIn() {
        return this.externalIdIn;
    }

    public String[] getExternalIdLike() {
        return this.externalIdLike;
    }

    public String[] getCreatorIn() {
        return this.creatorIn;
    }

    public String[] getCreatorLike() {
        return this.creatorLike;
    }

    public String[] getDescription() {
        return this.description;
    }

    public int[] getPriority() {
        return this.priority;
    }

    public TaskState[] getStateIn() {
        return this.stateIn;
    }

    public String[] getOwnerIn() {
        return this.ownerIn;
    }

    public String[] getOwnerLike() {
        return this.ownerLike;
    }

    public Boolean getIsRead() {
        return this.isRead;
    }

    public Boolean getIsTransferred() {
        return this.isTransferred;
    }

    public boolean getIsSelectAndClaim() {
        return this.selectAndClaim;
    }

    public String[] getPorCompanyIn() {
        return this.porCompanyIn;
    }

    public String[] getPorCompanyLike() {
        return this.porCompanyLike;
    }

    public String[] getPorSystemIn() {
        return this.porSystemIn;
    }

    public String[] getPorSystemLike() {
        return this.porSystemLike;
    }

    public String[] getPorSystemInstanceIn() {
        return this.porSystemInstanceIn;
    }

    public String[] getPorSystemInstanceLike() {
        return this.porSystemInstanceLike;
    }

    public String[] getPorTypeIn() {
        return this.porTypeIn;
    }

    public String[] getPorTypeLike() {
        return this.porTypeLike;
    }

    public String[] getPorValueIn() {
        return this.porValueIn;
    }

    public String[] getPorValueLike() {
        return this.porValueLike;
    }

    public List<String> getOrderBy() {
        return this.orderBy;
    }

    public List<String> getOrderColumns() {
        return this.orderColumns;
    }

    public TimeInterval[] getCreatedIn() {
        return this.createdIn;
    }

    public TaskServiceImpl getTaskService() {
        return this.taskService;
    }

    public String[] getNote() {
        return this.note;
    }

    public String[] getNoteLike() {
        return this.noteLike;
    }

    public String[] getParentBusinessProcessIdIn() {
        return this.parentBusinessProcessIdIn;
    }

    public String[] getParentBusinessProcessIdLike() {
        return this.parentBusinessProcessIdLike;
    }

    public String[] getBusinessProcessIdIn() {
        return this.businessProcessIdIn;
    }

    public String[] getBusinessProcessIdLike() {
        return this.businessProcessIdLike;
    }

    public String[] getCustom1In() {
        return this.custom1In;
    }

    public String[] getCustom1Like() {
        return this.custom1Like;
    }

    public String[] getCustom2In() {
        return this.custom2In;
    }

    public String[] getCustom2Like() {
        return this.custom2Like;
    }

    public String[] getCustom3In() {
        return this.custom3In;
    }

    public String[] getCustom3Like() {
        return this.custom3Like;
    }

    public String[] getCustom4In() {
        return this.custom4In;
    }

    public String[] getCustom4Like() {
        return this.custom4Like;
    }

    public String[] getCustom5In() {
        return this.custom5In;
    }

    public String[] getCustom5Like() {
        return this.custom5Like;
    }

    public String[] getCustom6In() {
        return this.custom6In;
    }

    public String[] getCustom6Like() {
        return this.custom6Like;
    }

    public String[] getCustom7In() {
        return this.custom7In;
    }

    public String[] getCustom7Like() {
        return this.custom7Like;
    }

    public String[] getCustom8In() {
        return this.custom8In;
    }

    public String[] getCustom8Like() {
        return this.custom8Like;
    }

    public String[] getCustom9In() {
        return this.custom9In;
    }

    public String[] getCustom9Like() {
        return this.custom9Like;
    }

    public String[] getCustom10In() {
        return this.custom10In;
    }

    public String[] getCustom10Like() {
        return this.custom10Like;
    }

    public String[] getCustom11In() {
        return this.custom11In;
    }

    public String[] getCustom11Like() {
        return this.custom11Like;
    }

    public String[] getCustom12In() {
        return this.custom12In;
    }

    public String[] getCustom12Like() {
        return this.custom12Like;
    }

    public String[] getCustom13In() {
        return this.custom13In;
    }

    public String[] getCustom13Like() {
        return this.custom13Like;
    }

    public String[] getCustom14In() {
        return this.custom14In;
    }

    public String[] getCustom14Like() {
        return this.custom14Like;
    }

    public String[] getCustom15In() {
        return this.custom15In;
    }

    public String[] getCustom15Like() {
        return this.custom15Like;
    }

    public String[] getCustom16In() {
        return this.custom16In;
    }

    public String[] getCustom16Like() {
        return this.custom16Like;
    }

    public String[] getClassificationCategoryIn() {
        return this.classificationCategoryIn;
    }

    public String[] getClassificationCategoryLike() {
        return this.classificationCategoryLike;
    }

    public TimeInterval[] getClaimedIn() {
        return this.claimedIn;
    }

    public TimeInterval[] getCompletedIn() {
        return this.completedIn;
    }

    public TimeInterval[] getModifiedIn() {
        return this.modifiedIn;
    }

    public TimeInterval[] getPlannedIn() {
        return this.plannedIn;
    }

    public TimeInterval[] getDueIn() {
        return this.dueIn;
    }

    public String[] getNameLike() {
        return this.nameLike;
    }

    public String[] getClassificationKeyIn() {
        return this.classificationKeyIn;
    }

    public String[] getClassificationKeyNotIn() {
        return this.classificationKeyNotIn;
    }

    public String[] getClassificationKeyLike() {
        return this.classificationKeyLike;
    }

    public String[] getClassificationIdIn() {
        return this.classificationIdIn;
    }

    public KeyDomain[] getWorkbasketKeyDomainIn() {
        return this.workbasketKeyDomainIn;
    }

    public String[] getWorkbasketIdIn() {
        return this.workbasketIdIn;
    }

    public TaskQueryColumnName getColumnName() {
        return this.columnName;
    }

    public String[] getAttachmentClassificationKeyIn() {
        return this.attachmentClassificationKeyIn;
    }

    public void setAttachmentClassificationKeyIn(String[] attachmentClassificationKeyIn) {
        this.attachmentClassificationKeyIn = attachmentClassificationKeyIn;
    }

    public String[] getAttachmentClassificationKeyLike() {
        return this.attachmentClassificationKeyLike;
    }

    public void setAttachmentClassificationKeyLike(String[] attachmentClassificationKeyLike) {
        this.attachmentClassificationKeyLike = attachmentClassificationKeyLike;
    }

    public String[] getAttachmentClassificationIdIn() {
        return this.attachmentClassificationIdIn;
    }

    public void setAttachmentClassificationIdIn(String[] attachmentClassificationIdIn) {
        this.attachmentClassificationIdIn = attachmentClassificationIdIn;
    }

    public String[] getAttachmentClassificationIdLike() {
        return this.attachmentClassificationIdLike;
    }

    public void setAttachmentClassificationIdLike(String[] attachmentclassificationIdLike) {
        this.attachmentClassificationIdLike = attachmentclassificationIdLike;
    }

    public String[] getAttachmentChannelIn() {
        return this.attachmentChannelIn;
    }

    public void setAttachmentChannelIn(String[] attachmentChannelIn) {
        this.attachmentChannelIn = attachmentChannelIn;
    }

    public String[] getAttachmentChannelLike() {
        return this.attachmentChannelLike;
    }

    public void setAttachmentChannelLike(String[] attachmentChannelLike) {
        this.attachmentChannelLike = attachmentChannelLike;
    }

    public String[] getAttachmentReferenceIn() {
        return this.attachmentReferenceIn;
    }

    public void setAttachmentReferenceIn(String[] attachmentReferenceIn) {
        this.attachmentReferenceIn = attachmentReferenceIn;
    }

    public String[] getAttachmentReferenceLike() {
        return this.attachmentReferenceLike;
    }

    public void setAttachmentReferenceLike(String[] attachmentReferenceLike) {
        this.attachmentReferenceLike = attachmentReferenceLike;
    }

    public TimeInterval[] getAttachmentReceivedIn() {
        return this.attachmentReceivedIn;
    }

    public void setAttachmentReceivedIn(TimeInterval[] attachmentReceivedIn) {
        this.attachmentReceivedIn = attachmentReceivedIn;
    }

    public String[] getClassificationNameIn() {
        return this.classificationNameIn;
    }

    public void setClassificationNameIn(String[] classificationNameIn) {
        this.classificationNameIn = classificationNameIn;
    }

    public String[] getClassificationNameLike() {
        return this.classificationNameLike;
    }

    public void setClassificationNameLike(String[] classificationNameLike) {
        this.classificationNameLike = classificationNameLike;
    }

    public String[] getAttachmentClassificationNameIn() {
        return this.attachmentClassificationNameIn;
    }

    public void setAttachmentClassificationNameIn(String[] attachmentClassificationNameIn) {
        this.attachmentClassificationNameIn = attachmentClassificationNameIn;
    }

    public String[] getAttachmentClassificationNameLike() {
        return this.attachmentClassificationNameLike;
    }

    public void setAttachmentClassificationNameLike(String[] attachmentClassificationNameLike) {
        this.attachmentClassificationNameLike = attachmentClassificationNameLike;
    }

    public boolean isAddClassificationNameToSelectClauseForOrdering() {
        return this.addClassificationNameToSelectClauseForOrdering;
    }

    public void setAddClassificationNameToSelectClauseForOrdering(boolean addClassificationNameToSelectClauseForOrdering) {
        this.addClassificationNameToSelectClauseForOrdering = addClassificationNameToSelectClauseForOrdering;
    }

    public boolean isAddAttachmentClassificationNameToSelectClauseForOrdering() {
        return this.addAttachmentClassificationNameToSelectClauseForOrdering;
    }

    public void setAddAttachmentClassificationNameToSelectClauseForOrdering(boolean addAttachmentClassificationNameToSelectClauseForOrdering) {
        this.addAttachmentClassificationNameToSelectClauseForOrdering = addAttachmentClassificationNameToSelectClauseForOrdering;
    }

    public WildcardSearchField[] getWildcardSearchFieldIn() {
        return this.wildcardSearchFieldIn;
    }

    public String getWildcardSearchValueLike() {
        return this.wildcardSearchValueLike;
    }

    private void checkForIllegalParamCombinations() {
        if (this.wildcardSearchValueLike != null && this.wildcardSearchFieldIn == null || this.wildcardSearchValueLike == null && this.wildcardSearchFieldIn != null) {
            throw new IllegalArgumentException("The params \"wildcardSearchFieldIn\" and \"wildcardSearchValueLike\" must be used together!");
        }
    }

    private String getDatabaseId() {
        return this.taskanaEngine.getSqlSession().getConfiguration().getDatabaseId();
    }

    private void setupJoinAndOrderParameters() {
        if (this.joinWithAttachmentClassifications) {
            this.joinWithAttachments = true;
            this.addAttachmentClassificationNameToSelectClauseForOrdering = true;
        }
        if (this.joinWithClassifications) {
            this.addClassificationNameToSelectClauseForOrdering = true;
        }
        if (this.addClassificationNameToSelectClauseForOrdering) {
            this.joinWithClassifications = true;
        }
        if (this.addAttachmentClassificationNameToSelectClauseForOrdering) {
            this.joinWithAttachments = true;
            this.joinWithAttachmentClassifications = true;
        }
        if (this.joinWithAttachments || this.joinWithClassifications) {
            this.useDistinctKeyword = true;
        }
    }

    private void setupAccessIds() {
        if (this.taskanaEngine.getEngine().isUserInRole(TaskanaRole.ADMIN, TaskanaRole.TASK_ADMIN) || !this.filterByAccessIdIn) {
            this.accessIdIn = null;
        } else if (this.accessIdIn == null) {
            String[] accessIds = new String[]{};
            List<String> ucAccessIds = CurrentUserContext.getAccessIds();
            if (!ucAccessIds.isEmpty()) {
                accessIds = new String[ucAccessIds.size()];
                accessIds = ucAccessIds.toArray(accessIds);
            }
            this.accessIdIn = accessIds;
            WorkbasketQueryImpl.lowercaseAccessIds(this.accessIdIn);
        }
    }

    private void checkOpenAndReadPermissionForSpecifiedWorkbaskets() {
        if (this.taskanaEngine.getEngine().isUserInRole(TaskanaRole.ADMIN, TaskanaRole.TASK_ADMIN)) {
            LOGGER.debug("Skipping permissions check since user is in role ADMIN or TASK_ADMIN.");
            return;
        }
        try {
            if (this.workbasketIdIn != null && this.workbasketIdIn.length > 0) {
                this.filterByAccessIdIn = false;
                for (String workbasketId : this.workbasketIdIn) {
                    this.checkOpenAndReadPermissionById(workbasketId);
                }
            }
            if (this.workbasketKeyDomainIn != null && this.workbasketKeyDomainIn.length > 0) {
                this.filterByAccessIdIn = false;
                for (KeyDomain keyDomain : this.workbasketKeyDomainIn) {
                    this.checkOpenAndReadPermissionByKeyDomain(keyDomain);
                }
            }
        }
        catch (NotAuthorizedException e) {
            throw new NotAuthorizedToQueryWorkbasketException(e.getMessage(), e.getCause());
        }
    }

    private void checkOpenAndReadPermissionById(String workbasketId) throws NotAuthorizedException {
        try {
            this.taskanaEngine.getEngine().getWorkbasketService().checkAuthorization(workbasketId, WorkbasketPermission.OPEN, WorkbasketPermission.READ);
        }
        catch (WorkbasketNotFoundException e) {
            LOGGER.warn(String.format("The workbasket with the ID ' %s ' does not exist.", workbasketId), (Throwable)e);
        }
    }

    private void checkOpenAndReadPermissionByKeyDomain(KeyDomain keyDomain) throws NotAuthorizedException {
        try {
            this.taskanaEngine.getEngine().getWorkbasketService().checkAuthorization(keyDomain.getKey(), keyDomain.getDomain(), WorkbasketPermission.OPEN, WorkbasketPermission.READ);
        }
        catch (WorkbasketNotFoundException e) {
            LOGGER.warn(String.format("The workbasket with the KEY ' %s ' and DOMAIN ' %s ' does not exist.", keyDomain.getKey(), keyDomain.getDomain()), (Throwable)e);
        }
    }

    private TaskQuery addOrderCriteria(String columnName, BaseQuery.SortDirection sortDirection) {
        String orderByDirection = " " + (Object)((Object)(sortDirection == null ? BaseQuery.SortDirection.ASCENDING : sortDirection));
        this.orderBy.add(columnName + orderByDirection);
        this.orderColumns.add(columnName);
        return this;
    }

    public String toString() {
        return "TaskQueryImpl [taskanaEngine=" + this.taskanaEngine + ", taskService=" + this.taskService + ", columnName=" + this.columnName + ", nameIn=" + Arrays.toString(this.nameIn) + ", nameLike=" + Arrays.toString(this.nameLike) + ", externalIdIn=" + Arrays.toString(this.externalIdIn) + ", externalIdLike=" + Arrays.toString(this.externalIdLike) + ", creatorIn=" + Arrays.toString(this.creatorIn) + ", creatorLike=" + Arrays.toString(this.creatorLike) + ", taskIds=" + Arrays.toString(this.taskIds) + ", description=" + Arrays.toString(this.description) + ", note=" + Arrays.toString(this.note) + ", noteLike=" + Arrays.toString(this.noteLike) + ", priority=" + Arrays.toString(this.priority) + ", workbasketKeyDomainIn=" + Arrays.toString(this.workbasketKeyDomainIn) + ", workbasketIdIn=" + Arrays.toString(this.workbasketIdIn) + ", stateIn=" + Arrays.toString((Object[])this.stateIn) + ", classificationIdIn=" + Arrays.toString(this.classificationIdIn) + ", classificationKeyIn=" + Arrays.toString(this.classificationKeyIn) + ", classificationKeyLike=" + Arrays.toString(this.classificationKeyLike) + ", classificationKeyNotIn=" + Arrays.toString(this.classificationKeyNotIn) + ", classificationCategoryIn=" + Arrays.toString(this.classificationCategoryIn) + ", classificationCategoryLike=" + Arrays.toString(this.classificationCategoryLike) + ", classificationNameIn=" + Arrays.toString(this.classificationNameIn) + ", classificationNameLike=" + Arrays.toString(this.classificationNameLike) + ", ownerIn=" + Arrays.toString(this.ownerIn) + ", ownerLike=" + Arrays.toString(this.ownerLike) + ", isRead=" + this.isRead + ", isTransferred=" + this.isTransferred + ", porCompanyIn=" + Arrays.toString(this.porCompanyIn) + ", porCompanyLike=" + Arrays.toString(this.porCompanyLike) + ", porSystemIn=" + Arrays.toString(this.porSystemIn) + ", porSystemLike=" + Arrays.toString(this.porSystemLike) + ", porSystemInstanceIn=" + Arrays.toString(this.porSystemInstanceIn) + ", porSystemInstanceLike=" + Arrays.toString(this.porSystemInstanceLike) + ", porTypeIn=" + Arrays.toString(this.porTypeIn) + ", porTypeLike=" + Arrays.toString(this.porTypeLike) + ", porValueIn=" + Arrays.toString(this.porValueIn) + ", porValueLike=" + Arrays.toString(this.porValueLike) + ", parentBusinessProcessIdIn=" + Arrays.toString(this.parentBusinessProcessIdIn) + ", parentBusinessProcessIdLike=" + Arrays.toString(this.parentBusinessProcessIdLike) + ", businessProcessIdIn=" + Arrays.toString(this.businessProcessIdIn) + ", businessProcessIdLike=" + Arrays.toString(this.businessProcessIdLike) + ", callbackStateIn=" + Arrays.toString((Object[])this.callbackStateIn) + ", custom1In=" + Arrays.toString(this.custom1In) + ", custom1Like=" + Arrays.toString(this.custom1Like) + ", custom2In=" + Arrays.toString(this.custom2In) + ", custom2Like=" + Arrays.toString(this.custom2Like) + ", custom3In=" + Arrays.toString(this.custom3In) + ", custom3Like=" + Arrays.toString(this.custom3Like) + ", custom4In=" + Arrays.toString(this.custom4In) + ", custom4Like=" + Arrays.toString(this.custom4Like) + ", custom5In=" + Arrays.toString(this.custom5In) + ", custom5Like=" + Arrays.toString(this.custom5Like) + ", custom6In=" + Arrays.toString(this.custom6In) + ", custom6Like=" + Arrays.toString(this.custom6Like) + ", custom7In=" + Arrays.toString(this.custom7In) + ", custom7Like=" + Arrays.toString(this.custom7Like) + ", custom8In=" + Arrays.toString(this.custom8In) + ", custom8Like=" + Arrays.toString(this.custom8Like) + ", custom9In=" + Arrays.toString(this.custom9In) + ", custom9Like=" + Arrays.toString(this.custom9Like) + ", custom10In=" + Arrays.toString(this.custom10In) + ", custom10Like=" + Arrays.toString(this.custom10Like) + ", custom11In=" + Arrays.toString(this.custom11In) + ", custom11Like=" + Arrays.toString(this.custom11Like) + ", custom12In=" + Arrays.toString(this.custom12In) + ", custom12Like=" + Arrays.toString(this.custom12Like) + ", custom13In=" + Arrays.toString(this.custom13In) + ", custom13Like=" + Arrays.toString(this.custom13Like) + ", custom14In=" + Arrays.toString(this.custom14In) + ", custom14Like=" + Arrays.toString(this.custom14Like) + ", custom15In=" + Arrays.toString(this.custom15In) + ", custom15Like=" + Arrays.toString(this.custom15Like) + ", custom16In=" + Arrays.toString(this.custom16In) + ", custom16Like=" + Arrays.toString(this.custom16Like) + ", attachmentClassificationKeyIn=" + Arrays.toString(this.attachmentClassificationKeyIn) + ", attachmentClassificationKeyLike=" + Arrays.toString(this.attachmentClassificationKeyLike) + ", attachmentClassificationIdIn=" + Arrays.toString(this.attachmentClassificationIdIn) + ", attachmentClassificationIdLike=" + Arrays.toString(this.attachmentClassificationIdLike) + ", attachmentClassificationNameIn=" + Arrays.toString(this.attachmentClassificationNameIn) + ", attachmentClassificationNameLike=" + Arrays.toString(this.attachmentClassificationNameLike) + ", attachmentChannelIn=" + Arrays.toString(this.attachmentChannelIn) + ", attachmentChannelLike=" + Arrays.toString(this.attachmentChannelLike) + ", attachmentReferenceIn=" + Arrays.toString(this.attachmentReferenceIn) + ", attachmentReferenceLike=" + Arrays.toString(this.attachmentReferenceLike) + ", attachmentReceivedIn=" + Arrays.toString(this.attachmentReceivedIn) + ", accessIdIn=" + Arrays.toString(this.accessIdIn) + ", filterByAccessIdIn=" + this.filterByAccessIdIn + ", createdIn=" + Arrays.toString(this.createdIn) + ", claimedIn=" + Arrays.toString(this.claimedIn) + ", completedIn=" + Arrays.toString(this.completedIn) + ", modifiedIn=" + Arrays.toString(this.modifiedIn) + ", plannedIn=" + Arrays.toString(this.plannedIn) + ", dueIn=" + Arrays.toString(this.dueIn) + ", orderBy=" + this.orderBy + ", orderColumns=" + this.orderColumns + ", wildcardSearchFieldIn=" + Arrays.toString((Object[])this.wildcardSearchFieldIn) + ", wildcardSearchValueLike=" + this.wildcardSearchValueLike + ", selectAndClaim=" + this.selectAndClaim + ", useDistinctKeyword=" + this.useDistinctKeyword + ", joinWithAttachments=" + this.joinWithAttachments + ", joinWithClassifications=" + this.joinWithClassifications + ", joinWithAttachmentClassifications=" + this.joinWithAttachmentClassifications + ", addAttachmentColumnsToSelectClauseForOrdering=" + this.addAttachmentColumnsToSelectClauseForOrdering + ", addClassificationNameToSelectClauseForOrdering=" + this.addClassificationNameToSelectClauseForOrdering + ", addAttachmentClassificationNameToSelectClauseForOrdering=" + this.addAttachmentClassificationNameToSelectClauseForOrdering + "]";
    }
}

