/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.task.internal;

import java.time.Instant;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.common.api.BulkOperationResults;
import pro.taskana.common.api.exceptions.InvalidArgumentException;
import pro.taskana.common.api.exceptions.NotAuthorizedException;
import pro.taskana.common.api.exceptions.TaskanaException;
import pro.taskana.common.internal.InternalTaskanaEngine;
import pro.taskana.common.internal.security.CurrentUserContext;
import pro.taskana.common.internal.util.IdGenerator;
import pro.taskana.spi.history.api.events.task.TaskTransferredEvent;
import pro.taskana.spi.history.internal.HistoryEventManager;
import pro.taskana.task.api.TaskState;
import pro.taskana.task.api.exceptions.InvalidStateException;
import pro.taskana.task.api.exceptions.TaskNotFoundException;
import pro.taskana.task.api.models.Task;
import pro.taskana.task.internal.TaskMapper;
import pro.taskana.task.internal.TaskServiceImpl;
import pro.taskana.task.internal.models.MinimalTaskSummary;
import pro.taskana.task.internal.models.TaskImpl;
import pro.taskana.task.internal.models.TaskSummaryImpl;
import pro.taskana.workbasket.api.WorkbasketPermission;
import pro.taskana.workbasket.api.WorkbasketService;
import pro.taskana.workbasket.api.exceptions.WorkbasketNotFoundException;
import pro.taskana.workbasket.api.models.Workbasket;
import pro.taskana.workbasket.api.models.WorkbasketSummary;
import pro.taskana.workbasket.internal.WorkbasketQueryImpl;

public class TaskTransferrer {
    private static final String WAS_NOT_FOUND2 = " was not found.";
    private static final String TASK_IN_END_STATE_WITH_ID_CANNOT_BE_TRANSFERRED = "Task in end state with id %s cannot be transferred.";
    private static final String TASK_WITH_ID = "Task with id ";
    private static final String WAS_MARKED_FOR_DELETION = " was marked for deletion";
    private static final String THE_WORKBASKET = "The workbasket ";
    private static final String ID_PREFIX_HISTORY_EVENT = "HEI";
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskTransferrer.class);
    private InternalTaskanaEngine taskanaEngine;
    private WorkbasketService workbasketService;
    private TaskServiceImpl taskService;
    private TaskMapper taskMapper;
    private HistoryEventManager historyEventManager;

    TaskTransferrer(InternalTaskanaEngine taskanaEngine, TaskMapper taskMapper, TaskServiceImpl taskService) {
        this.taskanaEngine = taskanaEngine;
        this.taskService = taskService;
        this.taskMapper = taskMapper;
        this.workbasketService = taskanaEngine.getEngine().getWorkbasketService();
        this.historyEventManager = taskanaEngine.getHistoryEventManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Task transfer(String taskId, String destinationWorkbasketKey, String domain) throws TaskNotFoundException, WorkbasketNotFoundException, NotAuthorizedException, InvalidStateException {
        LOGGER.debug("entry to transfer(taskId = {}, destinationWorkbasketKey = {}, domain = {})", new Object[]{taskId, destinationWorkbasketKey, domain});
        TaskImpl task = null;
        WorkbasketSummary oldWorkbasketSummary = null;
        try {
            this.taskanaEngine.openConnection();
            task = (TaskImpl)this.taskService.getTask(taskId);
            if (task.getState().isEndState()) {
                throw new InvalidStateException(String.format(TASK_IN_END_STATE_WITH_ID_CANNOT_BE_TRANSFERRED, task.getId()));
            }
            oldWorkbasketSummary = task.getWorkbasketSummary();
            this.workbasketService.checkAuthorization(destinationWorkbasketKey, domain, WorkbasketPermission.APPEND);
            this.workbasketService.checkAuthorization(task.getWorkbasketSummary().getId(), WorkbasketPermission.TRANSFER);
            Workbasket destinationWorkbasket = this.workbasketService.getWorkbasket(destinationWorkbasketKey, domain);
            task.setRead(false);
            task.setTransferred(true);
            if (destinationWorkbasket.isMarkedForDeletion()) {
                throw new WorkbasketNotFoundException(destinationWorkbasket.getId(), THE_WORKBASKET + destinationWorkbasket.getId() + WAS_MARKED_FOR_DELETION);
            }
            task.setWorkbasketSummary(destinationWorkbasket.asSummary());
            task.setModified(Instant.now());
            task.setState(TaskState.READY);
            task.setOwner(null);
            this.taskMapper.update(task);
            LOGGER.debug("Method transfer() transferred Task '{}' to destination workbasket {}", (Object)taskId, (Object)destinationWorkbasket.getId());
            if (HistoryEventManager.isHistoryEnabled()) {
                this.createTaskTransferredEvent(task, oldWorkbasketSummary, destinationWorkbasket.asSummary());
            }
            TaskImpl taskImpl = task;
            return taskImpl;
        }
        finally {
            this.taskanaEngine.returnConnection();
            LOGGER.debug("exit from transfer(). Returning result {} ", (Object)task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Task transfer(String taskId, String destinationWorkbasketId) throws TaskNotFoundException, WorkbasketNotFoundException, NotAuthorizedException, InvalidStateException {
        LOGGER.debug("entry to transfer(taskId = {}, destinationWorkbasketId = {})", (Object)taskId, (Object)destinationWorkbasketId);
        TaskImpl task = null;
        WorkbasketSummary oldWorkbasketSummary = null;
        try {
            this.taskanaEngine.openConnection();
            task = (TaskImpl)this.taskService.getTask(taskId);
            if (task.getState().isEndState()) {
                throw new InvalidStateException(String.format(TASK_IN_END_STATE_WITH_ID_CANNOT_BE_TRANSFERRED, task.getId()));
            }
            oldWorkbasketSummary = task.getWorkbasketSummary();
            this.workbasketService.checkAuthorization(destinationWorkbasketId, WorkbasketPermission.APPEND);
            this.workbasketService.checkAuthorization(task.getWorkbasketSummary().getId(), WorkbasketPermission.TRANSFER);
            Workbasket destinationWorkbasket = this.workbasketService.getWorkbasket(destinationWorkbasketId);
            task.setRead(false);
            task.setTransferred(true);
            if (destinationWorkbasket.isMarkedForDeletion()) {
                throw new WorkbasketNotFoundException(destinationWorkbasket.getId(), THE_WORKBASKET + destinationWorkbasket.getId() + WAS_MARKED_FOR_DELETION);
            }
            task.setWorkbasketSummary(destinationWorkbasket.asSummary());
            task.setModified(Instant.now());
            task.setState(TaskState.READY);
            task.setOwner(null);
            this.taskMapper.update(task);
            LOGGER.debug("Method transfer() transferred Task '{}' to destination workbasket {}", (Object)taskId, (Object)destinationWorkbasketId);
            if (HistoryEventManager.isHistoryEnabled()) {
                this.createTaskTransferredEvent(task, oldWorkbasketSummary, destinationWorkbasket.asSummary());
            }
            TaskImpl taskImpl = task;
            return taskImpl;
        }
        finally {
            this.taskanaEngine.returnConnection();
            LOGGER.debug("exit from transfer(). Returning result {} ", (Object)task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BulkOperationResults<String, TaskanaException> transferTasks(String destinationWorkbasketKey, String destinationWorkbasketDomain, List<String> taskIds) throws NotAuthorizedException, InvalidArgumentException, WorkbasketNotFoundException {
        BulkOperationResults<String, TaskanaException> bulkOperationResults;
        try {
            this.taskanaEngine.openConnection();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("entry to transferTasks(targetWbKey = {}, domain = {}, taskIds = {})", new Object[]{destinationWorkbasketKey, destinationWorkbasketDomain, taskIds});
            }
            if (destinationWorkbasketKey == null || destinationWorkbasketDomain == null) {
                throw new InvalidArgumentException("DestinationWorkbasketKey or domain can\u00b4t be used as NULL-Parameter.");
            }
            Workbasket destinationWorkbasket = this.workbasketService.getWorkbasket(destinationWorkbasketKey, destinationWorkbasketDomain);
            bulkOperationResults = this.transferTasks(taskIds, destinationWorkbasket);
        }
        catch (Throwable throwable) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("exit from transferTasks(targetWbKey = {}, targetWbDomain = {}, destination taskIds = {})", new Object[]{destinationWorkbasketKey, destinationWorkbasketDomain, taskIds});
            }
            this.taskanaEngine.returnConnection();
            throw throwable;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("exit from transferTasks(targetWbKey = {}, targetWbDomain = {}, destination taskIds = {})", new Object[]{destinationWorkbasketKey, destinationWorkbasketDomain, taskIds});
        }
        this.taskanaEngine.returnConnection();
        return bulkOperationResults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BulkOperationResults<String, TaskanaException> transferTasks(String destinationWorkbasketId, List<String> taskIds) throws NotAuthorizedException, InvalidArgumentException, WorkbasketNotFoundException {
        try {
            this.taskanaEngine.openConnection();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("entry to transferTasks(targetWbId = {}, taskIds = {})", (Object)destinationWorkbasketId, taskIds);
            }
            if (destinationWorkbasketId == null || destinationWorkbasketId.isEmpty()) {
                throw new InvalidArgumentException("DestinationWorkbasketId must not be null or empty.");
            }
            Workbasket destinationWorkbasket = this.workbasketService.getWorkbasket(destinationWorkbasketId);
            BulkOperationResults<String, TaskanaException> bulkOperationResults = this.transferTasks(taskIds, destinationWorkbasket);
            return bulkOperationResults;
        }
        finally {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("exit from transferTasks(targetWbKey = {}, taskIds = {})", (Object)destinationWorkbasketId, taskIds);
            }
            this.taskanaEngine.returnConnection();
        }
    }

    private BulkOperationResults<String, TaskanaException> transferTasks(List<String> taskIdsToBeTransferred, Workbasket destinationWorkbasket) throws InvalidArgumentException, WorkbasketNotFoundException, NotAuthorizedException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("entry to transferTasks(taskIdsToBeTransferred = {}, destinationWorkbasket = {})", taskIdsToBeTransferred, (Object)destinationWorkbasket);
        }
        this.workbasketService.checkAuthorization(destinationWorkbasket.getId(), WorkbasketPermission.APPEND);
        if (taskIdsToBeTransferred == null) {
            throw new InvalidArgumentException("TaskIds must not be null.");
        }
        BulkOperationResults<String, TaskanaException> bulkLog = new BulkOperationResults<String, TaskanaException>();
        ArrayList<String> taskIds = new ArrayList<String>(taskIdsToBeTransferred);
        this.taskService.removeNonExistingTasksFromTaskIdList(taskIds, bulkLog);
        if (taskIds.isEmpty()) {
            throw new InvalidArgumentException("TaskIds must not contain only invalid arguments.");
        }
        List<Object> taskSummaries = taskIds.isEmpty() ? new ArrayList() : this.taskMapper.findExistingTasks(taskIds, null);
        this.checkIfTransferConditionsAreFulfilled(taskIds, taskSummaries, bulkLog);
        this.updateTasksToBeTransferred(taskIds, taskSummaries, destinationWorkbasket);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("exit from transferTasks(), returning {}", bulkLog);
        }
        return bulkLog;
    }

    private void checkIfTransferConditionsAreFulfilled(List<String> taskIds, List<MinimalTaskSummary> taskSummaries, BulkOperationResults<String, TaskanaException> bulkLog) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("entry to checkIfTransferConditionsAreFulfilled(taskIds = {}, taskSummaries = {}, bulkLog = {})", new Object[]{taskIds, taskSummaries, bulkLog});
        }
        HashSet workbasketIds = new HashSet();
        taskSummaries.forEach(t -> workbasketIds.add(t.getWorkbasketId()));
        WorkbasketQueryImpl query = (WorkbasketQueryImpl)this.workbasketService.createWorkbasketQuery();
        query.setUsedToAugmentTasks(true);
        List<WorkbasketSummary> sourceWorkbaskets = taskSummaries.isEmpty() ? new ArrayList<WorkbasketSummary>() : query.callerHasPermission(WorkbasketPermission.TRANSFER).idIn(workbasketIds.toArray(new String[0])).list();
        this.checkIfTasksMatchTransferCriteria(taskIds, taskSummaries, sourceWorkbaskets, bulkLog);
        LOGGER.debug("exit from checkIfTransferConditionsAreFulfilled()");
    }

    private void checkIfTasksMatchTransferCriteria(List<String> taskIds, List<MinimalTaskSummary> taskSummaries, List<WorkbasketSummary> sourceWorkbaskets, BulkOperationResults<String, TaskanaException> bulkLog) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("entry to checkIfTasksMatchTransferCriteria(taskIds = {}, taskSummaries = {}, sourceWorkbaskets = {}, bulkLog = {})", new Object[]{taskIds, taskSummaries, sourceWorkbaskets, bulkLog});
        }
        Iterator<String> taskIdIterator = taskIds.iterator();
        while (taskIdIterator.hasNext()) {
            String currentTaskId = taskIdIterator.next();
            MinimalTaskSummary taskSummary = taskSummaries.stream().filter(t -> currentTaskId.equals(t.getTaskId())).findFirst().orElse(null);
            if (taskSummary == null) {
                bulkLog.addError(currentTaskId, new TaskNotFoundException(currentTaskId, TASK_WITH_ID + currentTaskId + WAS_NOT_FOUND2));
                taskIdIterator.remove();
                continue;
            }
            if (taskSummary.getTaskState().isEndState()) {
                bulkLog.addError(currentTaskId, new InvalidStateException(String.format(TASK_IN_END_STATE_WITH_ID_CANNOT_BE_TRANSFERRED, currentTaskId)));
                taskIdIterator.remove();
                continue;
            }
            if (!sourceWorkbaskets.stream().noneMatch(wb -> taskSummary.getWorkbasketId().equals(wb.getId()))) continue;
            bulkLog.addError(currentTaskId, new NotAuthorizedException("The workbasket of this task got not TRANSFER permissions. TaskId=" + currentTaskId, CurrentUserContext.getUserid()));
            taskIdIterator.remove();
        }
        LOGGER.debug("exit from checkIfTasksMatchTransferCriteria()");
    }

    private void createTaskTransferredEvent(Task task, WorkbasketSummary oldWorkbasketSummary, WorkbasketSummary newWorkbasketSummary) {
        this.historyEventManager.createEvent(new TaskTransferredEvent(IdGenerator.generateWithPrefix(ID_PREFIX_HISTORY_EVENT), task, oldWorkbasketSummary, newWorkbasketSummary, CurrentUserContext.getUserid()));
    }

    private void updateTasksToBeTransferred(List<String> taskIds, List<MinimalTaskSummary> taskSummaries, Workbasket destinationWorkbasket) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("entry to updateTasksToBeTransferred(taskIds = {}, taskSummaries = {}, destinationWorkbasket = {})", new Object[]{taskIds, taskSummaries, destinationWorkbasket.getId()});
        }
        if (!(taskSummaries = taskSummaries.stream().filter(ts -> taskIds.contains(ts.getTaskId())).collect(Collectors.toList())).isEmpty()) {
            Instant now = Instant.now();
            TaskSummaryImpl updateObject = new TaskSummaryImpl();
            updateObject.setRead(false);
            updateObject.setTransferred(true);
            updateObject.setWorkbasketSummary(destinationWorkbasket.asSummary());
            updateObject.setDomain(destinationWorkbasket.getDomain());
            updateObject.setModified(now);
            updateObject.setState(TaskState.READY);
            updateObject.setOwner(null);
            this.taskMapper.updateTransfered(taskIds, updateObject);
            if (HistoryEventManager.isHistoryEnabled()) {
                this.createTasksTransferredEvents(taskSummaries, updateObject);
            }
        }
        LOGGER.debug("exit from updateTasksToBeTransferred()");
    }

    private void createTasksTransferredEvents(List<MinimalTaskSummary> taskSummaries, TaskSummaryImpl updateObject) {
        taskSummaries.stream().forEach(task -> {
            TaskImpl newTask = (TaskImpl)this.taskService.newTask(task.getWorkbasketId());
            newTask.setWorkbasketSummary(updateObject.getWorkbasketSummary());
            newTask.setRead(updateObject.isRead());
            newTask.setTransferred(updateObject.isTransferred());
            newTask.setWorkbasketSummary(updateObject.getWorkbasketSummary());
            newTask.setDomain(updateObject.getDomain());
            newTask.setModified(updateObject.getModified());
            newTask.setState(updateObject.getState());
            newTask.setOwner(updateObject.getOwner());
            this.createTaskTransferredEvent(newTask, newTask.getWorkbasketSummary(), updateObject.getWorkbasketSummary());
        });
    }
}

