/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.task.internal.jobs;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.common.api.BaseQuery;
import pro.taskana.common.api.BulkOperationResults;
import pro.taskana.common.api.ScheduledJob;
import pro.taskana.common.api.TaskanaEngine;
import pro.taskana.common.api.TimeInterval;
import pro.taskana.common.api.exceptions.InvalidArgumentException;
import pro.taskana.common.api.exceptions.NotAuthorizedException;
import pro.taskana.common.api.exceptions.TaskanaException;
import pro.taskana.common.internal.jobs.AbstractTaskanaJob;
import pro.taskana.common.internal.transaction.TaskanaTransactionProvider;
import pro.taskana.common.internal.util.LogSanitizer;
import pro.taskana.task.api.models.TaskSummary;

public class TaskCleanupJob
extends AbstractTaskanaJob {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskCleanupJob.class);
    private static final BaseQuery.SortDirection ASCENDING = BaseQuery.SortDirection.ASCENDING;
    private final Instant firstRun;
    private final Duration runEvery;
    private final Duration minimumAge;
    private final int batchSize;
    private final boolean allCompletedSameParentBusiness;

    public TaskCleanupJob(TaskanaEngine taskanaEngine, TaskanaTransactionProvider<Object> txProvider, ScheduledJob scheduledJob) {
        super(taskanaEngine, txProvider, scheduledJob);
        this.firstRun = taskanaEngine.getConfiguration().getCleanupJobFirstRun();
        this.runEvery = taskanaEngine.getConfiguration().getCleanupJobRunEvery();
        this.minimumAge = taskanaEngine.getConfiguration().getCleanupJobMinimumAge();
        this.batchSize = taskanaEngine.getConfiguration().getMaxNumberOfUpdatesPerTransaction();
        this.allCompletedSameParentBusiness = taskanaEngine.getConfiguration().isTaskCleanupJobAllCompletedSameParentBusiness();
    }

    @Override
    public void run() throws TaskanaException {
        Instant completedBefore = Instant.now().minus(this.minimumAge);
        LOGGER.info("Running job to delete all tasks completed before ({})", (Object)completedBefore);
        try {
            List<TaskSummary> tasksCompletedBefore = this.getTasksCompletedBefore(completedBefore);
            int totalNumberOfTasksCompleted = 0;
            while (tasksCompletedBefore.size() > 0) {
                int upperLimit = this.batchSize;
                if (upperLimit > tasksCompletedBefore.size()) {
                    upperLimit = tasksCompletedBefore.size();
                }
                totalNumberOfTasksCompleted += this.deleteTasksTransactionally(tasksCompletedBefore.subList(0, upperLimit));
                tasksCompletedBefore.subList(0, upperLimit).clear();
            }
            LOGGER.info("Job ended successfully. {} tasks deleted.", (Object)totalNumberOfTasksCompleted);
        }
        catch (Exception e) {
            throw new TaskanaException("Error while processing TaskCleanupJob.", e);
        }
        finally {
            this.scheduleNextCleanupJob();
        }
    }

    public static void initializeSchedule(TaskanaEngine taskanaEngine) {
        TaskCleanupJob job = new TaskCleanupJob(taskanaEngine, null, null);
        job.scheduleNextCleanupJob();
    }

    private List<TaskSummary> getTasksCompletedBefore(Instant untilDate) {
        LOGGER.debug("entry to getTasksCompletedBefore(untilDate = {})", (Object)untilDate);
        List<TaskSummary> taskList = this.taskanaEngineImpl.getTaskService().createTaskQuery().completedWithin(new TimeInterval(null, untilDate)).orderByBusinessProcessId(ASCENDING).list();
        if (this.allCompletedSameParentBusiness) {
            HashMap<String, Long> numberParentTasksShouldHave = new HashMap<String, Long>();
            HashMap<String, Long> countParentTask = new HashMap<String, Long>();
            for (TaskSummary task : taskList) {
                numberParentTasksShouldHave.put(task.getParentBusinessProcessId(), this.taskanaEngineImpl.getTaskService().createTaskQuery().parentBusinessProcessIdIn(task.getParentBusinessProcessId()).count());
                countParentTask.merge(task.getParentBusinessProcessId(), 1L, Long::sum);
            }
            ArrayList idsList = new ArrayList();
            numberParentTasksShouldHave.forEach((k, v) -> {
                if (v.compareTo((Long)countParentTask.get(k)) == 0) {
                    idsList.add(k);
                }
            });
            if (idsList.isEmpty()) {
                LOGGER.debug("exit from getTasksCompletedBefore(), returning {}", new ArrayList());
                return new ArrayList<TaskSummary>();
            }
            String[] ids = new String[idsList.size()];
            ids = idsList.toArray(ids);
            taskList = this.taskanaEngineImpl.getTaskService().createTaskQuery().parentBusinessProcessIdIn(ids).list();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("exit from getTasksCompletedBefore(), returning {}", taskList);
        }
        return taskList;
    }

    private int deleteTasksTransactionally(List<TaskSummary> tasksToBeDeleted) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("entry to deleteTasksTransactionally(tasksToBeDeleted = {})", tasksToBeDeleted);
        }
        int deletedTaskCount = 0;
        if (this.txProvider != null) {
            int count = (Integer)this.txProvider.executeInTransaction(() -> {
                try {
                    return this.deleteTasks(tasksToBeDeleted);
                }
                catch (Exception e) {
                    LOGGER.warn("Could not delete tasks.", (Throwable)e);
                    return 0;
                }
            });
            LOGGER.debug("exit from deleteTasksTransactionally(), returning {}", (Object)count);
            return count;
        }
        try {
            deletedTaskCount = this.deleteTasks(tasksToBeDeleted);
        }
        catch (Exception e) {
            LOGGER.warn("Could not delete tasks.", (Throwable)e);
        }
        LOGGER.debug("exit from deleteTasksTransactionally(), returning {}", (Object)deletedTaskCount);
        return deletedTaskCount;
    }

    private int deleteTasks(List<TaskSummary> tasksToBeDeleted) throws InvalidArgumentException, NotAuthorizedException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("entry to deleteTasks(tasksToBeDeleted = {})", tasksToBeDeleted);
        }
        List<String> tasksIdsToBeDeleted = tasksToBeDeleted.stream().map(TaskSummary::getId).collect(Collectors.toList());
        BulkOperationResults<String, TaskanaException> results = this.taskanaEngineImpl.getTaskService().deleteTasks(tasksIdsToBeDeleted);
        LOGGER.debug("{} tasks deleted.", (Object)(tasksIdsToBeDeleted.size() - results.getFailedIds().size()));
        for (String failedId : results.getFailedIds()) {
            if (!LOGGER.isWarnEnabled()) continue;
            LOGGER.warn("Task with id {} could not be deleted. Reason: {}", (Object)LogSanitizer.stripLineBreakingChars(failedId), (Object)LogSanitizer.stripLineBreakingChars(results.getErrorForId(failedId)));
        }
        LOGGER.debug("exit from deleteTasks(), returning {}", (Object)(tasksIdsToBeDeleted.size() - results.getFailedIds().size()));
        return tasksIdsToBeDeleted.size() - results.getFailedIds().size();
    }

    private void scheduleNextCleanupJob() {
        LOGGER.debug("Entry to scheduleNextCleanupJob.");
        ScheduledJob job = new ScheduledJob();
        job.setType(ScheduledJob.Type.TASKCLEANUPJOB);
        job.setDue(this.getNextDueForTaskCleanupJob());
        this.taskanaEngineImpl.getJobService().createJob(job);
        LOGGER.debug("Exit from scheduleNextCleanupJob.");
    }

    private Instant getNextDueForTaskCleanupJob() {
        Instant nextRunAt = this.firstRun;
        while (nextRunAt.isBefore(Instant.now())) {
            nextRunAt = nextRunAt.plus(this.runEvery);
        }
        LOGGER.info("Scheduling next run of the TaskCleanupJob for {}", (Object)nextRunAt);
        return nextRunAt;
    }
}

