/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.monitor.internal.reports;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import pro.taskana.common.api.TaskanaRole;
import pro.taskana.common.api.exceptions.NotAuthorizedException;
import pro.taskana.common.internal.InternalTaskanaEngine;
import pro.taskana.common.internal.logging.LoggingAspect;
import pro.taskana.monitor.api.reports.TaskStatusReport;
import pro.taskana.monitor.api.reports.item.TaskQueryItem;
import pro.taskana.monitor.internal.MonitorMapper;
import pro.taskana.task.api.TaskState;
import pro.taskana.workbasket.api.WorkbasketService;
import pro.taskana.workbasket.api.models.WorkbasketSummary;

public class TaskStatusReportBuilderImpl
implements TaskStatusReport.Builder {
    private final InternalTaskanaEngine taskanaEngine;
    private final MonitorMapper monitorMapper;
    private final WorkbasketService workbasketService;
    private List<String> domains;
    private List<TaskState> states;
    private List<String> workbasketIds;
    private Integer priorityMinimum;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;

    public TaskStatusReportBuilderImpl(InternalTaskanaEngine taskanaEngine, MonitorMapper monitorMapper) {
        this.taskanaEngine = taskanaEngine;
        this.monitorMapper = monitorMapper;
        this.workbasketService = taskanaEngine.getEngine().getWorkbasketService();
    }

    @Override
    public TaskStatusReport buildReport() throws NotAuthorizedException {
        TaskStatusReport taskStatusReport;
        TaskStatusReport taskStatusReport2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.taskanaEngine.getEngine().checkRoleMembership(TaskanaRole.MONITOR, TaskanaRole.ADMIN);
        try {
            this.taskanaEngine.openConnection();
            List<TaskQueryItem> tasks = this.monitorMapper.getTasksCountByState(this.domains, this.states, this.workbasketIds, this.priorityMinimum);
            TaskStatusReport report = new TaskStatusReport(this.states);
            report.addItems(tasks);
            Map displayMap = this.taskanaEngine.getEngine().runAsAdmin(() -> this.workbasketService.createWorkbasketQuery().keyIn(report.getRows().keySet().toArray(new String[0])).domainIn(this.domains != null ? this.domains.toArray(new String[0]) : null).list().stream().collect(Collectors.toMap(WorkbasketSummary::getKey, WorkbasketSummary::getName, (a, b) -> a)));
            report.augmentDisplayNames(displayMap);
            TaskStatusReport taskStatusReport3 = report;
            taskStatusReport2 = taskStatusReport3;
        }
        finally {
            this.taskanaEngine.returnConnection();
        }
        TaskStatusReport taskStatusReport4 = taskStatusReport = taskStatusReport2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskStatusReport);
        return taskStatusReport2;
    }

    @Override
    public TaskStatusReportBuilderImpl stateIn(List<TaskState> states) {
        TaskStatusReportBuilderImpl taskStatusReportBuilderImpl;
        TaskStatusReportBuilderImpl taskStatusReportBuilderImpl2;
        List<TaskState> list = states;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, list);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.states = states;
        TaskStatusReportBuilderImpl taskStatusReportBuilderImpl3 = taskStatusReportBuilderImpl2 = (taskStatusReportBuilderImpl = this);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskStatusReportBuilderImpl2);
        return taskStatusReportBuilderImpl;
    }

    @Override
    public TaskStatusReportBuilderImpl priorityMinimum(Integer priorityMinimum) {
        TaskStatusReportBuilderImpl taskStatusReportBuilderImpl;
        TaskStatusReportBuilderImpl taskStatusReportBuilderImpl2;
        Integer n = priorityMinimum;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)n);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.priorityMinimum = priorityMinimum;
        TaskStatusReportBuilderImpl taskStatusReportBuilderImpl3 = taskStatusReportBuilderImpl2 = (taskStatusReportBuilderImpl = this);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskStatusReportBuilderImpl2);
        return taskStatusReportBuilderImpl;
    }

    @Override
    public TaskStatusReportBuilderImpl domainIn(List<String> domains) {
        TaskStatusReportBuilderImpl taskStatusReportBuilderImpl;
        TaskStatusReportBuilderImpl taskStatusReportBuilderImpl2;
        List<String> list = domains;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, list);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.domains = domains;
        TaskStatusReportBuilderImpl taskStatusReportBuilderImpl3 = taskStatusReportBuilderImpl2 = (taskStatusReportBuilderImpl = this);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskStatusReportBuilderImpl2);
        return taskStatusReportBuilderImpl;
    }

    @Override
    public TaskStatusReport.Builder workbasketIdsIn(List<String> workbasketIds) {
        TaskStatusReportBuilderImpl taskStatusReportBuilderImpl;
        TaskStatusReportBuilderImpl taskStatusReportBuilderImpl2;
        List<String> list = workbasketIds;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, list);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.workbasketIds = workbasketIds;
        TaskStatusReportBuilderImpl taskStatusReportBuilderImpl3 = taskStatusReportBuilderImpl2 = (taskStatusReportBuilderImpl = this);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskStatusReportBuilderImpl2);
        return taskStatusReportBuilderImpl;
    }

    static {
        TaskStatusReportBuilderImpl.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("TaskStatusReportBuilderImpl.java", TaskStatusReportBuilderImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "buildReport", "pro.taskana.monitor.internal.reports.TaskStatusReportBuilderImpl", "", "", "pro.taskana.common.api.exceptions.NotAuthorizedException", "pro.taskana.monitor.api.reports.TaskStatusReport"), 37);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "stateIn", "pro.taskana.monitor.internal.reports.TaskStatusReportBuilderImpl", "java.util.List", "states", "", "pro.taskana.monitor.internal.reports.TaskStatusReportBuilderImpl"), 70);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "priorityMinimum", "pro.taskana.monitor.internal.reports.TaskStatusReportBuilderImpl", "java.lang.Integer", "priorityMinimum", "", "pro.taskana.monitor.internal.reports.TaskStatusReportBuilderImpl"), 76);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "domainIn", "pro.taskana.monitor.internal.reports.TaskStatusReportBuilderImpl", "java.util.List", "domains", "", "pro.taskana.monitor.internal.reports.TaskStatusReportBuilderImpl"), 82);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "workbasketIdsIn", "pro.taskana.monitor.internal.reports.TaskStatusReportBuilderImpl", "java.util.List", "workbasketIds", "", "pro.taskana.monitor.api.reports.TaskStatusReport$Builder"), 88);
    }
}

