/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.common.internal;

import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.common.api.ConfigurationService;
import pro.taskana.common.api.exceptions.SystemException;
import pro.taskana.common.internal.ConfigurationMapper;
import pro.taskana.common.internal.InternalTaskanaEngine;
import pro.taskana.common.internal.logging.LoggingAspect;
import pro.taskana.common.internal.util.CheckedRunnable;
import pro.taskana.common.internal.util.ResourceUtil;

public class ConfigurationServiceImpl
implements ConfigurationService {
    private static final Logger LOGGER;
    private final InternalTaskanaEngine internalTaskanaEngine;
    private final ConfigurationMapper mapper;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;

    static {
        ConfigurationServiceImpl.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(ConfigurationServiceImpl.class);
    }

    public ConfigurationServiceImpl(InternalTaskanaEngine internalTaskanaEngine, ConfigurationMapper mapper) {
        this.internalTaskanaEngine = internalTaskanaEngine;
        this.mapper = mapper;
    }

    public void checkSecureAccess(boolean securityEnabled) {
        boolean bl = securityEnabled;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Boolean isSecurityEnabled = this.internalTaskanaEngine.executeInDatabaseConnection(() -> this.mapper.isSecurityEnabled(false));
        if (isSecurityEnabled == null) {
            this.initializeSecurityEnabled(securityEnabled);
        } else if (isSecurityEnabled.booleanValue() && !securityEnabled) {
            LOGGER.error("Tried to start TASKANA in unsecured mode while secured mode is enforced!");
            throw new SystemException("Secured TASKANA mode is enforced, can't start in unsecured mode");
        }
        Object var5_5 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var5_5);
    }

    public void setupDefaultCustomAttributes() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.internalTaskanaEngine.executeInDatabaseConnection(CheckedRunnable.wrap(() -> {
            if (this.mapper.getAllCustomAttributes(true) == null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("custom attributes are not set. Setting default value");
                }
                this.setAllCustomAttributes(this.generateDefaultCustomAttributes());
            }
        }));
        Object var2_2 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var2_2);
    }

    @Override
    public Map<String, Object> getAllCustomAttributes() {
        Map map;
        Map map2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Map map3 = map2 = (map = this.internalTaskanaEngine.executeInDatabaseConnection(() -> this.mapper.getAllCustomAttributes(false)));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)map2);
        return map;
    }

    @Override
    public void setAllCustomAttributes(Map<String, ?> customAttributes) {
        Map<String, ?> map = customAttributes;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, map);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.internalTaskanaEngine.executeInDatabaseConnection(() -> this.mapper.setAllCustomAttributes(customAttributes));
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    @Override
    public Optional<Object> getValue(String attribute) {
        Optional<Object> optional;
        Optional<Object> optional2;
        String string = attribute;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Optional<Object> optional3 = optional2 = (optional = Optional.ofNullable(this.getAllCustomAttributes().get(attribute)));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, optional2);
        return optional;
    }

    private void initializeSecurityEnabled(boolean securityEnabled) {
        Boolean isStillSecurityEnabled;
        boolean bl = securityEnabled;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Security-mode is not yet set. Setting security flag to {}", (Object)securityEnabled);
        }
        if ((isStillSecurityEnabled = this.mapper.isSecurityEnabled(true)) == null) {
            this.mapper.setSecurityEnabled(securityEnabled);
            isStillSecurityEnabled = securityEnabled;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Successfully set security mode to {}", (Object)securityEnabled);
            }
        }
        if (isStillSecurityEnabled.booleanValue() && !securityEnabled) {
            LOGGER.error("Tried to start TASKANA in unsecured mode while secured mode is enforced!");
            throw new SystemException("Secured TASKANA mode is enforced, can't start in unsecured mode");
        }
        Object var5_5 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var5_5);
    }

    private Map<String, Object> generateDefaultCustomAttributes() throws IOException {
        Map map;
        Map map2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        JSONObject jsonObject = new JSONObject(ResourceUtil.readResourceAsString(this.getClass(), (String)"defaultCustomAttributes.json"));
        Map map3 = map2 = (map = jsonObject.toMap());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)map2);
        return map;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ConfigurationServiceImpl.java", ConfigurationServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "checkSecureAccess", "pro.taskana.common.internal.ConfigurationServiceImpl", "boolean", "securityEnabled", "", "void"), 28);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setupDefaultCustomAttributes", "pro.taskana.common.internal.ConfigurationServiceImpl", "", "", "", "void"), 40);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getAllCustomAttributes", "pro.taskana.common.internal.ConfigurationServiceImpl", "", "", "", "java.util.Map"), 54);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setAllCustomAttributes", "pro.taskana.common.internal.ConfigurationServiceImpl", "java.util.Map", "customAttributes", "", "void"), 60);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getValue", "pro.taskana.common.internal.ConfigurationServiceImpl", "java.lang.String", "attribute", "", "java.util.Optional"), 66);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "initializeSecurityEnabled", "pro.taskana.common.internal.ConfigurationServiceImpl", "boolean", "securityEnabled", "", "void"), 70);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "generateDefaultCustomAttributes", "pro.taskana.common.internal.ConfigurationServiceImpl", "", "", "java.io.IOException", "java.util.Map"), 89);
    }
}

