/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.spi.routing.internal;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.common.api.TaskanaEngine;
import pro.taskana.common.internal.logging.LoggingAspect;
import pro.taskana.common.internal.util.CheckedFunction;
import pro.taskana.common.internal.util.LogSanitizer;
import pro.taskana.common.internal.util.SpiLoader;
import pro.taskana.spi.routing.api.TaskRoutingProvider;
import pro.taskana.task.api.models.Task;

public final class TaskRoutingManager {
    private static final Logger LOGGER;
    private final List<TaskRoutingProvider> taskRoutingProviders = SpiLoader.load(TaskRoutingProvider.class);
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    static {
        TaskRoutingManager.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(TaskRoutingManager.class);
    }

    public TaskRoutingManager(TaskanaEngine taskanaEngine) {
        for (TaskRoutingProvider taskRoutingProvider : this.taskRoutingProviders) {
            taskRoutingProvider.initialize(taskanaEngine);
            LOGGER.info("Registered TaskRouter provider: {}", (Object)taskRoutingProvider.getClass().getName());
        }
        if (this.taskRoutingProviders.isEmpty()) {
            LOGGER.info("No TaskRouter provider found. Running without Task routing.");
        }
    }

    public String determineWorkbasketId(Task task) {
        String string;
        String string2;
        Task task2 = task;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)task2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String workbasketId = null;
        if (this.isEnabled()) {
            Set workbasketIds = this.taskRoutingProviders.stream().map(CheckedFunction.wrap(taskRoutingProvider -> taskRoutingProvider.determineWorkbasketId(task))).filter(Objects::nonNull).collect(Collectors.toSet());
            if (workbasketIds.isEmpty()) {
                if (LOGGER.isErrorEnabled()) {
                    LOGGER.error("No TaskRouter determined a workbasket for task {}.", (Object)LogSanitizer.stripLineBreakingChars((Object)task));
                }
            } else if (workbasketIds.size() > 1) {
                if (LOGGER.isErrorEnabled()) {
                    LOGGER.error("The TaskRouters determined more than one workbasket for task {}", (Object)LogSanitizer.stripLineBreakingChars((Object)task));
                }
            } else {
                workbasketId = (String)workbasketIds.iterator().next();
            }
        }
        String string3 = string2 = (string = workbasketId);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, string2);
        return string;
    }

    public boolean isEnabled() {
        boolean bl;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        boolean bl2 = !this.taskRoutingProviders.isEmpty();
        boolean bl3 = bl = bl2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl));
        return bl2;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("TaskRoutingManager.java", TaskRoutingManager.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "determineWorkbasketId", "pro.taskana.spi.routing.internal.TaskRoutingManager", "pro.taskana.task.api.models.Task", "task", "", "java.lang.String"), 47);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isEnabled", "pro.taskana.spi.routing.internal.TaskRoutingManager", "", "", "", "boolean"), 76);
    }
}

