/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.classification.internal;

import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.apache.ibatis.exceptions.PersistenceException;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.classification.api.ClassificationQuery;
import pro.taskana.classification.api.ClassificationService;
import pro.taskana.classification.api.exceptions.ClassificationAlreadyExistException;
import pro.taskana.classification.api.exceptions.ClassificationInUseException;
import pro.taskana.classification.api.exceptions.ClassificationNotFoundException;
import pro.taskana.classification.api.exceptions.MalformedServiceLevelException;
import pro.taskana.classification.api.models.Classification;
import pro.taskana.classification.api.models.ClassificationSummary;
import pro.taskana.classification.internal.ClassificationMapper;
import pro.taskana.classification.internal.ClassificationQueryImpl;
import pro.taskana.classification.internal.jobs.ClassificationChangedJob;
import pro.taskana.classification.internal.models.ClassificationImpl;
import pro.taskana.common.api.ScheduledJob;
import pro.taskana.common.api.TaskanaRole;
import pro.taskana.common.api.exceptions.ConcurrencyException;
import pro.taskana.common.api.exceptions.DomainNotFoundException;
import pro.taskana.common.api.exceptions.InvalidArgumentException;
import pro.taskana.common.api.exceptions.NotAuthorizedException;
import pro.taskana.common.internal.InternalTaskanaEngine;
import pro.taskana.common.internal.logging.LoggingAspect;
import pro.taskana.common.internal.util.IdGenerator;
import pro.taskana.common.internal.util.LogSanitizer;
import pro.taskana.common.internal.util.ObjectAttributeChangeDetector;
import pro.taskana.spi.history.api.events.classification.ClassificationCreatedEvent;
import pro.taskana.spi.history.api.events.classification.ClassificationDeletedEvent;
import pro.taskana.spi.history.api.events.classification.ClassificationUpdatedEvent;
import pro.taskana.spi.history.internal.HistoryEventManager;
import pro.taskana.spi.priority.internal.PriorityServiceManager;
import pro.taskana.task.internal.TaskMapper;

public class ClassificationServiceImpl
implements ClassificationService {
    private static final Logger LOGGER;
    private final HistoryEventManager historyEventManager;
    private final PriorityServiceManager priorityServiceManager;
    private final ClassificationMapper classificationMapper;
    private final TaskMapper taskMapper;
    private final InternalTaskanaEngine taskanaEngine;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_16;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_17;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_18;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_19;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_20;

    static {
        ClassificationServiceImpl.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(ClassificationServiceImpl.class);
    }

    public ClassificationServiceImpl(InternalTaskanaEngine taskanaEngine, PriorityServiceManager priorityServiceManager, ClassificationMapper classificationMapper, TaskMapper taskMapper) {
        this.taskanaEngine = taskanaEngine;
        this.priorityServiceManager = priorityServiceManager;
        this.classificationMapper = classificationMapper;
        this.taskMapper = taskMapper;
        this.historyEventManager = taskanaEngine.getHistoryEventManager();
    }

    @Override
    public Classification getClassification(String key, String domain) throws ClassificationNotFoundException {
        ClassificationImpl classificationImpl;
        ClassificationImpl classificationImpl2;
        String string = key;
        String string2 = domain;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string, (Object)string2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (key == null) {
            throw new ClassificationNotFoundException(null, domain);
        }
        try {
            this.taskanaEngine.openConnection();
            ClassificationImpl result = this.classificationMapper.findByKeyAndDomain(key, domain);
            if (result == null && (result = this.classificationMapper.findByKeyAndDomain(key, "")) == null) {
                throw new ClassificationNotFoundException(key, domain);
            }
            ClassificationImpl classificationImpl3 = result;
            classificationImpl2 = classificationImpl3;
        }
        finally {
            this.taskanaEngine.returnConnection();
        }
        ClassificationImpl classificationImpl4 = classificationImpl = classificationImpl2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)classificationImpl);
        return classificationImpl2;
    }

    @Override
    public Classification getClassification(String id) throws ClassificationNotFoundException {
        ClassificationImpl classificationImpl;
        ClassificationImpl classificationImpl2;
        String string = id;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (id == null) {
            throw new ClassificationNotFoundException(null);
        }
        try {
            this.taskanaEngine.openConnection();
            ClassificationImpl result = this.classificationMapper.findById(id);
            if (result == null) {
                throw new ClassificationNotFoundException(id);
            }
            ClassificationImpl classificationImpl3 = result;
            classificationImpl2 = classificationImpl3;
        }
        finally {
            this.taskanaEngine.returnConnection();
        }
        ClassificationImpl classificationImpl4 = classificationImpl = classificationImpl2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)classificationImpl);
        return classificationImpl2;
    }

    @Override
    public void deleteClassification(String classificationId) throws ClassificationInUseException, ClassificationNotFoundException, NotAuthorizedException {
        String string = classificationId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.taskanaEngine.getEngine().checkRoleMembership(TaskanaRole.BUSINESS_ADMIN, TaskanaRole.ADMIN);
        try {
            this.taskanaEngine.openConnection();
            ClassificationImpl classification = this.classificationMapper.findById(classificationId);
            if (classification == null) {
                throw new ClassificationNotFoundException(classificationId);
            }
            if (classification.getDomain().equals("")) {
                List classificationsInDomain = this.createClassificationQuery().keyIn(classification.getKey()).list();
                for (ClassificationSummary classificationInDomain : classificationsInDomain) {
                    if ("".equals(classificationInDomain.getDomain())) continue;
                    this.deleteClassification(classificationInDomain.getId());
                }
            }
            List childClassifications = this.createClassificationQuery().parentIdIn(classificationId).list();
            for (ClassificationSummary child : childClassifications) {
                this.deleteClassification(child.getId());
            }
            try {
                this.classificationMapper.deleteClassification(classificationId);
                if (this.historyEventManager.isEnabled()) {
                    String details = ObjectAttributeChangeDetector.determineChangesInAttributes((Object)classification, (Object)this.newClassification("", "", ""));
                    this.historyEventManager.createEvent(new ClassificationDeletedEvent(IdGenerator.generateWithPrefix((String)"CHI"), classification, this.taskanaEngine.getEngine().getCurrentUserContext().getUserid(), details));
                }
            }
            catch (PersistenceException e) {
                if (this.isReferentialIntegrityConstraintViolation(e)) {
                    throw new ClassificationInUseException(classification, e);
                }
            }
        }
        finally {
            this.taskanaEngine.returnConnection();
        }
        Object var9_10 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var9_10);
    }

    @Override
    public void deleteClassification(String classificationKey, String domain) throws ClassificationInUseException, ClassificationNotFoundException, NotAuthorizedException {
        String string = classificationKey;
        String string2 = domain;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)string, (Object)string2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.taskanaEngine.getEngine().checkRoleMembership(TaskanaRole.BUSINESS_ADMIN, TaskanaRole.ADMIN);
        try {
            this.taskanaEngine.openConnection();
            ClassificationImpl classification = this.classificationMapper.findByKeyAndDomain(classificationKey, domain);
            if (classification == null) {
                throw new ClassificationNotFoundException(classificationKey, domain);
            }
            this.deleteClassification(classification.getId());
        }
        finally {
            this.taskanaEngine.returnConnection();
        }
        Object var8_8 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var8_8);
    }

    @Override
    public Classification createClassification(Classification classification) throws ClassificationAlreadyExistException, NotAuthorizedException, DomainNotFoundException, InvalidArgumentException, MalformedServiceLevelException {
        ClassificationImpl classificationImpl;
        ClassificationImpl classificationImpl2;
        ClassificationImpl classificationImpl3;
        Classification classification2 = classification;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)classification2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.taskanaEngine.getEngine().checkRoleMembership(TaskanaRole.BUSINESS_ADMIN, TaskanaRole.ADMIN);
        if (!this.taskanaEngine.domainExists(classification.getDomain()) && !"".equals(classification.getDomain())) {
            throw new DomainNotFoundException(classification.getDomain());
        }
        try {
            this.taskanaEngine.openConnection();
            boolean isClassificationExisting = this.doesClassificationExist(classification.getKey(), classification.getDomain());
            if (isClassificationExisting) {
                throw new ClassificationAlreadyExistException(classification);
            }
            classificationImpl3 = (ClassificationImpl)classification;
            this.checkClassificationId(classificationImpl3);
            classificationImpl3.setCreated(Instant.now());
            classificationImpl3.setModified(classificationImpl3.getCreated());
            this.initDefaultClassificationValues(classificationImpl3);
            this.validateAndPopulateParentInformation(classificationImpl3);
            this.classificationMapper.insert(classificationImpl3);
            if (this.historyEventManager.isEnabled()) {
                String details = ObjectAttributeChangeDetector.determineChangesInAttributes((Object)this.newClassification("", "", ""), (Object)classificationImpl3);
                this.historyEventManager.createEvent(new ClassificationCreatedEvent(IdGenerator.generateWithPrefix((String)"CHI"), classificationImpl3, this.taskanaEngine.getEngine().getCurrentUserContext().getUserid(), details));
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Method createClassification created classification {}.", (Object)classificationImpl3);
            }
            if (!classification.getDomain().isEmpty()) {
                this.addClassificationToMasterDomain(classificationImpl3);
            }
        }
        finally {
            this.taskanaEngine.returnConnection();
        }
        ClassificationImpl classificationImpl4 = classificationImpl2 = (classificationImpl = classificationImpl3);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)classificationImpl2);
        return classificationImpl;
    }

    @Override
    public Classification updateClassification(Classification classification) throws NotAuthorizedException, ConcurrencyException, ClassificationNotFoundException, InvalidArgumentException, MalformedServiceLevelException {
        Classification classification2;
        Classification classification3;
        Classification classification4 = classification;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)classification4);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.taskanaEngine.getEngine().checkRoleMembership(TaskanaRole.BUSINESS_ADMIN, TaskanaRole.ADMIN);
        try {
            this.taskanaEngine.openConnection();
            if (classification.getKey().equals(classification.getParentKey())) {
                throw new InvalidArgumentException(String.format("The Classification '%s' has the same key and parent key", classification.getName()));
            }
            ClassificationImpl classificationImpl = (ClassificationImpl)classification;
            Classification oldClassification = this.getExistingClassificationAndVerifyTimestampHasNotChanged(classificationImpl);
            classificationImpl.setModified(Instant.now());
            this.initDefaultClassificationValues(classificationImpl);
            if (!Objects.equals(oldClassification.getCategory(), classificationImpl.getCategory())) {
                this.updateCategoryOnAssociatedTasks(classificationImpl, oldClassification);
            }
            this.checkExistenceOfParentClassification(oldClassification, classificationImpl);
            this.classificationMapper.update(classificationImpl);
            if (!this.priorityServiceManager.isEnabled()) {
                this.createJobIfPriorityOrServiceLevelHasChanged(oldClassification, classificationImpl);
            }
            if (this.historyEventManager.isEnabled()) {
                String details = ObjectAttributeChangeDetector.determineChangesInAttributes((Object)oldClassification, (Object)classificationImpl);
                this.historyEventManager.createEvent(new ClassificationUpdatedEvent(IdGenerator.generateWithPrefix((String)"CHI"), classificationImpl, this.taskanaEngine.getEngine().getCurrentUserContext().getUserid(), details));
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Method updateClassification() updated the classification {}.", (Object)classificationImpl);
            }
            Classification classification5 = classification;
            classification3 = classification5;
        }
        finally {
            this.taskanaEngine.returnConnection();
        }
        Classification classification6 = classification2 = classification3;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)classification2);
        return classification3;
    }

    @Override
    public ClassificationQuery createClassificationQuery() {
        ClassificationQueryImpl classificationQueryImpl;
        ClassificationQueryImpl classificationQueryImpl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ClassificationQueryImpl classificationQueryImpl3 = classificationQueryImpl2 = (classificationQueryImpl = new ClassificationQueryImpl(this.taskanaEngine));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)classificationQueryImpl2);
        return classificationQueryImpl;
    }

    @Override
    public Classification newClassification(String key, String domain, String type) {
        ClassificationImpl classificationImpl;
        ClassificationImpl classificationImpl2;
        String string = key;
        String string2 = domain;
        String string3 = type;
        Object[] objectArray = new Object[]{string, string2, string3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ClassificationImpl classification = new ClassificationImpl();
        classification.setKey(key);
        classification.setDomain(domain);
        classification.setType(type);
        ClassificationImpl classificationImpl3 = classificationImpl2 = (classificationImpl = classification);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)classificationImpl2);
        return classificationImpl;
    }

    private static void validateServiceLevel(Classification classification) throws MalformedServiceLevelException {
        Duration duration;
        Classification classification2 = classification;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, null, null, (Object)classification2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String serviceLevel = classification.getServiceLevel();
        try {
            duration = Duration.parse(serviceLevel);
        }
        catch (Exception exception) {
            throw new MalformedServiceLevelException(serviceLevel, classification.getKey(), classification.getDomain());
        }
        if (duration.isNegative()) {
            throw new MalformedServiceLevelException(serviceLevel, classification.getKey(), classification.getDomain());
        }
        if (!serviceLevel.toLowerCase().startsWith("p") || !serviceLevel.toLowerCase().endsWith("d")) {
            throw new MalformedServiceLevelException(serviceLevel, classification.getKey(), classification.getDomain());
        }
        Object var5_5 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var5_5);
    }

    private void validateAndPopulateParentInformation(ClassificationImpl classificationImpl) throws InvalidArgumentException {
        ClassificationImpl classificationImpl2 = classificationImpl;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object)classificationImpl2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        try {
            Classification parentClassification;
            if (classificationImpl.getParentId() != null && !classificationImpl.getParentId().isEmpty()) {
                parentClassification = this.getClassification(classificationImpl.getParentId());
                if (classificationImpl.getParentKey() != null && !classificationImpl.getParentKey().isEmpty()) {
                    if (!classificationImpl.getParentKey().equals(parentClassification.getKey())) {
                        throw new InvalidArgumentException("Given parent key of classification does not match key of parent id.");
                    }
                    classificationImpl.setParentKey(parentClassification.getKey());
                }
            }
            if (classificationImpl.getParentKey() != null && !classificationImpl.getParentKey().isEmpty()) {
                parentClassification = this.getClassification(classificationImpl.getParentKey(), classificationImpl.getDomain());
                classificationImpl.setParentId(parentClassification.getId());
            }
        }
        catch (ClassificationNotFoundException e) {
            throw new InvalidArgumentException("Parent classification could not be found.", (Throwable)((Object)e));
        }
        Object var5_6 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var5_6);
    }

    private void checkClassificationId(ClassificationImpl classificationImpl) throws InvalidArgumentException {
        ClassificationImpl classificationImpl2 = classificationImpl;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, (Object)classificationImpl2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (classificationImpl.getId() != null && !classificationImpl.getId().isEmpty()) {
            throw new InvalidArgumentException("ClassificationId should be null on creation");
        }
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    private void addClassificationToMasterDomain(ClassificationImpl classification) {
        ClassificationImpl classificationImpl = classification;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this, (Object)classificationImpl);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (!Objects.equals(classification.getDomain(), "")) {
            ClassificationImpl masterClassification = classification.copy(classification.getKey());
            masterClassification.setId(IdGenerator.generateWithPrefix((String)"CLI"));
            masterClassification.setParentKey(classification.getParentKey());
            masterClassification.setDomain("");
            masterClassification.setIsValidInDomain(false);
            try {
                if (classification.getParentKey() != null && !classification.getParentKey().isEmpty()) {
                    masterClassification.setParentId(this.getClassification(classification.getParentKey(), "").getId());
                }
                this.getClassification(masterClassification.getKey(), masterClassification.getDomain());
                throw new ClassificationAlreadyExistException(masterClassification);
            }
            catch (ClassificationNotFoundException classificationNotFoundException) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Method createClassification: Classification does not exist in master domain. Classification {}.", (Object)masterClassification);
                }
                this.classificationMapper.insert(masterClassification);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Method createClassification: Classification created in master-domain, too. Classification {}.", (Object)masterClassification);
                }
            }
            catch (ClassificationAlreadyExistException classificationAlreadyExistException) {
                LOGGER.warn("Method createClassification: Classification does already exist in master domain. Classification {}.", (Object)LogSanitizer.stripLineBreakingChars((Object)masterClassification));
            }
        }
        Object var5_5 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var5_5);
    }

    private void initDefaultClassificationValues(ClassificationImpl classification) throws InvalidArgumentException, MalformedServiceLevelException {
        ClassificationImpl classificationImpl = classification;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this, (Object)classificationImpl);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Instant now = Instant.now();
        if (classification.getId() == null || classification.getId().isEmpty()) {
            classification.setId(IdGenerator.generateWithPrefix((String)"CLI"));
        }
        if (classification.getCreated() == null) {
            classification.setCreated(now);
        }
        if (classification.getModified() == null) {
            classification.setModified(now);
        }
        if (classification.getIsValidInDomain() == null) {
            classification.setIsValidInDomain(true);
        }
        if (classification.getServiceLevel() == null || classification.getServiceLevel().isEmpty()) {
            classification.setServiceLevel("P0D");
        } else {
            ClassificationServiceImpl.validateServiceLevel(classification);
        }
        if (classification.getKey() == null) {
            throw new InvalidArgumentException("Classification must contain a key");
        }
        if (classification.getParentId() == null) {
            classification.setParentId("");
        }
        if (classification.getParentKey() == null) {
            classification.setParentKey("");
        }
        if (classification.getType() != null && !this.taskanaEngine.getEngine().getConfiguration().getClassificationTypes().contains(classification.getType())) {
            throw new InvalidArgumentException("Given classification type " + classification.getType() + " is not valid according to the configuration.");
        }
        if (classification.getCategory() != null && !this.taskanaEngine.getEngine().getConfiguration().getClassificationCategoriesByType(classification.getType()).contains(classification.getCategory())) {
            throw new InvalidArgumentException("Given classification category " + classification.getCategory() + " with type " + classification.getType() + " is not valid according to the configuration.");
        }
        if (classification.getDomain().isEmpty()) {
            classification.setIsValidInDomain(false);
        }
        Object var5_5 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var5_5);
    }

    private boolean doesClassificationExist(String key, String domain) {
        boolean bl;
        boolean bl2;
        String string = key;
        String string2 = domain;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this, (Object)string, (Object)string2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        boolean isExisting = false;
        try {
            if (this.classificationMapper.findByKeyAndDomain(key, domain) != null) {
                isExisting = true;
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Classification-Service threw Exception while calling mapper and searching for classification. EX={}", (Object)ex, (Object)ex);
        }
        boolean bl3 = bl2 = (bl = isExisting);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl2));
        return bl;
    }

    private boolean isReferentialIntegrityConstraintViolation(PersistenceException e) {
        boolean bl;
        boolean bl2;
        PersistenceException persistenceException = e;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)this, (Object)this, (Object)((Object)persistenceException));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        boolean bl3 = bl2 = !this.isH2OrPostgresIntegrityConstraintViolation(e) && !this.isDb2IntegrityConstraintViolation(e) ? (bl = false) : (bl = true);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl2));
        return bl;
    }

    private boolean isDb2IntegrityConstraintViolation(PersistenceException e) {
        boolean bl;
        boolean bl2;
        PersistenceException persistenceException = e;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)this, (Object)this, (Object)((Object)persistenceException));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        boolean bl3 = bl2 = e.getCause() instanceof SQLIntegrityConstraintViolationException && e.getMessage().contains("-532") ? (bl = true) : (bl = false);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl2));
        return bl;
    }

    private boolean isH2OrPostgresIntegrityConstraintViolation(PersistenceException e) {
        boolean bl;
        boolean bl2;
        PersistenceException persistenceException = e;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, (Object)this, (Object)this, (Object)((Object)persistenceException));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        boolean bl3 = bl2 = e.getCause() instanceof SQLException && ((SQLException)e.getCause()).getSQLState().equals("23503") ? (bl = true) : (bl = false);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl2));
        return bl;
    }

    private Classification getExistingClassificationAndVerifyTimestampHasNotChanged(ClassificationImpl classificationImpl) throws ConcurrencyException, ClassificationNotFoundException {
        Classification classification;
        Classification classification2;
        ClassificationImpl classificationImpl2 = classificationImpl;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_17, (Object)this, (Object)this, (Object)classificationImpl2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Classification oldClassification = this.getClassification(classificationImpl.getKey(), classificationImpl.getDomain());
        if (!oldClassification.getModified().equals(classificationImpl.getModified())) {
            throw new ConcurrencyException(classificationImpl.getId());
        }
        Classification classification3 = classification2 = (classification = oldClassification);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)classification2);
        return classification;
    }

    private void updateCategoryOnAssociatedTasks(ClassificationImpl classificationImpl, Classification oldClassification) {
        ClassificationImpl classificationImpl2 = classificationImpl;
        Classification classification = oldClassification;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_18, (Object)this, (Object)this, (Object)classificationImpl2, (Object)classification);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        List taskSummaries = this.taskanaEngine.getEngine().getTaskService().createTaskQuery().classificationIdIn(oldClassification.getId()).list();
        if (!taskSummaries.isEmpty()) {
            ArrayList<String> taskIds = new ArrayList<String>();
            taskSummaries.forEach(ts -> {
                boolean bl = taskIds.add(ts.getId());
            });
            this.taskMapper.updateClassificationCategoryOnChange(taskIds, classificationImpl.getCategory());
        }
        Object var8_8 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var8_8);
    }

    private void checkExistenceOfParentClassification(Classification oldClassification, ClassificationImpl classificationImpl) throws ClassificationNotFoundException {
        Classification classification = oldClassification;
        ClassificationImpl classificationImpl2 = classificationImpl;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_19, (Object)this, (Object)this, (Object)classification, (Object)classificationImpl2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (!oldClassification.getParentId().equals(classificationImpl.getParentId()) && classificationImpl.getParentId() != null && !classificationImpl.getParentId().isEmpty()) {
            this.getClassification(classificationImpl.getParentId());
        }
        if (!oldClassification.getParentKey().equals(classificationImpl.getParentKey()) && classificationImpl.getParentKey() != null && !classificationImpl.getParentKey().isEmpty()) {
            this.getClassification(classificationImpl.getParentKey(), classificationImpl.getDomain());
        }
        Object var6_6 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var6_6);
    }

    private void createJobIfPriorityOrServiceLevelHasChanged(Classification oldClassification, ClassificationImpl classificationImpl) {
        boolean serviceLevelChanged;
        Classification classification = oldClassification;
        ClassificationImpl classificationImpl2 = classificationImpl;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_20, (Object)this, (Object)this, (Object)classification, (Object)classificationImpl2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        boolean priorityChanged = oldClassification.getPriority() != classificationImpl.getPriority();
        boolean bl = serviceLevelChanged = !Objects.equals(oldClassification.getServiceLevel(), classificationImpl.getServiceLevel());
        if (priorityChanged || serviceLevelChanged) {
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("classificationId", classificationImpl.getId());
            args.put("priorityChanged", String.valueOf(priorityChanged));
            args.put("serviceLevelChanged", String.valueOf(serviceLevelChanged));
            ScheduledJob job = new ScheduledJob();
            job.setArguments(args);
            job.setType(ClassificationChangedJob.class.getName());
            this.taskanaEngine.getEngine().getJobService().createJob(job);
        }
        Object var10_10 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var10_10);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ClassificationServiceImpl.java", ClassificationServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getClassification", "pro.taskana.classification.internal.ClassificationServiceImpl", "java.lang.String:java.lang.String", "key:domain", "pro.taskana.classification.api.exceptions.ClassificationNotFoundException", "pro.taskana.classification.api.models.Classification"), 67);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getClassification", "pro.taskana.classification.internal.ClassificationServiceImpl", "java.lang.String", "id", "pro.taskana.classification.api.exceptions.ClassificationNotFoundException", "pro.taskana.classification.api.models.Classification"), 90);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "checkClassificationId", "pro.taskana.classification.internal.ClassificationServiceImpl", "pro.taskana.classification.internal.models.ClassificationImpl", "classificationImpl", "pro.taskana.common.api.exceptions.InvalidArgumentException", "void"), 354);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "addClassificationToMasterDomain", "pro.taskana.classification.internal.ClassificationServiceImpl", "pro.taskana.classification.internal.models.ClassificationImpl", "classification", "", "void"), 361);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "initDefaultClassificationValues", "pro.taskana.classification.internal.ClassificationServiceImpl", "pro.taskana.classification.internal.models.ClassificationImpl", "classification", "pro.taskana.common.api.exceptions.InvalidArgumentException:pro.taskana.classification.api.exceptions.MalformedServiceLevelException", "void"), 408);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "doesClassificationExist", "pro.taskana.classification.internal.ClassificationServiceImpl", "java.lang.String:java.lang.String", "key:domain", "", "boolean"), 476);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "isReferentialIntegrityConstraintViolation", "pro.taskana.classification.internal.ClassificationServiceImpl", "org.apache.ibatis.exceptions.PersistenceException", "e", "", "boolean"), 492);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "isDb2IntegrityConstraintViolation", "pro.taskana.classification.internal.ClassificationServiceImpl", "org.apache.ibatis.exceptions.PersistenceException", "e", "", "boolean"), 496);
        ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "isH2OrPostgresIntegrityConstraintViolation", "pro.taskana.classification.internal.ClassificationServiceImpl", "org.apache.ibatis.exceptions.PersistenceException", "e", "", "boolean"), 501);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getExistingClassificationAndVerifyTimestampHasNotChanged", "pro.taskana.classification.internal.ClassificationServiceImpl", "pro.taskana.classification.internal.models.ClassificationImpl", "classificationImpl", "pro.taskana.common.api.exceptions.ConcurrencyException:pro.taskana.classification.api.exceptions.ClassificationNotFoundException", "pro.taskana.classification.api.models.Classification"), 514);
        ajc$tjp_18 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "updateCategoryOnAssociatedTasks", "pro.taskana.classification.internal.ClassificationServiceImpl", "pro.taskana.classification.internal.models.ClassificationImpl:pro.taskana.classification.api.models.Classification", "classificationImpl:oldClassification", "", "void"), 531);
        ajc$tjp_19 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "checkExistenceOfParentClassification", "pro.taskana.classification.internal.ClassificationServiceImpl", "pro.taskana.classification.api.models.Classification:pro.taskana.classification.internal.models.ClassificationImpl", "oldClassification:classificationImpl", "pro.taskana.classification.api.exceptions.ClassificationNotFoundException", "void"), 555);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteClassification", "pro.taskana.classification.internal.ClassificationServiceImpl", "java.lang.String", "classificationId", "pro.taskana.classification.api.exceptions.ClassificationInUseException:pro.taskana.classification.api.exceptions.ClassificationNotFoundException:pro.taskana.common.api.exceptions.NotAuthorizedException", "void"), 108);
        ajc$tjp_20 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "createJobIfPriorityOrServiceLevelHasChanged", "pro.taskana.classification.internal.ClassificationServiceImpl", "pro.taskana.classification.api.models.Classification:pro.taskana.classification.internal.models.ClassificationImpl", "oldClassification:classificationImpl", "", "void"), 577);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteClassification", "pro.taskana.classification.internal.ClassificationServiceImpl", "java.lang.String:java.lang.String", "classificationKey:domain", "pro.taskana.classification.api.exceptions.ClassificationInUseException:pro.taskana.classification.api.exceptions.ClassificationNotFoundException:pro.taskana.common.api.exceptions.NotAuthorizedException", "void"), 163);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createClassification", "pro.taskana.classification.internal.ClassificationServiceImpl", "pro.taskana.classification.api.models.Classification", "classification", "pro.taskana.classification.api.exceptions.ClassificationAlreadyExistException:pro.taskana.common.api.exceptions.NotAuthorizedException:pro.taskana.common.api.exceptions.DomainNotFoundException:pro.taskana.common.api.exceptions.InvalidArgumentException:pro.taskana.classification.api.exceptions.MalformedServiceLevelException", "pro.taskana.classification.api.models.Classification"), 180);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateClassification", "pro.taskana.classification.internal.ClassificationServiceImpl", "pro.taskana.classification.api.models.Classification", "classification", "pro.taskana.common.api.exceptions.NotAuthorizedException:pro.taskana.common.api.exceptions.ConcurrencyException:pro.taskana.classification.api.exceptions.ClassificationNotFoundException:pro.taskana.common.api.exceptions.InvalidArgumentException:pro.taskana.classification.api.exceptions.MalformedServiceLevelException", "pro.taskana.classification.api.models.Classification"), 234);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createClassificationQuery", "pro.taskana.classification.internal.ClassificationServiceImpl", "", "", "", "pro.taskana.classification.api.ClassificationQuery"), 288);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "newClassification", "pro.taskana.classification.internal.ClassificationServiceImpl", "java.lang.String:java.lang.String:java.lang.String", "key:domain:type", "", "pro.taskana.classification.api.models.Classification"), 293);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "validateServiceLevel", "pro.taskana.classification.internal.ClassificationServiceImpl", "pro.taskana.classification.api.models.Classification", "classification", "pro.taskana.classification.api.exceptions.MalformedServiceLevelException", "void"), 301);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "validateAndPopulateParentInformation", "pro.taskana.classification.internal.ClassificationServiceImpl", "pro.taskana.classification.internal.models.ClassificationImpl", "classificationImpl", "pro.taskana.common.api.exceptions.InvalidArgumentException", "void"), 324);
    }
}

