/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.task.internal.jobs;

import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.common.api.ScheduledJob;
import pro.taskana.common.api.TaskanaEngine;
import pro.taskana.common.api.exceptions.SystemException;
import pro.taskana.common.internal.JobServiceImpl;
import pro.taskana.common.internal.jobs.AbstractTaskanaJob;
import pro.taskana.common.internal.logging.LoggingAspect;
import pro.taskana.common.internal.transaction.TaskanaTransactionProvider;
import pro.taskana.common.internal.util.CollectionUtil;
import pro.taskana.task.internal.jobs.helper.TaskUpdatePriorityWorker;

public class TaskUpdatePriorityJob
extends AbstractTaskanaJob {
    private static final Logger LOGGER;
    private final int batchSize;
    private final boolean isJobActive;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;

    static {
        TaskUpdatePriorityJob.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(TaskUpdatePriorityJob.class);
    }

    public TaskUpdatePriorityJob(TaskanaEngine taskanaEngine) {
        this(taskanaEngine, null, null);
    }

    public TaskUpdatePriorityJob(TaskanaEngine taskanaEngine, TaskanaTransactionProvider txProvider, ScheduledJob scheduledJob) {
        super(taskanaEngine, txProvider, scheduledJob, true);
        this.batchSize = taskanaEngine.getConfiguration().getPriorityJobBatchSize();
        this.isJobActive = taskanaEngine.getConfiguration().isPriorityJobActive();
        this.runEvery = taskanaEngine.getConfiguration().getPriorityJobRunEvery();
        this.firstRun = taskanaEngine.getConfiguration().getPriorityJobFirstRun();
    }

    @Override
    public void execute() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (!this.isJobActive()) {
            LOGGER.debug("Job to update task priority is not active.");
        } else {
            TaskUpdatePriorityWorker worker = new TaskUpdatePriorityWorker(this.taskanaEngineImpl);
            LOGGER.info("Running job to calculate all non finished task priorities");
            try {
                CollectionUtil.partitionBasedOnSize(worker.getAllRelevantTaskIds(), (int)this.getBatchSize()).forEach(worker::executeBatch);
                LOGGER.info("Job to update priority of tasks has finished.");
            }
            catch (Exception e) {
                throw new SystemException("Error while processing TaskUpdatePriorityJob.", (Throwable)e);
            }
        }
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    public boolean isJobActive() {
        boolean bl;
        boolean bl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        boolean bl3 = bl2 = (bl = this.isJobActive);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl2));
        return bl;
    }

    public int getBatchSize() {
        int n;
        int n2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        int n3 = n2 = (n = this.batchSize);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.intObject((int)n2));
        return n;
    }

    public static void initializeSchedule(TaskanaEngine taskanaEngine) {
        TaskanaEngine taskanaEngine2 = taskanaEngine;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, null, null, (Object)taskanaEngine2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        JobServiceImpl jobService = (JobServiceImpl)taskanaEngine.getJobService();
        TaskUpdatePriorityJob job = new TaskUpdatePriorityJob(taskanaEngine);
        jobService.deleteJobs(job.getType());
        job.scheduleNextJob();
        Object var5_5 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var5_5);
    }

    @Override
    protected String getType() {
        String string;
        String string2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String string3 = string2 = (string = TaskUpdatePriorityJob.class.getName());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string2);
        return string;
    }

    public String toString() {
        return "TaskUpdatePriorityJob [firstRun=" + this.firstRun + ", runEvery=" + this.runEvery + ", taskanaEngineImpl=" + this.taskanaEngineImpl + ", txProvider=" + this.txProvider + ", scheduledJob=" + this.scheduledJob + ", batchSize=" + this.batchSize + "]";
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("TaskUpdatePriorityJob.java", TaskUpdatePriorityJob.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "execute", "pro.taskana.task.internal.jobs.TaskUpdatePriorityJob", "", "", "", "void"), 40);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isJobActive", "pro.taskana.task.internal.jobs.TaskUpdatePriorityJob", "", "", "", "boolean"), 56);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getBatchSize", "pro.taskana.task.internal.jobs.TaskUpdatePriorityJob", "", "", "", "int"), 60);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "initializeSchedule", "pro.taskana.task.internal.jobs.TaskUpdatePriorityJob", "pro.taskana.common.api.TaskanaEngine", "taskanaEngine", "", "void"), 70);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getType", "pro.taskana.task.internal.jobs.TaskUpdatePriorityJob", "", "", "", "java.lang.String"), 78);
    }
}

