/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.monitor.api.reports.row;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import pro.taskana.monitor.api.reports.item.QueryItem;
import pro.taskana.monitor.api.reports.row.Row;
import pro.taskana.monitor.api.reports.row.SingleRow;

public abstract class FoldableRow<I extends QueryItem>
extends SingleRow<I> {
    private final Map<String, Row<I>> foldableRows = new LinkedHashMap<String, Row<I>>();
    private final Function<? super I, String> calcFoldableRowKey;
    private final int columnSize;

    protected FoldableRow(String key, int columnSize, Function<? super I, String> calcFoldableRowKey) {
        super(key, columnSize);
        this.columnSize = columnSize;
        this.calcFoldableRowKey = calcFoldableRowKey;
    }

    public final int getFoldableRowCount() {
        return this.foldableRows.size();
    }

    public final Set<String> getFoldableRowKeySet() {
        return this.foldableRows.keySet();
    }

    @Override
    public void addItem(I item, int index) throws IndexOutOfBoundsException {
        super.addItem(item, index);
        this.foldableRows.computeIfAbsent(this.calcFoldableRowKey.apply(item), key -> this.buildRow((String)key, this.columnSize)).addItem(item, index);
    }

    @Override
    public void updateTotalValue(I item) {
        super.updateTotalValue(item);
        this.foldableRows.computeIfAbsent(this.calcFoldableRowKey.apply(item), key -> this.buildRow((String)key, this.columnSize)).updateTotalValue(item);
    }

    @Override
    public void setDisplayName(Map<String, String> displayMap) {
        super.setDisplayName(displayMap);
        this.foldableRows.values().forEach(row -> row.setDisplayName(displayMap));
    }

    public Row<I> getFoldableRow(String key) {
        return this.foldableRows.get(key);
    }

    public Map<String, Row<I>> getFoldableRows() {
        return this.foldableRows;
    }

    protected abstract Row<I> buildRow(String var1, int var2);

    public String toString() {
        return String.format("FoldableRow [detailRows= %s, columnSize= %d]", this.foldableRows, this.columnSize);
    }
}

