/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.spi.history.api.events.workbasket;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import pro.taskana.common.api.exceptions.SystemException;
import pro.taskana.workbasket.api.WorkbasketCustomField;
import pro.taskana.workbasket.api.models.WorkbasketSummary;

public class WorkbasketHistoryEvent {
    protected String id;
    protected String eventType;
    protected Instant created;
    protected String userId;
    protected String domain;
    protected String workbasketId;
    protected String key;
    protected String type;
    protected String owner;
    protected String custom1;
    protected String custom2;
    protected String custom3;
    protected String custom4;
    protected String orgLevel1;
    protected String orgLevel2;
    protected String orgLevel3;
    protected String orgLevel4;
    protected String details;

    public WorkbasketHistoryEvent() {
    }

    public WorkbasketHistoryEvent(String id, WorkbasketSummary workbasket, String userId, String details) {
        this.id = id;
        this.userId = userId;
        this.details = details;
        this.workbasketId = workbasket.getId();
        this.domain = workbasket.getDomain();
        this.key = workbasket.getKey();
        this.type = workbasket.getType().name();
        this.owner = workbasket.getOwner();
        this.custom1 = workbasket.getCustomAttribute(WorkbasketCustomField.CUSTOM_1);
        this.custom2 = workbasket.getCustomAttribute(WorkbasketCustomField.CUSTOM_2);
        this.custom3 = workbasket.getCustomAttribute(WorkbasketCustomField.CUSTOM_3);
        this.custom4 = workbasket.getCustomAttribute(WorkbasketCustomField.CUSTOM_4);
        this.orgLevel1 = workbasket.getOrgLevel1();
        this.orgLevel2 = workbasket.getOrgLevel2();
        this.orgLevel3 = workbasket.getOrgLevel3();
        this.orgLevel4 = workbasket.getOrgLevel4();
    }

    public void setCustomAttribute(WorkbasketCustomField customField, String value) {
        switch (customField) {
            case CUSTOM_1: {
                this.custom1 = value;
                break;
            }
            case CUSTOM_2: {
                this.custom2 = value;
                break;
            }
            case CUSTOM_3: {
                this.custom3 = value;
                break;
            }
            case CUSTOM_4: {
                this.custom4 = value;
                break;
            }
            default: {
                throw new SystemException("Unknown customField '" + (Object)((Object)customField) + "'");
            }
        }
    }

    public String getCustomAttribute(WorkbasketCustomField customField) {
        switch (customField) {
            case CUSTOM_1: {
                return this.custom1;
            }
            case CUSTOM_2: {
                return this.custom2;
            }
            case CUSTOM_3: {
                return this.custom3;
            }
            case CUSTOM_4: {
                return this.custom4;
            }
        }
        throw new SystemException("Unknown customField '" + (Object)((Object)customField) + "'");
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getEventType() {
        return this.eventType;
    }

    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    public Instant getCreated() {
        return this.created != null ? this.created.truncatedTo(ChronoUnit.MILLIS) : null;
    }

    public void setCreated(Instant created) {
        this.created = created != null ? created.truncatedTo(ChronoUnit.MILLIS) : null;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getWorkbasketId() {
        return this.workbasketId;
    }

    public void setWorkbasketId(String workbasketId) {
        this.workbasketId = workbasketId;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getOrgLevel1() {
        return this.orgLevel1;
    }

    public void setOrgLevel1(String orgLevel1) {
        this.orgLevel1 = orgLevel1;
    }

    public String getOrgLevel2() {
        return this.orgLevel2;
    }

    public void setOrgLevel2(String orgLevel2) {
        this.orgLevel2 = orgLevel2;
    }

    public String getOrgLevel3() {
        return this.orgLevel3;
    }

    public void setOrgLevel3(String orgLevel3) {
        this.orgLevel3 = orgLevel3;
    }

    public String getOrgLevel4() {
        return this.orgLevel4;
    }

    public void setOrgLevel4(String orgLevel4) {
        this.orgLevel4 = orgLevel4;
    }

    public String getDetails() {
        return this.details;
    }

    public void setDetails(String details) {
        this.details = details;
    }

    public int hashCode() {
        return Objects.hash(this.getId(), this.getEventType(), this.getCreated(), this.getUserId(), this.getDomain(), this.getWorkbasketId(), this.getKey(), this.getType(), this.getOwner(), this.custom1, this.custom2, this.custom3, this.custom4, this.getOrgLevel1(), this.getOrgLevel2(), this.getOrgLevel3(), this.getOrgLevel4(), this.getDetails());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof WorkbasketHistoryEvent)) {
            return false;
        }
        WorkbasketHistoryEvent other = (WorkbasketHistoryEvent)obj;
        return Objects.equals(this.getId(), other.getId()) && Objects.equals(this.getEventType(), other.getEventType()) && Objects.equals(this.getCreated(), other.getCreated()) && Objects.equals(this.getUserId(), other.getUserId()) && Objects.equals(this.getDomain(), other.getDomain()) && Objects.equals(this.getWorkbasketId(), other.getWorkbasketId()) && Objects.equals(this.getKey(), other.getKey()) && Objects.equals(this.getType(), other.getType()) && Objects.equals(this.getOwner(), other.getOwner()) && Objects.equals(this.custom1, other.custom1) && Objects.equals(this.custom2, other.custom2) && Objects.equals(this.custom3, other.custom3) && Objects.equals(this.custom4, other.custom4) && Objects.equals(this.getOrgLevel1(), other.getOrgLevel1()) && Objects.equals(this.getOrgLevel2(), other.getOrgLevel2()) && Objects.equals(this.getOrgLevel3(), other.getOrgLevel3()) && Objects.equals(this.getOrgLevel4(), other.getOrgLevel4()) && Objects.equals(this.getDetails(), other.getDetails());
    }

    public String toString() {
        return "WorkbasketEvent [id=" + this.id + ", eventType=" + this.eventType + ", created=" + this.created + ", userId=" + this.userId + ", domain=" + this.domain + ", workbasketId=" + this.workbasketId + ", workbasketKey=" + this.key + ", workbasketType=" + this.type + ", owner=" + this.owner + ", custom1=" + this.custom1 + ", custom2=" + this.custom2 + ", custom3=" + this.custom3 + ", custom4=" + this.custom4 + ", orgLevel1=" + this.orgLevel1 + ", orgLevel2=" + this.orgLevel2 + ", orgLevel3=" + this.orgLevel3 + ", orgLevel4=" + this.orgLevel4 + ", details=" + this.details + "]";
    }
}

