/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.task.internal;

import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.common.api.TaskanaRole;
import pro.taskana.common.api.exceptions.ConcurrencyException;
import pro.taskana.common.api.exceptions.InvalidArgumentException;
import pro.taskana.common.api.exceptions.NotAuthorizedException;
import pro.taskana.common.api.exceptions.SystemException;
import pro.taskana.common.internal.InternalTaskanaEngine;
import pro.taskana.common.internal.util.IdGenerator;
import pro.taskana.task.api.exceptions.TaskCommentNotFoundException;
import pro.taskana.task.api.exceptions.TaskNotFoundException;
import pro.taskana.task.api.models.TaskComment;
import pro.taskana.task.internal.TaskCommentMapper;
import pro.taskana.task.internal.TaskServiceImpl;
import pro.taskana.task.internal.models.TaskCommentImpl;

class TaskCommentServiceImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskCommentServiceImpl.class);
    private final InternalTaskanaEngine taskanaEngine;
    private final TaskServiceImpl taskService;
    private final TaskCommentMapper taskCommentMapper;

    TaskCommentServiceImpl(InternalTaskanaEngine taskanaEngine, TaskCommentMapper taskCommentMapper, TaskServiceImpl taskService) {
        this.taskanaEngine = taskanaEngine;
        this.taskService = taskService;
        this.taskCommentMapper = taskCommentMapper;
    }

    TaskComment newTaskComment(String taskId) {
        LOGGER.debug("entry to newTaskComment (taskId = {})", (Object)taskId);
        TaskCommentImpl taskComment = new TaskCommentImpl();
        taskComment.setTaskId(taskId);
        LOGGER.debug("exit from newTaskComment(), returning {}", (Object)taskComment);
        return taskComment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TaskComment updateTaskComment(TaskComment taskCommentToUpdate) throws NotAuthorizedException, ConcurrencyException, TaskCommentNotFoundException, TaskNotFoundException, InvalidArgumentException {
        TaskCommentImpl taskCommentImplToUpdate;
        block4: {
            LOGGER.debug("entry to updateTaskComment (taskComment = {})", (Object)taskCommentToUpdate);
            String userId = this.taskanaEngine.getEngine().getCurrentUserContext().getUserid();
            taskCommentImplToUpdate = (TaskCommentImpl)taskCommentToUpdate;
            try {
                this.taskanaEngine.openConnection();
                TaskComment originalTaskComment = this.getTaskComment(taskCommentImplToUpdate.getId());
                if (originalTaskComment.getCreator().equals(userId) || this.taskanaEngine.getEngine().isUserInRole(TaskanaRole.ADMIN) || this.taskanaEngine.getEngine().isUserInRole(TaskanaRole.TASK_ADMIN)) {
                    this.checkModifiedHasNotChanged(originalTaskComment, taskCommentImplToUpdate);
                    taskCommentImplToUpdate.setModified(Instant.now());
                    this.taskCommentMapper.update(taskCommentImplToUpdate);
                    LOGGER.debug("Method updateTaskComment() updated taskComment '{}' for user '{}'.", (Object)taskCommentImplToUpdate.getId(), (Object)userId);
                    break block4;
                }
                throw new NotAuthorizedException(String.format("Not authorized, TaskComment creator and current user must match. TaskComment creator is %s but current user is %s", taskCommentImplToUpdate.getCreator(), userId), userId);
            }
            finally {
                this.taskanaEngine.returnConnection();
                LOGGER.debug("exit from updateTaskComment()");
            }
        }
        return taskCommentImplToUpdate;
    }

    TaskComment createTaskComment(TaskComment taskCommentToCreate) throws NotAuthorizedException, TaskNotFoundException, InvalidArgumentException {
        LOGGER.debug("entry to setTaskComment (taskCommentToCreate = {})", (Object)taskCommentToCreate);
        TaskCommentImpl taskCommentImplToCreate = (TaskCommentImpl)taskCommentToCreate;
        try {
            this.taskanaEngine.openConnection();
            this.taskService.getTask(taskCommentImplToCreate.getTaskId());
            this.validateNoneExistingTaskCommentId(taskCommentImplToCreate.getId());
            this.initDefaultTaskCommentValues(taskCommentImplToCreate);
            this.taskCommentMapper.insert(taskCommentImplToCreate);
        }
        finally {
            this.taskanaEngine.returnConnection();
            LOGGER.debug("exit from setTaskComment()");
        }
        return taskCommentImplToCreate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteTaskComment(String taskCommentId) throws NotAuthorizedException, TaskCommentNotFoundException, TaskNotFoundException, InvalidArgumentException {
        block4: {
            LOGGER.debug("entry to deleteTaskComment (taskComment = {}", (Object)taskCommentId);
            String userId = this.taskanaEngine.getEngine().getCurrentUserContext().getUserid();
            try {
                this.taskanaEngine.openConnection();
                TaskComment taskCommentToDelete = this.getTaskComment(taskCommentId);
                if (taskCommentToDelete.getCreator().equals(userId) || this.taskanaEngine.getEngine().isUserInRole(TaskanaRole.ADMIN) || this.taskanaEngine.getEngine().isUserInRole(TaskanaRole.TASK_ADMIN)) {
                    this.taskCommentMapper.delete(taskCommentId);
                    LOGGER.debug("taskComment {} deleted", (Object)taskCommentToDelete.getId());
                    break block4;
                }
                throw new NotAuthorizedException(String.format("Not authorized, TaskComment creator and current user must match. TaskComment creator is %s but current user is %s", taskCommentToDelete.getCreator(), userId), userId);
            }
            finally {
                this.taskanaEngine.returnConnection();
                LOGGER.debug("exit from deleteTaskComment()");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<TaskComment> getTaskComments(String taskId) throws NotAuthorizedException, TaskNotFoundException {
        LOGGER.debug("entry to getTaskComments (taskId = {})", (Object)taskId);
        try {
            this.taskanaEngine.openConnection();
            this.taskService.getTask(taskId);
            ArrayList<TaskComment> taskComments = new ArrayList<TaskComment>(this.taskCommentMapper.findByTaskId(taskId));
            if (taskComments.isEmpty()) {
                LOGGER.debug("getTaskComments() found no comments for the provided taskId");
            }
            ArrayList<TaskComment> arrayList = taskComments;
            return arrayList;
        }
        finally {
            this.taskanaEngine.returnConnection();
            LOGGER.debug("exit from getTaskComments()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TaskComment getTaskComment(String taskCommentId) throws TaskCommentNotFoundException, NotAuthorizedException, TaskNotFoundException, InvalidArgumentException {
        LOGGER.debug("entry to getTaskComment (taskCommentId = {})", (Object)taskCommentId);
        this.verifyTaskCommentIdIsNotNullOrEmpty(taskCommentId);
        try {
            this.taskanaEngine.openConnection();
            TaskCommentImpl result = this.taskCommentMapper.findById(taskCommentId);
            if (result == null) {
                throw new TaskCommentNotFoundException(taskCommentId, String.format("TaskComment for taskCommentId '%s' was not found", taskCommentId));
            }
            this.taskService.getTask(result.getTaskId());
            TaskCommentImpl taskCommentImpl = result;
            return taskCommentImpl;
        }
        finally {
            this.taskanaEngine.returnConnection();
            LOGGER.debug("exit from getTaskComment()");
        }
    }

    private void checkModifiedHasNotChanged(TaskComment oldTaskComment, TaskComment taskCommentImplToUpdate) throws ConcurrencyException {
        if (!oldTaskComment.getModified().equals(taskCommentImplToUpdate.getModified())) {
            throw new ConcurrencyException("The current TaskComment has been modified while editing. The values can not be updated. TaskComment " + taskCommentImplToUpdate.toString());
        }
    }

    private void initDefaultTaskCommentValues(TaskCommentImpl taskCommentImplToCreate) {
        Instant now = Instant.now();
        taskCommentImplToCreate.setId(IdGenerator.generateWithPrefix((String)"TCI"));
        taskCommentImplToCreate.setModified(now);
        taskCommentImplToCreate.setCreated(now);
        String creator = this.taskanaEngine.getEngine().getCurrentUserContext().getUserid();
        if (this.taskanaEngine.getEngine().getConfiguration().isSecurityEnabled() && creator == null) {
            throw new SystemException("TaskanaSecurity is enabled, but the current UserId is NULL while creating a TaskComment.");
        }
        taskCommentImplToCreate.setCreator(creator);
    }

    private void validateNoneExistingTaskCommentId(String taskCommentId) throws InvalidArgumentException {
        if (taskCommentId != null && !taskCommentId.equals("")) {
            throw new InvalidArgumentException(String.format("taskCommentId must be null/empty for creation, but found %s", taskCommentId));
        }
    }

    private void verifyTaskCommentIdIsNotNullOrEmpty(String taskCommentId) throws InvalidArgumentException {
        if (taskCommentId == null || taskCommentId.isEmpty()) {
            throw new InvalidArgumentException("taskCommentId must not be null/empty for retrieval/deletion");
        }
    }
}

