/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.workbasket.internal.jobs;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.common.api.BaseQuery;
import pro.taskana.common.api.BulkOperationResults;
import pro.taskana.common.api.ScheduledJob;
import pro.taskana.common.api.TaskanaEngine;
import pro.taskana.common.api.exceptions.InvalidArgumentException;
import pro.taskana.common.api.exceptions.NotAuthorizedException;
import pro.taskana.common.api.exceptions.TaskanaException;
import pro.taskana.common.internal.JobServiceImpl;
import pro.taskana.common.internal.jobs.AbstractTaskanaJob;
import pro.taskana.common.internal.transaction.TaskanaTransactionProvider;
import pro.taskana.common.internal.util.CollectionUtil;
import pro.taskana.workbasket.api.WorkbasketQueryColumnName;

public class WorkbasketCleanupJob
extends AbstractTaskanaJob {
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkbasketCleanupJob.class);
    private final int batchSize;

    public WorkbasketCleanupJob(TaskanaEngine taskanaEngine, TaskanaTransactionProvider<Object> txProvider, ScheduledJob job) {
        super(taskanaEngine, txProvider, job);
        this.batchSize = taskanaEngine.getConfiguration().getMaxNumberOfUpdatesPerTransaction();
    }

    @Override
    public void run() throws TaskanaException {
        LOGGER.info("Running job to delete all workbaskets marked for deletion");
        try {
            List<String> workbasketsMarkedForDeletion = this.getWorkbasketsMarkedForDeletion();
            int totalNumberOfWorkbasketDeleted = CollectionUtil.partitionBasedOnSize(workbasketsMarkedForDeletion, (int)this.batchSize).stream().mapToInt(this::deleteWorkbasketsTransactionally).sum();
            LOGGER.info("Job ended successfully. {} workbaskets deleted.", (Object)totalNumberOfWorkbasketDeleted);
        }
        catch (Exception e) {
            throw new TaskanaException("Error while processing WorkbasketCleanupJob.", (Throwable)e);
        }
        finally {
            this.scheduleNextCleanupJob();
        }
    }

    public static void initializeSchedule(TaskanaEngine taskanaEngine) {
        JobServiceImpl jobService = (JobServiceImpl)taskanaEngine.getJobService();
        jobService.deleteJobs(ScheduledJob.Type.WORKBASKETCLEANUPJOB);
        WorkbasketCleanupJob job = new WorkbasketCleanupJob(taskanaEngine, null, null);
        job.scheduleNextCleanupJob();
    }

    private List<String> getWorkbasketsMarkedForDeletion() {
        return this.taskanaEngineImpl.getWorkbasketService().createWorkbasketQuery().markedForDeletion(true).listValues(WorkbasketQueryColumnName.ID, BaseQuery.SortDirection.ASCENDING);
    }

    private int deleteWorkbasketsTransactionally(List<String> workbasketsToBeDeleted) {
        int deletedWorkbasketsCount = 0;
        if (this.txProvider != null) {
            return (Integer)this.txProvider.executeInTransaction(() -> {
                try {
                    return this.deleteWorkbaskets(workbasketsToBeDeleted);
                }
                catch (Exception e) {
                    LOGGER.warn("Could not delete workbaskets.", (Throwable)e);
                    return 0;
                }
            });
        }
        try {
            deletedWorkbasketsCount = this.deleteWorkbaskets(workbasketsToBeDeleted);
        }
        catch (Exception e) {
            LOGGER.warn("Could not delete workbaskets.", (Throwable)e);
        }
        return deletedWorkbasketsCount;
    }

    private int deleteWorkbaskets(List<String> workbasketsToBeDeleted) throws InvalidArgumentException, NotAuthorizedException {
        BulkOperationResults<String, TaskanaException> results = this.taskanaEngineImpl.getWorkbasketService().deleteWorkbaskets(workbasketsToBeDeleted);
        LOGGER.debug("{} workbasket deleted.", (Object)(workbasketsToBeDeleted.size() - results.getFailedIds().size()));
        for (String failedId : results.getFailedIds()) {
            LOGGER.warn("Workbasket with id {} could not be deleted. Reason:", (Object)failedId, (Object)results.getErrorForId((Object)failedId));
        }
        return workbasketsToBeDeleted.size() - results.getFailedIds().size();
    }

    private void scheduleNextCleanupJob() {
        LOGGER.debug("Entry to scheduleNextCleanupJob.");
        ScheduledJob job = new ScheduledJob();
        job.setType(ScheduledJob.Type.WORKBASKETCLEANUPJOB);
        job.setDue(this.getNextDueForCleanupJob());
        this.taskanaEngineImpl.getJobService().createJob(job);
        LOGGER.debug("Exit from scheduleNextCleanupJob.");
    }
}

