/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.classification.internal.models;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import pro.taskana.classification.api.ClassificationCustomField;
import pro.taskana.classification.api.models.Classification;
import pro.taskana.classification.api.models.ClassificationSummary;
import pro.taskana.classification.internal.models.ClassificationSummaryImpl;
import pro.taskana.common.api.exceptions.SystemException;

public class ClassificationImpl
extends ClassificationSummaryImpl
implements Classification {
    private Boolean isValidInDomain;
    private Instant created;
    private Instant modified;
    private String description;

    public ClassificationImpl() {
    }

    private ClassificationImpl(ClassificationImpl copyFrom, String key) {
        super(copyFrom);
        this.isValidInDomain = copyFrom.isValidInDomain;
        this.created = copyFrom.created;
        this.modified = copyFrom.modified;
        this.description = copyFrom.description;
        this.key = key;
    }

    @Override
    public String getApplicationEntryPoint() {
        return this.applicationEntryPoint;
    }

    @Override
    public void setApplicationEntryPoint(String applicationEntryPoint) {
        this.applicationEntryPoint = applicationEntryPoint;
    }

    @Override
    public ClassificationImpl copy(String key) {
        return new ClassificationImpl(this, key);
    }

    @Override
    public Boolean getIsValidInDomain() {
        return this.isValidInDomain;
    }

    @Override
    public void setIsValidInDomain(Boolean isValidInDomain) {
        this.isValidInDomain = isValidInDomain;
    }

    @Override
    public Instant getCreated() {
        return this.created != null ? this.created.truncatedTo(ChronoUnit.MILLIS) : null;
    }

    public void setCreated(Instant created) {
        this.created = created != null ? created.truncatedTo(ChronoUnit.MILLIS) : null;
    }

    @Override
    public Instant getModified() {
        return this.modified != null ? this.modified.truncatedTo(ChronoUnit.MILLIS) : null;
    }

    public void setModified(Instant modified) {
        this.modified = modified != null ? modified.truncatedTo(ChronoUnit.MILLIS) : null;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public void setCustomAttribute(ClassificationCustomField customField, String value) {
        switch (customField) {
            case CUSTOM_1: {
                this.custom1 = value;
                break;
            }
            case CUSTOM_2: {
                this.custom2 = value;
                break;
            }
            case CUSTOM_3: {
                this.custom3 = value;
                break;
            }
            case CUSTOM_4: {
                this.custom4 = value;
                break;
            }
            case CUSTOM_5: {
                this.custom5 = value;
                break;
            }
            case CUSTOM_6: {
                this.custom6 = value;
                break;
            }
            case CUSTOM_7: {
                this.custom7 = value;
                break;
            }
            case CUSTOM_8: {
                this.custom8 = value;
                break;
            }
            default: {
                throw new SystemException("Unknown customField '" + (Object)((Object)customField) + "'");
            }
        }
    }

    @Override
    public ClassificationSummary asSummary() {
        ClassificationSummaryImpl summary = new ClassificationSummaryImpl();
        summary.setCategory(this.category);
        summary.setDomain(this.domain);
        summary.setId(this.id);
        summary.setKey(this.key);
        summary.setName(this.name);
        summary.setType(this.type);
        summary.setParentId(this.parentId);
        summary.setParentKey(this.parentKey);
        summary.setPriority(this.priority);
        summary.setServiceLevel(this.serviceLevel);
        summary.setApplicationEntryPoint(this.applicationEntryPoint);
        summary.setCustom1(this.custom1);
        summary.setCustom2(this.custom2);
        summary.setCustom3(this.custom3);
        summary.setCustom4(this.custom4);
        summary.setCustom5(this.custom5);
        summary.setCustom6(this.custom6);
        summary.setCustom7(this.custom7);
        summary.setCustom8(this.custom8);
        return summary;
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ClassificationImpl;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.isValidInDomain, this.created, this.modified, this.description);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ClassificationImpl)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        ClassificationImpl other = (ClassificationImpl)obj;
        return Objects.equals(this.isValidInDomain, other.isValidInDomain) && Objects.equals(this.created, other.created) && Objects.equals(this.modified, other.modified) && Objects.equals(this.description, other.description);
    }

    @Override
    public String toString() {
        return "ClassificationImpl [id=" + this.id + ", key=" + this.key + ", parentId=" + this.parentId + ", parentKey=" + this.parentKey + ", category=" + this.category + ", type=" + this.type + ", domain=" + this.domain + ", isValidInDomain=" + this.isValidInDomain + ", created=" + this.created + ", modified=" + this.modified + ", name=" + this.name + ", description=" + this.description + ", priority=" + this.priority + ", serviceLevel=" + this.serviceLevel + ", applicationEntryPoint=" + this.applicationEntryPoint + ", custom1=" + this.custom1 + ", custom2=" + this.custom2 + ", custom3=" + this.custom3 + ", custom4=" + this.custom4 + ", custom5=" + this.custom5 + ", custom6=" + this.custom6 + ", custom7=" + this.custom7 + ", custom8=" + this.custom8 + "]";
    }
}

