/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.common.internal;

import java.security.AccessController;
import java.security.Principal;
import java.sql.Connection;
import java.sql.SQLException;
import java.time.Instant;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.function.Supplier;
import javax.security.auth.Subject;
import org.apache.ibatis.mapping.Environment;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.SqlSessionFactoryBuilder;
import org.apache.ibatis.session.SqlSessionManager;
import org.apache.ibatis.transaction.TransactionFactory;
import org.apache.ibatis.transaction.jdbc.JdbcTransactionFactory;
import org.apache.ibatis.transaction.managed.ManagedTransactionFactory;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.TypeHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.TaskanaEngineConfiguration;
import pro.taskana.classification.api.ClassificationService;
import pro.taskana.classification.internal.ClassificationMapper;
import pro.taskana.classification.internal.ClassificationQueryMapper;
import pro.taskana.classification.internal.ClassificationServiceImpl;
import pro.taskana.common.api.JobService;
import pro.taskana.common.api.TaskanaEngine;
import pro.taskana.common.api.TaskanaRole;
import pro.taskana.common.api.WorkingDaysToDaysConverter;
import pro.taskana.common.api.exceptions.AutocommitFailedException;
import pro.taskana.common.api.exceptions.ConnectionNotSetException;
import pro.taskana.common.api.exceptions.NotAuthorizedException;
import pro.taskana.common.api.exceptions.SystemException;
import pro.taskana.common.api.exceptions.TaskanaRuntimeException;
import pro.taskana.common.api.security.CurrentUserContext;
import pro.taskana.common.api.security.GroupPrincipal;
import pro.taskana.common.internal.InternalTaskanaEngine;
import pro.taskana.common.internal.JobMapper;
import pro.taskana.common.internal.JobServiceImpl;
import pro.taskana.common.internal.configuration.DB;
import pro.taskana.common.internal.configuration.DbSchemaCreator;
import pro.taskana.common.internal.configuration.SecurityVerifier;
import pro.taskana.common.internal.persistence.InstantTypeHandler;
import pro.taskana.common.internal.persistence.MapTypeHandler;
import pro.taskana.common.internal.security.CurrentUserContextImpl;
import pro.taskana.monitor.api.MonitorService;
import pro.taskana.monitor.internal.MonitorMapper;
import pro.taskana.monitor.internal.MonitorServiceImpl;
import pro.taskana.spi.history.internal.HistoryEventManager;
import pro.taskana.spi.routing.internal.TaskRoutingManager;
import pro.taskana.spi.task.internal.CreateTaskPreprocessorManager;
import pro.taskana.task.api.TaskService;
import pro.taskana.task.internal.AttachmentMapper;
import pro.taskana.task.internal.ObjectReferenceMapper;
import pro.taskana.task.internal.TaskCommentMapper;
import pro.taskana.task.internal.TaskMapper;
import pro.taskana.task.internal.TaskQueryMapper;
import pro.taskana.task.internal.TaskServiceImpl;
import pro.taskana.workbasket.api.WorkbasketService;
import pro.taskana.workbasket.internal.DistributionTargetMapper;
import pro.taskana.workbasket.internal.WorkbasketAccessMapper;
import pro.taskana.workbasket.internal.WorkbasketMapper;
import pro.taskana.workbasket.internal.WorkbasketQueryMapper;
import pro.taskana.workbasket.internal.WorkbasketServiceImpl;

public class TaskanaEngineImpl
implements TaskanaEngine {
    private static final String TASKANA_SCHEMA_VERSION = "4.0.0";
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskanaEngineImpl.class);
    private static final SessionStack SESSION_STACK = new SessionStack();
    private final TaskRoutingManager taskRoutingManager;
    private final CreateTaskPreprocessorManager createTaskPreprocessorManager;
    private final InternalTaskanaEngineImpl internalTaskanaEngineImpl;
    private final WorkingDaysToDaysConverter workingDaysToDaysConverter;
    private final HistoryEventManager historyEventManager;
    private final CurrentUserContext currentUserContext;
    protected TaskanaEngineConfiguration taskanaEngineConfiguration;
    protected TransactionFactory transactionFactory;
    protected SqlSessionManager sessionManager;
    protected TaskanaEngine.ConnectionManagementMode mode = TaskanaEngine.ConnectionManagementMode.PARTICIPATE;
    protected Connection connection = null;

    protected TaskanaEngineImpl(TaskanaEngineConfiguration taskanaEngineConfiguration) throws SQLException {
        this.taskanaEngineConfiguration = taskanaEngineConfiguration;
        this.createTransactionFactory(taskanaEngineConfiguration.getUseManagedTransactions());
        this.sessionManager = this.createSqlSessionManager();
        this.initializeDbSchema(taskanaEngineConfiguration);
        this.createTaskPreprocessorManager = CreateTaskPreprocessorManager.getInstance();
        this.internalTaskanaEngineImpl = new InternalTaskanaEngineImpl();
        this.workingDaysToDaysConverter = new WorkingDaysToDaysConverter(taskanaEngineConfiguration.isGermanPublicHolidaysEnabled(), taskanaEngineConfiguration.isCorpusChristiEnabled(), taskanaEngineConfiguration.getCustomHolidays());
        this.currentUserContext = new CurrentUserContextImpl(TaskanaEngineConfiguration.shouldUseLowerCaseForAccessIds());
        this.historyEventManager = HistoryEventManager.getInstance(this);
        this.taskRoutingManager = TaskRoutingManager.getInstance(this);
    }

    public static TaskanaEngine createTaskanaEngine(TaskanaEngineConfiguration taskanaEngineConfiguration) throws SQLException {
        return new TaskanaEngineImpl(taskanaEngineConfiguration);
    }

    @Override
    public TaskService getTaskService() {
        SqlSessionManager session = this.sessionManager;
        return new TaskServiceImpl(this.internalTaskanaEngineImpl, (TaskMapper)session.getMapper(TaskMapper.class), (TaskCommentMapper)session.getMapper(TaskCommentMapper.class), (AttachmentMapper)session.getMapper(AttachmentMapper.class));
    }

    @Override
    public MonitorService getMonitorService() {
        SqlSessionManager session = this.sessionManager;
        return new MonitorServiceImpl(this.internalTaskanaEngineImpl, (MonitorMapper)session.getMapper(MonitorMapper.class));
    }

    @Override
    public WorkbasketService getWorkbasketService() {
        SqlSessionManager session = this.sessionManager;
        return new WorkbasketServiceImpl(this.internalTaskanaEngineImpl, (WorkbasketMapper)session.getMapper(WorkbasketMapper.class), (DistributionTargetMapper)session.getMapper(DistributionTargetMapper.class), (WorkbasketAccessMapper)session.getMapper(WorkbasketAccessMapper.class));
    }

    @Override
    public ClassificationService getClassificationService() {
        SqlSessionManager session = this.sessionManager;
        return new ClassificationServiceImpl(this.internalTaskanaEngineImpl, (ClassificationMapper)session.getMapper(ClassificationMapper.class), (TaskMapper)session.getMapper(TaskMapper.class));
    }

    @Override
    public JobService getJobService() {
        SqlSessionManager session = this.sessionManager;
        return new JobServiceImpl(this.internalTaskanaEngineImpl, (JobMapper)session.getMapper(JobMapper.class));
    }

    @Override
    public TaskanaEngineConfiguration getConfiguration() {
        return this.taskanaEngineConfiguration;
    }

    @Override
    public WorkingDaysToDaysConverter getWorkingDaysToDaysConverter() {
        return this.workingDaysToDaysConverter;
    }

    @Override
    public boolean isHistoryEnabled() {
        return HistoryEventManager.isHistoryEnabled();
    }

    @Override
    public void setConnectionManagementMode(TaskanaEngine.ConnectionManagementMode mode) {
        if (this.mode == TaskanaEngine.ConnectionManagementMode.EXPLICIT && this.connection != null && mode != TaskanaEngine.ConnectionManagementMode.EXPLICIT) {
            if (this.sessionManager.isManagedSessionStarted()) {
                this.sessionManager.close();
            }
            this.connection = null;
        }
        this.mode = mode;
    }

    @Override
    public void setConnection(Connection connection) throws SQLException {
        if (connection != null) {
            this.connection = connection;
            connection.setAutoCommit(false);
            connection.setSchema(this.taskanaEngineConfiguration.getSchemaName());
            this.mode = TaskanaEngine.ConnectionManagementMode.EXPLICIT;
            this.sessionManager.startManagedSession(connection);
        } else if (this.connection != null) {
            this.closeConnection();
        }
    }

    @Override
    public void closeConnection() {
        if (this.mode == TaskanaEngine.ConnectionManagementMode.EXPLICIT) {
            this.connection = null;
            if (this.sessionManager.isManagedSessionStarted()) {
                this.sessionManager.close();
            }
            this.mode = TaskanaEngine.ConnectionManagementMode.PARTICIPATE;
        }
    }

    @Override
    public boolean isUserInRole(TaskanaRole ... roles) {
        if (!this.getConfiguration().isSecurityEnabled()) {
            return true;
        }
        List accessIds = this.currentUserContext.getAccessIds();
        HashSet rolesMembers = new HashSet();
        for (TaskanaRole role : roles) {
            rolesMembers.addAll(this.getConfiguration().getRoleMap().get(role));
        }
        for (String accessId : accessIds) {
            if (!rolesMembers.contains(accessId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void checkRoleMembership(TaskanaRole ... roles) throws NotAuthorizedException {
        if (!this.isUserInRole(roles)) {
            if (LOGGER.isDebugEnabled()) {
                String rolesAsString = Arrays.toString(roles);
                LOGGER.debug("Throwing NotAuthorizedException because accessIds {} are not member of roles {}", (Object)this.currentUserContext.getAccessIds(), (Object)rolesAsString);
            }
            throw new NotAuthorizedException("current user is not member of role(s) " + Arrays.toString(roles), this.currentUserContext.getUserid());
        }
    }

    @Override
    public CurrentUserContext getCurrentUserContext() {
        return this.currentUserContext;
    }

    protected SqlSessionManager createSqlSessionManager() {
        Environment environment = new Environment("default", this.transactionFactory, this.taskanaEngineConfiguration.getDatasource());
        Configuration configuration = new Configuration(environment);
        try (Connection con = this.taskanaEngineConfiguration.getDatasource().getConnection();){
            String databaseProductName = con.getMetaData().getDatabaseProductName();
            String databaseProductId = DB.getDatabaseProductId((String)databaseProductName);
            configuration.setDatabaseId(databaseProductId);
        }
        catch (SQLException e) {
            throw new SystemException("Method createSqlSessionManager() could not open a connection to the database. No databaseId has been set.", e.getCause());
        }
        configuration.getTypeHandlerRegistry().register((TypeHandler)new MapTypeHandler());
        configuration.getTypeHandlerRegistry().register(Instant.class, (TypeHandler)new InstantTypeHandler());
        configuration.getTypeHandlerRegistry().register(JdbcType.TIMESTAMP, (TypeHandler)new InstantTypeHandler());
        configuration.addMapper(TaskMapper.class);
        configuration.addMapper(MonitorMapper.class);
        configuration.addMapper(WorkbasketMapper.class);
        configuration.addMapper(DistributionTargetMapper.class);
        configuration.addMapper(ClassificationMapper.class);
        configuration.addMapper(WorkbasketAccessMapper.class);
        configuration.addMapper(ObjectReferenceMapper.class);
        configuration.addMapper(WorkbasketQueryMapper.class);
        configuration.addMapper(TaskQueryMapper.class);
        configuration.addMapper(TaskCommentMapper.class);
        configuration.addMapper(ClassificationQueryMapper.class);
        configuration.addMapper(AttachmentMapper.class);
        configuration.addMapper(JobMapper.class);
        SqlSessionFactory localSessionFactory = new SqlSessionFactoryBuilder().build(configuration);
        return SqlSessionManager.newInstance((SqlSessionFactory)localSessionFactory);
    }

    private void initializeDbSchema(TaskanaEngineConfiguration taskanaEngineConfiguration) throws SQLException {
        DbSchemaCreator dbSchemaCreator = new DbSchemaCreator(taskanaEngineConfiguration.getDatasource(), taskanaEngineConfiguration.getSchemaName());
        dbSchemaCreator.run();
        if (!dbSchemaCreator.isValidSchemaVersion(TASKANA_SCHEMA_VERSION)) {
            throw new SystemException("The Database Schema Version doesn't match the expected minimal version 4.0.0");
        }
        new SecurityVerifier(taskanaEngineConfiguration.getDatasource(), taskanaEngineConfiguration.getSchemaName()).checkSecureAccess(taskanaEngineConfiguration.isSecurityEnabled());
    }

    private void createTransactionFactory(boolean useManagedTransactions) {
        this.transactionFactory = useManagedTransactions ? new ManagedTransactionFactory() : new JdbcTransactionFactory();
    }

    private class InternalTaskanaEngineImpl
    implements InternalTaskanaEngine {
        private InternalTaskanaEngineImpl() {
        }

        @Override
        public void openConnection() {
            this.initSqlSession();
            try {
                TaskanaEngineImpl.this.sessionManager.getConnection().setSchema(TaskanaEngineImpl.this.taskanaEngineConfiguration.getSchemaName());
            }
            catch (SQLException e) {
                throw new SystemException("Method openConnection() could not open a connection to the database. No schema has been created.", e.getCause());
            }
            if (TaskanaEngineImpl.this.mode != TaskanaEngine.ConnectionManagementMode.EXPLICIT) {
                SESSION_STACK.pushSessionToStack(TaskanaEngineImpl.this.sessionManager);
            }
        }

        @Override
        public void returnConnection() {
            if (TaskanaEngineImpl.this.mode != TaskanaEngine.ConnectionManagementMode.EXPLICIT) {
                SESSION_STACK.popSessionFromStack();
                if (SESSION_STACK.getSessionStack().isEmpty() && TaskanaEngineImpl.this.sessionManager != null && TaskanaEngineImpl.this.sessionManager.isManagedSessionStarted()) {
                    if (TaskanaEngineImpl.this.mode == TaskanaEngine.ConnectionManagementMode.AUTOCOMMIT) {
                        try {
                            TaskanaEngineImpl.this.sessionManager.commit();
                        }
                        catch (Exception e) {
                            throw new AutocommitFailedException(e.getCause());
                        }
                    }
                    TaskanaEngineImpl.this.sessionManager.close();
                }
            }
        }

        @Override
        public <T> T openAndReturnConnection(Supplier<T> supplier) {
            try {
                this.openConnection();
                T t = supplier.get();
                return t;
            }
            finally {
                this.returnConnection();
            }
        }

        @Override
        public void initSqlSession() {
            if (TaskanaEngineImpl.this.mode == TaskanaEngine.ConnectionManagementMode.EXPLICIT && TaskanaEngineImpl.this.connection == null) {
                throw new ConnectionNotSetException();
            }
            if (TaskanaEngineImpl.this.mode != TaskanaEngine.ConnectionManagementMode.EXPLICIT && !TaskanaEngineImpl.this.sessionManager.isManagedSessionStarted()) {
                TaskanaEngineImpl.this.sessionManager.startManagedSession();
            }
        }

        @Override
        public boolean domainExists(String domain) {
            return TaskanaEngineImpl.this.getConfiguration().getDomains().contains(domain);
        }

        @Override
        public SqlSession getSqlSession() {
            return TaskanaEngineImpl.this.sessionManager;
        }

        @Override
        public TaskanaEngine getEngine() {
            return TaskanaEngineImpl.this;
        }

        @Override
        public HistoryEventManager getHistoryEventManager() {
            return TaskanaEngineImpl.this.historyEventManager;
        }

        @Override
        public TaskRoutingManager getTaskRoutingManager() {
            return TaskanaEngineImpl.this.taskRoutingManager;
        }

        @Override
        public CreateTaskPreprocessorManager getCreateTaskPreprocessorManager() {
            return TaskanaEngineImpl.this.createTaskPreprocessorManager;
        }

        @Override
        public <T> T runAsAdmin(Supplier<T> supplier) {
            Subject subject = Subject.getSubject(AccessController.getContext());
            if (subject == null) {
                return supplier.get();
            }
            HashSet<Principal> principalsCopy = new HashSet<Principal>(subject.getPrincipals());
            HashSet<Object> privateCredentialsCopy = new HashSet<Object>(subject.getPrivateCredentials());
            HashSet<Object> publicCredentialsCopy = new HashSet<Object>(subject.getPublicCredentials());
            String adminName = (String)this.getEngine().getConfiguration().getRoleMap().get(TaskanaRole.ADMIN).stream().findFirst().orElseThrow(() -> new TaskanaRuntimeException("There is no admin configured"));
            principalsCopy.add((Principal)new GroupPrincipal(adminName));
            Subject subject1 = new Subject(true, principalsCopy, privateCredentialsCopy, publicCredentialsCopy);
            return (T)Subject.doAs(subject1, supplier::get);
        }
    }

    private static class SessionStack {
        private final ThreadLocal<Deque<SqlSessionManager>> sessionStack = new ThreadLocal();

        private SessionStack() {
        }

        private Deque<SqlSessionManager> getSessionStack() {
            Deque<SqlSessionManager> stack = this.sessionStack.get();
            if (stack == null) {
                stack = new ArrayDeque<SqlSessionManager>();
                this.sessionStack.set(stack);
            }
            return stack;
        }

        private void pushSessionToStack(SqlSessionManager session) {
            this.getSessionStack().push(session);
        }

        private void popSessionFromStack() {
            Deque<SqlSessionManager> stack = this.getSessionStack();
            if (!stack.isEmpty()) {
                stack.pop();
            }
        }
    }
}

