/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.spi.history.api.events.task;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import pro.taskana.common.api.exceptions.SystemException;
import pro.taskana.spi.history.api.events.task.TaskHistoryCustomField;
import pro.taskana.task.api.models.TaskSummary;

public class TaskHistoryEvent {
    protected String id;
    protected String businessProcessId;
    protected String parentBusinessProcessId;
    protected String taskId;
    protected String eventType;
    protected Instant created;
    protected String userId;
    protected String domain;
    protected String workbasketKey;
    protected String porCompany;
    protected String porSystem;
    protected String porInstance;
    protected String porType;
    protected String porValue;
    protected String taskClassificationKey;
    protected String taskClassificationCategory;
    protected String attachmentClassificationKey;
    protected String oldValue;
    protected String newValue;
    protected String custom1;
    protected String custom2;
    protected String custom3;
    protected String custom4;
    protected String details;

    public TaskHistoryEvent() {
    }

    public TaskHistoryEvent(String id, TaskSummary task, String userId, String details) {
        this.id = id;
        this.userId = userId;
        this.details = details;
        this.taskId = task.getId();
        this.businessProcessId = task.getBusinessProcessId();
        this.parentBusinessProcessId = task.getParentBusinessProcessId();
        this.domain = task.getDomain();
        this.workbasketKey = task.getWorkbasketSummary().getKey();
        if (task.getClassificationSummary() != null) {
            this.taskClassificationCategory = task.getClassificationSummary().getCategory();
            this.taskClassificationKey = task.getClassificationSummary().getKey();
        }
        if (!task.getAttachmentSummaries().isEmpty()) {
            this.attachmentClassificationKey = task.getAttachmentSummaries().get(0).getClassificationSummary().getKey();
        }
        if (task.getPrimaryObjRef() != null) {
            this.porCompany = task.getPrimaryObjRef().getCompany();
            this.porSystem = task.getPrimaryObjRef().getSystem();
            this.porInstance = task.getPrimaryObjRef().getSystemInstance();
            this.porType = task.getPrimaryObjRef().getType();
            this.porValue = task.getPrimaryObjRef().getValue();
        }
    }

    public void setCustomAttribute(TaskHistoryCustomField customField, String value) {
        switch (customField) {
            case CUSTOM_1: {
                this.custom1 = value;
                break;
            }
            case CUSTOM_2: {
                this.custom2 = value;
                break;
            }
            case CUSTOM_3: {
                this.custom3 = value;
                break;
            }
            case CUSTOM_4: {
                this.custom4 = value;
                break;
            }
            default: {
                throw new SystemException("Unknown customField '" + (Object)((Object)customField) + "'");
            }
        }
    }

    public String getCustomAttribute(TaskHistoryCustomField customField) {
        switch (customField) {
            case CUSTOM_1: {
                return this.custom1;
            }
            case CUSTOM_2: {
                return this.custom2;
            }
            case CUSTOM_3: {
                return this.custom3;
            }
            case CUSTOM_4: {
                return this.custom4;
            }
        }
        throw new SystemException("Unknown customField '" + (Object)((Object)customField) + "'");
    }

    public String getBusinessProcessId() {
        return this.businessProcessId;
    }

    public void setBusinessProcessId(String businessProcessId) {
        this.businessProcessId = businessProcessId;
    }

    public String getParentBusinessProcessId() {
        return this.parentBusinessProcessId;
    }

    public void setParentBusinessProcessId(String parentBusinessProcessId) {
        this.parentBusinessProcessId = parentBusinessProcessId;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getWorkbasketKey() {
        return this.workbasketKey;
    }

    public void setWorkbasketKey(String workbasketKey) {
        this.workbasketKey = workbasketKey;
    }

    public String getPorCompany() {
        return this.porCompany;
    }

    public void setPorCompany(String porCompany) {
        this.porCompany = porCompany;
    }

    public String getPorSystem() {
        return this.porSystem;
    }

    public void setPorSystem(String porSystem) {
        this.porSystem = porSystem;
    }

    public String getPorInstance() {
        return this.porInstance;
    }

    public void setPorInstance(String porInstance) {
        this.porInstance = porInstance;
    }

    public String getPorType() {
        return this.porType;
    }

    public void setPorType(String porType) {
        this.porType = porType;
    }

    public String getPorValue() {
        return this.porValue;
    }

    public void setPorValue(String porValue) {
        this.porValue = porValue;
    }

    public String getTaskClassificationKey() {
        return this.taskClassificationKey;
    }

    public void setTaskClassificationKey(String taskClassificationKey) {
        this.taskClassificationKey = taskClassificationKey;
    }

    public String getTaskClassificationCategory() {
        return this.taskClassificationCategory;
    }

    public void setTaskClassificationCategory(String taskClassificationCategory) {
        this.taskClassificationCategory = taskClassificationCategory;
    }

    public String getAttachmentClassificationKey() {
        return this.attachmentClassificationKey;
    }

    public void setAttachmentClassificationKey(String attachmentClassificationKey) {
        this.attachmentClassificationKey = attachmentClassificationKey;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getEventType() {
        return this.eventType;
    }

    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    public Instant getCreated() {
        return this.created != null ? this.created.truncatedTo(ChronoUnit.MILLIS) : null;
    }

    public void setCreated(Instant created) {
        this.created = created != null ? created.truncatedTo(ChronoUnit.MILLIS) : null;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getOldValue() {
        return this.oldValue;
    }

    public void setOldValue(String oldValue) {
        this.oldValue = oldValue;
    }

    public String getNewValue() {
        return this.newValue;
    }

    public void setNewValue(String newValue) {
        this.newValue = newValue;
    }

    public String getDetails() {
        return this.details;
    }

    public void setDetails(String details) {
        this.details = details;
    }

    public int hashCode() {
        return Objects.hash(this.getId(), this.getBusinessProcessId(), this.getParentBusinessProcessId(), this.getTaskId(), this.getEventType(), this.getCreated(), this.getUserId(), this.getDomain(), this.getWorkbasketKey(), this.getPorCompany(), this.getPorSystem(), this.getPorInstance(), this.getPorType(), this.getPorValue(), this.getTaskClassificationKey(), this.getTaskClassificationCategory(), this.getAttachmentClassificationKey(), this.getOldValue(), this.getNewValue(), this.custom1, this.custom2, this.custom3, this.custom4, this.getDetails());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TaskHistoryEvent)) {
            return false;
        }
        TaskHistoryEvent other = (TaskHistoryEvent)obj;
        return Objects.equals(this.getId(), other.getId()) && Objects.equals(this.getBusinessProcessId(), other.getBusinessProcessId()) && Objects.equals(this.getParentBusinessProcessId(), other.getParentBusinessProcessId()) && Objects.equals(this.getTaskId(), other.getTaskId()) && Objects.equals(this.getEventType(), other.getEventType()) && Objects.equals(this.getCreated(), other.getCreated()) && Objects.equals(this.getUserId(), other.getUserId()) && Objects.equals(this.getDomain(), other.getDomain()) && Objects.equals(this.getWorkbasketKey(), other.getWorkbasketKey()) && Objects.equals(this.getPorCompany(), other.getPorCompany()) && Objects.equals(this.getPorSystem(), other.getPorSystem()) && Objects.equals(this.getPorInstance(), other.getPorInstance()) && Objects.equals(this.getPorType(), other.getPorType()) && Objects.equals(this.getPorValue(), other.getPorValue()) && Objects.equals(this.getTaskClassificationKey(), other.getTaskClassificationKey()) && Objects.equals(this.getTaskClassificationCategory(), other.getTaskClassificationCategory()) && Objects.equals(this.getAttachmentClassificationKey(), other.getAttachmentClassificationKey()) && Objects.equals(this.getOldValue(), other.getOldValue()) && Objects.equals(this.getNewValue(), other.getNewValue()) && Objects.equals(this.custom1, other.custom1) && Objects.equals(this.custom2, other.custom2) && Objects.equals(this.custom3, other.custom3) && Objects.equals(this.custom4, other.custom4) && Objects.equals(this.getDetails(), other.getDetails());
    }

    public String toString() {
        return "TaskEvent [id=" + this.id + ", businessProcessId=" + this.businessProcessId + ", parentBusinessProcessId=" + this.parentBusinessProcessId + ", taskId=" + this.taskId + ", eventType=" + this.eventType + ", created=" + this.created + ", userId=" + this.userId + ", domain=" + this.domain + ", workbasketKey=" + this.workbasketKey + ", porCompany=" + this.porCompany + ", porSystem=" + this.porSystem + ", porInstance=" + this.porInstance + ", porType=" + this.porType + ", porValue=" + this.porValue + ", taskClassificationKey=" + this.taskClassificationKey + ", taskClassificationCategory=" + this.taskClassificationCategory + ", attachmentClassificationKey=" + this.attachmentClassificationKey + ", oldValue=" + this.oldValue + ", newValue=" + this.newValue + ", custom1=" + this.custom1 + ", custom2=" + this.custom2 + ", custom3=" + this.custom3 + ", custom4=" + this.custom4 + ", details=" + this.details + "]";
    }
}

