/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.common.api;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import java.util.Objects;
import pro.taskana.classification.internal.jobs.ClassificationChangedJob;
import pro.taskana.task.internal.jobs.TaskCleanupJob;
import pro.taskana.task.internal.jobs.TaskRefreshJob;
import pro.taskana.workbasket.internal.jobs.WorkbasketCleanupJob;

public class ScheduledJob {
    Map<String, String> arguments;
    private Integer jobId;
    private Integer priority;
    private Instant created = Instant.now().truncatedTo(ChronoUnit.MILLIS);
    private Instant due;
    private State state = State.READY;
    private String lockedBy;
    private Instant lockExpires;
    private Type type;
    private int retryCount = 0;

    public Integer getJobId() {
        return this.jobId;
    }

    public void setJobId(Integer jobId) {
        this.jobId = jobId;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public Instant getCreated() {
        return this.created != null ? this.created.truncatedTo(ChronoUnit.MILLIS) : null;
    }

    public void setCreated(Instant created) {
        this.created = created != null ? created.truncatedTo(ChronoUnit.MILLIS) : null;
    }

    public Instant getDue() {
        return this.due != null ? this.due.truncatedTo(ChronoUnit.MILLIS) : null;
    }

    public void setDue(Instant due) {
        this.due = due != null ? due.truncatedTo(ChronoUnit.MILLIS) : null;
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        this.state = state;
    }

    public String getLockedBy() {
        return this.lockedBy;
    }

    public void setLockedBy(String lockedBy) {
        this.lockedBy = lockedBy;
    }

    public Instant getLockExpires() {
        return this.lockExpires != null ? this.lockExpires.truncatedTo(ChronoUnit.MILLIS) : null;
    }

    public void setLockExpires(Instant lockExpires) {
        this.lockExpires = lockExpires != null ? lockExpires.truncatedTo(ChronoUnit.MILLIS) : null;
    }

    public Map<String, String> getArguments() {
        return this.arguments;
    }

    public void setArguments(Map<String, String> arguments) {
        this.arguments = arguments;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.arguments, this.created, this.due, this.jobId, this.lockExpires, this.lockedBy, this.priority, this.retryCount, this.state, this.type});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ScheduledJob)) {
            return false;
        }
        ScheduledJob other = (ScheduledJob)obj;
        return Objects.equals(this.arguments, other.arguments) && Objects.equals(this.created, other.created) && Objects.equals(this.due, other.due) && Objects.equals(this.jobId, other.jobId) && Objects.equals(this.lockExpires, other.lockExpires) && Objects.equals(this.lockedBy, other.lockedBy) && Objects.equals(this.priority, other.priority) && this.retryCount == other.retryCount && this.state == other.state && this.type == other.type;
    }

    public String toString() {
        return "ScheduledJob [jobId=" + this.jobId + ", priority=" + this.priority + ", created=" + this.created + ", due=" + this.due + ", state=" + (Object)((Object)this.state) + ", lockedBy=" + this.lockedBy + ", lockExpires=" + this.lockExpires + ", type=" + (Object)((Object)this.type) + ", retryCount=" + this.retryCount + ", arguments=" + this.arguments + "]";
    }

    public static enum Type {
        CLASSIFICATIONCHANGEDJOB(ClassificationChangedJob.class.getName()),
        UPDATETASKSJOB(TaskRefreshJob.class.getName()),
        TASKCLEANUPJOB(TaskCleanupJob.class.getName()),
        WORKBASKETCLEANUPJOB(WorkbasketCleanupJob.class.getName()),
        HISTORYCLEANUPJOB("pro.taskana.simplehistory.impl.jobs.HistoryCleanupJob");

        private String clazz;

        private Type(String clazz) {
            this.clazz = clazz;
        }

        public String getClazz() {
            return this.clazz;
        }
    }

    public static enum State {
        READY,
        FAILED;

    }
}

