/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.spi.history.api.events.classification;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import pro.taskana.classification.api.ClassificationCustomField;
import pro.taskana.classification.api.models.ClassificationSummary;
import pro.taskana.common.api.exceptions.SystemException;

public class ClassificationHistoryEvent {
    protected String id;
    protected String eventType;
    protected Instant created;
    protected String userId;
    protected String classificationId;
    protected String applicationEntryPoint;
    protected String category;
    protected String domain;
    protected String key;
    protected String name;
    protected String parentId;
    protected String parentKey;
    protected int priority;
    protected String serviceLevel;
    protected String type;
    protected String custom1;
    protected String custom2;
    protected String custom3;
    protected String custom4;
    protected String custom5;
    protected String custom6;
    protected String custom7;
    protected String custom8;
    protected String details;

    public ClassificationHistoryEvent() {
    }

    public ClassificationHistoryEvent(String id, ClassificationSummary classification, String userId, String details) {
        this.id = id;
        this.userId = userId;
        this.classificationId = classification.getId();
        this.applicationEntryPoint = classification.getApplicationEntryPoint();
        this.category = classification.getCategory();
        this.domain = classification.getDomain();
        this.key = classification.getKey();
        this.name = classification.getName();
        this.parentId = classification.getParentId();
        this.parentKey = classification.getParentKey();
        this.priority = classification.getPriority();
        this.serviceLevel = classification.getServiceLevel();
        this.type = classification.getType();
        this.custom1 = classification.getCustomAttribute(ClassificationCustomField.CUSTOM_1);
        this.custom2 = classification.getCustomAttribute(ClassificationCustomField.CUSTOM_2);
        this.custom3 = classification.getCustomAttribute(ClassificationCustomField.CUSTOM_3);
        this.custom4 = classification.getCustomAttribute(ClassificationCustomField.CUSTOM_4);
        this.custom5 = classification.getCustomAttribute(ClassificationCustomField.CUSTOM_5);
        this.custom6 = classification.getCustomAttribute(ClassificationCustomField.CUSTOM_6);
        this.custom7 = classification.getCustomAttribute(ClassificationCustomField.CUSTOM_7);
        this.custom8 = classification.getCustomAttribute(ClassificationCustomField.CUSTOM_8);
        this.details = details;
    }

    public void setCustomAttribute(ClassificationCustomField customField, String value) {
        switch (customField) {
            case CUSTOM_1: {
                this.custom1 = value;
                break;
            }
            case CUSTOM_2: {
                this.custom2 = value;
                break;
            }
            case CUSTOM_3: {
                this.custom3 = value;
                break;
            }
            case CUSTOM_4: {
                this.custom4 = value;
                break;
            }
            case CUSTOM_5: {
                this.custom5 = value;
                break;
            }
            case CUSTOM_6: {
                this.custom6 = value;
                break;
            }
            case CUSTOM_7: {
                this.custom7 = value;
                break;
            }
            case CUSTOM_8: {
                this.custom8 = value;
                break;
            }
            default: {
                throw new SystemException("Unknown customField '" + (Object)((Object)customField) + "'");
            }
        }
    }

    public String getCustomAttribute(ClassificationCustomField customField) {
        switch (customField) {
            case CUSTOM_1: {
                return this.custom1;
            }
            case CUSTOM_2: {
                return this.custom2;
            }
            case CUSTOM_3: {
                return this.custom3;
            }
            case CUSTOM_4: {
                return this.custom4;
            }
            case CUSTOM_5: {
                return this.custom5;
            }
            case CUSTOM_6: {
                return this.custom6;
            }
            case CUSTOM_7: {
                return this.custom7;
            }
            case CUSTOM_8: {
                return this.custom8;
            }
        }
        throw new SystemException("Unknown customField '" + (Object)((Object)customField) + "'");
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getEventType() {
        return this.eventType;
    }

    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    public Instant getCreated() {
        return this.created != null ? this.created.truncatedTo(ChronoUnit.MILLIS) : null;
    }

    public void setCreated(Instant created) {
        this.created = created != null ? created.truncatedTo(ChronoUnit.MILLIS) : null;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getClassificationId() {
        return this.classificationId;
    }

    public void setClassificationId(String classificationId) {
        this.classificationId = classificationId;
    }

    public String getApplicationEntryPoint() {
        return this.applicationEntryPoint;
    }

    public void setApplicationEntryPoint(String applicationEntryPoint) {
        this.applicationEntryPoint = applicationEntryPoint;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public String getParentKey() {
        return this.parentKey;
    }

    public void setParentKey(String parentKey) {
        this.parentKey = parentKey;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public String getServiceLevel() {
        return this.serviceLevel;
    }

    public void setServiceLevel(String serviceLevel) {
        this.serviceLevel = serviceLevel;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getDetails() {
        return this.details;
    }

    public void setDetails(String details) {
        this.details = details;
    }

    public int hashCode() {
        return Objects.hash(this.getId(), this.getEventType(), this.getCreated(), this.getUserId(), this.getClassificationId(), this.getApplicationEntryPoint(), this.getCategory(), this.getDomain(), this.getKey(), this.getName(), this.getParentId(), this.getParentKey(), this.getPriority(), this.getServiceLevel(), this.getType(), this.custom1, this.custom2, this.custom3, this.custom4, this.custom5, this.custom6, this.custom7, this.custom8, this.getDetails());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ClassificationHistoryEvent)) {
            return false;
        }
        ClassificationHistoryEvent other = (ClassificationHistoryEvent)obj;
        return this.getPriority() == other.getPriority() && Objects.equals(this.getId(), other.getId()) && Objects.equals(this.getEventType(), other.getEventType()) && Objects.equals(this.getCreated(), other.getCreated()) && Objects.equals(this.getUserId(), other.getUserId()) && Objects.equals(this.getClassificationId(), other.getClassificationId()) && Objects.equals(this.getApplicationEntryPoint(), other.getApplicationEntryPoint()) && Objects.equals(this.getCategory(), other.getCategory()) && Objects.equals(this.getDomain(), other.getDomain()) && Objects.equals(this.getKey(), other.getKey()) && Objects.equals(this.getName(), other.getName()) && Objects.equals(this.getParentId(), other.getParentId()) && Objects.equals(this.getParentKey(), other.getParentKey()) && Objects.equals(this.getServiceLevel(), other.getServiceLevel()) && Objects.equals(this.getType(), other.getType()) && Objects.equals(this.custom1, other.custom1) && Objects.equals(this.custom2, other.custom2) && Objects.equals(this.custom3, other.custom3) && Objects.equals(this.custom4, other.custom4) && Objects.equals(this.custom5, other.custom5) && Objects.equals(this.custom6, other.custom6) && Objects.equals(this.custom7, other.custom7) && Objects.equals(this.custom8, other.custom8) && Objects.equals(this.getDetails(), other.getDetails());
    }

    public String toString() {
        return "ClassificationHistoryEvent [id=" + this.id + ", eventType=" + this.eventType + ", created=" + this.created + ", userId=" + this.userId + ", classificationId=" + this.classificationId + ", applicationEntryPoint=" + this.applicationEntryPoint + ", category=" + this.category + ", domain=" + this.domain + ", key=" + this.key + ", name=" + this.name + ", parentId=" + this.parentId + ", parentKey=" + this.parentKey + ", priority=" + this.priority + ", serviceLevel=" + this.serviceLevel + ", type=" + this.type + ", custom1=" + this.custom1 + ", custom2=" + this.custom2 + ", custom3=" + this.custom3 + ", custom4=" + this.custom4 + ", custom5=" + this.custom5 + ", custom6=" + this.custom6 + ", custom7=" + this.custom7 + ", custom8=" + this.custom8 + ", details=" + this.details + "]";
    }
}

