/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.task.internal;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ibatis.exceptions.PersistenceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.classification.api.ClassificationService;
import pro.taskana.classification.api.exceptions.ClassificationNotFoundException;
import pro.taskana.classification.api.models.Classification;
import pro.taskana.classification.api.models.ClassificationSummary;
import pro.taskana.common.api.BulkOperationResults;
import pro.taskana.common.api.TaskanaRole;
import pro.taskana.common.api.exceptions.ConcurrencyException;
import pro.taskana.common.api.exceptions.InvalidArgumentException;
import pro.taskana.common.api.exceptions.NotAuthorizedException;
import pro.taskana.common.api.exceptions.SystemException;
import pro.taskana.common.api.exceptions.TaskanaException;
import pro.taskana.common.internal.InternalTaskanaEngine;
import pro.taskana.common.internal.util.CheckedConsumer;
import pro.taskana.common.internal.util.CollectionUtil;
import pro.taskana.common.internal.util.IdGenerator;
import pro.taskana.common.internal.util.ObjectAttributeChangeDetector;
import pro.taskana.common.internal.util.Pair;
import pro.taskana.spi.history.api.events.task.TaskCancelledEvent;
import pro.taskana.spi.history.api.events.task.TaskClaimCancelledEvent;
import pro.taskana.spi.history.api.events.task.TaskClaimedEvent;
import pro.taskana.spi.history.api.events.task.TaskCompletedEvent;
import pro.taskana.spi.history.api.events.task.TaskCreatedEvent;
import pro.taskana.spi.history.api.events.task.TaskTerminatedEvent;
import pro.taskana.spi.history.api.events.task.TaskUpdatedEvent;
import pro.taskana.spi.history.internal.HistoryEventManager;
import pro.taskana.spi.task.internal.CreateTaskPreprocessorManager;
import pro.taskana.task.api.CallbackState;
import pro.taskana.task.api.TaskCustomField;
import pro.taskana.task.api.TaskQuery;
import pro.taskana.task.api.TaskService;
import pro.taskana.task.api.TaskState;
import pro.taskana.task.api.exceptions.AttachmentPersistenceException;
import pro.taskana.task.api.exceptions.InvalidOwnerException;
import pro.taskana.task.api.exceptions.InvalidStateException;
import pro.taskana.task.api.exceptions.TaskAlreadyExistException;
import pro.taskana.task.api.exceptions.TaskCommentNotFoundException;
import pro.taskana.task.api.exceptions.TaskNotFoundException;
import pro.taskana.task.api.exceptions.UpdateFailedException;
import pro.taskana.task.api.models.Attachment;
import pro.taskana.task.api.models.ObjectReference;
import pro.taskana.task.api.models.Task;
import pro.taskana.task.api.models.TaskComment;
import pro.taskana.task.api.models.TaskSummary;
import pro.taskana.task.internal.AttachmentHandler;
import pro.taskana.task.internal.AttachmentMapper;
import pro.taskana.task.internal.ServiceLevelHandler;
import pro.taskana.task.internal.TaskCommentMapper;
import pro.taskana.task.internal.TaskCommentServiceImpl;
import pro.taskana.task.internal.TaskCustomPropertySelector;
import pro.taskana.task.internal.TaskMapper;
import pro.taskana.task.internal.TaskQueryImpl;
import pro.taskana.task.internal.TaskTransferrer;
import pro.taskana.task.internal.models.AttachmentImpl;
import pro.taskana.task.internal.models.AttachmentSummaryImpl;
import pro.taskana.task.internal.models.MinimalTaskSummary;
import pro.taskana.task.internal.models.TaskImpl;
import pro.taskana.task.internal.models.TaskSummaryImpl;
import pro.taskana.workbasket.api.WorkbasketPermission;
import pro.taskana.workbasket.api.WorkbasketService;
import pro.taskana.workbasket.api.exceptions.WorkbasketNotFoundException;
import pro.taskana.workbasket.api.models.Workbasket;
import pro.taskana.workbasket.api.models.WorkbasketSummary;
import pro.taskana.workbasket.internal.WorkbasketQueryImpl;
import pro.taskana.workbasket.internal.models.WorkbasketSummaryImpl;

public class TaskServiceImpl
implements TaskService {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskServiceImpl.class);
    private final InternalTaskanaEngine taskanaEngine;
    private final WorkbasketService workbasketService;
    private final ClassificationService classificationService;
    private final TaskMapper taskMapper;
    private final TaskTransferrer taskTransferrer;
    private final TaskCommentServiceImpl taskCommentService;
    private final ServiceLevelHandler serviceLevelHandler;
    private final AttachmentHandler attachmentHandler;
    private final AttachmentMapper attachmentMapper;
    private final HistoryEventManager historyEventManager;
    private final CreateTaskPreprocessorManager createTaskPreprocessorManager;

    public TaskServiceImpl(InternalTaskanaEngine taskanaEngine, TaskMapper taskMapper, TaskCommentMapper taskCommentMapper, AttachmentMapper attachmentMapper) {
        this.taskanaEngine = taskanaEngine;
        this.taskMapper = taskMapper;
        this.workbasketService = taskanaEngine.getEngine().getWorkbasketService();
        this.attachmentMapper = attachmentMapper;
        this.classificationService = taskanaEngine.getEngine().getClassificationService();
        this.historyEventManager = taskanaEngine.getHistoryEventManager();
        this.createTaskPreprocessorManager = taskanaEngine.getCreateTaskPreprocessorManager();
        this.taskTransferrer = new TaskTransferrer(taskanaEngine, taskMapper, this);
        this.taskCommentService = new TaskCommentServiceImpl(taskanaEngine, taskCommentMapper, this);
        this.serviceLevelHandler = new ServiceLevelHandler(taskanaEngine, taskMapper, attachmentMapper);
        this.attachmentHandler = new AttachmentHandler(attachmentMapper, this.classificationService);
    }

    @Override
    public Task claim(String taskId) throws TaskNotFoundException, InvalidStateException, InvalidOwnerException, NotAuthorizedException {
        return this.claim(taskId, false);
    }

    @Override
    public Task forceClaim(String taskId) throws TaskNotFoundException, InvalidStateException, InvalidOwnerException, NotAuthorizedException {
        return this.claim(taskId, true);
    }

    @Override
    public Task cancelClaim(String taskId) throws TaskNotFoundException, InvalidStateException, InvalidOwnerException, NotAuthorizedException {
        return this.cancelClaim(taskId, false);
    }

    @Override
    public Task forceCancelClaim(String taskId) throws TaskNotFoundException, InvalidStateException, InvalidOwnerException, NotAuthorizedException {
        return this.cancelClaim(taskId, true);
    }

    @Override
    public Task completeTask(String taskId) throws TaskNotFoundException, InvalidOwnerException, InvalidStateException, NotAuthorizedException {
        return this.completeTask(taskId, false);
    }

    @Override
    public Task forceCompleteTask(String taskId) throws TaskNotFoundException, InvalidOwnerException, InvalidStateException, NotAuthorizedException {
        return this.completeTask(taskId, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Task createTask(Task taskToCreate) throws NotAuthorizedException, WorkbasketNotFoundException, ClassificationNotFoundException, TaskAlreadyExistException, InvalidArgumentException {
        LOGGER.debug("entry to createTask(task = {})", (Object)taskToCreate);
        if (CreateTaskPreprocessorManager.isCreateTaskPreprocessorEnabled()) {
            taskToCreate = this.createTaskPreprocessorManager.processTaskBeforeCreation(taskToCreate);
        }
        TaskImpl task = (TaskImpl)taskToCreate;
        try {
            Workbasket workbasket;
            this.taskanaEngine.openConnection();
            if (task.getId() != null && !task.getId().equals("")) {
                throw new TaskAlreadyExistException(task.getId());
            }
            LOGGER.debug("Task {} cannot be found, so it can be created.", (Object)task.getId());
            if (task.getWorkbasketSummary().getId() != null) {
                workbasket = this.workbasketService.getWorkbasket(task.getWorkbasketSummary().getId());
            } else if (task.getWorkbasketKey() != null) {
                workbasket = this.workbasketService.getWorkbasket(task.getWorkbasketKey(), task.getDomain());
            } else {
                String workbasketId = this.taskanaEngine.getTaskRoutingManager().determineWorkbasketId(task);
                if (workbasketId != null) {
                    workbasket = this.workbasketService.getWorkbasket(workbasketId);
                    task.setWorkbasketSummary(workbasket.asSummary());
                } else {
                    throw new InvalidArgumentException("Cannot create a task outside a workbasket");
                }
            }
            if (workbasket.isMarkedForDeletion()) {
                throw new WorkbasketNotFoundException(workbasket.getId(), "The workbasket " + workbasket.getId() + " was marked for deletion");
            }
            task.setWorkbasketSummary(workbasket.asSummary());
            task.setDomain(workbasket.getDomain());
            this.workbasketService.checkAuthorization(task.getWorkbasketSummary().getId(), WorkbasketPermission.APPEND);
            String classificationKey = task.getClassificationKey();
            if (classificationKey == null || classificationKey.length() == 0) {
                throw new InvalidArgumentException("classificationKey of task must not be empty");
            }
            Classification classification = this.classificationService.getClassification(classificationKey, workbasket.getDomain());
            task.setClassificationSummary(classification.asSummary());
            ObjectReference.validate(task.getPrimaryObjRef(), "primary ObjectReference", "Task");
            this.standardSettings(task, classification);
            this.setCallbackStateOnTaskCreation(task);
            try {
                this.taskMapper.insert(task);
                LOGGER.debug("Method createTask() created Task '{}'.", (Object)task.getId());
                if (HistoryEventManager.isHistoryEnabled()) {
                    String details = ObjectAttributeChangeDetector.determineChangesInAttributes((Object)this.newTask(), (Object)task);
                    this.historyEventManager.createEvent(new TaskCreatedEvent(IdGenerator.generateWithPrefix((String)"THI"), task, this.taskanaEngine.getEngine().getCurrentUserContext().getUserid(), details));
                }
            }
            catch (PersistenceException e) {
                String msg;
                String string = msg = e.getMessage() != null ? e.getMessage().toLowerCase() : null;
                if (msg != null && (msg.contains("violation") || msg.contains("violates") || msg.contains("verletzt")) && msg.contains("external_id")) {
                    throw new TaskAlreadyExistException("Task with external id " + task.getExternalId() + " already exists");
                }
                throw e;
            }
            TaskImpl taskImpl = task;
            return taskImpl;
        }
        finally {
            this.taskanaEngine.returnConnection();
            LOGGER.debug("exit from createTask(task = {})", (Object)task);
        }
    }

    @Override
    public Task getTask(String id) throws NotAuthorizedException, TaskNotFoundException {
        LOGGER.debug("entry to getTaskById(id = {})", (Object)id);
        TaskImpl resultTask = null;
        try {
            this.taskanaEngine.openConnection();
            resultTask = this.taskMapper.findById(id);
            if (resultTask != null) {
                WorkbasketQueryImpl query = (WorkbasketQueryImpl)this.workbasketService.createWorkbasketQuery();
                query.setUsedToAugmentTasks(true);
                String workbasketId = resultTask.getWorkbasketSummary().getId();
                List workbaskets = query.idIn(workbasketId).list();
                if (workbaskets.isEmpty()) {
                    String currentUser = this.taskanaEngine.getEngine().getCurrentUserContext().getUserid();
                    throw new NotAuthorizedException("The current user " + currentUser + " has no read permission for workbasket " + workbasketId, this.taskanaEngine.getEngine().getCurrentUserContext().getUserid());
                }
                resultTask.setWorkbasketSummary((WorkbasketSummary)workbaskets.get(0));
                List<AttachmentImpl> attachmentImpls = this.attachmentMapper.findAttachmentsByTaskId(resultTask.getId());
                if (attachmentImpls == null) {
                    attachmentImpls = new ArrayList<AttachmentImpl>();
                }
                List<ClassificationSummary> classifications = this.findClassificationForTaskImplAndAttachments(resultTask, attachmentImpls);
                List<Attachment> attachments = this.addClassificationSummariesToAttachments(attachmentImpls, classifications);
                resultTask.setAttachments(attachments);
                String classificationId = resultTask.getClassificationSummary().getId();
                ClassificationSummary classification = classifications.stream().filter(c -> c.getId().equals(classificationId)).findFirst().orElse(null);
                if (classification == null) {
                    throw new SystemException("Could not find a Classification for task " + resultTask.getId());
                }
                resultTask.setClassificationSummary(classification);
                TaskImpl taskImpl = resultTask;
                return taskImpl;
            }
            throw new TaskNotFoundException(id, String.format("Task with id %s was not found.", id));
        }
        finally {
            this.taskanaEngine.returnConnection();
            LOGGER.debug("exit from getTaskById(). Returning result {} ", (Object)resultTask);
        }
    }

    @Override
    public Task transfer(String taskId, String destinationWorkbasketId, boolean setTransferFlag) throws TaskNotFoundException, WorkbasketNotFoundException, NotAuthorizedException, InvalidStateException {
        return this.taskTransferrer.transfer(taskId, destinationWorkbasketId, setTransferFlag);
    }

    @Override
    public Task transfer(String taskId, String workbasketKey, String domain, boolean setTransferFlag) throws TaskNotFoundException, WorkbasketNotFoundException, NotAuthorizedException, InvalidStateException {
        return this.taskTransferrer.transfer(taskId, workbasketKey, domain, setTransferFlag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Task setTaskRead(String taskId, boolean isRead) throws TaskNotFoundException, NotAuthorizedException {
        LOGGER.debug("entry to setTaskRead(taskId = {}, isRead = {})", (Object)taskId, (Object)isRead);
        TaskImpl task = null;
        try {
            this.taskanaEngine.openConnection();
            task = (TaskImpl)this.getTask(taskId);
            task.setRead(isRead);
            task.setModified(Instant.now());
            this.taskMapper.update(task);
            LOGGER.debug("Method setTaskRead() set read property of Task '{}' to {} ", (Object)task, (Object)isRead);
            TaskImpl taskImpl = task;
            return taskImpl;
        }
        finally {
            this.taskanaEngine.returnConnection();
            LOGGER.debug("exit from setTaskRead(taskId, isRead). Returning result {} ", (Object)task);
        }
    }

    @Override
    public TaskQuery createTaskQuery() {
        return new TaskQueryImpl(this.taskanaEngine);
    }

    @Override
    public Task newTask() {
        return this.newTask(null);
    }

    @Override
    public Task newTask(String workbasketId) {
        TaskImpl task = new TaskImpl();
        WorkbasketSummaryImpl wb = new WorkbasketSummaryImpl();
        wb.setId(workbasketId);
        task.setWorkbasketSummary(wb);
        task.setCallbackState(CallbackState.NONE);
        return task;
    }

    @Override
    public Task newTask(String workbasketKey, String domain) {
        LOGGER.debug("entry to newTask(workbasketKey = {}, domain = {})", (Object)workbasketKey, (Object)domain);
        TaskImpl task = new TaskImpl();
        WorkbasketSummaryImpl wb = new WorkbasketSummaryImpl();
        wb.setKey(workbasketKey);
        wb.setDomain(domain);
        task.setWorkbasketSummary(wb);
        LOGGER.debug("exit from newTask(), returning {}", (Object)task);
        return task;
    }

    @Override
    public TaskComment newTaskComment(String taskId) {
        return this.taskCommentService.newTaskComment(taskId);
    }

    @Override
    public Attachment newAttachment() {
        return new AttachmentImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Task updateTask(Task task) throws InvalidArgumentException, TaskNotFoundException, ConcurrencyException, NotAuthorizedException, AttachmentPersistenceException, InvalidStateException, ClassificationNotFoundException {
        String userId = this.taskanaEngine.getEngine().getCurrentUserContext().getUserid();
        LOGGER.debug("entry to updateTask(task = {}, userId = {})", (Object)task, (Object)userId);
        TaskImpl newTaskImpl = (TaskImpl)task;
        try {
            this.taskanaEngine.openConnection();
            TaskImpl oldTaskImpl = (TaskImpl)this.getTask(newTaskImpl.getId());
            this.checkConcurrencyAndSetModified(newTaskImpl, oldTaskImpl);
            this.attachmentHandler.insertAndDeleteAttachmentsOnTaskUpdate(newTaskImpl, oldTaskImpl);
            ObjectReference.validate(newTaskImpl.getPrimaryObjRef(), "primary ObjectReference", "Task");
            this.standardUpdateActions(oldTaskImpl, newTaskImpl);
            this.taskMapper.update(newTaskImpl);
            LOGGER.debug("Method updateTask() updated task '{}' for user '{}'.", (Object)task.getId(), (Object)userId);
            if (HistoryEventManager.isHistoryEnabled()) {
                String changeDetails = ObjectAttributeChangeDetector.determineChangesInAttributes((Object)oldTaskImpl, (Object)newTaskImpl);
                this.historyEventManager.createEvent(new TaskUpdatedEvent(IdGenerator.generateWithPrefix((String)"THI"), task, this.taskanaEngine.getEngine().getCurrentUserContext().getUserid(), changeDetails));
            }
        }
        finally {
            this.taskanaEngine.returnConnection();
            LOGGER.debug("exit from claim()");
        }
        return task;
    }

    @Override
    public BulkOperationResults<String, TaskanaException> transferTasks(String destinationWorkbasketId, List<String> taskIds, boolean setTransferFlag) throws NotAuthorizedException, InvalidArgumentException, WorkbasketNotFoundException {
        return this.taskTransferrer.transferTasks(destinationWorkbasketId, taskIds, setTransferFlag);
    }

    @Override
    public BulkOperationResults<String, TaskanaException> transferTasks(String destinationWorkbasketKey, String destinationWorkbasketDomain, List<String> taskIds, boolean setTransferFlag) throws NotAuthorizedException, InvalidArgumentException, WorkbasketNotFoundException {
        return this.taskTransferrer.transferTasks(destinationWorkbasketKey, destinationWorkbasketDomain, taskIds, setTransferFlag);
    }

    @Override
    public void deleteTask(String taskId) throws TaskNotFoundException, InvalidStateException, NotAuthorizedException {
        this.deleteTask(taskId, false);
    }

    @Override
    public void forceDeleteTask(String taskId) throws TaskNotFoundException, InvalidStateException, NotAuthorizedException {
        this.deleteTask(taskId, true);
    }

    @Override
    public Task selectAndClaim(TaskQuery taskQuery) throws NotAuthorizedException, InvalidOwnerException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("entry to selectAndClaim(taskQuery = {})", (Object)taskQuery);
        }
        try {
            this.taskanaEngine.openConnection();
            ((TaskQueryImpl)taskQuery).selectAndClaimEquals(true);
            TaskSummary taskSummary = (TaskSummary)taskQuery.single();
            if (taskSummary == null) {
                throw new SystemException("No tasks matched the specified filter and sorting options, task query returned nothing!");
            }
            Task task = this.claim(taskSummary.getId());
            return task;
        }
        catch (InvalidStateException | TaskNotFoundException e) {
            throw new SystemException("Caught exception ", (Throwable)e);
        }
        finally {
            LOGGER.debug("exit from selectAndClaim()");
            this.taskanaEngine.returnConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BulkOperationResults<String, TaskanaException> deleteTasks(List<String> taskIds) throws InvalidArgumentException, NotAuthorizedException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("entry to deleteTasks(tasks = {})", taskIds);
        }
        this.taskanaEngine.getEngine().checkRoleMembership(TaskanaRole.ADMIN);
        try {
            this.taskanaEngine.openConnection();
            if (taskIds == null) {
                throw new InvalidArgumentException("List of TaskIds must not be null.");
            }
            taskIds = new ArrayList<String>(taskIds);
            BulkOperationResults bulkLog = new BulkOperationResults();
            if (taskIds.isEmpty()) {
                BulkOperationResults bulkOperationResults = bulkLog;
                return bulkOperationResults;
            }
            List<MinimalTaskSummary> taskSummaries = this.taskMapper.findExistingTasks(taskIds, null);
            Iterator<String> taskIdIterator = taskIds.iterator();
            while (taskIdIterator.hasNext()) {
                this.removeSingleTaskForTaskDeletionById((BulkOperationResults<String, TaskanaException>)bulkLog, taskSummaries, taskIdIterator);
            }
            if (!taskIds.isEmpty()) {
                this.attachmentMapper.deleteMultipleByTaskIds(taskIds);
                this.taskMapper.deleteMultiple(taskIds);
                if (this.taskanaEngine.getEngine().isHistoryEnabled() && this.taskanaEngine.getEngine().getConfiguration().isDeleteHistoryOnTaskDeletionEnabled()) {
                    this.historyEventManager.deleteEvents(taskIds);
                }
            }
            BulkOperationResults bulkOperationResults = bulkLog;
            return bulkOperationResults;
        }
        finally {
            LOGGER.debug("exit from deleteTasks()");
            this.taskanaEngine.returnConnection();
        }
    }

    @Override
    public BulkOperationResults<String, TaskanaException> completeTasks(List<String> taskIds) throws InvalidArgumentException {
        return this.completeTasks(taskIds, false);
    }

    @Override
    public BulkOperationResults<String, TaskanaException> forceCompleteTasks(List<String> taskIds) throws InvalidArgumentException {
        return this.completeTasks(taskIds, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> updateTasks(ObjectReference selectionCriteria, Map<TaskCustomField, String> customFieldsToUpdate) throws InvalidArgumentException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("entry to updateTasks(selectionCriteria = {}, customFieldsToUpdate = {})", (Object)selectionCriteria, customFieldsToUpdate);
        }
        ObjectReference.validate(selectionCriteria, "ObjectReference", "updateTasks call");
        this.validateCustomFields(customFieldsToUpdate);
        TaskCustomPropertySelector fieldSelector = new TaskCustomPropertySelector();
        TaskImpl updated = this.initUpdatedTask(customFieldsToUpdate, fieldSelector);
        try {
            this.taskanaEngine.openConnection();
            List<TaskSummary> taskSummaries = this.getTasksToChange(selectionCriteria);
            List<String> changedTasks = new ArrayList<String>();
            if (!taskSummaries.isEmpty()) {
                changedTasks = taskSummaries.stream().map(TaskSummary::getId).collect(Collectors.toList());
                this.taskMapper.updateTasks(changedTasks, updated, fieldSelector);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("updateTasks() updated the following tasks: {} ", changedTasks);
                }
            } else {
                LOGGER.debug("updateTasks() found no tasks for update ");
            }
            ArrayList<String> arrayList = changedTasks;
            return arrayList;
        }
        finally {
            LOGGER.debug("exit from updateTasks().");
            this.taskanaEngine.returnConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> updateTasks(List<String> taskIds, Map<TaskCustomField, String> customFieldsToUpdate) throws InvalidArgumentException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("entry to updateTasks(taskIds = {}, customFieldsToUpdate = {})", taskIds, customFieldsToUpdate);
        }
        this.validateCustomFields(customFieldsToUpdate);
        TaskCustomPropertySelector fieldSelector = new TaskCustomPropertySelector();
        TaskImpl updatedTask = this.initUpdatedTask(customFieldsToUpdate, fieldSelector);
        try {
            this.taskanaEngine.openConnection();
            List<TaskSummary> taskSummaries = this.getTasksToChange(taskIds);
            List<String> changedTasks = new ArrayList<String>();
            if (!taskSummaries.isEmpty()) {
                changedTasks = taskSummaries.stream().map(TaskSummary::getId).collect(Collectors.toList());
                this.taskMapper.updateTasks(changedTasks, updatedTask, fieldSelector);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("updateTasks() updated the following tasks: {} ", changedTasks);
                }
            } else {
                LOGGER.debug("updateTasks() found no tasks for update ");
            }
            ArrayList<String> arrayList = changedTasks;
            return arrayList;
        }
        finally {
            LOGGER.debug("exit from updateTasks().");
            this.taskanaEngine.returnConnection();
        }
    }

    @Override
    public TaskComment createTaskComment(TaskComment taskComment) throws NotAuthorizedException, TaskNotFoundException, InvalidArgumentException {
        return this.taskCommentService.createTaskComment(taskComment);
    }

    @Override
    public TaskComment updateTaskComment(TaskComment taskComment) throws NotAuthorizedException, ConcurrencyException, TaskCommentNotFoundException, TaskNotFoundException, InvalidArgumentException {
        return this.taskCommentService.updateTaskComment(taskComment);
    }

    @Override
    public void deleteTaskComment(String taskCommentId) throws NotAuthorizedException, TaskCommentNotFoundException, TaskNotFoundException, InvalidArgumentException {
        this.taskCommentService.deleteTaskComment(taskCommentId);
    }

    @Override
    public TaskComment getTaskComment(String taskCommentid) throws TaskCommentNotFoundException, NotAuthorizedException, TaskNotFoundException, InvalidArgumentException {
        return this.taskCommentService.getTaskComment(taskCommentid);
    }

    @Override
    public List<TaskComment> getTaskComments(String taskId) throws NotAuthorizedException, TaskNotFoundException {
        return this.taskCommentService.getTaskComments(taskId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BulkOperationResults<String, TaskanaException> setCallbackStateForTasks(List<String> externalIds, CallbackState state) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("entry to setCallbackStateForTasks(externalIds = {})", externalIds);
        }
        try {
            this.taskanaEngine.openConnection();
            BulkOperationResults bulkLog = new BulkOperationResults();
            if (externalIds == null || externalIds.isEmpty()) {
                BulkOperationResults bulkOperationResults = bulkLog;
                return bulkOperationResults;
            }
            List<MinimalTaskSummary> taskSummaries = this.taskMapper.findExistingTasks(null, externalIds);
            Iterator<String> taskIdIterator = new ArrayList<String>(externalIds).iterator();
            while (taskIdIterator.hasNext()) {
                this.removeSingleTaskForCallbackStateByExternalId((BulkOperationResults<String, TaskanaException>)bulkLog, taskSummaries, taskIdIterator, state);
            }
            if (!externalIds.isEmpty()) {
                this.taskMapper.setCallbackStateMultiple(externalIds, state);
            }
            BulkOperationResults bulkOperationResults = bulkLog;
            return bulkOperationResults;
        }
        finally {
            LOGGER.debug("exit from setCallbckStateForTasks()");
            this.taskanaEngine.returnConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BulkOperationResults<String, TaskanaException> setOwnerOfTasks(String owner, List<String> argTaskIds) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("entry to setOwnerOfTasks(owner = {}, tasks = {})", (Object)owner, argTaskIds);
        }
        BulkOperationResults bulkLog = new BulkOperationResults();
        if (argTaskIds == null || argTaskIds.isEmpty()) {
            return bulkLog;
        }
        List<String> taskIds = argTaskIds.stream().distinct().collect(Collectors.toList());
        int requestSize = taskIds.size();
        try {
            int numberOfAffectedTasks;
            this.taskanaEngine.openConnection();
            Pair<List<MinimalTaskSummary>, ServiceLevelHandler.BulkLog> resultsPair = this.getMinimalTaskSummaries(taskIds);
            List<MinimalTaskSummary> existingMinimalTaskSummaries = (List<MinimalTaskSummary>)resultsPair.getLeft();
            taskIds = existingMinimalTaskSummaries.stream().map(MinimalTaskSummary::getTaskId).collect(Collectors.toList());
            bulkLog.addAllErrors((BulkOperationResults)resultsPair.getRight());
            if (!taskIds.isEmpty() && (numberOfAffectedTasks = this.taskMapper.setOwnerOfTasks(owner, taskIds, Instant.now())) != taskIds.size()) {
                existingMinimalTaskSummaries = this.taskMapper.findExistingTasks(taskIds, null);
                bulkLog.addAllErrors(this.addExceptionsForTasksWhoseOwnerWasNotSet(owner, existingMinimalTaskSummaries));
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Received the Request to set owner on {} tasks, actually modified tasks = {}, could not set owner on {} tasks.", new Object[]{requestSize, numberOfAffectedTasks, bulkLog.getFailedIds().size()});
                }
            }
            BulkOperationResults bulkOperationResults = bulkLog;
            return bulkOperationResults;
        }
        finally {
            LOGGER.debug("exit from setOwnerOfTasks()");
            this.taskanaEngine.returnConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BulkOperationResults<String, TaskanaException> setPlannedPropertyOfTasks(Instant planned, List<String> argTaskIds) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("entry to setPlannedPropertyOfTasks(planned = {}, tasks = {})", (Object)planned, argTaskIds);
        }
        ServiceLevelHandler.BulkLog bulkLog = new ServiceLevelHandler.BulkLog();
        if (argTaskIds == null || argTaskIds.isEmpty()) {
            return bulkLog;
        }
        try {
            this.taskanaEngine.openConnection();
            Pair<List<MinimalTaskSummary>, ServiceLevelHandler.BulkLog> resultsPair = this.getMinimalTaskSummaries(argTaskIds);
            List tasksToModify = (List)resultsPair.getLeft();
            bulkLog.addAllErrors((BulkOperationResults)resultsPair.getRight());
            ServiceLevelHandler.BulkLog errorsFromProcessing = this.serviceLevelHandler.setPlannedPropertyOfTasksImpl(planned, tasksToModify);
            bulkLog.addAllErrors(errorsFromProcessing);
            ServiceLevelHandler.BulkLog bulkLog2 = bulkLog;
            return bulkLog2;
        }
        finally {
            LOGGER.debug("exit from setPlannedPropertyOfTasks");
            this.taskanaEngine.returnConnection();
        }
    }

    @Override
    public Task cancelTask(String taskId) throws TaskNotFoundException, InvalidStateException, NotAuthorizedException {
        TaskImpl cancelledTask;
        LOGGER.debug("entry to cancelTask(task = {})", (Object)taskId);
        try {
            this.taskanaEngine.openConnection();
            cancelledTask = this.terminateCancelCommonActions(taskId, TaskState.CANCELLED);
            if (HistoryEventManager.isHistoryEnabled()) {
                this.historyEventManager.createEvent(new TaskCancelledEvent(IdGenerator.generateWithPrefix((String)"THI"), cancelledTask, this.taskanaEngine.getEngine().getCurrentUserContext().getUserid()));
            }
        }
        finally {
            this.taskanaEngine.returnConnection();
            LOGGER.debug("exit from cancelTask()");
        }
        return cancelledTask;
    }

    @Override
    public Task terminateTask(String taskId) throws TaskNotFoundException, InvalidStateException, NotAuthorizedException {
        TaskImpl terminatedTask;
        LOGGER.debug("entry to terminateTask(task = {})", (Object)taskId);
        this.taskanaEngine.getEngine().checkRoleMembership(TaskanaRole.ADMIN, TaskanaRole.TASK_ADMIN);
        try {
            this.taskanaEngine.openConnection();
            terminatedTask = this.terminateCancelCommonActions(taskId, TaskState.TERMINATED);
            if (HistoryEventManager.isHistoryEnabled()) {
                this.historyEventManager.createEvent(new TaskTerminatedEvent(IdGenerator.generateWithPrefix((String)"THI"), terminatedTask, this.taskanaEngine.getEngine().getCurrentUserContext().getUserid()));
            }
        }
        finally {
            this.taskanaEngine.returnConnection();
            LOGGER.debug("exit from terminateTask()");
        }
        return terminatedTask;
    }

    public List<String> findTasksIdsAffectedByClassificationChange(String classificationId) {
        LOGGER.debug("entry to findTasksIdsAffectedByClassificationChange(classificationId = {})", (Object)classificationId);
        List tasksAffectedDirectly = this.createTaskQuery().classificationIdIn(classificationId).stateIn(TaskState.READY, TaskState.CLAIMED).list();
        List affectedPairs = tasksAffectedDirectly.stream().map(t -> Pair.of((Object)t.getId(), (Object)t.getPlanned())).collect(Collectors.toList());
        List<Pair<String, Instant>> taskIdsAndPlannedFromAttachments = this.attachmentMapper.findTaskIdsAndPlannedAffectedByClassificationChange(classificationId);
        List<String> taskIdsFromAttachments = taskIdsAndPlannedFromAttachments.stream().map(Pair::getLeft).collect(Collectors.toList());
        List<Object> filteredTaskIdsAndPlannedFromAttachments = taskIdsFromAttachments.isEmpty() ? new ArrayList() : this.taskMapper.filterTaskIdsForReadyAndClaimed(taskIdsFromAttachments);
        affectedPairs.addAll(filteredTaskIdsAndPlannedFromAttachments);
        List<String> affectedTaskIds = affectedPairs.stream().sorted(Comparator.comparing(Pair::getRight)).distinct().map(Pair::getLeft).collect(Collectors.toList());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("the following tasks are affected by the update of classification {} : {}", (Object)classificationId, affectedTaskIds);
        }
        LOGGER.debug("exit from findTasksIdsAffectedByClassificationChange(). ");
        return affectedTaskIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshPriorityAndDueDatesOfTasksOnClassificationUpdate(List<String> taskIds, boolean serviceLevelChanged, boolean priorityChanged) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("entry to refreshPriorityAndDueDateOfTasks(tasks = {})", taskIds);
        }
        Pair<List<MinimalTaskSummary>, ServiceLevelHandler.BulkLog> resultsPair = this.getMinimalTaskSummaries(taskIds);
        List tasks = (List)resultsPair.getLeft();
        try {
            this.taskanaEngine.openConnection();
            Set<String> adminAccessIds = this.taskanaEngine.getEngine().getConfiguration().getRoleMap().get(TaskanaRole.ADMIN);
            if (adminAccessIds.contains(this.taskanaEngine.getEngine().getCurrentUserContext().getUserid())) {
                this.serviceLevelHandler.refreshPriorityAndDueDatesOfTasks(tasks, serviceLevelChanged, priorityChanged);
            } else {
                this.taskanaEngine.getEngine().runAsAdmin(() -> {
                    this.serviceLevelHandler.refreshPriorityAndDueDatesOfTasks(tasks, serviceLevelChanged, priorityChanged);
                    return null;
                });
            }
        }
        finally {
            LOGGER.debug("exit from refreshPriorityAndDueDateOfTasks");
            this.taskanaEngine.returnConnection();
        }
    }

    Pair<List<MinimalTaskSummary>, ServiceLevelHandler.BulkLog> getMinimalTaskSummaries(List<String> argTaskIds) {
        ServiceLevelHandler.BulkLog bulkLog = new ServiceLevelHandler.BulkLog();
        List<String> taskIds = argTaskIds.stream().distinct().collect(Collectors.toList());
        List<MinimalTaskSummary> minimalTaskSummaries = this.taskMapper.findExistingTasks(taskIds, null);
        bulkLog.addAllErrors(this.addExceptionsForNonExistingTasksToBulkLog(taskIds, minimalTaskSummaries));
        Pair<List<MinimalTaskSummary>, ServiceLevelHandler.BulkLog> filteredPair = this.filterTasksAuthorizedForAndLogErrorsForNotAuthorized(minimalTaskSummaries);
        bulkLog.addAllErrors((BulkOperationResults)filteredPair.getRight());
        return new Pair((Object)((List)filteredPair.getLeft()), (Object)bulkLog);
    }

    Pair<List<MinimalTaskSummary>, ServiceLevelHandler.BulkLog> filterTasksAuthorizedForAndLogErrorsForNotAuthorized(List<MinimalTaskSummary> existingTasks) {
        ServiceLevelHandler.BulkLog bulkLog = new ServiceLevelHandler.BulkLog();
        if (this.taskanaEngine.getEngine().isUserInRole(TaskanaRole.ADMIN, TaskanaRole.TASK_ADMIN)) {
            return new Pair(existingTasks, (Object)bulkLog);
        }
        List<String> taskIds = existingTasks.stream().map(MinimalTaskSummary::getTaskId).collect(Collectors.toList());
        List accessIds = this.taskanaEngine.getEngine().getCurrentUserContext().getAccessIds();
        List<String> taskIdsNotAuthorizedFor = this.taskMapper.filterTaskIdsNotAuthorizedFor(taskIds, accessIds);
        String userId = this.taskanaEngine.getEngine().getCurrentUserContext().getUserid();
        for (String taskId : taskIdsNotAuthorizedFor) {
            bulkLog.addError(taskId, (Exception)((Object)new NotAuthorizedException(String.format("User %s is not authorized for task %s ", userId, taskId), userId)));
        }
        taskIds.removeAll(taskIdsNotAuthorizedFor);
        List tasksAuthorizedFor = existingTasks.stream().filter(t -> taskIds.contains(t.getTaskId())).collect(Collectors.toList());
        return new Pair(tasksAuthorizedFor, (Object)bulkLog);
    }

    ServiceLevelHandler.BulkLog addExceptionsForNonExistingTasksToBulkLog(List<String> requestTaskIds, List<MinimalTaskSummary> existingMinimalTaskSummaries) {
        ServiceLevelHandler.BulkLog bulkLog = new ServiceLevelHandler.BulkLog();
        ArrayList<String> nonExistingTaskIds = new ArrayList<String>(requestTaskIds);
        List existingTaskIds = existingMinimalTaskSummaries.stream().map(MinimalTaskSummary::getTaskId).collect(Collectors.toList());
        nonExistingTaskIds.removeAll(existingTaskIds);
        nonExistingTaskIds.forEach(taskId -> bulkLog.addError(taskId, (Exception)((Object)new TaskNotFoundException((String)taskId, "Task was not found"))));
        return bulkLog;
    }

    void removeNonExistingTasksFromTaskIdList(List<String> taskIds, BulkOperationResults<String, TaskanaException> bulkLog) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("entry to removeNonExistingTasksFromTaskIdList(targetWbId = {}, taskIds = {})", taskIds, bulkLog);
        }
        Iterator<String> taskIdIterator = taskIds.iterator();
        while (taskIdIterator.hasNext()) {
            String currentTaskId = taskIdIterator.next();
            if (currentTaskId != null && !currentTaskId.equals("")) continue;
            bulkLog.addError((Object)"", (Exception)new InvalidArgumentException("IDs with EMPTY or NULL value are not allowed."));
            taskIdIterator.remove();
        }
        LOGGER.debug("exit from removeNonExistingTasksFromTaskIdList()");
    }

    List<TaskSummary> augmentTaskSummariesByContainedSummariesWithPartitioning(List<TaskSummaryImpl> taskSummaries) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("entry to augmentTaskSummariesByContainedSummariesWithPartitioning(taskSummaries= {})", taskSummaries);
        }
        List<TaskSummary> result = CollectionUtil.partitionBasedOnSize(taskSummaries, (int)32000).stream().map(this::augmentTaskSummariesByContainedSummariesWithoutPartitioning).flatMap(Collection::stream).collect(Collectors.toList());
        LOGGER.debug("exit from to augmentTaskSummariesByContainedSummariesWithPartitioning()");
        return result;
    }

    private List<TaskSummaryImpl> augmentTaskSummariesByContainedSummariesWithoutPartitioning(List<TaskSummaryImpl> taskSummaries) {
        List<String> taskIds = taskSummaries.stream().map(TaskSummaryImpl::getId).distinct().collect(Collectors.toList());
        if (taskIds.isEmpty()) {
            taskIds = null;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("augmentTaskSummariesByContainedSummariesWithoutPartitioning() with sublist {} about to query for attachmentSummaries ", taskSummaries);
        }
        List<AttachmentSummaryImpl> attachmentSummaries = this.attachmentMapper.findAttachmentSummariesByTaskIds(taskIds);
        List<ClassificationSummary> classifications = this.findClassificationsForTasksAndAttachments(taskSummaries, attachmentSummaries);
        this.addClassificationSummariesToTaskSummaries(taskSummaries, classifications);
        this.addWorkbasketSummariesToTaskSummaries(taskSummaries);
        this.addAttachmentSummariesToTaskSummaries(taskSummaries, attachmentSummaries, classifications);
        return taskSummaries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BulkOperationResults<String, TaskanaException> completeTasks(List<String> taskIds, boolean forced) throws InvalidArgumentException {
        try {
            LOGGER.debug("entry to completeTasks(taskIds = {})", taskIds);
            this.taskanaEngine.openConnection();
            if (taskIds == null) {
                throw new InvalidArgumentException("TaskIds can't be used as NULL-Parameter.");
            }
            BulkOperationResults bulkLog = new BulkOperationResults();
            Instant now = Instant.now().truncatedTo(ChronoUnit.MILLIS);
            Stream<TaskSummaryImpl> filteredSummaries = this.filterNotExistingTaskIds(taskIds, (BulkOperationResults<String, TaskanaException>)bulkLog).filter(task -> task.getState() != TaskState.COMPLETED).filter(TaskServiceImpl.addErrorToBulkLog((CheckedConsumer<TaskSummaryImpl, TaskanaException>)((CheckedConsumer)TaskServiceImpl::checkIfTaskIsTerminatedOrCancelled), (BulkOperationResults<String, TaskanaException>)bulkLog));
            if (!forced) {
                filteredSummaries = filteredSummaries.filter(TaskServiceImpl.addErrorToBulkLog((CheckedConsumer<TaskSummaryImpl, TaskanaException>)((CheckedConsumer)this::checkPreconditionsForCompleteTask), (BulkOperationResults<String, TaskanaException>)bulkLog));
            } else {
                String userId = this.taskanaEngine.getEngine().getCurrentUserContext().getUserid();
                filteredSummaries = filteredSummaries.filter(TaskServiceImpl.addErrorToBulkLog((CheckedConsumer<TaskSummaryImpl, TaskanaException>)((CheckedConsumer)summary -> {
                    if (TaskServiceImpl.taskIsNotClaimed(summary)) {
                        this.checkPreconditionsForClaimTask((TaskSummary)summary, true);
                        TaskServiceImpl.claimActionsOnTask(summary, userId, now);
                    }
                }), (BulkOperationResults<String, TaskanaException>)bulkLog));
            }
            this.updateTasksToBeCompleted(filteredSummaries, now);
            BulkOperationResults bulkOperationResults = bulkLog;
            return bulkOperationResults;
        }
        finally {
            this.taskanaEngine.returnConnection();
            LOGGER.debug("exit from to completeTasks(taskIds = {})", taskIds);
        }
    }

    private Stream<TaskSummaryImpl> filterNotExistingTaskIds(List<String> taskIds, BulkOperationResults<String, TaskanaException> bulkLog) {
        Map<String, TaskSummaryImpl> taskSummaryMap = this.getTasksToChange(taskIds).stream().collect(Collectors.toMap(TaskSummary::getId, TaskSummaryImpl.class::cast));
        return taskIds.stream().map(id -> Pair.of((Object)id, (Object)((TaskSummaryImpl)taskSummaryMap.get(id)))).filter(pair -> {
            if (pair.getRight() == null) {
                String taskId = (String)pair.getLeft();
                bulkLog.addError((Object)taskId, (Exception)((Object)new TaskNotFoundException(taskId, String.format("Task with id %s was not found.", taskId))));
                return false;
            }
            return true;
        }).map(Pair::getRight);
    }

    private static Predicate<TaskSummaryImpl> addErrorToBulkLog(CheckedConsumer<TaskSummaryImpl, TaskanaException> checkedConsumer, BulkOperationResults<String, TaskanaException> bulkLog) {
        return summary -> {
            try {
                checkedConsumer.accept(summary);
                return true;
            }
            catch (TaskanaException e) {
                bulkLog.addError((Object)summary.getId(), (Exception)((Object)e));
                return false;
            }
        };
    }

    private void checkConcurrencyAndSetModified(TaskImpl newTaskImpl, TaskImpl oldTaskImpl) throws ConcurrencyException {
        if (oldTaskImpl.getModified() != null && !oldTaskImpl.getModified().equals(newTaskImpl.getModified()) || oldTaskImpl.getClaimed() != null && !oldTaskImpl.getClaimed().equals(newTaskImpl.getClaimed()) || oldTaskImpl.getState() != null && !oldTaskImpl.getState().equals((Object)newTaskImpl.getState())) {
            throw new ConcurrencyException("The task has already been updated by another user");
        }
        newTaskImpl.setModified(Instant.now());
    }

    private TaskImpl terminateCancelCommonActions(String taskId, TaskState targetState) throws NotAuthorizedException, TaskNotFoundException, InvalidStateException {
        if (taskId == null || taskId.isEmpty()) {
            throw new TaskNotFoundException(taskId, String.format("Task with id %s was not found.", taskId));
        }
        TaskImpl task = (TaskImpl)this.getTask(taskId);
        TaskState state = task.getState();
        if (state.isEndState()) {
            throw new InvalidStateException(String.format("Task with Id %s is already in an end state.", taskId));
        }
        Instant now = Instant.now();
        task.setModified(now);
        task.setCompleted(now);
        task.setState(targetState);
        this.taskMapper.update(task);
        LOGGER.debug("Task '{}' cancelled by user '{}'.", (Object)taskId, (Object)this.taskanaEngine.getEngine().getCurrentUserContext().getUserid());
        return task;
    }

    private BulkOperationResults<String, TaskanaException> addExceptionsForTasksWhoseOwnerWasNotSet(String owner, List<MinimalTaskSummary> existingMinimalTaskSummaries) {
        BulkOperationResults bulkLog = new BulkOperationResults();
        for (MinimalTaskSummary taskSummary : existingMinimalTaskSummaries) {
            if (owner.equals(taskSummary.getOwner())) continue;
            if (!TaskState.READY.equals((Object)taskSummary.getTaskState())) {
                bulkLog.addError((Object)taskSummary.getTaskId(), (Exception)((Object)new InvalidStateException(String.format("Task with id %s is in state %s and not in state ready.", new Object[]{taskSummary.getTaskId(), taskSummary.getTaskState()}))));
                continue;
            }
            bulkLog.addError((Object)taskSummary.getTaskId(), (Exception)((Object)new UpdateFailedException(String.format("Could not set owner of Task %s .", taskSummary.getTaskId()))));
        }
        return bulkLog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Task claim(String taskId, boolean forceClaim) throws TaskNotFoundException, InvalidStateException, InvalidOwnerException, NotAuthorizedException {
        TaskImpl task;
        String userId = this.taskanaEngine.getEngine().getCurrentUserContext().getUserid();
        LOGGER.debug("entry to claim(id = {}, userId = {}, forceClaim = {})", new Object[]{taskId, userId, forceClaim});
        try {
            this.taskanaEngine.openConnection();
            task = (TaskImpl)this.getTask(taskId);
            Instant now = Instant.now();
            this.checkPreconditionsForClaimTask(task, forceClaim);
            TaskServiceImpl.claimActionsOnTask(task, userId, now);
            this.taskMapper.update(task);
            LOGGER.debug("Task '{}' claimed by user '{}'.", (Object)taskId, (Object)userId);
            if (HistoryEventManager.isHistoryEnabled()) {
                this.historyEventManager.createEvent(new TaskClaimedEvent(IdGenerator.generateWithPrefix((String)"THI"), task, this.taskanaEngine.getEngine().getCurrentUserContext().getUserid()));
            }
        }
        finally {
            this.taskanaEngine.returnConnection();
            LOGGER.debug("exit from claim()");
        }
        return task;
    }

    private static void claimActionsOnTask(TaskSummaryImpl task, String userId, Instant now) {
        task.setOwner(userId);
        task.setModified(now);
        task.setClaimed(now);
        task.setRead(true);
        task.setState(TaskState.CLAIMED);
    }

    private static void completeActionsOnTask(TaskSummaryImpl task, String userId, Instant now) {
        task.setCompleted(now);
        task.setModified(now);
        task.setState(TaskState.COMPLETED);
        task.setOwner(userId);
    }

    private void checkPreconditionsForClaimTask(TaskSummary task, boolean forced) throws InvalidStateException, InvalidOwnerException {
        TaskState state = task.getState();
        if (!state.in(TaskState.READY, TaskState.CLAIMED)) {
            throw new InvalidStateException(String.format("Task with Id %s is already in an end state.", task.getId()));
        }
        if (!forced && state == TaskState.CLAIMED && !task.getOwner().equals(this.taskanaEngine.getEngine().getCurrentUserContext().getUserid())) {
            throw new InvalidOwnerException(String.format("Task with id %s is already claimed by %s.", task.getId(), task.getOwner()));
        }
    }

    private static boolean taskIsNotClaimed(TaskSummary task) {
        return task.getClaimed() == null || task.getState() != TaskState.CLAIMED;
    }

    private static void checkIfTaskIsTerminatedOrCancelled(TaskSummary task) throws InvalidStateException {
        if (task.getState().in(TaskState.CANCELLED, TaskState.TERMINATED)) {
            throw new InvalidStateException(String.format("Cannot complete task %s because it is in state %s.", new Object[]{task.getId(), task.getState()}));
        }
    }

    private void checkPreconditionsForCompleteTask(TaskSummary task) throws InvalidStateException, InvalidOwnerException {
        if (TaskServiceImpl.taskIsNotClaimed(task)) {
            throw new InvalidStateException(String.format("Task with Id %s has to be claimed before.", task.getId()));
        }
        if (!this.taskanaEngine.getEngine().getCurrentUserContext().getAccessIds().contains(task.getOwner()) && !this.taskanaEngine.getEngine().isUserInRole(TaskanaRole.ADMIN)) {
            throw new InvalidOwnerException(String.format("Owner of task %s is %s, but current user is %s ", task.getId(), task.getOwner(), this.taskanaEngine.getEngine().getCurrentUserContext().getUserid()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Task cancelClaim(String taskId, boolean forceUnclaim) throws TaskNotFoundException, InvalidStateException, InvalidOwnerException, NotAuthorizedException {
        TaskImpl task;
        String userId = this.taskanaEngine.getEngine().getCurrentUserContext().getUserid();
        LOGGER.debug("entry to cancelClaim(taskId = {}), userId = {}, forceUnclaim = {})", new Object[]{taskId, userId, forceUnclaim});
        try {
            this.taskanaEngine.openConnection();
            task = (TaskImpl)this.getTask(taskId);
            TaskState state = task.getState();
            if (state.isEndState()) {
                throw new InvalidStateException(String.format("Task with Id %s is already in an end state.", taskId));
            }
            if (state == TaskState.CLAIMED && !forceUnclaim && !userId.equals(task.getOwner())) {
                throw new InvalidOwnerException(String.format("Task with id %s is already claimed by %s.", taskId, task.getOwner()));
            }
            Instant now = Instant.now();
            task.setOwner(null);
            task.setModified(now);
            task.setClaimed(null);
            task.setRead(true);
            task.setState(TaskState.READY);
            this.taskMapper.update(task);
            LOGGER.debug("Task '{}' unclaimed by user '{}'.", (Object)taskId, (Object)userId);
            if (HistoryEventManager.isHistoryEnabled()) {
                this.historyEventManager.createEvent(new TaskClaimCancelledEvent(IdGenerator.generateWithPrefix((String)"THI"), task, this.taskanaEngine.getEngine().getCurrentUserContext().getUserid()));
            }
        }
        finally {
            this.taskanaEngine.returnConnection();
            LOGGER.debug("exit from cancelClaim()");
        }
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Task completeTask(String taskId, boolean isForced) throws TaskNotFoundException, InvalidOwnerException, InvalidStateException, NotAuthorizedException {
        TaskImpl task;
        String userId = this.taskanaEngine.getEngine().getCurrentUserContext().getUserid();
        LOGGER.debug("entry to completeTask(id = {}, userId = {}, isForced = {})", new Object[]{taskId, userId, isForced});
        try {
            this.taskanaEngine.openConnection();
            task = (TaskImpl)this.getTask(taskId);
            if (task.getState() == TaskState.COMPLETED) {
                TaskImpl taskImpl = task;
                return taskImpl;
            }
            TaskServiceImpl.checkIfTaskIsTerminatedOrCancelled(task);
            if (!isForced) {
                this.checkPreconditionsForCompleteTask(task);
            } else if (TaskServiceImpl.taskIsNotClaimed(task)) {
                task = (TaskImpl)this.forceClaim(taskId);
            }
            Instant now = Instant.now();
            TaskServiceImpl.completeActionsOnTask(task, userId, now);
            this.taskMapper.update(task);
            LOGGER.debug("Task '{}' completed by user '{}'.", (Object)taskId, (Object)userId);
            if (HistoryEventManager.isHistoryEnabled()) {
                this.historyEventManager.createEvent(new TaskCompletedEvent(IdGenerator.generateWithPrefix((String)"THI"), task, this.taskanaEngine.getEngine().getCurrentUserContext().getUserid()));
            }
        }
        finally {
            this.taskanaEngine.returnConnection();
            LOGGER.debug("exit from completeTask()");
        }
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteTask(String taskId, boolean forceDelete) throws TaskNotFoundException, InvalidStateException, NotAuthorizedException {
        LOGGER.debug("entry to deleteTask(taskId = {} , forceDelete = {})", (Object)taskId, (Object)forceDelete);
        this.taskanaEngine.getEngine().checkRoleMembership(TaskanaRole.ADMIN);
        try {
            this.taskanaEngine.openConnection();
            TaskImpl task = (TaskImpl)this.getTask(taskId);
            if (!task.getState().isEndState() && !forceDelete) {
                throw new InvalidStateException("Cannot delete Task " + taskId + " because it is not in an end state.");
            }
            if (!task.getState().in(TaskState.TERMINATED, TaskState.CANCELLED) && CallbackState.CALLBACK_PROCESSING_REQUIRED.equals((Object)task.getCallbackState())) {
                throw new InvalidStateException(String.format("Task wit Id %s cannot be deleted because its callback is not yet processed", taskId));
            }
            this.attachmentMapper.deleteMultipleByTaskIds(Collections.singletonList(taskId));
            this.taskMapper.delete(taskId);
            if (this.taskanaEngine.getEngine().isHistoryEnabled() && this.taskanaEngine.getEngine().getConfiguration().isDeleteHistoryOnTaskDeletionEnabled()) {
                this.historyEventManager.deleteEvents(Collections.singletonList(taskId));
            }
            LOGGER.debug("Task {} deleted.", (Object)taskId);
        }
        finally {
            this.taskanaEngine.returnConnection();
            LOGGER.debug("exit from deleteTask().");
        }
    }

    private void removeSingleTaskForTaskDeletionById(BulkOperationResults<String, TaskanaException> bulkLog, List<MinimalTaskSummary> taskSummaries, Iterator<String> taskIdIterator) {
        LOGGER.debug("entry to removeSingleTask()");
        String currentTaskId = taskIdIterator.next();
        if (currentTaskId == null || currentTaskId.equals("")) {
            bulkLog.addError((Object)"", (Exception)new InvalidArgumentException("IDs with EMPTY or NULL value are not allowed."));
            taskIdIterator.remove();
        } else {
            MinimalTaskSummary foundSummary = taskSummaries.stream().filter(taskSummary -> currentTaskId.equals(taskSummary.getTaskId())).findFirst().orElse(null);
            if (foundSummary == null) {
                bulkLog.addError((Object)currentTaskId, (Exception)((Object)new TaskNotFoundException(currentTaskId, String.format("Task with id %s was not found.", currentTaskId))));
                taskIdIterator.remove();
            } else if (!foundSummary.getTaskState().isEndState()) {
                bulkLog.addError((Object)currentTaskId, (Exception)((Object)new InvalidStateException(currentTaskId)));
                taskIdIterator.remove();
            } else if (!foundSummary.getTaskState().in(TaskState.CANCELLED, TaskState.TERMINATED) && CallbackState.CALLBACK_PROCESSING_REQUIRED.equals((Object)foundSummary.getCallbackState())) {
                bulkLog.addError((Object)currentTaskId, (Exception)((Object)new InvalidStateException(String.format("Task wit Id %s cannot be deleted because its callback is not yet processed", currentTaskId))));
                taskIdIterator.remove();
            }
        }
        LOGGER.debug("exit from removeSingleTask()");
    }

    private void removeSingleTaskForCallbackStateByExternalId(BulkOperationResults<String, TaskanaException> bulkLog, List<MinimalTaskSummary> taskSummaries, Iterator<String> externalIdIterator, CallbackState desiredCallbackState) {
        LOGGER.debug("entry to removeSingleTask()");
        String currentExternalId = externalIdIterator.next();
        if (currentExternalId == null || currentExternalId.equals("")) {
            bulkLog.addError((Object)"", (Exception)new InvalidArgumentException("IDs with EMPTY or NULL value are not allowed."));
            externalIdIterator.remove();
        } else {
            Optional<MinimalTaskSummary> foundSummary = taskSummaries.stream().filter(taskSummary -> currentExternalId.equals(taskSummary.getExternalId())).findFirst();
            if (foundSummary.isPresent()) {
                if (!this.desiredCallbackStateCanBeSetForFoundSummary(foundSummary.get(), desiredCallbackState)) {
                    bulkLog.addError((Object)currentExternalId, (Exception)((Object)new InvalidStateException(currentExternalId)));
                    externalIdIterator.remove();
                }
            } else {
                bulkLog.addError((Object)currentExternalId, (Exception)((Object)new TaskNotFoundException(currentExternalId, String.format("Task with id %s was not found.", currentExternalId))));
                externalIdIterator.remove();
            }
        }
        LOGGER.debug("exit from removeSingleTask()");
    }

    private boolean desiredCallbackStateCanBeSetForFoundSummary(MinimalTaskSummary foundSummary, CallbackState desiredCallbackState) {
        CallbackState currentTaskCallbackState = foundSummary.getCallbackState();
        TaskState currentTaskState = foundSummary.getTaskState();
        switch (desiredCallbackState) {
            case CALLBACK_PROCESSING_COMPLETED: {
                return currentTaskState.isEndState();
            }
            case CLAIMED: {
                if (!currentTaskState.equals((Object)TaskState.CLAIMED)) {
                    return false;
                }
                return currentTaskCallbackState.equals((Object)CallbackState.CALLBACK_PROCESSING_REQUIRED);
            }
            case CALLBACK_PROCESSING_REQUIRED: {
                return !currentTaskCallbackState.equals((Object)CallbackState.CALLBACK_PROCESSING_COMPLETED);
            }
        }
        return false;
    }

    private void standardSettings(TaskImpl task, Classification classification) throws InvalidArgumentException {
        TaskImpl task1 = task;
        LOGGER.debug("entry to standardSettings()");
        Instant now = Instant.now();
        task1.setId(IdGenerator.generateWithPrefix((String)"TKI"));
        if (task1.getExternalId() == null) {
            task1.setExternalId(IdGenerator.generateWithPrefix((String)"ETI"));
        }
        task1.setState(TaskState.READY);
        task1.setCreated(now);
        task1.setModified(now);
        task1.setRead(false);
        task1.setTransferred(false);
        String creator = this.taskanaEngine.getEngine().getCurrentUserContext().getUserid();
        if (this.taskanaEngine.getEngine().getConfiguration().isSecurityEnabled() && creator == null) {
            throw new SystemException("TaskanaSecurity is enabled, but the current UserId is NULL while creating a Task.");
        }
        task1.setCreator(creator);
        if (task1.getBusinessProcessId() == null) {
            task1.setBusinessProcessId(IdGenerator.generateWithPrefix((String)"BPI"));
        }
        if (task1.getPlanned() == null && (classification == null || task1.getDue() == null)) {
            task1.setPlanned(now);
        }
        if (classification != null) {
            task1 = this.serviceLevelHandler.updatePrioPlannedDueOfTask(task1, null, false);
        }
        if (task1.getName() == null && classification != null) {
            task1.setName(classification.getName());
        }
        if (task1.getDescription() == null && classification != null) {
            task1.setDescription(classification.getDescription());
        }
        try {
            this.attachmentHandler.insertNewAttachmentsOnTaskCreation(task);
        }
        catch (AttachmentPersistenceException e) {
            throw new SystemException("Internal error when trying to insert new Attachments on Task Creation.", (Throwable)((Object)e));
        }
        LOGGER.debug("exit from standardSettings()");
    }

    private void setCallbackStateOnTaskCreation(TaskImpl task) throws InvalidArgumentException {
        String value;
        Map<String, String> callbackInfo = task.getCallbackInfo();
        if (callbackInfo != null && callbackInfo.containsKey("callbackState") && (value = callbackInfo.get("callbackState")) != null && !value.isEmpty()) {
            try {
                CallbackState state = CallbackState.valueOf(value);
                task.setCallbackState(state);
            }
            catch (Exception e) {
                LOGGER.warn("Attempted to determine callback state from {} and caught exception", (Object)value, (Object)e);
                throw new InvalidArgumentException(String.format("Attempted to set callback state for task %s.", task.getId()), (Throwable)e);
            }
        }
    }

    private void updateTasksToBeCompleted(Stream<TaskSummaryImpl> taskSummaries, Instant now) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("entry to updateTasksToBeCompleted()");
        }
        ArrayList<String> taskIds = new ArrayList<String>();
        ArrayList<String> updateClaimedTaskIds = new ArrayList<String>();
        List taskSummaryList = taskSummaries.peek(summary -> TaskServiceImpl.completeActionsOnTask(summary, this.taskanaEngine.getEngine().getCurrentUserContext().getUserid(), now)).peek(summary -> taskIds.add(summary.getId())).peek(summary -> {
            if (summary.getClaimed().equals(now)) {
                updateClaimedTaskIds.add(summary.getId());
            }
        }).collect(Collectors.toList());
        TaskSummary claimedReference = taskSummaryList.stream().filter(summary -> updateClaimedTaskIds.contains(summary.getId())).findFirst().orElse(null);
        if (!taskSummaryList.isEmpty()) {
            this.taskMapper.updateCompleted(taskIds, (TaskSummary)taskSummaryList.get(0));
            if (!updateClaimedTaskIds.isEmpty()) {
                this.taskMapper.updateClaimed(updateClaimedTaskIds, claimedReference);
            }
            if (HistoryEventManager.isHistoryEnabled()) {
                this.createTasksCompletedEvents(taskSummaryList);
            }
        }
        LOGGER.debug("exit from updateTasksToBeCompleted()");
    }

    private void addClassificationSummariesToTaskSummaries(List<TaskSummaryImpl> tasks, List<ClassificationSummary> classifications) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("entry to addClassificationSummariesToTaskSummaries(tasks = {}, classifications = {})", tasks, classifications);
        }
        if (tasks == null || tasks.isEmpty()) {
            LOGGER.debug("exit from addClassificationSummariesToTaskSummaries()");
            return;
        }
        for (TaskSummaryImpl task : tasks) {
            String classificationId = task.getClassificationSummary().getId();
            ClassificationSummary classificationSummary = classifications.stream().filter(c -> c.getId().equals(classificationId)).findFirst().orElse(null);
            if (classificationSummary == null) {
                throw new SystemException("Did not find a Classification for task (Id=" + task.getId() + ",classification=" + task.getClassificationSummary().getId() + ")");
            }
            task.setClassificationSummary(classificationSummary);
        }
        LOGGER.debug("exit from addClassificationSummariesToTaskSummaries()");
    }

    private List<ClassificationSummary> findClassificationsForTasksAndAttachments(List<TaskSummaryImpl> taskSummaries, List<AttachmentSummaryImpl> attachmentSummaries) {
        LOGGER.debug("entry to findClassificationsForTasksAndAttachments()");
        if (taskSummaries == null || taskSummaries.isEmpty()) {
            return new ArrayList<ClassificationSummary>();
        }
        Set<String> classificationIdSet = taskSummaries.stream().map(t -> t.getClassificationSummary().getId()).collect(Collectors.toSet());
        if (attachmentSummaries != null && !attachmentSummaries.isEmpty()) {
            for (AttachmentSummaryImpl att : attachmentSummaries) {
                classificationIdSet.add(att.getClassificationSummary().getId());
            }
        }
        LOGGER.debug("exit from findClassificationsForTasksAndAttachments()");
        return this.queryClassificationsForTasksAndAttachments(classificationIdSet);
    }

    private List<ClassificationSummary> findClassificationForTaskImplAndAttachments(TaskImpl task, List<AttachmentImpl> attachmentImpls) {
        LOGGER.debug("entry to transferBulk()");
        HashSet<String> classificationIdSet = new HashSet<String>(Collections.singletonList(task.getClassificationSummary().getId()));
        if (attachmentImpls != null && !attachmentImpls.isEmpty()) {
            for (AttachmentImpl att : attachmentImpls) {
                classificationIdSet.add(att.getClassificationSummary().getId());
            }
        }
        LOGGER.debug("exit from findClassificationForTaskImplAndAttachments()");
        return this.queryClassificationsForTasksAndAttachments(classificationIdSet);
    }

    private List<ClassificationSummary> queryClassificationsForTasksAndAttachments(Set<String> classificationIdSet) {
        String[] classificationIdArray = classificationIdSet.toArray(new String[0]);
        LOGGER.debug("getClassificationsForTasksAndAttachments() about to query classifications and exit");
        return this.classificationService.createClassificationQuery().idIn(classificationIdArray).list();
    }

    private void addWorkbasketSummariesToTaskSummaries(List<TaskSummaryImpl> taskSummaries) {
        LOGGER.debug("entry to addWorkbasketSummariesToTaskSummaries()");
        if (taskSummaries == null || taskSummaries.isEmpty()) {
            return;
        }
        String[] workbasketIdArray = (String[])taskSummaries.stream().map(t -> t.getWorkbasketSummary().getId()).distinct().toArray(String[]::new);
        LOGGER.debug("addWorkbasketSummariesToTaskSummaries() about to query workbaskets");
        WorkbasketQueryImpl query = (WorkbasketQueryImpl)this.workbasketService.createWorkbasketQuery();
        query.setUsedToAugmentTasks(true);
        List workbaskets = query.idIn(workbasketIdArray).list();
        Iterator<TaskSummaryImpl> taskIterator = taskSummaries.iterator();
        while (taskIterator.hasNext()) {
            TaskSummaryImpl task = taskIterator.next();
            String workbasketId = task.getWorkbasketSummaryImpl().getId();
            WorkbasketSummary workbasketSummary = workbaskets.stream().filter(x -> workbasketId != null && workbasketId.equals(x.getId())).findFirst().orElse(null);
            if (workbasketSummary == null) {
                LOGGER.warn("Could not find a Workbasket for task {}.", (Object)task.getId());
                taskIterator.remove();
                continue;
            }
            task.setWorkbasketSummary(workbasketSummary);
        }
        LOGGER.debug("exit from addWorkbasketSummariesToTaskSummaries()");
    }

    private void addAttachmentSummariesToTaskSummaries(List<TaskSummaryImpl> taskSummaries, List<AttachmentSummaryImpl> attachmentSummaries, List<ClassificationSummary> classifications) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("entry to addAttachmentSummariesToTaskSummaries(taskSummaries = {}, attachmentSummaries = {}, classifications = {})", new Object[]{taskSummaries, attachmentSummaries, classifications});
        }
        if (taskSummaries == null || taskSummaries.isEmpty()) {
            return;
        }
        this.addClassificationSummariesToAttachmentSummaries(attachmentSummaries, taskSummaries, classifications);
        for (TaskSummaryImpl task : taskSummaries) {
            for (AttachmentSummaryImpl attachment : attachmentSummaries) {
                if (attachment.getTaskId() == null || !attachment.getTaskId().equals(task.getId())) continue;
                task.addAttachmentSummary(attachment);
            }
        }
        LOGGER.debug("exit from addAttachmentSummariesToTaskSummaries()");
    }

    private void addClassificationSummariesToAttachmentSummaries(List<AttachmentSummaryImpl> attachmentSummaries, List<TaskSummaryImpl> taskSummaries, List<ClassificationSummary> classifications) {
        LOGGER.debug("entry to addClassificationSummariesToAttachmentSummaries()");
        if (attachmentSummaries == null || attachmentSummaries.isEmpty() || taskSummaries == null || taskSummaries.isEmpty()) {
            LOGGER.debug("exit from addClassificationSummariesToAttachmentSummaries()");
            return;
        }
        for (AttachmentSummaryImpl att : attachmentSummaries) {
            String classificationId = att.getClassificationSummary().getId();
            ClassificationSummary classificationSummary = classifications.stream().filter(x -> classificationId != null && classificationId.equals(x.getId())).findFirst().orElse(null);
            if (classificationSummary == null) {
                throw new SystemException("Could not find a Classification for attachment " + att);
            }
            att.setClassificationSummary(classificationSummary);
        }
        LOGGER.debug("exit from addClassificationSummariesToAttachmentSummaries()");
    }

    private List<Attachment> addClassificationSummariesToAttachments(List<AttachmentImpl> attachmentImpls, List<ClassificationSummary> classifications) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("entry to addClassificationSummariesToAttachments(targetWbId = {}, taskIds = {})", attachmentImpls, classifications);
        }
        if (attachmentImpls == null || attachmentImpls.isEmpty()) {
            LOGGER.debug("exit from addClassificationSummariesToAttachments()");
            return new ArrayList<Attachment>();
        }
        ArrayList<Attachment> result = new ArrayList<Attachment>();
        for (AttachmentImpl att : attachmentImpls) {
            ClassificationSummary classificationSummary = classifications.stream().filter(c -> c != null && c.getId().equals(att.getClassificationSummary().getId())).findFirst().orElse(null);
            if (classificationSummary == null) {
                throw new SystemException("Could not find a Classification for attachment " + att);
            }
            att.setClassificationSummary(classificationSummary);
            result.add(att);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("exit from addClassificationSummariesToAttachments(), returning {}", result);
        }
        return result;
    }

    private TaskImpl initUpdatedTask(Map<TaskCustomField, String> customFieldsToUpdate, TaskCustomPropertySelector fieldSelector) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("entry to initUpdatedTask(customFieldsToUpdate = {}, fieldSelector = {})", customFieldsToUpdate, (Object)fieldSelector);
        }
        TaskImpl newTask = new TaskImpl();
        newTask.setModified(Instant.now());
        for (Map.Entry<TaskCustomField, String> entry : customFieldsToUpdate.entrySet()) {
            TaskCustomField key = entry.getKey();
            fieldSelector.setCustomProperty(key, true);
            newTask.setCustomAttribute(key, entry.getValue());
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("exit from initUpdatedTask(), returning {}", (Object)newTask);
        }
        return newTask;
    }

    private void validateCustomFields(Map<TaskCustomField, String> customFieldsToUpdate) throws InvalidArgumentException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("entry to validateCustomFields(customFieldsToUpdate = {})", customFieldsToUpdate);
        }
        if (customFieldsToUpdate == null || customFieldsToUpdate.isEmpty()) {
            throw new InvalidArgumentException("The customFieldsToUpdate argument to updateTasks must not be empty.");
        }
        LOGGER.debug("exit from validateCustomFields()");
    }

    private List<TaskSummary> getTasksToChange(List<String> taskIds) {
        return this.createTaskQuery().idIn(taskIds.toArray(new String[0])).list();
    }

    private List<TaskSummary> getTasksToChange(ObjectReference selectionCriteria) {
        return this.createTaskQuery().primaryObjectReferenceCompanyIn(selectionCriteria.getCompany()).primaryObjectReferenceSystemIn(selectionCriteria.getSystem()).primaryObjectReferenceSystemInstanceIn(selectionCriteria.getSystemInstance()).primaryObjectReferenceTypeIn(selectionCriteria.getType()).primaryObjectReferenceValueIn(selectionCriteria.getValue()).list();
    }

    private void standardUpdateActions(TaskImpl oldTaskImpl, TaskImpl newTaskImpl) throws InvalidArgumentException, InvalidStateException, ClassificationNotFoundException {
        boolean isOwnerChanged;
        if (oldTaskImpl.getExternalId() == null || !oldTaskImpl.getExternalId().equals(newTaskImpl.getExternalId())) {
            throw new InvalidArgumentException("A task's external Id cannot be changed via update of the task");
        }
        String newWorkbasketKey = newTaskImpl.getWorkbasketKey();
        if (newWorkbasketKey != null && !newWorkbasketKey.equals(oldTaskImpl.getWorkbasketKey())) {
            throw new InvalidArgumentException("A task's Workbasket cannot be changed via update of the task");
        }
        if (newTaskImpl.getClassificationSummary() == null) {
            newTaskImpl.setClassificationSummary(oldTaskImpl.getClassificationSummary());
        }
        this.updateClassificationSummary(newTaskImpl, oldTaskImpl);
        TaskImpl newTaskImpl1 = this.serviceLevelHandler.updatePrioPlannedDueOfTask(newTaskImpl, oldTaskImpl, false);
        if (newTaskImpl1.getBusinessProcessId() == null) {
            newTaskImpl1.setBusinessProcessId(oldTaskImpl.getBusinessProcessId());
        }
        boolean bl = isOwnerChanged = !Objects.equals(newTaskImpl1.getOwner(), oldTaskImpl.getOwner());
        if (isOwnerChanged && oldTaskImpl.getState() != TaskState.READY) {
            throw new InvalidStateException(String.format("Task with id %s is in state %s and not in state ready.", new Object[]{oldTaskImpl.getId(), oldTaskImpl.getState()}));
        }
    }

    private void updateClassificationSummary(TaskImpl newTaskImpl, TaskImpl oldTaskImpl) throws ClassificationNotFoundException {
        ClassificationSummary oldClassificationSummary = oldTaskImpl.getClassificationSummary();
        ClassificationSummary newClassificationSummary = newTaskImpl.getClassificationSummary();
        if (newClassificationSummary == null) {
            newClassificationSummary = oldClassificationSummary;
        }
        if (!oldClassificationSummary.getKey().equals(newClassificationSummary.getKey())) {
            Classification newClassification = this.classificationService.getClassification(newClassificationSummary.getKey(), newTaskImpl.getWorkbasketSummary().getDomain());
            newClassificationSummary = newClassification.asSummary();
            newTaskImpl.setClassificationSummary(newClassificationSummary);
        }
    }

    private void createTasksCompletedEvents(List<? extends TaskSummary> taskSummaries) {
        taskSummaries.forEach(task -> this.historyEventManager.createEvent(new TaskCompletedEvent(IdGenerator.generateWithPrefix((String)"THI"), (TaskSummary)task, this.taskanaEngine.getEngine().getCurrentUserContext().getUserid())));
    }
}

