/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.task.internal.models;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import pro.taskana.task.api.models.Attachment;
import pro.taskana.task.api.models.AttachmentSummary;
import pro.taskana.task.internal.models.AttachmentSummaryImpl;

public class AttachmentImpl
extends AttachmentSummaryImpl
implements Attachment {
    private Map<String, String> customAttributes = new HashMap<String, String>();

    public AttachmentImpl() {
    }

    private AttachmentImpl(AttachmentImpl copyFrom) {
        super(copyFrom);
        this.customAttributes = new HashMap<String, String>(copyFrom.customAttributes);
    }

    @Override
    public Map<String, String> getCustomAttributeMap() {
        return this.getCustomAttributes();
    }

    @Override
    public void setCustomAttributeMap(Map<String, String> customAttributes) {
        this.setCustomAttributes(customAttributes);
    }

    @Override
    public AttachmentSummary asSummary() {
        AttachmentSummaryImpl summary = new AttachmentSummaryImpl();
        summary.setClassificationSummary(this.classificationSummary);
        summary.setCreated(this.created);
        summary.setId(this.id);
        summary.setModified(this.modified);
        summary.setReceived(this.received);
        summary.setTaskId(this.taskId);
        summary.setChannel(this.channel);
        summary.setObjectReference(this.objectReference);
        return summary;
    }

    public Map<String, String> getCustomAttributes() {
        if (this.customAttributes == null) {
            this.customAttributes = new HashMap<String, String>();
        }
        return this.customAttributes;
    }

    public void setCustomAttributes(Map<String, String> customAttributes) {
        this.customAttributes = customAttributes;
    }

    @Override
    public AttachmentImpl copy() {
        return new AttachmentImpl(this);
    }

    @Override
    protected boolean canEqual(Object other) {
        return !(other instanceof AttachmentImpl);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.customAttributes);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AttachmentImpl)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        AttachmentImpl other = (AttachmentImpl)obj;
        if (other.canEqual(this)) {
            return false;
        }
        return Objects.equals(this.customAttributes, other.customAttributes);
    }

    @Override
    public String toString() {
        return "AttachmentImpl [id=" + this.id + ", taskId=" + this.taskId + ", created=" + this.created + ", modified=" + this.modified + ", classificationSummary=" + this.classificationSummary + ", objectReference=" + this.objectReference + ", channel=" + this.channel + ", received=" + this.received + ", customAttributes=" + this.customAttributes + "]";
    }
}

