/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.workbasket.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.ibatis.exceptions.PersistenceException;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.common.api.BaseQuery;
import pro.taskana.common.api.exceptions.TaskanaRuntimeException;
import pro.taskana.common.internal.InternalTaskanaEngine;
import pro.taskana.workbasket.api.AccessItemQueryColumnName;
import pro.taskana.workbasket.api.WorkbasketAccessItemQuery;
import pro.taskana.workbasket.api.models.WorkbasketAccessItem;
import pro.taskana.workbasket.internal.WorkbasketQueryImpl;

public class WorkbasketAccessItemQueryImpl
implements WorkbasketAccessItemQuery {
    private static final String LINK_TO_MAPPER = "pro.taskana.workbasket.internal.WorkbasketQueryMapper.queryWorkbasketAccessItems";
    private static final String LINK_TO_COUNTER = "pro.taskana.workbasket.internal.WorkbasketQueryMapper.countQueryWorkbasketAccessItems";
    private static final String LINK_TO_VALUEMAPPER = "pro.taskana.workbasket.internal.WorkbasketQueryMapper.queryWorkbasketAccessItemColumnValues";
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkbasketQueryImpl.class);
    private AccessItemQueryColumnName columnName;
    private String[] accessIdIn;
    private String[] accessIdLike;
    private String[] workbasketIdIn;
    private String[] workbasketKeyIn;
    private String[] workbasketKeyLike;
    private String[] idIn;
    private InternalTaskanaEngine taskanaEngine;
    private List<String> orderBy;
    private List<String> orderColumns;

    WorkbasketAccessItemQueryImpl(InternalTaskanaEngine taskanaEngine) {
        this.taskanaEngine = taskanaEngine;
        this.orderBy = new ArrayList<String>();
        this.orderColumns = new ArrayList<String>();
    }

    @Override
    public WorkbasketAccessItemQuery idIn(String ... ids) {
        this.idIn = ids;
        return this;
    }

    @Override
    public WorkbasketAccessItemQuery workbasketIdIn(String ... id) {
        this.workbasketIdIn = id;
        return this;
    }

    @Override
    public WorkbasketAccessItemQuery workbasketKeyIn(String ... keys) {
        this.workbasketKeyIn = keys;
        return this;
    }

    @Override
    public WorkbasketAccessItemQuery workbasketKeyLike(String ... key) {
        this.workbasketKeyLike = this.toUpperCopy(key);
        return this;
    }

    @Override
    public WorkbasketAccessItemQuery accessIdIn(String ... accessId) {
        this.accessIdIn = accessId;
        WorkbasketQueryImpl.lowercaseAccessIds(this.accessIdIn);
        return this;
    }

    @Override
    public WorkbasketAccessItemQuery accessIdLike(String ... ids) {
        this.accessIdLike = this.toUpperCopy(ids);
        return this;
    }

    @Override
    public WorkbasketAccessItemQuery orderByWorkbasketId(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("WORKBASKET_ID", sortDirection);
    }

    @Override
    public WorkbasketAccessItemQuery orderByWorkbasketKey(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("WB.KEY", sortDirection);
    }

    @Override
    public WorkbasketAccessItemQuery orderByAccessId(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("ACCESS_ID", sortDirection);
    }

    @Override
    public WorkbasketAccessItemQuery orderById(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("ID", sortDirection);
    }

    public List<WorkbasketAccessItem> list() {
        LOGGER.debug("entry to list(), this = {}", (Object)this);
        List result = this.taskanaEngine.openAndReturnConnection(() -> new ArrayList(this.taskanaEngine.getSqlSession().selectList(LINK_TO_MAPPER, (Object)this)));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("exit from list(). Returning {} resulting Objects: {} ", (Object)result.size(), (Object)result);
        }
        return result;
    }

    public List<WorkbasketAccessItem> list(int offset, int limit) {
        LOGGER.debug("entry to list(offset = {}, limit = {}), this = {}", new Object[]{offset, limit, this});
        ArrayList<WorkbasketAccessItem> result = new ArrayList<WorkbasketAccessItem>();
        try {
            this.taskanaEngine.openConnection();
            RowBounds rowBounds = new RowBounds(offset, limit);
            List foundAccessItms = this.taskanaEngine.getSqlSession().selectList(LINK_TO_MAPPER, (Object)this, rowBounds);
            result.addAll(foundAccessItms);
            ArrayList<WorkbasketAccessItem> arrayList = result;
            return arrayList;
        }
        catch (PersistenceException e) {
            if (e.getMessage().contains("ERRORCODE=-4470")) {
                TaskanaRuntimeException ex = new TaskanaRuntimeException("The offset beginning was set over the amount of result-rows.", e.getCause());
                ex.setStackTrace(e.getStackTrace());
                throw ex;
            }
            throw e;
        }
        finally {
            this.taskanaEngine.returnConnection();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("exit from list(offset,limit). Returning {} resulting Objects: {} ", (Object)result.size(), result);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> listValues(AccessItemQueryColumnName columnName, BaseQuery.SortDirection sortDirection) {
        List list;
        LOGGER.debug("Entry to listValues(dbColumnName={}) this = {}", (Object)columnName, (Object)this);
        List result = null;
        try {
            this.taskanaEngine.openConnection();
            this.columnName = columnName;
            this.orderBy.clear();
            this.addOrderCriteria(columnName.toString(), sortDirection);
            list = result = this.taskanaEngine.getSqlSession().selectList(LINK_TO_VALUEMAPPER, (Object)this);
            this.taskanaEngine.returnConnection();
        }
        catch (Throwable throwable) {
            this.taskanaEngine.returnConnection();
            if (LOGGER.isDebugEnabled()) {
                int numberOfResultObjects = result == null ? 0 : result.size();
                LOGGER.debug("Exit from listValues. Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)result);
            }
            throw throwable;
        }
        if (LOGGER.isDebugEnabled()) {
            int numberOfResultObjects = result == null ? 0 : result.size();
            LOGGER.debug("Exit from listValues. Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)result);
        }
        return list;
    }

    public WorkbasketAccessItem single() {
        WorkbasketAccessItem workbasketAccessItem;
        LOGGER.debug("entry to single(), this = {}", (Object)this);
        WorkbasketAccessItem accessItm = null;
        try {
            this.taskanaEngine.openConnection();
            workbasketAccessItem = accessItm = (WorkbasketAccessItem)this.taskanaEngine.getSqlSession().selectOne(LINK_TO_MAPPER, (Object)this);
            this.taskanaEngine.returnConnection();
        }
        catch (Throwable throwable) {
            this.taskanaEngine.returnConnection();
            LOGGER.debug("exit from single(). Returning result {} ", accessItm);
            throw throwable;
        }
        LOGGER.debug("exit from single(). Returning result {} ", (Object)accessItm);
        return workbasketAccessItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long count() {
        long l;
        LOGGER.debug("entry to count(), this = {}", (Object)this);
        Long rowCount = null;
        try {
            this.taskanaEngine.openConnection();
            rowCount = (Long)this.taskanaEngine.getSqlSession().selectOne(LINK_TO_COUNTER, (Object)this);
            l = rowCount == null ? 0L : rowCount;
            this.taskanaEngine.returnConnection();
        }
        catch (Throwable throwable) {
            this.taskanaEngine.returnConnection();
            LOGGER.debug("exit from count(). Returning result {} ", rowCount);
            throw throwable;
        }
        LOGGER.debug("exit from count(). Returning result {} ", (Object)rowCount);
        return l;
    }

    public String[] getIdIn() {
        return this.idIn;
    }

    public String[] getAccessIdIn() {
        return this.accessIdIn;
    }

    public String[] getAccessIdLike() {
        return this.accessIdLike;
    }

    public String[] getWorkbasketIdIn() {
        return this.workbasketIdIn;
    }

    public List<String> getOrderBy() {
        return this.orderBy;
    }

    public List<String> getOrderColumns() {
        return this.orderColumns;
    }

    public AccessItemQueryColumnName getColumnName() {
        return this.columnName;
    }

    public String[] getWorkbasketKeyIn() {
        return this.workbasketKeyIn;
    }

    public String[] getWorkbasketKeyLike() {
        return this.workbasketKeyLike;
    }

    private WorkbasketAccessItemQuery addOrderCriteria(String colName, BaseQuery.SortDirection sortDirection) {
        String orderByDirection = " " + (sortDirection == null ? BaseQuery.SortDirection.ASCENDING.toString() : sortDirection.toString());
        this.orderBy.add(colName + orderByDirection);
        this.orderColumns.add(colName);
        return this;
    }

    public String toString() {
        return "WorkbasketAccessItemQueryImpl [idIn=" + Arrays.toString(this.idIn) + ", accessIdIn=" + Arrays.toString(this.accessIdIn) + ", workbasketIdIn=" + Arrays.toString(this.workbasketIdIn) + ", orderBy=" + this.orderBy + "]";
    }
}

