/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.classification.internal.jobs;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.common.api.ScheduledJob;
import pro.taskana.common.api.TaskanaEngine;
import pro.taskana.common.api.exceptions.TaskanaException;
import pro.taskana.common.internal.jobs.AbstractTaskanaJob;
import pro.taskana.common.internal.logging.LoggingAspect;
import pro.taskana.common.internal.transaction.TaskanaTransactionProvider;
import pro.taskana.task.internal.TaskServiceImpl;

public class ClassificationChangedJob
extends AbstractTaskanaJob {
    public static final String TASK_IDS = "taskIds";
    public static final String CLASSIFICATION_ID = "classificationId";
    public static final String PRIORITY_CHANGED = "priorityChanged";
    public static final String SERVICE_LEVEL_CHANGED = "serviceLevelChanged";
    private static final Logger LOGGER;
    private String classificationId;
    private boolean priorityChanged;
    private boolean serviceLevelChanged;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    static {
        ClassificationChangedJob.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(ClassificationChangedJob.class);
    }

    public ClassificationChangedJob(TaskanaEngine engine, TaskanaTransactionProvider<Object> txProvider, ScheduledJob job) {
        super(engine, txProvider, job);
        Map<String, String> args = job.getArguments();
        this.classificationId = args.get(CLASSIFICATION_ID);
        this.priorityChanged = Boolean.parseBoolean(args.get(PRIORITY_CHANGED));
        this.serviceLevelChanged = Boolean.parseBoolean(args.get(SERVICE_LEVEL_CHANGED));
    }

    @Override
    public void run() throws TaskanaException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        LOGGER.info("Running ClassificationChangedJob for classification ({})", (Object)this.classificationId);
        try {
            TaskServiceImpl taskService = (TaskServiceImpl)this.taskanaEngineImpl.getTaskService();
            List<String> affectedTaskIds = taskService.findTasksIdsAffectedByClassificationChange(this.classificationId);
            if (!affectedTaskIds.isEmpty()) {
                this.scheduleTaskRefreshJobs(affectedTaskIds);
            }
            LOGGER.info("ClassificationChangedJob ended successfully.");
        }
        catch (Exception e) {
            throw new TaskanaException("Error while processing ClassificationChangedJob.", (Throwable)e);
        }
        Object var4_5 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_5);
    }

    private void scheduleTaskRefreshJobs(List<String> affectedTaskIds) {
        List<String> list = affectedTaskIds;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, list);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        int batchSize = this.taskanaEngineImpl.getConfiguration().getMaxNumberOfUpdatesPerTransaction();
        List<List<String>> affectedTaskBatches = this.partition(affectedTaskIds, batchSize);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Creating {} TaskRefreshJobs out of {} affected tasks with a maximum number of {} tasks each. ", new Object[]{affectedTaskBatches.size(), affectedTaskIds.size(), batchSize});
        }
        for (List<String> taskIdBatch : affectedTaskBatches) {
            HashMap<String, String> args = new HashMap<String, String>();
            if (taskIdBatch.isEmpty()) continue;
            String taskIds = String.join((CharSequence)",", affectedTaskIds);
            args.put(TASK_IDS, taskIds);
            args.put(PRIORITY_CHANGED, Boolean.toString(this.priorityChanged));
            args.put(SERVICE_LEVEL_CHANGED, Boolean.toString(this.serviceLevelChanged));
            ScheduledJob job = new ScheduledJob();
            job.setType(ScheduledJob.Type.UPDATETASKSJOB);
            job.setArguments(args);
            this.taskanaEngineImpl.getJobService().createJob(job);
        }
        Object var11_11 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var11_11);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ClassificationChangedJob.java", ClassificationChangedJob.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "run", "pro.taskana.classification.internal.jobs.ClassificationChangedJob", "", "", "pro.taskana.common.api.exceptions.TaskanaException", "void"), 38);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "scheduleTaskRefreshJobs", "pro.taskana.classification.internal.jobs.ClassificationChangedJob", "java.util.List", "affectedTaskIds", "", "void"), 53);
    }
}

