/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.monitor.internal.reports;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import pro.taskana.common.api.TaskanaRole;
import pro.taskana.common.api.WorkingDaysToDaysConverter;
import pro.taskana.common.api.exceptions.InvalidArgumentException;
import pro.taskana.common.api.exceptions.NotAuthorizedException;
import pro.taskana.common.internal.InternalTaskanaEngine;
import pro.taskana.common.internal.logging.LoggingAspect;
import pro.taskana.monitor.api.CombinedClassificationFilter;
import pro.taskana.monitor.api.SelectedItem;
import pro.taskana.monitor.api.TaskTimestamp;
import pro.taskana.monitor.api.reports.ClassificationReport;
import pro.taskana.monitor.api.reports.TimeIntervalReportBuilder;
import pro.taskana.monitor.api.reports.header.TimeIntervalColumnHeader;
import pro.taskana.monitor.api.reports.item.AgeQueryItem;
import pro.taskana.monitor.internal.MonitorMapper;
import pro.taskana.monitor.internal.preprocessor.WorkingDaysToDaysReportConverter;
import pro.taskana.task.api.TaskCustomField;
import pro.taskana.task.api.TaskState;

abstract class TimeIntervalReportBuilderImpl<B extends TimeIntervalReportBuilder<B, I, H>, I extends AgeQueryItem, H extends TimeIntervalColumnHeader>
implements TimeIntervalReportBuilder<B, I, H> {
    protected InternalTaskanaEngine taskanaEngine;
    protected MonitorMapper monitorMapper;
    protected List<H> columnHeaders;
    protected boolean inWorkingDays;
    protected List<String> workbasketIds;
    protected List<TaskState> states;
    protected List<String> classificationCategory;
    protected List<String> domains;
    protected List<String> classificationIds;
    protected List<String> excludedClassificationIds;
    protected Map<TaskCustomField, String> customAttributeFilter;
    protected WorkingDaysToDaysConverter converter;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;

    TimeIntervalReportBuilderImpl(InternalTaskanaEngine taskanaEngine, MonitorMapper monitorMapper) {
        this.taskanaEngine = taskanaEngine;
        this.monitorMapper = monitorMapper;
        this.columnHeaders = Collections.emptyList();
        this.converter = taskanaEngine.getEngine().getWorkingDaysToDaysConverter();
    }

    @Override
    public B withColumnHeaders(List<H> columnHeaders) {
        B b;
        B b2;
        List<H> list = columnHeaders;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, list);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.columnHeaders = columnHeaders;
        B b3 = b2 = (b = this._this());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, b2);
        return b;
    }

    @Override
    public B inWorkingDays() {
        B b;
        B b2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.inWorkingDays = true;
        B b3 = b2 = (b = this._this());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, b2);
        return b;
    }

    @Override
    public B workbasketIdIn(List<String> workbasketIds) {
        B b;
        B b2;
        List<String> list = workbasketIds;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, list);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.workbasketIds = new ArrayList<String>(workbasketIds);
        B b3 = b2 = (b = this._this());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, b2);
        return b;
    }

    @Override
    public B stateIn(List<TaskState> states) {
        B b;
        B b2;
        List<TaskState> list = states;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, list);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.states = new ArrayList<TaskState>(states);
        B b3 = b2 = (b = this._this());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, b2);
        return b;
    }

    @Override
    public B classificationCategoryIn(List<String> classificationCategory) {
        B b;
        B b2;
        List<String> list = classificationCategory;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, list);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.classificationCategory = new ArrayList<String>(classificationCategory);
        B b3 = b2 = (b = this._this());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, b2);
        return b;
    }

    @Override
    public B classificationIdIn(List<String> classificationIds) {
        B b;
        B b2;
        List<String> list = classificationIds;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, list);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.classificationIds = new ArrayList<String>(classificationIds);
        B b3 = b2 = (b = this._this());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, b2);
        return b;
    }

    @Override
    public B excludedClassificationIdIn(List<String> excludedClassificationIds) {
        B b;
        B b2;
        List<String> list = excludedClassificationIds;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, list);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.excludedClassificationIds = new ArrayList<String>(excludedClassificationIds);
        B b3 = b2 = (b = this._this());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, b2);
        return b;
    }

    @Override
    public B domainIn(List<String> domains) {
        B b;
        B b2;
        List<String> list = domains;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, list);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.domains = new ArrayList<String>(domains);
        B b3 = b2 = (b = this._this());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, b2);
        return b;
    }

    @Override
    public B customAttributeFilterIn(Map<TaskCustomField, String> customAttributeFilter) {
        B b;
        B b2;
        Map<TaskCustomField, String> map = customAttributeFilter;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, map);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.customAttributeFilter = new HashMap<TaskCustomField, String>(customAttributeFilter);
        B b3 = b2 = (b = this._this());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, b2);
        return b;
    }

    @Override
    public List<String> listTaskIdsForSelectedItems(List<SelectedItem> selectedItems, TaskTimestamp timestamp) throws NotAuthorizedException, InvalidArgumentException {
        List<String> list;
        List<String> list2;
        List<SelectedItem> list3 = selectedItems;
        TaskTimestamp taskTimestamp = timestamp;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, list3, (Object)((Object)taskTimestamp));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.taskanaEngine.getEngine().checkRoleMembership(TaskanaRole.MONITOR);
        try {
            this.taskanaEngine.openConnection();
            if (this.columnHeaders == null) {
                throw new InvalidArgumentException("ColumnHeader must not be null.");
            }
            if (selectedItems == null || selectedItems.isEmpty()) {
                throw new InvalidArgumentException("SelectedItems must not be null or empty.");
            }
            boolean joinWithAttachments = this.subKeyIsSet(selectedItems);
            if (!(this instanceof ClassificationReport.Builder) && joinWithAttachments) {
                throw new InvalidArgumentException("SubKeys are supported for ClassificationReport only.");
            }
            List<CombinedClassificationFilter> combinedClassificationFilter = this.getCombinedClassificationFilter();
            joinWithAttachments |= combinedClassificationFilter != null;
            if (this.inWorkingDays) {
                selectedItems = this.convertWorkingDaysToDays(selectedItems, this.columnHeaders);
            }
            List<String> list4 = this.monitorMapper.getTaskIdsForSelectedItems(Instant.now(), this.workbasketIds, this.states, this.classificationCategory, this.domains, this.classificationIds, this.excludedClassificationIds, this.customAttributeFilter, combinedClassificationFilter, this.determineGroupedBy(), timestamp, selectedItems, joinWithAttachments);
            list2 = list4;
        }
        finally {
            this.taskanaEngine.returnConnection();
        }
        List<String> list5 = list = list2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, list);
        return list2;
    }

    @Override
    public List<String> listCustomAttributeValuesForCustomAttributeName(TaskCustomField taskCustomField) throws NotAuthorizedException {
        List<String> list;
        List<String> list2;
        TaskCustomField taskCustomField2 = taskCustomField;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, (Object)((Object)taskCustomField2));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.taskanaEngine.getEngine().checkRoleMembership(TaskanaRole.MONITOR);
        try {
            this.taskanaEngine.openConnection();
            List<String> list3 = this.monitorMapper.getCustomAttributeValuesForReport(this.workbasketIds, this.states, this.classificationCategory, this.domains, this.classificationIds, this.excludedClassificationIds, this.customAttributeFilter, this.getCombinedClassificationFilter(), taskCustomField);
            list2 = list3;
        }
        finally {
            this.taskanaEngine.returnConnection();
        }
        List<String> list4 = list = list2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, list);
        return list2;
    }

    protected abstract B _this();

    protected abstract String determineGroupedBy();

    protected List<CombinedClassificationFilter> getCombinedClassificationFilter() {
        List<CombinedClassificationFilter> list;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        List<CombinedClassificationFilter> list2 = null;
        List<CombinedClassificationFilter> list3 = list = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, list);
        return list2;
    }

    private List<SelectedItem> convertWorkingDaysToDays(List<SelectedItem> selectedItems, List<H> columnHeaders) throws InvalidArgumentException {
        List<SelectedItem> list;
        List<SelectedItem> list2;
        List<SelectedItem> list3 = selectedItems;
        List<H> list4 = columnHeaders;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this, list3, list4);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        WorkingDaysToDaysReportConverter instance = WorkingDaysToDaysReportConverter.initialize(columnHeaders, this.converter);
        List<SelectedItem> list5 = list2 = (list = selectedItems.stream().map(s -> new SelectedItem(s.getKey(), s.getSubKey(), Collections.min(instance.convertWorkingDaysToDays(s.getLowerAgeLimit())), Collections.max(instance.convertWorkingDaysToDays(s.getUpperAgeLimit())))).collect(Collectors.toList()));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, list2);
        return list;
    }

    private boolean subKeyIsSet(List<SelectedItem> selectedItems) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        JoinPoint joinPoint;
        block1: {
            List<SelectedItem> list = selectedItems;
            joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this, list);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            for (SelectedItem selectedItem : selectedItems) {
                if (selectedItem.getSubKey() == null || selectedItem.getSubKey().isEmpty()) continue;
                bl2 = bl3 = true;
                break block1;
            }
            bl2 = bl3 = false;
        }
        boolean bl4 = bl = bl2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl));
        return bl3;
    }

    static {
        TimeIntervalReportBuilderImpl.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("TimeIntervalReportBuilderImpl.java", TimeIntervalReportBuilderImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withColumnHeaders", "pro.taskana.monitor.internal.reports.TimeIntervalReportBuilderImpl", "java.util.List", "columnHeaders", "", "pro.taskana.monitor.api.reports.TimeIntervalReportBuilder"), 62);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "inWorkingDays", "pro.taskana.monitor.internal.reports.TimeIntervalReportBuilderImpl", "", "", "", "pro.taskana.monitor.api.reports.TimeIntervalReportBuilder"), 68);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "listCustomAttributeValuesForCustomAttributeName", "pro.taskana.monitor.internal.reports.TimeIntervalReportBuilderImpl", "pro.taskana.task.api.TaskCustomField", "taskCustomField", "pro.taskana.common.api.exceptions.NotAuthorizedException", "java.util.List"), 159);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getCombinedClassificationFilter", "pro.taskana.monitor.internal.reports.TimeIntervalReportBuilderImpl", "", "", "", "java.util.List"), 184);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "convertWorkingDaysToDays", "pro.taskana.monitor.internal.reports.TimeIntervalReportBuilderImpl", "java.util.List:java.util.List", "selectedItems:columnHeaders", "pro.taskana.common.api.exceptions.InvalidArgumentException", "java.util.List"), 191);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "subKeyIsSet", "pro.taskana.monitor.internal.reports.TimeIntervalReportBuilderImpl", "java.util.List", "selectedItems", "", "boolean"), 206);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "workbasketIdIn", "pro.taskana.monitor.internal.reports.TimeIntervalReportBuilderImpl", "java.util.List", "workbasketIds", "", "pro.taskana.monitor.api.reports.TimeIntervalReportBuilder"), 74);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "stateIn", "pro.taskana.monitor.internal.reports.TimeIntervalReportBuilderImpl", "java.util.List", "states", "", "pro.taskana.monitor.api.reports.TimeIntervalReportBuilder"), 80);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "classificationCategoryIn", "pro.taskana.monitor.internal.reports.TimeIntervalReportBuilderImpl", "java.util.List", "classificationCategory", "", "pro.taskana.monitor.api.reports.TimeIntervalReportBuilder"), 86);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "classificationIdIn", "pro.taskana.monitor.internal.reports.TimeIntervalReportBuilderImpl", "java.util.List", "classificationIds", "", "pro.taskana.monitor.api.reports.TimeIntervalReportBuilder"), 92);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "excludedClassificationIdIn", "pro.taskana.monitor.internal.reports.TimeIntervalReportBuilderImpl", "java.util.List", "excludedClassificationIds", "", "pro.taskana.monitor.api.reports.TimeIntervalReportBuilder"), 98);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "domainIn", "pro.taskana.monitor.internal.reports.TimeIntervalReportBuilderImpl", "java.util.List", "domains", "", "pro.taskana.monitor.api.reports.TimeIntervalReportBuilder"), 104);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "customAttributeFilterIn", "pro.taskana.monitor.internal.reports.TimeIntervalReportBuilderImpl", "java.util.Map", "customAttributeFilter", "", "pro.taskana.monitor.api.reports.TimeIntervalReportBuilder"), 110);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "listTaskIdsForSelectedItems", "pro.taskana.monitor.internal.reports.TimeIntervalReportBuilderImpl", "java.util.List:pro.taskana.monitor.api.TaskTimestamp", "selectedItems:timestamp", "pro.taskana.common.api.exceptions.NotAuthorizedException:pro.taskana.common.api.exceptions.InvalidArgumentException", "java.util.List"), 116);
    }
}

