/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.task.internal;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ibatis.exceptions.PersistenceException;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.classification.api.ClassificationService;
import pro.taskana.classification.api.exceptions.ClassificationNotFoundException;
import pro.taskana.classification.api.models.Classification;
import pro.taskana.classification.api.models.ClassificationSummary;
import pro.taskana.common.api.BulkOperationResults;
import pro.taskana.common.api.TaskanaRole;
import pro.taskana.common.api.exceptions.ConcurrencyException;
import pro.taskana.common.api.exceptions.InvalidArgumentException;
import pro.taskana.common.api.exceptions.NotAuthorizedException;
import pro.taskana.common.api.exceptions.SystemException;
import pro.taskana.common.api.exceptions.TaskanaException;
import pro.taskana.common.internal.InternalTaskanaEngine;
import pro.taskana.common.internal.logging.LoggingAspect;
import pro.taskana.common.internal.util.CheckedConsumer;
import pro.taskana.common.internal.util.CollectionUtil;
import pro.taskana.common.internal.util.IdGenerator;
import pro.taskana.common.internal.util.ObjectAttributeChangeDetector;
import pro.taskana.common.internal.util.Pair;
import pro.taskana.spi.history.api.events.task.TaskCancelledEvent;
import pro.taskana.spi.history.api.events.task.TaskClaimCancelledEvent;
import pro.taskana.spi.history.api.events.task.TaskClaimedEvent;
import pro.taskana.spi.history.api.events.task.TaskCompletedEvent;
import pro.taskana.spi.history.api.events.task.TaskCreatedEvent;
import pro.taskana.spi.history.api.events.task.TaskTerminatedEvent;
import pro.taskana.spi.history.api.events.task.TaskUpdatedEvent;
import pro.taskana.spi.history.internal.HistoryEventManager;
import pro.taskana.spi.task.internal.CreateTaskPreprocessorManager;
import pro.taskana.task.api.CallbackState;
import pro.taskana.task.api.TaskCustomField;
import pro.taskana.task.api.TaskQuery;
import pro.taskana.task.api.TaskService;
import pro.taskana.task.api.TaskState;
import pro.taskana.task.api.exceptions.AttachmentPersistenceException;
import pro.taskana.task.api.exceptions.InvalidOwnerException;
import pro.taskana.task.api.exceptions.InvalidStateException;
import pro.taskana.task.api.exceptions.TaskAlreadyExistException;
import pro.taskana.task.api.exceptions.TaskCommentNotFoundException;
import pro.taskana.task.api.exceptions.TaskNotFoundException;
import pro.taskana.task.api.exceptions.UpdateFailedException;
import pro.taskana.task.api.models.Attachment;
import pro.taskana.task.api.models.ObjectReference;
import pro.taskana.task.api.models.Task;
import pro.taskana.task.api.models.TaskComment;
import pro.taskana.task.api.models.TaskSummary;
import pro.taskana.task.internal.AttachmentHandler;
import pro.taskana.task.internal.AttachmentMapper;
import pro.taskana.task.internal.ServiceLevelHandler;
import pro.taskana.task.internal.TaskCommentMapper;
import pro.taskana.task.internal.TaskCommentServiceImpl;
import pro.taskana.task.internal.TaskCustomPropertySelector;
import pro.taskana.task.internal.TaskMapper;
import pro.taskana.task.internal.TaskQueryImpl;
import pro.taskana.task.internal.TaskTransferrer;
import pro.taskana.task.internal.models.AttachmentImpl;
import pro.taskana.task.internal.models.AttachmentSummaryImpl;
import pro.taskana.task.internal.models.MinimalTaskSummary;
import pro.taskana.task.internal.models.TaskImpl;
import pro.taskana.task.internal.models.TaskSummaryImpl;
import pro.taskana.workbasket.api.WorkbasketPermission;
import pro.taskana.workbasket.api.WorkbasketService;
import pro.taskana.workbasket.api.exceptions.WorkbasketNotFoundException;
import pro.taskana.workbasket.api.models.Workbasket;
import pro.taskana.workbasket.api.models.WorkbasketSummary;
import pro.taskana.workbasket.internal.WorkbasketQueryImpl;
import pro.taskana.workbasket.internal.models.WorkbasketSummaryImpl;

public class TaskServiceImpl
implements TaskService {
    private static final Logger LOGGER;
    private final InternalTaskanaEngine taskanaEngine;
    private final WorkbasketService workbasketService;
    private final ClassificationService classificationService;
    private final TaskMapper taskMapper;
    private final TaskTransferrer taskTransferrer;
    private final TaskCommentServiceImpl taskCommentService;
    private final ServiceLevelHandler serviceLevelHandler;
    private final AttachmentHandler attachmentHandler;
    private final AttachmentMapper attachmentMapper;
    private final HistoryEventManager historyEventManager;
    private final CreateTaskPreprocessorManager createTaskPreprocessorManager;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_16;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_17;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_18;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_19;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_20;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_21;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_22;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_23;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_24;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_25;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_26;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_27;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_28;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_29;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_30;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_31;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_32;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_33;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_34;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_35;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_36;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_37;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_38;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_39;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_40;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_41;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_42;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_43;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_44;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_45;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_46;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_47;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_48;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_49;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_50;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_51;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_52;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_53;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_54;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_55;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_56;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_57;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_58;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_59;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_60;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_61;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_62;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_63;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_64;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_65;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_66;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_67;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_68;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_69;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_70;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_71;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_72;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_73;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_74;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_75;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_76;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_77;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_78;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_79;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_80;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_81;

    static {
        TaskServiceImpl.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(TaskServiceImpl.class);
    }

    public TaskServiceImpl(InternalTaskanaEngine taskanaEngine, TaskMapper taskMapper, TaskCommentMapper taskCommentMapper, AttachmentMapper attachmentMapper) {
        this.taskanaEngine = taskanaEngine;
        this.taskMapper = taskMapper;
        this.workbasketService = taskanaEngine.getEngine().getWorkbasketService();
        this.attachmentMapper = attachmentMapper;
        this.classificationService = taskanaEngine.getEngine().getClassificationService();
        this.historyEventManager = taskanaEngine.getHistoryEventManager();
        this.createTaskPreprocessorManager = taskanaEngine.getCreateTaskPreprocessorManager();
        this.taskTransferrer = new TaskTransferrer(taskanaEngine, taskMapper, this);
        this.taskCommentService = new TaskCommentServiceImpl(taskanaEngine, taskCommentMapper, this);
        this.serviceLevelHandler = new ServiceLevelHandler(taskanaEngine, taskMapper, attachmentMapper);
        this.attachmentHandler = new AttachmentHandler(attachmentMapper, this.classificationService);
    }

    @Override
    public Task claim(String taskId) throws TaskNotFoundException, InvalidStateException, InvalidOwnerException, NotAuthorizedException {
        Task task;
        Task task2;
        String string = taskId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Task task3 = task2 = (task = this.claim(taskId, false));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)task2);
        return task;
    }

    @Override
    public Task forceClaim(String taskId) throws TaskNotFoundException, InvalidStateException, InvalidOwnerException, NotAuthorizedException {
        Task task;
        Task task2;
        String string = taskId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Task task3 = task2 = (task = this.claim(taskId, true));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)task2);
        return task;
    }

    @Override
    public Task cancelClaim(String taskId) throws TaskNotFoundException, InvalidStateException, InvalidOwnerException, NotAuthorizedException {
        Task task;
        Task task2;
        String string = taskId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Task task3 = task2 = (task = this.cancelClaim(taskId, false));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)task2);
        return task;
    }

    @Override
    public Task forceCancelClaim(String taskId) throws TaskNotFoundException, InvalidStateException, InvalidOwnerException, NotAuthorizedException {
        Task task;
        Task task2;
        String string = taskId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Task task3 = task2 = (task = this.cancelClaim(taskId, true));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)task2);
        return task;
    }

    @Override
    public Task completeTask(String taskId) throws TaskNotFoundException, InvalidOwnerException, InvalidStateException, NotAuthorizedException {
        Task task;
        Task task2;
        String string = taskId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Task task3 = task2 = (task = this.completeTask(taskId, false));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)task2);
        return task;
    }

    @Override
    public Task forceCompleteTask(String taskId) throws TaskNotFoundException, InvalidOwnerException, InvalidStateException, NotAuthorizedException {
        Task task;
        Task task2;
        String string = taskId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Task task3 = task2 = (task = this.completeTask(taskId, true));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)task2);
        return task;
    }

    @Override
    public Task createTask(Task taskToCreate) throws NotAuthorizedException, WorkbasketNotFoundException, ClassificationNotFoundException, TaskAlreadyExistException, InvalidArgumentException {
        TaskImpl taskImpl;
        TaskImpl taskImpl2;
        Task task = taskToCreate;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)task);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (CreateTaskPreprocessorManager.isCreateTaskPreprocessorEnabled()) {
            taskToCreate = this.createTaskPreprocessorManager.processTaskBeforeCreation(taskToCreate);
        }
        TaskImpl task2 = (TaskImpl)taskToCreate;
        try {
            Workbasket workbasket;
            this.taskanaEngine.openConnection();
            if (task2.getId() != null && !task2.getId().isEmpty()) {
                throw new InvalidArgumentException("taskId must be empty when creating a task");
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Task {} cannot be found, so it can be created.", (Object)task2.getId());
            }
            if (task2.getWorkbasketSummary().getId() != null) {
                workbasket = this.workbasketService.getWorkbasket(task2.getWorkbasketSummary().getId());
            } else if (task2.getWorkbasketKey() != null) {
                workbasket = this.workbasketService.getWorkbasket(task2.getWorkbasketKey(), task2.getDomain());
            } else {
                String workbasketId = this.taskanaEngine.getTaskRoutingManager().determineWorkbasketId(task2);
                if (workbasketId != null) {
                    workbasket = this.workbasketService.getWorkbasket(workbasketId);
                    task2.setWorkbasketSummary(workbasket.asSummary());
                } else {
                    throw new InvalidArgumentException("Cannot create a task outside a workbasket");
                }
            }
            if (workbasket.isMarkedForDeletion()) {
                throw new WorkbasketNotFoundException(workbasket.getId(), "The workbasket " + workbasket.getId() + " was marked for deletion");
            }
            task2.setWorkbasketSummary(workbasket.asSummary());
            task2.setDomain(workbasket.getDomain());
            this.workbasketService.checkAuthorization(task2.getWorkbasketSummary().getId(), WorkbasketPermission.APPEND);
            String classificationKey = task2.getClassificationKey();
            if (classificationKey == null || classificationKey.length() == 0) {
                throw new InvalidArgumentException("classificationKey of task must not be empty");
            }
            Classification classification = this.classificationService.getClassification(classificationKey, workbasket.getDomain());
            task2.setClassificationSummary(classification.asSummary());
            ObjectReference.validate(task2.getPrimaryObjRef(), "primary ObjectReference", "Task");
            this.standardSettings(task2, classification);
            this.setCallbackStateOnTaskCreation(task2);
            try {
                this.taskMapper.insert(task2);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Method createTask() created Task '{}'.", (Object)task2.getId());
                }
                if (HistoryEventManager.isHistoryEnabled()) {
                    String details = ObjectAttributeChangeDetector.determineChangesInAttributes((Object)this.newTask(), (Object)task2);
                    this.historyEventManager.createEvent(new TaskCreatedEvent(IdGenerator.generateWithPrefix((String)"THI"), task2, this.taskanaEngine.getEngine().getCurrentUserContext().getUserid(), details));
                }
            }
            catch (PersistenceException e) {
                String msg;
                String string = msg = e.getMessage() != null ? e.getMessage().toLowerCase() : null;
                if (msg != null && (msg.contains("violation") || msg.contains("violates") || msg.contains("verletzt")) && msg.contains("external_id")) {
                    throw new TaskAlreadyExistException("Task with external id " + task2.getExternalId() + " already exists");
                }
                throw e;
            }
            TaskImpl taskImpl3 = task2;
            taskImpl2 = taskImpl3;
        }
        finally {
            this.taskanaEngine.returnConnection();
        }
        TaskImpl taskImpl4 = taskImpl = taskImpl2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskImpl);
        return taskImpl2;
    }

    @Override
    public Task getTask(String id) throws NotAuthorizedException, TaskNotFoundException {
        TaskImpl taskImpl;
        TaskImpl taskImpl2;
        JoinPoint joinPoint;
        block8: {
            String string = id;
            joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)string);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            TaskImpl resultTask = null;
            try {
                this.taskanaEngine.openConnection();
                resultTask = this.taskMapper.findById(id);
                if (resultTask != null) {
                    WorkbasketQueryImpl query = (WorkbasketQueryImpl)this.workbasketService.createWorkbasketQuery();
                    query.setUsedToAugmentTasks(true);
                    String workbasketId = resultTask.getWorkbasketSummary().getId();
                    List workbaskets = query.idIn(workbasketId).list();
                    if (workbaskets.isEmpty()) {
                        String currentUser = this.taskanaEngine.getEngine().getCurrentUserContext().getUserid();
                        throw new NotAuthorizedException("The current user " + currentUser + " has no read permission for workbasket " + workbasketId, this.taskanaEngine.getEngine().getCurrentUserContext().getUserid());
                    }
                    resultTask.setWorkbasketSummary((WorkbasketSummary)workbaskets.get(0));
                    List<AttachmentImpl> attachmentImpls = this.attachmentMapper.findAttachmentsByTaskId(resultTask.getId());
                    if (attachmentImpls == null) {
                        attachmentImpls = new ArrayList<AttachmentImpl>();
                    }
                    List<ClassificationSummary> classifications = this.findClassificationForTaskImplAndAttachments(resultTask, attachmentImpls);
                    List<Attachment> attachments = this.addClassificationSummariesToAttachments(attachmentImpls, classifications);
                    resultTask.setAttachments(attachments);
                    String classificationId = resultTask.getClassificationSummary().getId();
                    ClassificationSummary classification = classifications.stream().filter(c -> c.getId().equals(classificationId)).findFirst().orElse(null);
                    if (classification == null) {
                        throw new SystemException("Could not find a Classification for task " + resultTask.getId());
                    }
                    resultTask.setClassificationSummary(classification);
                    TaskImpl taskImpl3 = resultTask;
                    taskImpl2 = taskImpl3;
                    break block8;
                }
                throw new TaskNotFoundException(id, String.format("Task with id %s was not found.", id));
            }
            finally {
                this.taskanaEngine.returnConnection();
            }
        }
        TaskImpl taskImpl4 = taskImpl = taskImpl2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskImpl);
        return taskImpl2;
    }

    @Override
    public Task transfer(String taskId, String destinationWorkbasketId, boolean setTransferFlag) throws TaskNotFoundException, WorkbasketNotFoundException, NotAuthorizedException, InvalidStateException {
        Task task;
        Task task2;
        String string = taskId;
        String string2 = destinationWorkbasketId;
        boolean bl = setTransferFlag;
        Object[] objectArray = new Object[]{string, string2, Conversions.booleanObject((boolean)bl)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Task task3 = task2 = (task = this.taskTransferrer.transfer(taskId, destinationWorkbasketId, setTransferFlag));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)task2);
        return task;
    }

    @Override
    public Task transfer(String taskId, String workbasketKey, String domain, boolean setTransferFlag) throws TaskNotFoundException, WorkbasketNotFoundException, NotAuthorizedException, InvalidStateException {
        Task task;
        Task task2;
        String string = taskId;
        String string2 = workbasketKey;
        String string3 = domain;
        boolean bl = setTransferFlag;
        Object[] objectArray = new Object[]{string, string2, string3, Conversions.booleanObject((boolean)bl)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Task task3 = task2 = (task = this.taskTransferrer.transfer(taskId, workbasketKey, domain, setTransferFlag));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)task2);
        return task;
    }

    @Override
    public Task setTaskRead(String taskId, boolean isRead) throws TaskNotFoundException, NotAuthorizedException {
        TaskImpl taskImpl;
        TaskImpl taskImpl2;
        String string = taskId;
        boolean bl = isRead;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, (Object)string, (Object)Conversions.booleanObject((boolean)bl));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        TaskImpl task = null;
        try {
            this.taskanaEngine.openConnection();
            task = (TaskImpl)this.getTask(taskId);
            task.setRead(isRead);
            task.setModified(Instant.now());
            this.taskMapper.update(task);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Method setTaskRead() set read property of Task '{}' to {} ", (Object)task, (Object)isRead);
            }
            TaskImpl taskImpl3 = task;
            taskImpl2 = taskImpl3;
        }
        finally {
            this.taskanaEngine.returnConnection();
        }
        TaskImpl taskImpl4 = taskImpl = taskImpl2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskImpl);
        return taskImpl2;
    }

    @Override
    public TaskQuery createTaskQuery() {
        TaskQueryImpl taskQueryImpl;
        TaskQueryImpl taskQueryImpl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        TaskQueryImpl taskQueryImpl3 = taskQueryImpl2 = (taskQueryImpl = new TaskQueryImpl(this.taskanaEngine));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskQueryImpl2);
        return taskQueryImpl;
    }

    @Override
    public Task newTask() {
        Task task;
        Task task2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Task task3 = task2 = (task = this.newTask(null));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)task2);
        return task;
    }

    @Override
    public Task newTask(String workbasketId) {
        TaskImpl taskImpl;
        TaskImpl taskImpl2;
        String string = workbasketId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        TaskImpl task = new TaskImpl();
        WorkbasketSummaryImpl wb = new WorkbasketSummaryImpl();
        wb.setId(workbasketId);
        task.setWorkbasketSummary(wb);
        task.setCallbackState(CallbackState.NONE);
        TaskImpl taskImpl3 = taskImpl2 = (taskImpl = task);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskImpl2);
        return taskImpl;
    }

    @Override
    public Task newTask(String workbasketKey, String domain) {
        TaskImpl taskImpl;
        TaskImpl taskImpl2;
        String string = workbasketKey;
        String string2 = domain;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)this, (Object)this, (Object)string, (Object)string2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        TaskImpl task = new TaskImpl();
        WorkbasketSummaryImpl wb = new WorkbasketSummaryImpl();
        wb.setKey(workbasketKey);
        wb.setDomain(domain);
        task.setWorkbasketSummary(wb);
        TaskImpl taskImpl3 = taskImpl2 = (taskImpl = task);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskImpl2);
        return taskImpl;
    }

    @Override
    public TaskComment newTaskComment(String taskId) {
        TaskComment taskComment;
        TaskComment taskComment2;
        String string = taskId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        TaskComment taskComment3 = taskComment2 = (taskComment = this.taskCommentService.newTaskComment(taskId));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskComment2);
        return taskComment;
    }

    @Override
    public Attachment newAttachment() {
        AttachmentImpl attachmentImpl;
        AttachmentImpl attachmentImpl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        AttachmentImpl attachmentImpl3 = attachmentImpl2 = (attachmentImpl = new AttachmentImpl());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)attachmentImpl2);
        return attachmentImpl;
    }

    @Override
    public Task updateTask(Task task) throws InvalidArgumentException, TaskNotFoundException, ConcurrencyException, NotAuthorizedException, AttachmentPersistenceException, InvalidStateException, ClassificationNotFoundException {
        Task task2;
        Task task3;
        Task task4 = task;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_17, (Object)this, (Object)this, (Object)task4);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String userId = this.taskanaEngine.getEngine().getCurrentUserContext().getUserid();
        TaskImpl newTaskImpl = (TaskImpl)task;
        try {
            this.taskanaEngine.openConnection();
            TaskImpl oldTaskImpl = (TaskImpl)this.getTask(newTaskImpl.getId());
            this.checkConcurrencyAndSetModified(newTaskImpl, oldTaskImpl);
            this.attachmentHandler.insertAndDeleteAttachmentsOnTaskUpdate(newTaskImpl, oldTaskImpl);
            ObjectReference.validate(newTaskImpl.getPrimaryObjRef(), "primary ObjectReference", "Task");
            this.standardUpdateActions(oldTaskImpl, newTaskImpl);
            this.taskMapper.update(newTaskImpl);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Method updateTask() updated task '{}' for user '{}'.", (Object)task.getId(), (Object)userId);
            }
            if (HistoryEventManager.isHistoryEnabled()) {
                String changeDetails = ObjectAttributeChangeDetector.determineChangesInAttributes((Object)oldTaskImpl, (Object)newTaskImpl);
                this.historyEventManager.createEvent(new TaskUpdatedEvent(IdGenerator.generateWithPrefix((String)"THI"), task, this.taskanaEngine.getEngine().getCurrentUserContext().getUserid(), changeDetails));
            }
        }
        finally {
            this.taskanaEngine.returnConnection();
        }
        Task task5 = task3 = (task2 = task);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)task3);
        return task2;
    }

    @Override
    public BulkOperationResults<String, TaskanaException> transferTasks(String destinationWorkbasketId, List<String> taskIds, boolean setTransferFlag) throws NotAuthorizedException, InvalidArgumentException, WorkbasketNotFoundException {
        BulkOperationResults<String, TaskanaException> bulkOperationResults;
        BulkOperationResults<String, TaskanaException> bulkOperationResults2;
        String string = destinationWorkbasketId;
        List<String> list = taskIds;
        boolean bl = setTransferFlag;
        Object[] objectArray = new Object[]{string, list, Conversions.booleanObject((boolean)bl)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_18, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        BulkOperationResults<String, TaskanaException> bulkOperationResults3 = bulkOperationResults2 = (bulkOperationResults = this.taskTransferrer.transfer(taskIds, destinationWorkbasketId, setTransferFlag));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, bulkOperationResults2);
        return bulkOperationResults;
    }

    @Override
    public BulkOperationResults<String, TaskanaException> transferTasks(String destinationWorkbasketKey, String destinationWorkbasketDomain, List<String> taskIds, boolean setTransferFlag) throws NotAuthorizedException, InvalidArgumentException, WorkbasketNotFoundException {
        BulkOperationResults<String, TaskanaException> bulkOperationResults;
        BulkOperationResults<String, TaskanaException> bulkOperationResults2;
        String string = destinationWorkbasketKey;
        String string2 = destinationWorkbasketDomain;
        List<String> list = taskIds;
        boolean bl = setTransferFlag;
        Object[] objectArray = new Object[]{string, string2, list, Conversions.booleanObject((boolean)bl)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_19, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        BulkOperationResults<String, TaskanaException> bulkOperationResults3 = bulkOperationResults2 = (bulkOperationResults = this.taskTransferrer.transfer(taskIds, destinationWorkbasketKey, destinationWorkbasketDomain, setTransferFlag));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, bulkOperationResults2);
        return bulkOperationResults;
    }

    @Override
    public void deleteTask(String taskId) throws TaskNotFoundException, InvalidStateException, NotAuthorizedException {
        String string = taskId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_20, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.deleteTask(taskId, false);
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    @Override
    public void forceDeleteTask(String taskId) throws TaskNotFoundException, InvalidStateException, NotAuthorizedException {
        String string = taskId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_21, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.deleteTask(taskId, true);
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    @Override
    public Task selectAndClaim(TaskQuery taskQuery) throws NotAuthorizedException, InvalidOwnerException {
        Task task;
        Task task2;
        TaskQuery taskQuery2 = taskQuery;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_22, (Object)this, (Object)this, (Object)taskQuery2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        try {
            this.taskanaEngine.openConnection();
            ((TaskQueryImpl)taskQuery).selectAndClaimEquals(true);
            TaskSummary taskSummary = (TaskSummary)taskQuery.single();
            if (taskSummary == null) {
                throw new SystemException("No tasks matched the specified filter and sorting options, task query returned nothing!");
            }
            Task task3 = this.claim(taskSummary.getId());
            task2 = task3;
        }
        catch (InvalidStateException | TaskNotFoundException e) {
            throw new SystemException("Caught exception ", (Throwable)e);
        }
        finally {
            this.taskanaEngine.returnConnection();
        }
        Task task4 = task = task2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)task);
        return task2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public BulkOperationResults<String, TaskanaException> deleteTasks(List<String> taskIds) throws InvalidArgumentException, NotAuthorizedException {
        BulkOperationResults bulkOperationResults;
        BulkOperationResults bulkOperationResults2;
        BulkOperationResults bulkOperationResults3;
        JoinPoint joinPoint;
        block9: {
            List<String> list = taskIds;
            joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_23, (Object)this, (Object)this, list);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.taskanaEngine.getEngine().checkRoleMembership(TaskanaRole.ADMIN);
            this.taskanaEngine.openConnection();
            if (taskIds == null) {
                throw new InvalidArgumentException("List of TaskIds must not be null.");
            }
            taskIds = new ArrayList<String>(taskIds);
            BulkOperationResults bulkLog = new BulkOperationResults();
            if (taskIds.isEmpty()) {
                BulkOperationResults bulkOperationResults4 = bulkLog;
                bulkOperationResults2 = bulkOperationResults3 = bulkOperationResults4;
                break block9;
            }
            List<MinimalTaskSummary> taskSummaries = this.taskMapper.findExistingTasks(taskIds, null);
            Iterator<String> taskIdIterator = taskIds.iterator();
            while (taskIdIterator.hasNext()) {
                this.removeSingleTaskForTaskDeletionById((BulkOperationResults<String, TaskanaException>)bulkLog, taskSummaries, taskIdIterator);
            }
            if (!taskIds.isEmpty()) {
                this.attachmentMapper.deleteMultipleByTaskIds(taskIds);
                this.taskMapper.deleteMultiple(taskIds);
                if (this.taskanaEngine.getEngine().isHistoryEnabled() && this.taskanaEngine.getEngine().getConfiguration().isDeleteHistoryOnTaskDeletionEnabled()) {
                    this.historyEventManager.deleteEvents(taskIds);
                }
            }
            BulkOperationResults bulkOperationResults5 = bulkLog;
            bulkOperationResults2 = bulkOperationResults3 = bulkOperationResults5;
            break block9;
            finally {
                this.taskanaEngine.returnConnection();
            }
        }
        BulkOperationResults bulkOperationResults6 = bulkOperationResults = bulkOperationResults2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)bulkOperationResults);
        return bulkOperationResults3;
    }

    @Override
    public BulkOperationResults<String, TaskanaException> completeTasks(List<String> taskIds) throws InvalidArgumentException {
        BulkOperationResults<String, TaskanaException> bulkOperationResults;
        BulkOperationResults<String, TaskanaException> bulkOperationResults2;
        List<String> list = taskIds;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_24, (Object)this, (Object)this, list);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        BulkOperationResults<String, TaskanaException> bulkOperationResults3 = bulkOperationResults2 = (bulkOperationResults = this.completeTasks(taskIds, false));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, bulkOperationResults2);
        return bulkOperationResults;
    }

    @Override
    public BulkOperationResults<String, TaskanaException> forceCompleteTasks(List<String> taskIds) throws InvalidArgumentException {
        BulkOperationResults<String, TaskanaException> bulkOperationResults;
        BulkOperationResults<String, TaskanaException> bulkOperationResults2;
        List<String> list = taskIds;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_25, (Object)this, (Object)this, list);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        BulkOperationResults<String, TaskanaException> bulkOperationResults3 = bulkOperationResults2 = (bulkOperationResults = this.completeTasks(taskIds, true));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, bulkOperationResults2);
        return bulkOperationResults;
    }

    @Override
    public List<String> updateTasks(ObjectReference selectionCriteria, Map<TaskCustomField, String> customFieldsToUpdate) throws InvalidArgumentException {
        ArrayList<String> arrayList;
        ArrayList<String> arrayList2;
        ObjectReference objectReference = selectionCriteria;
        Map<TaskCustomField, String> map = customFieldsToUpdate;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_26, (Object)this, (Object)this, (Object)objectReference, map);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ObjectReference.validate(selectionCriteria, "ObjectReference", "updateTasks call");
        this.validateCustomFields(customFieldsToUpdate);
        TaskCustomPropertySelector fieldSelector = new TaskCustomPropertySelector();
        TaskImpl updated = this.initUpdatedTask(customFieldsToUpdate, fieldSelector);
        try {
            this.taskanaEngine.openConnection();
            List<TaskSummary> taskSummaries = this.getTasksToChange(selectionCriteria);
            ArrayList<String> changedTasks = new ArrayList<String>();
            if (!taskSummaries.isEmpty()) {
                changedTasks = taskSummaries.stream().map(TaskSummary::getId).collect(Collectors.toList());
                this.taskMapper.updateTasks(changedTasks, updated, fieldSelector);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("updateTasks() updated the following tasks: {} ", changedTasks);
                }
            } else if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("updateTasks() found no tasks for update ");
            }
            ArrayList<String> arrayList3 = changedTasks;
            arrayList2 = arrayList3;
        }
        finally {
            this.taskanaEngine.returnConnection();
        }
        ArrayList<String> arrayList4 = arrayList = arrayList2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, arrayList);
        return arrayList2;
    }

    @Override
    public List<String> updateTasks(List<String> taskIds, Map<TaskCustomField, String> customFieldsToUpdate) throws InvalidArgumentException {
        ArrayList<String> arrayList;
        ArrayList<String> arrayList2;
        List<String> list = taskIds;
        Map<TaskCustomField, String> map = customFieldsToUpdate;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_27, (Object)this, (Object)this, list, map);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.validateCustomFields(customFieldsToUpdate);
        TaskCustomPropertySelector fieldSelector = new TaskCustomPropertySelector();
        TaskImpl updatedTask = this.initUpdatedTask(customFieldsToUpdate, fieldSelector);
        try {
            this.taskanaEngine.openConnection();
            List<TaskSummary> taskSummaries = this.getTasksToChange(taskIds);
            ArrayList<String> changedTasks = new ArrayList<String>();
            if (!taskSummaries.isEmpty()) {
                changedTasks = taskSummaries.stream().map(TaskSummary::getId).collect(Collectors.toList());
                this.taskMapper.updateTasks(changedTasks, updatedTask, fieldSelector);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("updateTasks() updated the following tasks: {} ", changedTasks);
                }
            } else if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("updateTasks() found no tasks for update ");
            }
            ArrayList<String> arrayList3 = changedTasks;
            arrayList2 = arrayList3;
        }
        finally {
            this.taskanaEngine.returnConnection();
        }
        ArrayList<String> arrayList4 = arrayList = arrayList2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, arrayList);
        return arrayList2;
    }

    @Override
    public TaskComment createTaskComment(TaskComment taskComment) throws NotAuthorizedException, TaskNotFoundException, InvalidArgumentException {
        TaskComment taskComment2;
        TaskComment taskComment3;
        TaskComment taskComment4 = taskComment;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_28, (Object)this, (Object)this, (Object)taskComment4);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        TaskComment taskComment5 = taskComment3 = (taskComment2 = this.taskCommentService.createTaskComment(taskComment));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskComment3);
        return taskComment2;
    }

    @Override
    public TaskComment updateTaskComment(TaskComment taskComment) throws NotAuthorizedException, ConcurrencyException, TaskCommentNotFoundException, TaskNotFoundException, InvalidArgumentException {
        TaskComment taskComment2;
        TaskComment taskComment3;
        TaskComment taskComment4 = taskComment;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_29, (Object)this, (Object)this, (Object)taskComment4);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        TaskComment taskComment5 = taskComment3 = (taskComment2 = this.taskCommentService.updateTaskComment(taskComment));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskComment3);
        return taskComment2;
    }

    @Override
    public void deleteTaskComment(String taskCommentId) throws NotAuthorizedException, TaskCommentNotFoundException, TaskNotFoundException, InvalidArgumentException {
        String string = taskCommentId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_30, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.taskCommentService.deleteTaskComment(taskCommentId);
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    @Override
    public TaskComment getTaskComment(String taskCommentid) throws TaskCommentNotFoundException, NotAuthorizedException, TaskNotFoundException, InvalidArgumentException {
        TaskComment taskComment;
        TaskComment taskComment2;
        String string = taskCommentid;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_31, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        TaskComment taskComment3 = taskComment2 = (taskComment = this.taskCommentService.getTaskComment(taskCommentid));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskComment2);
        return taskComment;
    }

    @Override
    public List<TaskComment> getTaskComments(String taskId) throws NotAuthorizedException, TaskNotFoundException {
        List<TaskComment> list;
        List<TaskComment> list2;
        String string = taskId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_32, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        List<TaskComment> list3 = list2 = (list = this.taskCommentService.getTaskComments(taskId));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, list2);
        return list;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public BulkOperationResults<String, TaskanaException> setCallbackStateForTasks(List<String> externalIds, CallbackState state) {
        BulkOperationResults bulkOperationResults;
        BulkOperationResults bulkOperationResults2;
        BulkOperationResults bulkOperationResults3;
        JoinPoint joinPoint;
        block7: {
            List<String> list = externalIds;
            CallbackState callbackState = state;
            joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_33, (Object)this, (Object)this, list, (Object)((Object)callbackState));
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.taskanaEngine.openConnection();
            BulkOperationResults bulkLog = new BulkOperationResults();
            if (externalIds == null || externalIds.isEmpty()) {
                BulkOperationResults bulkOperationResults4 = bulkLog;
                bulkOperationResults2 = bulkOperationResults3 = bulkOperationResults4;
                break block7;
            }
            List<MinimalTaskSummary> taskSummaries = this.taskMapper.findExistingTasks(null, externalIds);
            Iterator<String> taskIdIterator = new ArrayList<String>(externalIds).iterator();
            while (taskIdIterator.hasNext()) {
                this.removeSingleTaskForCallbackStateByExternalId((BulkOperationResults<String, TaskanaException>)bulkLog, taskSummaries, taskIdIterator, state);
            }
            if (!externalIds.isEmpty()) {
                this.taskMapper.setCallbackStateMultiple(externalIds, state);
            }
            BulkOperationResults bulkOperationResults5 = bulkLog;
            bulkOperationResults2 = bulkOperationResults3 = bulkOperationResults5;
            break block7;
            finally {
                this.taskanaEngine.returnConnection();
            }
        }
        BulkOperationResults bulkOperationResults6 = bulkOperationResults = bulkOperationResults2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)bulkOperationResults);
        return bulkOperationResults3;
    }

    @Override
    public BulkOperationResults<String, TaskanaException> setOwnerOfTasks(String owner, List<String> argTaskIds) {
        BulkOperationResults bulkOperationResults;
        BulkOperationResults bulkOperationResults2;
        BulkOperationResults bulkOperationResults3;
        JoinPoint joinPoint;
        block7: {
            String string = owner;
            List<String> list = argTaskIds;
            joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_34, (Object)this, (Object)this, (Object)string, list);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            BulkOperationResults bulkLog = new BulkOperationResults();
            if (argTaskIds == null || argTaskIds.isEmpty()) {
                bulkOperationResults2 = bulkOperationResults3 = bulkLog;
            } else {
                int numberOfAffectedTasks;
                List<String> taskIds = argTaskIds.stream().distinct().collect(Collectors.toList());
                int requestSize = taskIds.size();
                this.taskanaEngine.openConnection();
                Pair<List<MinimalTaskSummary>, ServiceLevelHandler.BulkLog> resultsPair = this.getMinimalTaskSummaries(taskIds);
                List<MinimalTaskSummary> existingMinimalTaskSummaries = (List<MinimalTaskSummary>)resultsPair.getLeft();
                taskIds = existingMinimalTaskSummaries.stream().map(MinimalTaskSummary::getTaskId).collect(Collectors.toList());
                bulkLog.addAllErrors((BulkOperationResults)resultsPair.getRight());
                if (!taskIds.isEmpty() && (numberOfAffectedTasks = this.taskMapper.setOwnerOfTasks(owner, taskIds, Instant.now())) != taskIds.size()) {
                    existingMinimalTaskSummaries = this.taskMapper.findExistingTasks(taskIds, null);
                    bulkLog.addAllErrors(this.addExceptionsForTasksWhoseOwnerWasNotSet(owner, existingMinimalTaskSummaries));
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Received the Request to set owner on {} tasks, actually modified tasks = {}, could not set owner on {} tasks.", new Object[]{requestSize, numberOfAffectedTasks, bulkLog.getFailedIds().size()});
                    }
                }
                BulkOperationResults bulkOperationResults4 = bulkLog;
                bulkOperationResults2 = bulkOperationResults3 = bulkOperationResults4;
            }
            break block7;
            finally {
                this.taskanaEngine.returnConnection();
            }
        }
        BulkOperationResults bulkOperationResults5 = bulkOperationResults = bulkOperationResults2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)bulkOperationResults);
        return bulkOperationResults3;
    }

    @Override
    public BulkOperationResults<String, TaskanaException> setPlannedPropertyOfTasks(Instant planned, List<String> argTaskIds) {
        ServiceLevelHandler.BulkLog bulkLog;
        ServiceLevelHandler.BulkLog bulkLog2;
        ServiceLevelHandler.BulkLog bulkLog3;
        JoinPoint joinPoint;
        block5: {
            Instant instant = planned;
            List<String> list = argTaskIds;
            joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_35, (Object)this, (Object)this, (Object)instant, list);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            ServiceLevelHandler.BulkLog bulkLog4 = new ServiceLevelHandler.BulkLog();
            if (argTaskIds == null || argTaskIds.isEmpty()) {
                bulkLog2 = bulkLog3 = bulkLog4;
            } else {
                this.taskanaEngine.openConnection();
                Pair<List<MinimalTaskSummary>, ServiceLevelHandler.BulkLog> resultsPair = this.getMinimalTaskSummaries(argTaskIds);
                List tasksToModify = (List)resultsPair.getLeft();
                bulkLog4.addAllErrors((BulkOperationResults)resultsPair.getRight());
                ServiceLevelHandler.BulkLog errorsFromProcessing = this.serviceLevelHandler.setPlannedPropertyOfTasksImpl(planned, tasksToModify);
                bulkLog4.addAllErrors(errorsFromProcessing);
                ServiceLevelHandler.BulkLog bulkLog5 = bulkLog4;
                bulkLog2 = bulkLog3 = bulkLog5;
            }
            break block5;
            finally {
                this.taskanaEngine.returnConnection();
            }
        }
        ServiceLevelHandler.BulkLog bulkLog6 = bulkLog = bulkLog2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)bulkLog);
        return bulkLog3;
    }

    @Override
    public Task cancelTask(String taskId) throws TaskNotFoundException, InvalidStateException, NotAuthorizedException {
        TaskImpl taskImpl;
        TaskImpl taskImpl2;
        TaskImpl cancelledTask;
        String string = taskId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_36, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        try {
            this.taskanaEngine.openConnection();
            cancelledTask = this.terminateCancelCommonActions(taskId, TaskState.CANCELLED);
            if (HistoryEventManager.isHistoryEnabled()) {
                this.historyEventManager.createEvent(new TaskCancelledEvent(IdGenerator.generateWithPrefix((String)"THI"), cancelledTask, this.taskanaEngine.getEngine().getCurrentUserContext().getUserid()));
            }
        }
        finally {
            this.taskanaEngine.returnConnection();
        }
        TaskImpl taskImpl3 = taskImpl2 = (taskImpl = cancelledTask);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskImpl2);
        return taskImpl;
    }

    @Override
    public Task terminateTask(String taskId) throws TaskNotFoundException, InvalidStateException, NotAuthorizedException {
        TaskImpl taskImpl;
        TaskImpl taskImpl2;
        TaskImpl terminatedTask;
        String string = taskId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_37, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.taskanaEngine.getEngine().checkRoleMembership(TaskanaRole.ADMIN, TaskanaRole.TASK_ADMIN);
        try {
            this.taskanaEngine.openConnection();
            terminatedTask = this.terminateCancelCommonActions(taskId, TaskState.TERMINATED);
            if (HistoryEventManager.isHistoryEnabled()) {
                this.historyEventManager.createEvent(new TaskTerminatedEvent(IdGenerator.generateWithPrefix((String)"THI"), terminatedTask, this.taskanaEngine.getEngine().getCurrentUserContext().getUserid()));
            }
        }
        finally {
            this.taskanaEngine.returnConnection();
        }
        TaskImpl taskImpl3 = taskImpl2 = (taskImpl = terminatedTask);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskImpl2);
        return taskImpl;
    }

    public List<String> findTasksIdsAffectedByClassificationChange(String classificationId) {
        List<String> list;
        List<String> list2;
        String string = classificationId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_38, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        List tasksAffectedDirectly = this.createTaskQuery().classificationIdIn(classificationId).stateIn(TaskState.READY, TaskState.CLAIMED).list();
        List affectedPairs = tasksAffectedDirectly.stream().map(t -> Pair.of((Object)t.getId(), (Object)t.getPlanned())).collect(Collectors.toList());
        List<Pair<String, Instant>> taskIdsAndPlannedFromAttachments = this.attachmentMapper.findTaskIdsAndPlannedAffectedByClassificationChange(classificationId);
        List<String> taskIdsFromAttachments = taskIdsAndPlannedFromAttachments.stream().map(Pair::getLeft).collect(Collectors.toList());
        List<Object> filteredTaskIdsAndPlannedFromAttachments = taskIdsFromAttachments.isEmpty() ? new ArrayList() : this.taskMapper.filterTaskIdsForReadyAndClaimed(taskIdsFromAttachments);
        affectedPairs.addAll(filteredTaskIdsAndPlannedFromAttachments);
        List<String> affectedTaskIds = affectedPairs.stream().sorted(Comparator.comparing(Pair::getRight)).distinct().map(Pair::getLeft).collect(Collectors.toList());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("the following tasks are affected by the update of classification {} : {}", (Object)classificationId, affectedTaskIds);
        }
        List<String> list3 = list2 = (list = affectedTaskIds);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, list2);
        return list;
    }

    public void refreshPriorityAndDueDatesOfTasksOnClassificationUpdate(List<String> taskIds, boolean serviceLevelChanged, boolean priorityChanged) {
        List<String> list = taskIds;
        boolean bl = serviceLevelChanged;
        boolean bl2 = priorityChanged;
        Object[] objectArray = new Object[]{list, Conversions.booleanObject((boolean)bl), Conversions.booleanObject((boolean)bl2)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_39, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Pair<List<MinimalTaskSummary>, ServiceLevelHandler.BulkLog> resultsPair = this.getMinimalTaskSummaries(taskIds);
        List tasks = (List)resultsPair.getLeft();
        try {
            this.taskanaEngine.openConnection();
            Set<String> adminAccessIds = this.taskanaEngine.getEngine().getConfiguration().getRoleMap().get(TaskanaRole.ADMIN);
            if (adminAccessIds.contains(this.taskanaEngine.getEngine().getCurrentUserContext().getUserid())) {
                this.serviceLevelHandler.refreshPriorityAndDueDatesOfTasks(tasks, serviceLevelChanged, priorityChanged);
            } else {
                this.taskanaEngine.getEngine().runAsAdmin(() -> {
                    this.serviceLevelHandler.refreshPriorityAndDueDatesOfTasks(tasks, serviceLevelChanged, priorityChanged);
                    return null;
                });
            }
        }
        finally {
            this.taskanaEngine.returnConnection();
        }
        Object var13_13 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var13_13);
    }

    Pair<List<MinimalTaskSummary>, ServiceLevelHandler.BulkLog> getMinimalTaskSummaries(List<String> argTaskIds) {
        Pair pair;
        Pair pair2;
        List<String> list = argTaskIds;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_40, (Object)this, (Object)this, list);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ServiceLevelHandler.BulkLog bulkLog = new ServiceLevelHandler.BulkLog();
        List<String> taskIds = argTaskIds.stream().distinct().collect(Collectors.toList());
        List<MinimalTaskSummary> minimalTaskSummaries = this.taskMapper.findExistingTasks(taskIds, null);
        bulkLog.addAllErrors(this.addExceptionsForNonExistingTasksToBulkLog(taskIds, minimalTaskSummaries));
        Pair<List<MinimalTaskSummary>, ServiceLevelHandler.BulkLog> filteredPair = this.filterTasksAuthorizedForAndLogErrorsForNotAuthorized(minimalTaskSummaries);
        bulkLog.addAllErrors((BulkOperationResults)filteredPair.getRight());
        Pair pair3 = pair2 = (pair = Pair.of((Object)((List)filteredPair.getLeft()), (Object)((Object)bulkLog)));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)pair2);
        return pair;
    }

    Pair<List<MinimalTaskSummary>, ServiceLevelHandler.BulkLog> filterTasksAuthorizedForAndLogErrorsForNotAuthorized(List<MinimalTaskSummary> existingTasks) {
        Pair pair;
        Pair pair2;
        Pair pair3;
        List<MinimalTaskSummary> list = existingTasks;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_41, (Object)this, (Object)this, list);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ServiceLevelHandler.BulkLog bulkLog = new ServiceLevelHandler.BulkLog();
        if (this.taskanaEngine.getEngine().isUserInRole(TaskanaRole.ADMIN, TaskanaRole.TASK_ADMIN)) {
            pair2 = pair3 = Pair.of(existingTasks, (Object)((Object)bulkLog));
        } else {
            List<String> taskIds = existingTasks.stream().map(MinimalTaskSummary::getTaskId).collect(Collectors.toList());
            List accessIds = this.taskanaEngine.getEngine().getCurrentUserContext().getAccessIds();
            List<String> taskIdsNotAuthorizedFor = this.taskMapper.filterTaskIdsNotAuthorizedFor(taskIds, accessIds);
            String userId = this.taskanaEngine.getEngine().getCurrentUserContext().getUserid();
            for (String taskId : taskIdsNotAuthorizedFor) {
                bulkLog.addError(taskId, (Exception)((Object)new NotAuthorizedException(String.format("User %s is not authorized for task %s ", userId, taskId), userId)));
            }
            taskIds.removeAll(taskIdsNotAuthorizedFor);
            List tasksAuthorizedFor = existingTasks.stream().filter(t -> taskIds.contains(t.getTaskId())).collect(Collectors.toList());
            pair2 = pair3 = Pair.of(tasksAuthorizedFor, (Object)((Object)bulkLog));
        }
        Pair pair4 = pair = pair2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)pair);
        return pair3;
    }

    ServiceLevelHandler.BulkLog addExceptionsForNonExistingTasksToBulkLog(List<String> requestTaskIds, List<MinimalTaskSummary> existingMinimalTaskSummaries) {
        ServiceLevelHandler.BulkLog bulkLog;
        ServiceLevelHandler.BulkLog bulkLog2;
        List<String> list = requestTaskIds;
        List<MinimalTaskSummary> list2 = existingMinimalTaskSummaries;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_42, (Object)this, (Object)this, list, list2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ServiceLevelHandler.BulkLog bulkLog3 = new ServiceLevelHandler.BulkLog();
        ArrayList<String> nonExistingTaskIds = new ArrayList<String>(requestTaskIds);
        List existingTaskIds = existingMinimalTaskSummaries.stream().map(MinimalTaskSummary::getTaskId).collect(Collectors.toList());
        nonExistingTaskIds.removeAll(existingTaskIds);
        nonExistingTaskIds.forEach(taskId -> bulkLog3.addError(taskId, (Exception)((Object)new TaskNotFoundException((String)taskId, "Task was not found"))));
        ServiceLevelHandler.BulkLog bulkLog4 = bulkLog2 = (bulkLog = bulkLog3);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)bulkLog2);
        return bulkLog;
    }

    List<TaskSummary> augmentTaskSummariesByContainedSummariesWithPartitioning(List<TaskSummaryImpl> taskSummaries) {
        List<TaskSummary> list;
        List<TaskSummary> list2;
        List<TaskSummaryImpl> list3 = taskSummaries;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_43, (Object)this, (Object)this, list3);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        List<TaskSummary> list4 = list2 = (list = CollectionUtil.partitionBasedOnSize(taskSummaries, (int)32000).stream().map(this::augmentTaskSummariesByContainedSummariesWithoutPartitioning).flatMap(Collection::stream).collect(Collectors.toList()));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, list2);
        return list;
    }

    private List<TaskSummaryImpl> augmentTaskSummariesByContainedSummariesWithoutPartitioning(List<TaskSummaryImpl> taskSummaries) {
        List<TaskSummaryImpl> list;
        List<TaskSummaryImpl> list2;
        List<TaskSummaryImpl> list3 = taskSummaries;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_44, (Object)this, (Object)this, list3);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        List<String> taskIds = taskSummaries.stream().map(TaskSummaryImpl::getId).distinct().collect(Collectors.toList());
        if (taskIds.isEmpty()) {
            taskIds = null;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("augmentTaskSummariesByContainedSummariesWithoutPartitioning() with sublist {} about to query for attachmentSummaries ", taskSummaries);
        }
        List<AttachmentSummaryImpl> attachmentSummaries = this.attachmentMapper.findAttachmentSummariesByTaskIds(taskIds);
        List<ClassificationSummary> classifications = this.findClassificationsForTasksAndAttachments(taskSummaries, attachmentSummaries);
        this.addClassificationSummariesToTaskSummaries(taskSummaries, classifications);
        this.addWorkbasketSummariesToTaskSummaries(taskSummaries);
        this.addAttachmentSummariesToTaskSummaries(taskSummaries, attachmentSummaries, classifications);
        List<TaskSummaryImpl> list4 = list2 = (list = taskSummaries);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, list2);
        return list;
    }

    private BulkOperationResults<String, TaskanaException> completeTasks(List<String> taskIds, boolean forced) throws InvalidArgumentException {
        BulkOperationResults bulkOperationResults;
        BulkOperationResults bulkOperationResults2;
        List<String> list = taskIds;
        boolean bl = forced;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_45, (Object)this, (Object)this, list, (Object)Conversions.booleanObject((boolean)bl));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        try {
            this.taskanaEngine.openConnection();
            if (taskIds == null) {
                throw new InvalidArgumentException("TaskIds can't be used as NULL-Parameter.");
            }
            BulkOperationResults bulkLog = new BulkOperationResults();
            Instant now = Instant.now().truncatedTo(ChronoUnit.MILLIS);
            Stream<TaskSummaryImpl> filteredSummaries = this.filterNotExistingTaskIds(taskIds, (BulkOperationResults<String, TaskanaException>)bulkLog).filter(task -> task.getState() != TaskState.COMPLETED).filter(TaskServiceImpl.addErrorToBulkLog((CheckedConsumer<TaskSummaryImpl, TaskanaException>)((CheckedConsumer)TaskServiceImpl::checkIfTaskIsTerminatedOrCancelled), (BulkOperationResults<String, TaskanaException>)bulkLog));
            if (!forced) {
                filteredSummaries = filteredSummaries.filter(TaskServiceImpl.addErrorToBulkLog((CheckedConsumer<TaskSummaryImpl, TaskanaException>)((CheckedConsumer)this::checkPreconditionsForCompleteTask), (BulkOperationResults<String, TaskanaException>)bulkLog));
            } else {
                String userId = this.taskanaEngine.getEngine().getCurrentUserContext().getUserid();
                filteredSummaries = filteredSummaries.filter(TaskServiceImpl.addErrorToBulkLog((CheckedConsumer<TaskSummaryImpl, TaskanaException>)((CheckedConsumer)summary -> {
                    if (TaskServiceImpl.taskIsNotClaimed(summary)) {
                        this.checkPreconditionsForClaimTask((TaskSummary)summary, true);
                        TaskServiceImpl.claimActionsOnTask(summary, userId, now);
                    }
                }), (BulkOperationResults<String, TaskanaException>)bulkLog));
            }
            this.updateTasksToBeCompleted(filteredSummaries, now);
            BulkOperationResults bulkOperationResults3 = bulkLog;
            bulkOperationResults2 = bulkOperationResults3;
        }
        finally {
            this.taskanaEngine.returnConnection();
        }
        BulkOperationResults bulkOperationResults4 = bulkOperationResults = bulkOperationResults2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)bulkOperationResults);
        return bulkOperationResults2;
    }

    private Stream<TaskSummaryImpl> filterNotExistingTaskIds(List<String> taskIds, BulkOperationResults<String, TaskanaException> bulkLog) {
        Stream<TaskSummaryImpl> stream;
        Stream<TaskSummaryImpl> stream2;
        List<String> list = taskIds;
        BulkOperationResults<String, TaskanaException> bulkOperationResults = bulkLog;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_46, (Object)this, (Object)this, list, bulkOperationResults);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Map<String, TaskSummaryImpl> taskSummaryMap = this.getTasksToChange(taskIds).stream().collect(Collectors.toMap(TaskSummary::getId, TaskSummaryImpl.class::cast));
        Stream<TaskSummaryImpl> stream3 = stream2 = (stream = taskIds.stream().map(id -> Pair.of((Object)id, (Object)((TaskSummaryImpl)taskSummaryMap.get(id)))).filter(pair -> {
            if (pair.getRight() == null) {
                String taskId = (String)pair.getLeft();
                bulkLog.addError((Object)taskId, (Exception)((Object)new TaskNotFoundException(taskId, String.format("Task with id %s was not found.", taskId))));
                return false;
            }
            return true;
        }).map(Pair::getRight));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, stream2);
        return stream;
    }

    private static Predicate<TaskSummaryImpl> addErrorToBulkLog(CheckedConsumer<TaskSummaryImpl, TaskanaException> checkedConsumer, BulkOperationResults<String, TaskanaException> bulkLog) {
        Predicate<TaskSummaryImpl> predicate;
        Predicate<TaskSummaryImpl> predicate2;
        CheckedConsumer<TaskSummaryImpl, TaskanaException> checkedConsumer2 = checkedConsumer;
        BulkOperationResults<String, TaskanaException> bulkOperationResults = bulkLog;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_47, null, null, checkedConsumer2, bulkOperationResults);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Predicate<TaskSummaryImpl> predicate3 = predicate2 = (predicate = summary -> {
            try {
                checkedConsumer.accept(summary);
                return true;
            }
            catch (TaskanaException e) {
                bulkLog.addError((Object)summary.getId(), (Exception)((Object)e));
                return false;
            }
        });
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, predicate2);
        return predicate;
    }

    private void checkConcurrencyAndSetModified(TaskImpl newTaskImpl, TaskImpl oldTaskImpl) throws ConcurrencyException {
        TaskImpl taskImpl = newTaskImpl;
        TaskImpl taskImpl2 = oldTaskImpl;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_48, (Object)this, (Object)this, (Object)taskImpl, (Object)taskImpl2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (oldTaskImpl.getModified() != null && !oldTaskImpl.getModified().equals(newTaskImpl.getModified()) || oldTaskImpl.getClaimed() != null && !oldTaskImpl.getClaimed().equals(newTaskImpl.getClaimed()) || oldTaskImpl.getState() != null && !oldTaskImpl.getState().equals((Object)newTaskImpl.getState())) {
            throw new ConcurrencyException("The task has already been updated by another user");
        }
        newTaskImpl.setModified(Instant.now());
        Object var6_6 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var6_6);
    }

    private TaskImpl terminateCancelCommonActions(String taskId, TaskState targetState) throws NotAuthorizedException, TaskNotFoundException, InvalidStateException {
        TaskImpl taskImpl;
        TaskImpl taskImpl2;
        String string = taskId;
        TaskState taskState = targetState;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_49, (Object)this, (Object)this, (Object)string, (Object)((Object)taskState));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (taskId == null || taskId.isEmpty()) {
            throw new TaskNotFoundException(taskId, String.format("Task with id %s was not found.", taskId));
        }
        TaskImpl task = (TaskImpl)this.getTask(taskId);
        TaskState state = task.getState();
        if (state.isEndState()) {
            throw new InvalidStateException(String.format("Task with Id %s is already in an end state.", taskId));
        }
        Instant now = Instant.now();
        task.setModified(now);
        task.setCompleted(now);
        task.setState(targetState);
        this.taskMapper.update(task);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Task '{}' cancelled by user '{}'.", (Object)taskId, (Object)this.taskanaEngine.getEngine().getCurrentUserContext().getUserid());
        }
        TaskImpl taskImpl3 = taskImpl2 = (taskImpl = task);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskImpl2);
        return taskImpl;
    }

    private BulkOperationResults<String, TaskanaException> addExceptionsForTasksWhoseOwnerWasNotSet(String owner, List<MinimalTaskSummary> existingMinimalTaskSummaries) {
        BulkOperationResults bulkOperationResults;
        BulkOperationResults bulkOperationResults2;
        String string = owner;
        List<MinimalTaskSummary> list = existingMinimalTaskSummaries;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_50, (Object)this, (Object)this, (Object)string, list);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        BulkOperationResults bulkLog = new BulkOperationResults();
        for (MinimalTaskSummary taskSummary : existingMinimalTaskSummaries) {
            if (owner.equals(taskSummary.getOwner())) continue;
            if (!TaskState.READY.equals((Object)taskSummary.getTaskState())) {
                bulkLog.addError((Object)taskSummary.getTaskId(), (Exception)((Object)new InvalidStateException(String.format("Task with id %s is in state %s and not in state ready.", new Object[]{taskSummary.getTaskId(), taskSummary.getTaskState()}))));
                continue;
            }
            bulkLog.addError((Object)taskSummary.getTaskId(), (Exception)((Object)new UpdateFailedException(String.format("Could not set owner of Task %s .", taskSummary.getTaskId()))));
        }
        BulkOperationResults bulkOperationResults3 = bulkOperationResults2 = (bulkOperationResults = bulkLog);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)bulkOperationResults2);
        return bulkOperationResults;
    }

    private Task claim(String taskId, boolean forceClaim) throws TaskNotFoundException, InvalidStateException, InvalidOwnerException, NotAuthorizedException {
        TaskImpl taskImpl;
        TaskImpl taskImpl2;
        TaskImpl task;
        String string = taskId;
        boolean bl = forceClaim;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_51, (Object)this, (Object)this, (Object)string, (Object)Conversions.booleanObject((boolean)bl));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String userId = this.taskanaEngine.getEngine().getCurrentUserContext().getUserid();
        try {
            this.taskanaEngine.openConnection();
            task = (TaskImpl)this.getTask(taskId);
            Instant now = Instant.now();
            this.checkPreconditionsForClaimTask(task, forceClaim);
            TaskServiceImpl.claimActionsOnTask(task, userId, now);
            this.taskMapper.update(task);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Task '{}' claimed by user '{}'.", (Object)taskId, (Object)userId);
            }
            if (HistoryEventManager.isHistoryEnabled()) {
                this.historyEventManager.createEvent(new TaskClaimedEvent(IdGenerator.generateWithPrefix((String)"THI"), task, this.taskanaEngine.getEngine().getCurrentUserContext().getUserid()));
            }
        }
        finally {
            this.taskanaEngine.returnConnection();
        }
        TaskImpl taskImpl3 = taskImpl2 = (taskImpl = task);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskImpl2);
        return taskImpl;
    }

    private static void claimActionsOnTask(TaskSummaryImpl task, String userId, Instant now) {
        TaskSummaryImpl taskSummaryImpl = task;
        String string = userId;
        Instant instant = now;
        Object[] objectArray = new Object[]{taskSummaryImpl, string, instant};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_52, null, null, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        task.setOwner(userId);
        task.setModified(now);
        task.setClaimed(now);
        task.setRead(true);
        task.setState(TaskState.CLAIMED);
        Object var8_8 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var8_8);
    }

    private static void completeActionsOnTask(TaskSummaryImpl task, String userId, Instant now) {
        TaskSummaryImpl taskSummaryImpl = task;
        String string = userId;
        Instant instant = now;
        Object[] objectArray = new Object[]{taskSummaryImpl, string, instant};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_53, null, null, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        task.setCompleted(now);
        task.setModified(now);
        task.setState(TaskState.COMPLETED);
        task.setOwner(userId);
        Object var8_8 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var8_8);
    }

    private void checkPreconditionsForClaimTask(TaskSummary task, boolean forced) throws InvalidStateException, InvalidOwnerException {
        TaskSummary taskSummary = task;
        boolean bl = forced;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_54, (Object)this, (Object)this, (Object)taskSummary, (Object)Conversions.booleanObject((boolean)bl));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        TaskState state = task.getState();
        if (!state.in(TaskState.READY, TaskState.CLAIMED)) {
            throw new InvalidStateException(String.format("Task with Id %s is already in an end state.", task.getId()));
        }
        if (!forced && state == TaskState.CLAIMED && !task.getOwner().equals(this.taskanaEngine.getEngine().getCurrentUserContext().getUserid())) {
            throw new InvalidOwnerException(String.format("Task with id %s is already claimed by %s.", task.getId(), task.getOwner()));
        }
        Object var7_7 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var7_7);
    }

    private static boolean taskIsNotClaimed(TaskSummary task) {
        boolean bl;
        boolean bl2;
        TaskSummary taskSummary = task;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_55, null, null, (Object)taskSummary);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        boolean bl3 = bl2 = task.getClaimed() != null && task.getState() == TaskState.CLAIMED ? (bl = false) : (bl = true);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl2));
        return bl;
    }

    private static void checkIfTaskIsTerminatedOrCancelled(TaskSummary task) throws InvalidStateException {
        TaskSummary taskSummary = task;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_56, null, null, (Object)taskSummary);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (task.getState().in(TaskState.CANCELLED, TaskState.TERMINATED)) {
            throw new InvalidStateException(String.format("Cannot complete task %s because it is in state %s.", new Object[]{task.getId(), task.getState()}));
        }
        Object var3_3 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var3_3);
    }

    private void checkPreconditionsForCompleteTask(TaskSummary task) throws InvalidStateException, InvalidOwnerException {
        TaskSummary taskSummary = task;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_57, (Object)this, (Object)this, (Object)taskSummary);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (TaskServiceImpl.taskIsNotClaimed(task)) {
            throw new InvalidStateException(String.format("Task with Id %s has to be claimed before.", task.getId()));
        }
        if (!this.taskanaEngine.getEngine().getCurrentUserContext().getAccessIds().contains(task.getOwner()) && !this.taskanaEngine.getEngine().isUserInRole(TaskanaRole.ADMIN)) {
            throw new InvalidOwnerException(String.format("Owner of task %s is %s, but current user is %s ", task.getId(), task.getOwner(), this.taskanaEngine.getEngine().getCurrentUserContext().getUserid()));
        }
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    private Task cancelClaim(String taskId, boolean forceUnclaim) throws TaskNotFoundException, InvalidStateException, InvalidOwnerException, NotAuthorizedException {
        TaskImpl taskImpl;
        TaskImpl taskImpl2;
        TaskImpl task;
        String string = taskId;
        boolean bl = forceUnclaim;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_58, (Object)this, (Object)this, (Object)string, (Object)Conversions.booleanObject((boolean)bl));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String userId = this.taskanaEngine.getEngine().getCurrentUserContext().getUserid();
        try {
            this.taskanaEngine.openConnection();
            task = (TaskImpl)this.getTask(taskId);
            TaskState state = task.getState();
            if (state.isEndState()) {
                throw new InvalidStateException(String.format("Task with Id %s is already in an end state.", taskId));
            }
            if (state == TaskState.CLAIMED && !forceUnclaim && !userId.equals(task.getOwner())) {
                throw new InvalidOwnerException(String.format("Task with id %s is already claimed by %s.", taskId, task.getOwner()));
            }
            Instant now = Instant.now();
            task.setOwner(null);
            task.setModified(now);
            task.setClaimed(null);
            task.setRead(true);
            task.setState(TaskState.READY);
            this.taskMapper.update(task);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Task '{}' unclaimed by user '{}'.", (Object)taskId, (Object)userId);
            }
            if (HistoryEventManager.isHistoryEnabled()) {
                this.historyEventManager.createEvent(new TaskClaimCancelledEvent(IdGenerator.generateWithPrefix((String)"THI"), task, this.taskanaEngine.getEngine().getCurrentUserContext().getUserid()));
            }
        }
        finally {
            this.taskanaEngine.returnConnection();
        }
        TaskImpl taskImpl3 = taskImpl2 = (taskImpl = task);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskImpl2);
        return taskImpl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Task completeTask(String taskId, boolean isForced) throws TaskNotFoundException, InvalidOwnerException, InvalidStateException, NotAuthorizedException {
        TaskImpl taskImpl;
        TaskImpl taskImpl2;
        TaskImpl taskImpl3;
        JoinPoint joinPoint;
        block10: {
            TaskImpl task;
            String string = taskId;
            boolean bl = isForced;
            joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_59, (Object)this, (Object)this, (Object)string, (Object)Conversions.booleanObject((boolean)bl));
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            String userId = this.taskanaEngine.getEngine().getCurrentUserContext().getUserid();
            try {
                this.taskanaEngine.openConnection();
                task = (TaskImpl)this.getTask(taskId);
                if (task.getState() == TaskState.COMPLETED) {
                    TaskImpl taskImpl4 = task;
                    taskImpl2 = taskImpl3 = taskImpl4;
                    break block10;
                }
                TaskServiceImpl.checkIfTaskIsTerminatedOrCancelled(task);
                if (!isForced) {
                    this.checkPreconditionsForCompleteTask(task);
                } else if (TaskServiceImpl.taskIsNotClaimed(task)) {
                    task = (TaskImpl)this.forceClaim(taskId);
                }
                Instant now = Instant.now();
                TaskServiceImpl.completeActionsOnTask(task, userId, now);
                this.taskMapper.update(task);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Task '{}' completed by user '{}'.", (Object)taskId, (Object)userId);
                }
                if (HistoryEventManager.isHistoryEnabled()) {
                    this.historyEventManager.createEvent(new TaskCompletedEvent(IdGenerator.generateWithPrefix((String)"THI"), task, this.taskanaEngine.getEngine().getCurrentUserContext().getUserid()));
                }
            }
            finally {
                this.taskanaEngine.returnConnection();
            }
            taskImpl2 = taskImpl3 = task;
        }
        TaskImpl taskImpl5 = taskImpl = taskImpl2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskImpl);
        return taskImpl3;
    }

    private void deleteTask(String taskId, boolean forceDelete) throws TaskNotFoundException, InvalidStateException, NotAuthorizedException {
        String string = taskId;
        boolean bl = forceDelete;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_60, (Object)this, (Object)this, (Object)string, (Object)Conversions.booleanObject((boolean)bl));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.taskanaEngine.getEngine().checkRoleMembership(TaskanaRole.ADMIN);
        try {
            this.taskanaEngine.openConnection();
            TaskImpl task = (TaskImpl)this.getTask(taskId);
            if (!task.getState().isEndState() && !forceDelete) {
                throw new InvalidStateException("Cannot delete Task " + taskId + " because it is not in an end state.");
            }
            if (!task.getState().in(TaskState.TERMINATED, TaskState.CANCELLED) && CallbackState.CALLBACK_PROCESSING_REQUIRED.equals((Object)task.getCallbackState())) {
                throw new InvalidStateException(String.format("Task wit Id %s cannot be deleted because its callback is not yet processed", taskId));
            }
            this.attachmentMapper.deleteMultipleByTaskIds(Collections.singletonList(taskId));
            this.taskMapper.delete(taskId);
            if (this.taskanaEngine.getEngine().isHistoryEnabled() && this.taskanaEngine.getEngine().getConfiguration().isDeleteHistoryOnTaskDeletionEnabled()) {
                this.historyEventManager.deleteEvents(Collections.singletonList(taskId));
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Task {} deleted.", (Object)taskId);
            }
        }
        finally {
            this.taskanaEngine.returnConnection();
        }
        Object var8_8 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var8_8);
    }

    private void removeSingleTaskForTaskDeletionById(BulkOperationResults<String, TaskanaException> bulkLog, List<MinimalTaskSummary> taskSummaries, Iterator<String> taskIdIterator) {
        BulkOperationResults<String, TaskanaException> bulkOperationResults = bulkLog;
        List<MinimalTaskSummary> list = taskSummaries;
        Iterator<String> iterator = taskIdIterator;
        Object[] objectArray = new Object[]{bulkOperationResults, list, iterator};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_61, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String currentTaskId = taskIdIterator.next();
        if (currentTaskId == null || currentTaskId.equals("")) {
            bulkLog.addError((Object)"", (Exception)new InvalidArgumentException("IDs with EMPTY or NULL value are not allowed."));
            taskIdIterator.remove();
        } else {
            MinimalTaskSummary foundSummary = taskSummaries.stream().filter(taskSummary -> currentTaskId.equals(taskSummary.getTaskId())).findFirst().orElse(null);
            if (foundSummary == null) {
                bulkLog.addError((Object)currentTaskId, (Exception)((Object)new TaskNotFoundException(currentTaskId, String.format("Task with id %s was not found.", currentTaskId))));
                taskIdIterator.remove();
            } else if (!foundSummary.getTaskState().isEndState()) {
                bulkLog.addError((Object)currentTaskId, (Exception)((Object)new InvalidStateException(currentTaskId)));
                taskIdIterator.remove();
            } else if (!foundSummary.getTaskState().in(TaskState.CANCELLED, TaskState.TERMINATED) && CallbackState.CALLBACK_PROCESSING_REQUIRED.equals((Object)foundSummary.getCallbackState())) {
                bulkLog.addError((Object)currentTaskId, (Exception)((Object)new InvalidStateException(String.format("Task wit Id %s cannot be deleted because its callback is not yet processed", currentTaskId))));
                taskIdIterator.remove();
            }
        }
        Object var11_11 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var11_11);
    }

    private void removeSingleTaskForCallbackStateByExternalId(BulkOperationResults<String, TaskanaException> bulkLog, List<MinimalTaskSummary> taskSummaries, Iterator<String> externalIdIterator, CallbackState desiredCallbackState) {
        BulkOperationResults<String, TaskanaException> bulkOperationResults = bulkLog;
        List<MinimalTaskSummary> list = taskSummaries;
        Iterator<String> iterator = externalIdIterator;
        CallbackState callbackState = desiredCallbackState;
        Object[] objectArray = new Object[]{bulkOperationResults, list, iterator, callbackState};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_62, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String currentExternalId = externalIdIterator.next();
        if (currentExternalId == null || currentExternalId.equals("")) {
            bulkLog.addError((Object)"", (Exception)new InvalidArgumentException("IDs with EMPTY or NULL value are not allowed."));
            externalIdIterator.remove();
        } else {
            Optional<MinimalTaskSummary> foundSummary = taskSummaries.stream().filter(taskSummary -> currentExternalId.equals(taskSummary.getExternalId())).findFirst();
            if (foundSummary.isPresent()) {
                if (!this.desiredCallbackStateCanBeSetForFoundSummary(foundSummary.get(), desiredCallbackState)) {
                    bulkLog.addError((Object)currentExternalId, (Exception)((Object)new InvalidStateException(currentExternalId)));
                    externalIdIterator.remove();
                }
            } else {
                bulkLog.addError((Object)currentExternalId, (Exception)((Object)new TaskNotFoundException(currentExternalId, String.format("Task with id %s was not found.", currentExternalId))));
                externalIdIterator.remove();
            }
        }
        Object var13_13 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var13_13);
    }

    private boolean desiredCallbackStateCanBeSetForFoundSummary(MinimalTaskSummary foundSummary, CallbackState desiredCallbackState) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        MinimalTaskSummary minimalTaskSummary = foundSummary;
        CallbackState callbackState = desiredCallbackState;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_63, (Object)this, (Object)this, (Object)minimalTaskSummary, (Object)((Object)callbackState));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        CallbackState currentTaskCallbackState = foundSummary.getCallbackState();
        TaskState currentTaskState = foundSummary.getTaskState();
        switch (desiredCallbackState) {
            case CALLBACK_PROCESSING_COMPLETED: {
                bl2 = bl3 = currentTaskState.isEndState();
                break;
            }
            case CLAIMED: {
                if (!currentTaskState.equals((Object)TaskState.CLAIMED)) {
                    bl2 = bl3 = false;
                    break;
                }
                bl2 = bl3 = currentTaskCallbackState.equals((Object)CallbackState.CALLBACK_PROCESSING_REQUIRED);
                break;
            }
            case CALLBACK_PROCESSING_REQUIRED: {
                bl2 = bl3 = !currentTaskCallbackState.equals((Object)CallbackState.CALLBACK_PROCESSING_COMPLETED);
                break;
            }
            default: {
                bl2 = bl3 = false;
            }
        }
        boolean bl4 = bl = bl2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl));
        return bl3;
    }

    private void standardSettings(TaskImpl task, Classification classification) throws InvalidArgumentException {
        TaskImpl taskImpl = task;
        Classification classification2 = classification;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_64, (Object)this, (Object)this, (Object)taskImpl, (Object)classification2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        TaskImpl task1 = task;
        Instant now = Instant.now();
        task1.setId(IdGenerator.generateWithPrefix((String)"TKI"));
        if (task1.getExternalId() == null) {
            task1.setExternalId(IdGenerator.generateWithPrefix((String)"ETI"));
        }
        task1.setState(TaskState.READY);
        task1.setCreated(now);
        task1.setModified(now);
        task1.setRead(false);
        task1.setTransferred(false);
        String creator = this.taskanaEngine.getEngine().getCurrentUserContext().getUserid();
        if (this.taskanaEngine.getEngine().getConfiguration().isSecurityEnabled() && creator == null) {
            throw new SystemException("TaskanaSecurity is enabled, but the current UserId is NULL while creating a Task.");
        }
        task1.setCreator(creator);
        if (task1.getBusinessProcessId() == null) {
            task1.setBusinessProcessId(IdGenerator.generateWithPrefix((String)"BPI"));
        }
        if (task1.getPlanned() == null && (classification == null || task1.getDue() == null)) {
            task1.setPlanned(now);
        }
        if (classification != null) {
            task1 = this.serviceLevelHandler.updatePrioPlannedDueOfTask(task1, null, false);
        }
        if (task1.getName() == null && classification != null) {
            task1.setName(classification.getName());
        }
        if (task1.getDescription() == null && classification != null) {
            task1.setDescription(classification.getDescription());
        }
        try {
            this.attachmentHandler.insertNewAttachmentsOnTaskCreation(task);
        }
        catch (AttachmentPersistenceException e) {
            throw new SystemException("Internal error when trying to insert new Attachments on Task Creation.", (Throwable)((Object)e));
        }
        Object var10_10 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var10_10);
    }

    private void setCallbackStateOnTaskCreation(TaskImpl task) throws InvalidArgumentException {
        String value;
        TaskImpl taskImpl = task;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_65, (Object)this, (Object)this, (Object)taskImpl);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Map<String, String> callbackInfo = task.getCallbackInfo();
        if (callbackInfo != null && callbackInfo.containsKey("callbackState") && (value = callbackInfo.get("callbackState")) != null && !value.isEmpty()) {
            try {
                CallbackState state = CallbackState.valueOf(value);
                task.setCallbackState(state);
            }
            catch (Exception e) {
                LOGGER.warn("Attempted to determine callback state from {} and caught exception", (Object)value, (Object)e);
                throw new InvalidArgumentException(String.format("Attempted to set callback state for task %s.", task.getId()), (Throwable)e);
            }
        }
        Object var7_8 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var7_8);
    }

    private void updateTasksToBeCompleted(Stream<TaskSummaryImpl> taskSummaries, Instant now) {
        Stream<TaskSummaryImpl> stream = taskSummaries;
        Instant instant = now;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_66, (Object)this, (Object)this, stream, (Object)instant);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ArrayList<String> taskIds = new ArrayList<String>();
        ArrayList<String> updateClaimedTaskIds = new ArrayList<String>();
        List taskSummaryList = taskSummaries.peek(summary -> TaskServiceImpl.completeActionsOnTask(summary, this.taskanaEngine.getEngine().getCurrentUserContext().getUserid(), now)).peek(summary -> {
            boolean bl = taskIds.add(summary.getId());
        }).peek(summary -> {
            if (summary.getClaimed().equals(now)) {
                updateClaimedTaskIds.add(summary.getId());
            }
        }).collect(Collectors.toList());
        TaskSummary claimedReference = taskSummaryList.stream().filter(summary -> updateClaimedTaskIds.contains(summary.getId())).findFirst().orElse(null);
        if (!taskSummaryList.isEmpty()) {
            this.taskMapper.updateCompleted(taskIds, (TaskSummary)taskSummaryList.get(0));
            if (!updateClaimedTaskIds.isEmpty()) {
                this.taskMapper.updateClaimed(updateClaimedTaskIds, claimedReference);
            }
            if (HistoryEventManager.isHistoryEnabled()) {
                this.createTasksCompletedEvents(taskSummaryList);
            }
        }
        Object var10_10 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var10_10);
    }

    private void addClassificationSummariesToTaskSummaries(List<TaskSummaryImpl> tasks, List<ClassificationSummary> classifications) {
        List<TaskSummaryImpl> list = tasks;
        List<ClassificationSummary> list2 = classifications;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_67, (Object)this, (Object)this, list, list2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (tasks != null && !tasks.isEmpty()) {
            for (TaskSummaryImpl task : tasks) {
                String classificationId = task.getClassificationSummary().getId();
                ClassificationSummary classificationSummary = classifications.stream().filter(c -> c.getId().equals(classificationId)).findFirst().orElse(null);
                if (classificationSummary == null) {
                    throw new SystemException("Did not find a Classification for task (Id=" + task.getId() + ",classification=" + task.getClassificationSummary().getId() + ")");
                }
                task.setClassificationSummary(classificationSummary);
            }
        }
        Object var10_10 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var10_10);
    }

    private List<ClassificationSummary> findClassificationsForTasksAndAttachments(List<TaskSummaryImpl> taskSummaries, List<AttachmentSummaryImpl> attachmentSummaries) {
        ArrayList<ClassificationSummary> arrayList;
        List<ClassificationSummary> list;
        List<ClassificationSummary> list2;
        List<TaskSummaryImpl> list3 = taskSummaries;
        List<AttachmentSummaryImpl> list4 = attachmentSummaries;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_68, (Object)this, (Object)this, list3, list4);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (taskSummaries == null || taskSummaries.isEmpty()) {
            list = list2 = new ArrayList<ClassificationSummary>();
        } else {
            Set<String> classificationIdSet = taskSummaries.stream().map(t -> t.getClassificationSummary().getId()).collect(Collectors.toSet());
            if (attachmentSummaries != null && !attachmentSummaries.isEmpty()) {
                for (AttachmentSummaryImpl att : attachmentSummaries) {
                    classificationIdSet.add(att.getClassificationSummary().getId());
                }
            }
            list = list2 = this.queryClassificationsForTasksAndAttachments(classificationIdSet);
        }
        ArrayList<ClassificationSummary> arrayList2 = arrayList = list;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, arrayList);
        return list2;
    }

    private List<ClassificationSummary> findClassificationForTaskImplAndAttachments(TaskImpl task, List<AttachmentImpl> attachmentImpls) {
        List<ClassificationSummary> list;
        List<ClassificationSummary> list2;
        TaskImpl taskImpl = task;
        List<AttachmentImpl> list3 = attachmentImpls;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_69, (Object)this, (Object)this, (Object)taskImpl, list3);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        HashSet<String> classificationIdSet = new HashSet<String>(Collections.singletonList(task.getClassificationSummary().getId()));
        if (attachmentImpls != null && !attachmentImpls.isEmpty()) {
            for (AttachmentImpl att : attachmentImpls) {
                classificationIdSet.add(att.getClassificationSummary().getId());
            }
        }
        List<ClassificationSummary> list4 = list2 = (list = this.queryClassificationsForTasksAndAttachments(classificationIdSet));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, list2);
        return list;
    }

    private List<ClassificationSummary> queryClassificationsForTasksAndAttachments(Set<String> classificationIdSet) {
        List list;
        List list2;
        Set<String> set = classificationIdSet;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_70, (Object)this, (Object)this, set);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] classificationIdArray = classificationIdSet.toArray(new String[0]);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("getClassificationsForTasksAndAttachments() about to query classifications and exit");
        }
        List list3 = list2 = (list = this.classificationService.createClassificationQuery().idIn(classificationIdArray).list());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)list2);
        return list;
    }

    private void addWorkbasketSummariesToTaskSummaries(List<TaskSummaryImpl> taskSummaries) {
        List<TaskSummaryImpl> list = taskSummaries;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_71, (Object)this, (Object)this, list);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (taskSummaries != null && !taskSummaries.isEmpty()) {
            String[] workbasketIdArray = (String[])taskSummaries.stream().map(t -> t.getWorkbasketSummary().getId()).distinct().toArray(String[]::new);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("addWorkbasketSummariesToTaskSummaries() about to query workbaskets");
            }
            WorkbasketQueryImpl query = (WorkbasketQueryImpl)this.workbasketService.createWorkbasketQuery();
            query.setUsedToAugmentTasks(true);
            List workbaskets = query.idIn(workbasketIdArray).list();
            Iterator<TaskSummaryImpl> taskIterator = taskSummaries.iterator();
            while (taskIterator.hasNext()) {
                TaskSummaryImpl task = taskIterator.next();
                String workbasketId = task.getWorkbasketSummaryImpl().getId();
                WorkbasketSummary workbasketSummary = workbaskets.stream().filter(x -> workbasketId != null && workbasketId.equals(x.getId())).findFirst().orElse(null);
                if (workbasketSummary == null) {
                    LOGGER.warn("Could not find a Workbasket for task {}.", (Object)task.getId());
                    taskIterator.remove();
                    continue;
                }
                task.setWorkbasketSummary(workbasketSummary);
            }
        }
        Object var11_11 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var11_11);
    }

    private void addAttachmentSummariesToTaskSummaries(List<TaskSummaryImpl> taskSummaries, List<AttachmentSummaryImpl> attachmentSummaries, List<ClassificationSummary> classifications) {
        List<TaskSummaryImpl> list = taskSummaries;
        List<AttachmentSummaryImpl> list2 = attachmentSummaries;
        List<ClassificationSummary> list3 = classifications;
        Object[] objectArray = new Object[]{list, list2, list3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_72, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (taskSummaries != null && !taskSummaries.isEmpty()) {
            this.addClassificationSummariesToAttachmentSummaries(attachmentSummaries, taskSummaries, classifications);
            for (TaskSummaryImpl task : taskSummaries) {
                for (AttachmentSummaryImpl attachment : attachmentSummaries) {
                    if (attachment.getTaskId() == null || !attachment.getTaskId().equals(task.getId())) continue;
                    task.addAttachmentSummary(attachment);
                }
            }
        }
        Object var13_13 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var13_13);
    }

    private void addClassificationSummariesToAttachmentSummaries(List<AttachmentSummaryImpl> attachmentSummaries, List<TaskSummaryImpl> taskSummaries, List<ClassificationSummary> classifications) {
        List<AttachmentSummaryImpl> list = attachmentSummaries;
        List<TaskSummaryImpl> list2 = taskSummaries;
        List<ClassificationSummary> list3 = classifications;
        Object[] objectArray = new Object[]{list, list2, list3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_73, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (attachmentSummaries != null && !attachmentSummaries.isEmpty() && taskSummaries != null && !taskSummaries.isEmpty()) {
            for (AttachmentSummaryImpl att : attachmentSummaries) {
                String classificationId = att.getClassificationSummary().getId();
                ClassificationSummary classificationSummary = classifications.stream().filter(x -> classificationId != null && classificationId.equals(x.getId())).findFirst().orElse(null);
                if (classificationSummary == null) {
                    throw new SystemException("Could not find a Classification for attachment " + att);
                }
                att.setClassificationSummary(classificationSummary);
            }
        }
        Object var13_13 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var13_13);
    }

    private List<Attachment> addClassificationSummariesToAttachments(List<AttachmentImpl> attachmentImpls, List<ClassificationSummary> classifications) {
        ArrayList<Attachment> arrayList;
        ArrayList<Attachment> arrayList2;
        ArrayList<Attachment> arrayList3;
        List<AttachmentImpl> list = attachmentImpls;
        List<ClassificationSummary> list2 = classifications;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_74, (Object)this, (Object)this, list, list2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (attachmentImpls == null || attachmentImpls.isEmpty()) {
            arrayList2 = arrayList3 = new ArrayList<Attachment>();
        } else {
            ArrayList<AttachmentImpl> result = new ArrayList<AttachmentImpl>();
            for (AttachmentImpl att : attachmentImpls) {
                ClassificationSummary classificationSummary = classifications.stream().filter(c -> c != null && c.getId().equals(att.getClassificationSummary().getId())).findFirst().orElse(null);
                if (classificationSummary == null) {
                    throw new SystemException("Could not find a Classification for attachment " + att);
                }
                att.setClassificationSummary(classificationSummary);
                result.add(att);
            }
            arrayList2 = arrayList3 = result;
        }
        ArrayList<Attachment> arrayList4 = arrayList = arrayList2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, arrayList);
        return arrayList3;
    }

    private TaskImpl initUpdatedTask(Map<TaskCustomField, String> customFieldsToUpdate, TaskCustomPropertySelector fieldSelector) {
        TaskImpl taskImpl;
        TaskImpl taskImpl2;
        Map<TaskCustomField, String> map = customFieldsToUpdate;
        TaskCustomPropertySelector taskCustomPropertySelector = fieldSelector;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_75, (Object)this, (Object)this, map, (Object)taskCustomPropertySelector);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        TaskImpl newTask = new TaskImpl();
        newTask.setModified(Instant.now());
        for (Map.Entry<TaskCustomField, String> entry : customFieldsToUpdate.entrySet()) {
            TaskCustomField key = entry.getKey();
            fieldSelector.setCustomProperty(key, true);
            newTask.setCustomAttribute(key, entry.getValue());
        }
        TaskImpl taskImpl3 = taskImpl2 = (taskImpl = newTask);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskImpl2);
        return taskImpl;
    }

    private void validateCustomFields(Map<TaskCustomField, String> customFieldsToUpdate) throws InvalidArgumentException {
        Map<TaskCustomField, String> map = customFieldsToUpdate;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_76, (Object)this, (Object)this, map);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (customFieldsToUpdate == null || customFieldsToUpdate.isEmpty()) {
            throw new InvalidArgumentException("The customFieldsToUpdate argument to updateTasks must not be empty.");
        }
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    private List<TaskSummary> getTasksToChange(List<String> taskIds) {
        List list;
        List list2;
        List<String> list3 = taskIds;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_77, (Object)this, (Object)this, list3);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        List list4 = list2 = (list = this.createTaskQuery().idIn(taskIds.toArray(new String[0])).list());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)list2);
        return list;
    }

    private List<TaskSummary> getTasksToChange(ObjectReference selectionCriteria) {
        List list;
        List list2;
        ObjectReference objectReference = selectionCriteria;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_78, (Object)this, (Object)this, (Object)objectReference);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        List list3 = list2 = (list = this.createTaskQuery().primaryObjectReferenceCompanyIn(selectionCriteria.getCompany()).primaryObjectReferenceSystemIn(selectionCriteria.getSystem()).primaryObjectReferenceSystemInstanceIn(selectionCriteria.getSystemInstance()).primaryObjectReferenceTypeIn(selectionCriteria.getType()).primaryObjectReferenceValueIn(selectionCriteria.getValue()).list());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)list2);
        return list;
    }

    private void standardUpdateActions(TaskImpl oldTaskImpl, TaskImpl newTaskImpl) throws InvalidArgumentException, InvalidStateException, ClassificationNotFoundException {
        boolean isOwnerChanged;
        TaskImpl taskImpl = oldTaskImpl;
        TaskImpl taskImpl2 = newTaskImpl;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_79, (Object)this, (Object)this, (Object)taskImpl, (Object)taskImpl2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (oldTaskImpl.getExternalId() == null || !oldTaskImpl.getExternalId().equals(newTaskImpl.getExternalId())) {
            throw new InvalidArgumentException("A task's external Id cannot be changed via update of the task");
        }
        String newWorkbasketKey = newTaskImpl.getWorkbasketKey();
        if (newWorkbasketKey != null && !newWorkbasketKey.equals(oldTaskImpl.getWorkbasketKey())) {
            throw new InvalidArgumentException("A task's Workbasket cannot be changed via update of the task");
        }
        if (newTaskImpl.getClassificationSummary() == null) {
            newTaskImpl.setClassificationSummary(oldTaskImpl.getClassificationSummary());
        }
        this.updateClassificationSummary(newTaskImpl, oldTaskImpl);
        TaskImpl newTaskImpl1 = this.serviceLevelHandler.updatePrioPlannedDueOfTask(newTaskImpl, oldTaskImpl, false);
        if (newTaskImpl1.getBusinessProcessId() == null) {
            newTaskImpl1.setBusinessProcessId(oldTaskImpl.getBusinessProcessId());
        }
        boolean bl = isOwnerChanged = !Objects.equals(newTaskImpl1.getOwner(), oldTaskImpl.getOwner());
        if (isOwnerChanged && oldTaskImpl.getState() != TaskState.READY) {
            throw new InvalidStateException(String.format("Task with id %s is in state %s and not in state ready.", new Object[]{oldTaskImpl.getId(), oldTaskImpl.getState()}));
        }
        Object var9_9 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var9_9);
    }

    private void updateClassificationSummary(TaskImpl newTaskImpl, TaskImpl oldTaskImpl) throws ClassificationNotFoundException {
        TaskImpl taskImpl = newTaskImpl;
        TaskImpl taskImpl2 = oldTaskImpl;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_80, (Object)this, (Object)this, (Object)taskImpl, (Object)taskImpl2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ClassificationSummary oldClassificationSummary = oldTaskImpl.getClassificationSummary();
        ClassificationSummary newClassificationSummary = newTaskImpl.getClassificationSummary();
        if (newClassificationSummary == null) {
            newClassificationSummary = oldClassificationSummary;
        }
        if (!oldClassificationSummary.getKey().equals(newClassificationSummary.getKey())) {
            Classification newClassification = this.classificationService.getClassification(newClassificationSummary.getKey(), newTaskImpl.getWorkbasketSummary().getDomain());
            newClassificationSummary = newClassification.asSummary();
            newTaskImpl.setClassificationSummary(newClassificationSummary);
        }
        Object var9_9 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var9_9);
    }

    private void createTasksCompletedEvents(List<? extends TaskSummary> taskSummaries) {
        List<? extends TaskSummary> list = taskSummaries;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_81, (Object)this, (Object)this, list);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        taskSummaries.forEach(task -> this.historyEventManager.createEvent(new TaskCompletedEvent(IdGenerator.generateWithPrefix((String)"THI"), (TaskSummary)task, this.taskanaEngine.getEngine().getCurrentUserContext().getUserid())));
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("TaskServiceImpl.java", TaskServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "claim", "pro.taskana.task.internal.TaskServiceImpl", "java.lang.String", "taskId", "pro.taskana.task.api.exceptions.TaskNotFoundException:pro.taskana.task.api.exceptions.InvalidStateException:pro.taskana.task.api.exceptions.InvalidOwnerException:pro.taskana.common.api.exceptions.NotAuthorizedException", "pro.taskana.task.api.models.Task"), 117);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "forceClaim", "pro.taskana.task.internal.TaskServiceImpl", "java.lang.String", "taskId", "pro.taskana.task.api.exceptions.TaskNotFoundException:pro.taskana.task.api.exceptions.InvalidStateException:pro.taskana.task.api.exceptions.InvalidOwnerException:pro.taskana.common.api.exceptions.NotAuthorizedException", "pro.taskana.task.api.models.Task"), 124);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setTaskRead", "pro.taskana.task.internal.TaskServiceImpl", "java.lang.String:boolean", "taskId:isRead", "pro.taskana.task.api.exceptions.TaskNotFoundException:pro.taskana.common.api.exceptions.NotAuthorizedException", "pro.taskana.task.api.models.Task"), 347);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createTaskQuery", "pro.taskana.task.internal.TaskServiceImpl", "", "", "", "pro.taskana.task.api.TaskQuery"), 366);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "newTask", "pro.taskana.task.internal.TaskServiceImpl", "", "", "", "pro.taskana.task.api.models.Task"), 371);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "newTask", "pro.taskana.task.internal.TaskServiceImpl", "java.lang.String", "workbasketId", "", "pro.taskana.task.api.models.Task"), 376);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "newTask", "pro.taskana.task.internal.TaskServiceImpl", "java.lang.String:java.lang.String", "workbasketKey:domain", "", "pro.taskana.task.api.models.Task"), 386);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "newTaskComment", "pro.taskana.task.internal.TaskServiceImpl", "java.lang.String", "taskId", "", "pro.taskana.task.api.models.TaskComment"), 396);
        ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "newAttachment", "pro.taskana.task.internal.TaskServiceImpl", "", "", "", "pro.taskana.task.api.models.Attachment"), 401);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateTask", "pro.taskana.task.internal.TaskServiceImpl", "pro.taskana.task.api.models.Task", "task", "pro.taskana.common.api.exceptions.InvalidArgumentException:pro.taskana.task.api.exceptions.TaskNotFoundException:pro.taskana.common.api.exceptions.ConcurrencyException:pro.taskana.common.api.exceptions.NotAuthorizedException:pro.taskana.task.api.exceptions.AttachmentPersistenceException:pro.taskana.task.api.exceptions.InvalidStateException:pro.taskana.classification.api.exceptions.ClassificationNotFoundException", "pro.taskana.task.api.models.Task"), 406);
        ajc$tjp_18 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "transferTasks", "pro.taskana.task.internal.TaskServiceImpl", "java.lang.String:java.util.List:boolean", "destinationWorkbasketId:taskIds:setTransferFlag", "pro.taskana.common.api.exceptions.NotAuthorizedException:pro.taskana.common.api.exceptions.InvalidArgumentException:pro.taskana.workbasket.api.exceptions.WorkbasketNotFoundException", "pro.taskana.common.api.BulkOperationResults"), 450);
        ajc$tjp_19 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "transferTasks", "pro.taskana.task.internal.TaskServiceImpl", "java.lang.String:java.lang.String:java.util.List:boolean", "destinationWorkbasketKey:destinationWorkbasketDomain:taskIds:setTransferFlag", "pro.taskana.common.api.exceptions.NotAuthorizedException:pro.taskana.common.api.exceptions.InvalidArgumentException:pro.taskana.workbasket.api.exceptions.WorkbasketNotFoundException", "pro.taskana.common.api.BulkOperationResults"), 457);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "cancelClaim", "pro.taskana.task.internal.TaskServiceImpl", "java.lang.String", "taskId", "pro.taskana.task.api.exceptions.TaskNotFoundException:pro.taskana.task.api.exceptions.InvalidStateException:pro.taskana.task.api.exceptions.InvalidOwnerException:pro.taskana.common.api.exceptions.NotAuthorizedException", "pro.taskana.task.api.models.Task"), 131);
        ajc$tjp_20 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteTask", "pro.taskana.task.internal.TaskServiceImpl", "java.lang.String", "taskId", "pro.taskana.task.api.exceptions.TaskNotFoundException:pro.taskana.task.api.exceptions.InvalidStateException:pro.taskana.common.api.exceptions.NotAuthorizedException", "void"), 468);
        ajc$tjp_21 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "forceDeleteTask", "pro.taskana.task.internal.TaskServiceImpl", "java.lang.String", "taskId", "pro.taskana.task.api.exceptions.TaskNotFoundException:pro.taskana.task.api.exceptions.InvalidStateException:pro.taskana.common.api.exceptions.NotAuthorizedException", "void"), 474);
        ajc$tjp_22 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "selectAndClaim", "pro.taskana.task.internal.TaskServiceImpl", "pro.taskana.task.api.TaskQuery", "taskQuery", "pro.taskana.common.api.exceptions.NotAuthorizedException:pro.taskana.task.api.exceptions.InvalidOwnerException", "pro.taskana.task.api.models.Task"), 480);
        ajc$tjp_23 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteTasks", "pro.taskana.task.internal.TaskServiceImpl", "java.util.List", "taskIds", "pro.taskana.common.api.exceptions.InvalidArgumentException:pro.taskana.common.api.exceptions.NotAuthorizedException", "pro.taskana.common.api.BulkOperationResults"), 507);
        ajc$tjp_24 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "completeTasks", "pro.taskana.task.internal.TaskServiceImpl", "java.util.List", "taskIds", "pro.taskana.common.api.exceptions.InvalidArgumentException", "pro.taskana.common.api.BulkOperationResults"), 551);
        ajc$tjp_25 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "forceCompleteTasks", "pro.taskana.task.internal.TaskServiceImpl", "java.util.List", "taskIds", "pro.taskana.common.api.exceptions.InvalidArgumentException", "pro.taskana.common.api.BulkOperationResults"), 557);
        ajc$tjp_26 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateTasks", "pro.taskana.task.internal.TaskServiceImpl", "pro.taskana.task.api.models.ObjectReference:java.util.Map", "selectionCriteria:customFieldsToUpdate", "pro.taskana.common.api.exceptions.InvalidArgumentException", "java.util.List"), 563);
        ajc$tjp_27 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateTasks", "pro.taskana.task.internal.TaskServiceImpl", "java.util.List:java.util.Map", "taskIds:customFieldsToUpdate", "pro.taskana.common.api.exceptions.InvalidArgumentException", "java.util.List"), 598);
        ajc$tjp_28 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createTaskComment", "pro.taskana.task.internal.TaskServiceImpl", "pro.taskana.task.api.models.TaskComment", "taskComment", "pro.taskana.common.api.exceptions.NotAuthorizedException:pro.taskana.task.api.exceptions.TaskNotFoundException:pro.taskana.common.api.exceptions.InvalidArgumentException", "pro.taskana.task.api.models.TaskComment"), 632);
        ajc$tjp_29 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateTaskComment", "pro.taskana.task.internal.TaskServiceImpl", "pro.taskana.task.api.models.TaskComment", "taskComment", "pro.taskana.common.api.exceptions.NotAuthorizedException:pro.taskana.common.api.exceptions.ConcurrencyException:pro.taskana.task.api.exceptions.TaskCommentNotFoundException:pro.taskana.task.api.exceptions.TaskNotFoundException:pro.taskana.common.api.exceptions.InvalidArgumentException", "pro.taskana.task.api.models.TaskComment"), 638);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "forceCancelClaim", "pro.taskana.task.internal.TaskServiceImpl", "java.lang.String", "taskId", "pro.taskana.task.api.exceptions.TaskNotFoundException:pro.taskana.task.api.exceptions.InvalidStateException:pro.taskana.task.api.exceptions.InvalidOwnerException:pro.taskana.common.api.exceptions.NotAuthorizedException", "pro.taskana.task.api.models.Task"), 138);
        ajc$tjp_30 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteTaskComment", "pro.taskana.task.internal.TaskServiceImpl", "java.lang.String", "taskCommentId", "pro.taskana.common.api.exceptions.NotAuthorizedException:pro.taskana.task.api.exceptions.TaskCommentNotFoundException:pro.taskana.task.api.exceptions.TaskNotFoundException:pro.taskana.common.api.exceptions.InvalidArgumentException", "void"), 645);
        ajc$tjp_31 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTaskComment", "pro.taskana.task.internal.TaskServiceImpl", "java.lang.String", "taskCommentid", "pro.taskana.task.api.exceptions.TaskCommentNotFoundException:pro.taskana.common.api.exceptions.NotAuthorizedException:pro.taskana.task.api.exceptions.TaskNotFoundException:pro.taskana.common.api.exceptions.InvalidArgumentException", "pro.taskana.task.api.models.TaskComment"), 652);
        ajc$tjp_32 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTaskComments", "pro.taskana.task.internal.TaskServiceImpl", "java.lang.String", "taskId", "pro.taskana.common.api.exceptions.NotAuthorizedException:pro.taskana.task.api.exceptions.TaskNotFoundException", "java.util.List"), 659);
        ajc$tjp_33 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setCallbackStateForTasks", "pro.taskana.task.internal.TaskServiceImpl", "java.util.List:pro.taskana.task.api.CallbackState", "externalIds:state", "", "pro.taskana.common.api.BulkOperationResults"), 666);
        ajc$tjp_34 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setOwnerOfTasks", "pro.taskana.task.internal.TaskServiceImpl", "java.lang.String:java.util.List", "owner:argTaskIds", "", "pro.taskana.common.api.BulkOperationResults"), 694);
        ajc$tjp_35 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setPlannedPropertyOfTasks", "pro.taskana.task.internal.TaskServiceImpl", "java.time.Instant:java.util.List", "planned:argTaskIds", "", "pro.taskana.common.api.BulkOperationResults"), 739);
        ajc$tjp_36 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "cancelTask", "pro.taskana.task.internal.TaskServiceImpl", "java.lang.String", "taskId", "pro.taskana.task.api.exceptions.TaskNotFoundException:pro.taskana.task.api.exceptions.InvalidStateException:pro.taskana.common.api.exceptions.NotAuthorizedException", "pro.taskana.task.api.models.Task"), 761);
        ajc$tjp_37 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "terminateTask", "pro.taskana.task.internal.TaskServiceImpl", "java.lang.String", "taskId", "pro.taskana.task.api.exceptions.TaskNotFoundException:pro.taskana.task.api.exceptions.InvalidStateException:pro.taskana.common.api.exceptions.NotAuthorizedException", "pro.taskana.task.api.models.Task"), 785);
        ajc$tjp_38 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "findTasksIdsAffectedByClassificationChange", "pro.taskana.task.internal.TaskServiceImpl", "java.lang.String", "classificationId", "", "java.util.List"), 810);
        ajc$tjp_39 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "refreshPriorityAndDueDatesOfTasksOnClassificationUpdate", "pro.taskana.task.internal.TaskServiceImpl", "java.util.List:boolean:boolean", "taskIds:serviceLevelChanged:priorityChanged", "", "void"), 851);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "completeTask", "pro.taskana.task.internal.TaskServiceImpl", "java.lang.String", "taskId", "pro.taskana.task.api.exceptions.TaskNotFoundException:pro.taskana.task.api.exceptions.InvalidOwnerException:pro.taskana.task.api.exceptions.InvalidStateException:pro.taskana.common.api.exceptions.NotAuthorizedException", "pro.taskana.task.api.models.Task"), 145);
        ajc$tjp_40 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "getMinimalTaskSummaries", "pro.taskana.task.internal.TaskServiceImpl", "java.util.List", "argTaskIds", "", "pro.taskana.common.internal.util.Pair"), 877);
        ajc$tjp_41 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "filterTasksAuthorizedForAndLogErrorsForNotAuthorized", "pro.taskana.task.internal.TaskServiceImpl", "java.util.List", "existingTasks", "", "pro.taskana.common.internal.util.Pair"), 890);
        ajc$tjp_42 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "addExceptionsForNonExistingTasksToBulkLog", "pro.taskana.task.internal.TaskServiceImpl", "java.util.List:java.util.List", "requestTaskIds:existingMinimalTaskSummaries", "", "pro.taskana.task.internal.ServiceLevelHandler$BulkLog"), 918);
        ajc$tjp_43 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "augmentTaskSummariesByContainedSummariesWithPartitioning", "pro.taskana.task.internal.TaskServiceImpl", "java.util.List", "taskSummaries", "", "java.util.List"), 933);
        ajc$tjp_44 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "augmentTaskSummariesByContainedSummariesWithoutPartitioning", "pro.taskana.task.internal.TaskServiceImpl", "java.util.List", "taskSummaries", "", "java.util.List"), 943);
        ajc$tjp_45 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "completeTasks", "pro.taskana.task.internal.TaskServiceImpl", "java.util.List:boolean", "taskIds:forced", "pro.taskana.common.api.exceptions.InvalidArgumentException", "pro.taskana.common.api.BulkOperationResults"), 971);
        ajc$tjp_46 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "filterNotExistingTaskIds", "pro.taskana.task.internal.TaskServiceImpl", "java.util.List:pro.taskana.common.api.BulkOperationResults", "taskIds:bulkLog", "", "java.util.stream.Stream"), 1012);
        ajc$tjp_47 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "addErrorToBulkLog", "pro.taskana.task.internal.TaskServiceImpl", "pro.taskana.common.internal.util.CheckedConsumer:pro.taskana.common.api.BulkOperationResults", "checkedConsumer:bulkLog", "", "java.util.function.Predicate"), 1035);
        ajc$tjp_48 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "checkConcurrencyAndSetModified", "pro.taskana.task.internal.TaskServiceImpl", "pro.taskana.task.internal.models.TaskImpl:pro.taskana.task.internal.models.TaskImpl", "newTaskImpl:oldTaskImpl", "pro.taskana.common.api.exceptions.ConcurrencyException", "void"), 1049);
        ajc$tjp_49 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "terminateCancelCommonActions", "pro.taskana.task.internal.TaskServiceImpl", "java.lang.String:pro.taskana.task.api.TaskState", "taskId:targetState", "pro.taskana.common.api.exceptions.NotAuthorizedException:pro.taskana.task.api.exceptions.TaskNotFoundException:pro.taskana.task.api.exceptions.InvalidStateException", "pro.taskana.task.internal.models.TaskImpl"), 1064);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "forceCompleteTask", "pro.taskana.task.internal.TaskServiceImpl", "java.lang.String", "taskId", "pro.taskana.task.api.exceptions.TaskNotFoundException:pro.taskana.task.api.exceptions.InvalidOwnerException:pro.taskana.task.api.exceptions.InvalidStateException:pro.taskana.common.api.exceptions.NotAuthorizedException", "pro.taskana.task.api.models.Task"), 152);
        ajc$tjp_50 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "addExceptionsForTasksWhoseOwnerWasNotSet", "pro.taskana.task.internal.TaskServiceImpl", "java.lang.String:java.util.List", "owner:existingMinimalTaskSummaries", "", "pro.taskana.common.api.BulkOperationResults"), 1091);
        ajc$tjp_51 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "claim", "pro.taskana.task.internal.TaskServiceImpl", "java.lang.String:boolean", "taskId:forceClaim", "pro.taskana.task.api.exceptions.TaskNotFoundException:pro.taskana.task.api.exceptions.InvalidStateException:pro.taskana.task.api.exceptions.InvalidOwnerException:pro.taskana.common.api.exceptions.NotAuthorizedException", "pro.taskana.task.api.models.Task"), 1115);
        ajc$tjp_52 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "claimActionsOnTask", "pro.taskana.task.internal.TaskServiceImpl", "pro.taskana.task.internal.models.TaskSummaryImpl:java.lang.String:java.time.Instant", "task:userId:now", "", "void"), 1144);
        ajc$tjp_53 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "completeActionsOnTask", "pro.taskana.task.internal.TaskServiceImpl", "pro.taskana.task.internal.models.TaskSummaryImpl:java.lang.String:java.time.Instant", "task:userId:now", "", "void"), 1152);
        ajc$tjp_54 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "checkPreconditionsForClaimTask", "pro.taskana.task.internal.TaskServiceImpl", "pro.taskana.task.api.models.TaskSummary:boolean", "task:forced", "pro.taskana.task.api.exceptions.InvalidStateException:pro.taskana.task.api.exceptions.InvalidOwnerException", "void"), 1159);
        ajc$tjp_55 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "taskIsNotClaimed", "pro.taskana.task.internal.TaskServiceImpl", "pro.taskana.task.api.models.TaskSummary", "task", "", "boolean"), 1175);
        ajc$tjp_56 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "checkIfTaskIsTerminatedOrCancelled", "pro.taskana.task.internal.TaskServiceImpl", "pro.taskana.task.api.models.TaskSummary", "task", "pro.taskana.task.api.exceptions.InvalidStateException", "void"), 1179);
        ajc$tjp_57 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "checkPreconditionsForCompleteTask", "pro.taskana.task.internal.TaskServiceImpl", "pro.taskana.task.api.models.TaskSummary", "task", "pro.taskana.task.api.exceptions.InvalidStateException:pro.taskana.task.api.exceptions.InvalidOwnerException", "void"), 1188);
        ajc$tjp_58 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "cancelClaim", "pro.taskana.task.internal.TaskServiceImpl", "java.lang.String:boolean", "taskId:forceUnclaim", "pro.taskana.task.api.exceptions.TaskNotFoundException:pro.taskana.task.api.exceptions.InvalidStateException:pro.taskana.task.api.exceptions.InvalidOwnerException:pro.taskana.common.api.exceptions.NotAuthorizedException", "pro.taskana.task.api.models.Task"), 1208);
        ajc$tjp_59 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "completeTask", "pro.taskana.task.internal.TaskServiceImpl", "java.lang.String:boolean", "taskId:isForced", "pro.taskana.task.api.exceptions.TaskNotFoundException:pro.taskana.task.api.exceptions.InvalidOwnerException:pro.taskana.task.api.exceptions.InvalidStateException:pro.taskana.common.api.exceptions.NotAuthorizedException", "pro.taskana.task.api.models.Task"), 1248);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createTask", "pro.taskana.task.internal.TaskServiceImpl", "pro.taskana.task.api.models.Task", "taskToCreate", "pro.taskana.common.api.exceptions.NotAuthorizedException:pro.taskana.workbasket.api.exceptions.WorkbasketNotFoundException:pro.taskana.classification.api.exceptions.ClassificationNotFoundException:pro.taskana.task.api.exceptions.TaskAlreadyExistException:pro.taskana.common.api.exceptions.InvalidArgumentException", "pro.taskana.task.api.models.Task"), 159);
        ajc$tjp_60 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "deleteTask", "pro.taskana.task.internal.TaskServiceImpl", "java.lang.String:boolean", "taskId:forceDelete", "pro.taskana.task.api.exceptions.TaskNotFoundException:pro.taskana.task.api.exceptions.InvalidStateException:pro.taskana.common.api.exceptions.NotAuthorizedException", "void"), 1288);
        ajc$tjp_61 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "removeSingleTaskForTaskDeletionById", "pro.taskana.task.internal.TaskServiceImpl", "pro.taskana.common.api.BulkOperationResults:java.util.List:java.util.Iterator", "bulkLog:taskSummaries:taskIdIterator", "", "void"), 1324);
        ajc$tjp_62 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "removeSingleTaskForCallbackStateByExternalId", "pro.taskana.task.internal.TaskServiceImpl", "pro.taskana.common.api.BulkOperationResults:java.util.List:java.util.Iterator:pro.taskana.task.api.CallbackState", "bulkLog:taskSummaries:externalIdIterator:desiredCallbackState", "", "void"), 1363);
        ajc$tjp_63 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "desiredCallbackStateCanBeSetForFoundSummary", "pro.taskana.task.internal.TaskServiceImpl", "pro.taskana.task.internal.models.MinimalTaskSummary:pro.taskana.task.api.CallbackState", "foundSummary:desiredCallbackState", "", "boolean"), 1395);
        ajc$tjp_64 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "standardSettings", "pro.taskana.task.internal.TaskServiceImpl", "pro.taskana.task.internal.models.TaskImpl:pro.taskana.classification.api.models.Classification", "task:classification", "pro.taskana.common.api.exceptions.InvalidArgumentException", "void"), 1420);
        ajc$tjp_65 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "setCallbackStateOnTaskCreation", "pro.taskana.task.internal.TaskServiceImpl", "pro.taskana.task.internal.models.TaskImpl", "task", "pro.taskana.common.api.exceptions.InvalidArgumentException", "void"), 1470);
        ajc$tjp_66 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "updateTasksToBeCompleted", "pro.taskana.task.internal.TaskServiceImpl", "java.util.stream.Stream:java.time.Instant", "taskSummaries:now", "", "void"), 1488);
        ajc$tjp_67 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "addClassificationSummariesToTaskSummaries", "pro.taskana.task.internal.TaskServiceImpl", "java.util.List:java.util.List", "tasks:classifications", "", "void"), 1525);
        ajc$tjp_68 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "findClassificationsForTasksAndAttachments", "pro.taskana.task.internal.TaskServiceImpl", "java.util.List:java.util.List", "taskSummaries:attachmentSummaries", "", "java.util.List"), 1552);
        ajc$tjp_69 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "findClassificationForTaskImplAndAttachments", "pro.taskana.task.internal.TaskServiceImpl", "pro.taskana.task.internal.models.TaskImpl:java.util.List", "task:attachmentImpls", "", "java.util.List"), 1571);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTask", "pro.taskana.task.internal.TaskServiceImpl", "java.lang.String", "id", "pro.taskana.common.api.exceptions.NotAuthorizedException:pro.taskana.task.api.exceptions.TaskNotFoundException", "pro.taskana.task.api.models.Task"), 276);
        ajc$tjp_70 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "queryClassificationsForTasksAndAttachments", "pro.taskana.task.internal.TaskServiceImpl", "java.util.Set", "classificationIdSet", "", "java.util.List"), 1583);
        ajc$tjp_71 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "addWorkbasketSummariesToTaskSummaries", "pro.taskana.task.internal.TaskServiceImpl", "java.util.List", "taskSummaries", "", "void"), 1599);
        ajc$tjp_72 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "addAttachmentSummariesToTaskSummaries", "pro.taskana.task.internal.TaskServiceImpl", "java.util.List:java.util.List:java.util.List", "taskSummaries:attachmentSummaries:classifications", "", "void"), 1636);
        ajc$tjp_73 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "addClassificationSummariesToAttachmentSummaries", "pro.taskana.task.internal.TaskServiceImpl", "java.util.List:java.util.List:java.util.List", "attachmentSummaries:taskSummaries:classifications", "", "void"), 1661);
        ajc$tjp_74 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "addClassificationSummariesToAttachments", "pro.taskana.task.internal.TaskServiceImpl", "java.util.List:java.util.List", "attachmentImpls:classifications", "", "java.util.List"), 1687);
        ajc$tjp_75 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "initUpdatedTask", "pro.taskana.task.internal.TaskServiceImpl", "java.util.Map:pro.taskana.task.internal.TaskCustomPropertySelector", "customFieldsToUpdate:fieldSelector", "", "pro.taskana.task.internal.models.TaskImpl"), 1713);
        ajc$tjp_76 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "validateCustomFields", "pro.taskana.task.internal.TaskServiceImpl", "java.util.Map", "customFieldsToUpdate", "pro.taskana.common.api.exceptions.InvalidArgumentException", "void"), 1727);
        ajc$tjp_77 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getTasksToChange", "pro.taskana.task.internal.TaskServiceImpl", "java.util.List", "taskIds", "", "java.util.List"), 1736);
        ajc$tjp_78 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getTasksToChange", "pro.taskana.task.internal.TaskServiceImpl", "pro.taskana.task.api.models.ObjectReference", "selectionCriteria", "", "java.util.List"), 1740);
        ajc$tjp_79 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "standardUpdateActions", "pro.taskana.task.internal.TaskServiceImpl", "pro.taskana.task.internal.models.TaskImpl:pro.taskana.task.internal.models.TaskImpl", "oldTaskImpl:newTaskImpl", "pro.taskana.common.api.exceptions.InvalidArgumentException:pro.taskana.task.api.exceptions.InvalidStateException:pro.taskana.classification.api.exceptions.ClassificationNotFoundException", "void"), 1750);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "transfer", "pro.taskana.task.internal.TaskServiceImpl", "java.lang.String:java.lang.String:boolean", "taskId:destinationWorkbasketId:setTransferFlag", "pro.taskana.task.api.exceptions.TaskNotFoundException:pro.taskana.workbasket.api.exceptions.WorkbasketNotFoundException:pro.taskana.common.api.exceptions.NotAuthorizedException:pro.taskana.task.api.exceptions.InvalidStateException", "pro.taskana.task.api.models.Task"), 333);
        ajc$tjp_80 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "updateClassificationSummary", "pro.taskana.task.internal.TaskServiceImpl", "pro.taskana.task.internal.models.TaskImpl:pro.taskana.task.internal.models.TaskImpl", "newTaskImpl:oldTaskImpl", "pro.taskana.classification.api.exceptions.ClassificationNotFoundException", "void"), 1789);
        ajc$tjp_81 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "createTasksCompletedEvents", "pro.taskana.task.internal.TaskServiceImpl", "java.util.List", "taskSummaries", "", "void"), 1806);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "transfer", "pro.taskana.task.internal.TaskServiceImpl", "java.lang.String:java.lang.String:java.lang.String:boolean", "taskId:workbasketKey:domain:setTransferFlag", "pro.taskana.task.api.exceptions.TaskNotFoundException:pro.taskana.workbasket.api.exceptions.WorkbasketNotFoundException:pro.taskana.common.api.exceptions.NotAuthorizedException:pro.taskana.task.api.exceptions.InvalidStateException", "pro.taskana.task.api.models.Task"), 340);
    }
}

