/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.common.internal;

import java.time.Instant;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.common.api.JobService;
import pro.taskana.common.api.ScheduledJob;
import pro.taskana.common.internal.InternalTaskanaEngine;
import pro.taskana.common.internal.JobMapper;
import pro.taskana.common.internal.logging.LoggingAspect;

public class JobServiceImpl
implements JobService {
    public static final Integer JOB_DEFAULT_PRIORITY;
    public static final long DEFAULT_LOCK_EXPIRATION_PERIOD = 60000L;
    private static final Logger LOGGER;
    private JobMapper jobMapper;
    private InternalTaskanaEngine taskanaEngineImpl;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;

    static {
        JobServiceImpl.ajc$preClinit();
        JOB_DEFAULT_PRIORITY = 50;
        LOGGER = LoggerFactory.getLogger(JobServiceImpl.class);
    }

    public JobServiceImpl(InternalTaskanaEngine taskanaEngine, JobMapper jobMapper) {
        this.taskanaEngineImpl = taskanaEngine;
        this.jobMapper = jobMapper;
    }

    @Override
    public ScheduledJob createJob(ScheduledJob job) {
        ScheduledJob scheduledJob;
        ScheduledJob scheduledJob2;
        ScheduledJob scheduledJob3 = job;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)scheduledJob3);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        try {
            this.taskanaEngineImpl.openConnection();
            job = this.initializeJobDefault(job);
            Integer jobId = this.jobMapper.insertJob(job);
            job.setJobId(jobId);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Created job {}", (Object)job);
            }
        }
        finally {
            this.taskanaEngineImpl.returnConnection();
        }
        ScheduledJob scheduledJob4 = scheduledJob2 = (scheduledJob = job);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)scheduledJob2);
        return scheduledJob;
    }

    public void deleteJobs(ScheduledJob.Type jobType) {
        ScheduledJob.Type type = jobType;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)((Object)type));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        try {
            this.taskanaEngineImpl.openConnection();
            this.jobMapper.deleteMultiple(jobType);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Deleted jobs of type: {}", (Object)jobType);
            }
        }
        finally {
            this.taskanaEngineImpl.returnConnection();
        }
        Object var5_5 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var5_5);
    }

    public ScheduledJob lockJob(ScheduledJob job, String owner) {
        ScheduledJob scheduledJob;
        ScheduledJob scheduledJob2;
        ScheduledJob scheduledJob3 = job;
        String string = owner;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)scheduledJob3, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        try {
            this.taskanaEngineImpl.openConnection();
            job.setLockedBy(owner);
            job.setLockExpires(Instant.now().plusMillis(60000L));
            job.setRetryCount(job.getRetryCount() - 1);
            this.jobMapper.update(job);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Job {} locked. Remaining retries: {}", (Object)job.getJobId(), (Object)job.getRetryCount());
            }
        }
        finally {
            this.taskanaEngineImpl.returnConnection();
        }
        ScheduledJob scheduledJob4 = scheduledJob2 = (scheduledJob = job);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)scheduledJob2);
        return scheduledJob;
    }

    public List<ScheduledJob> findJobsToRun() {
        List<ScheduledJob> list;
        List<ScheduledJob> list2;
        List<ScheduledJob> availableJobs;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        try {
            this.taskanaEngineImpl.openConnection();
            availableJobs = this.jobMapper.findJobsToRun(Instant.now());
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Found available jobs: {}", availableJobs);
            }
        }
        finally {
            this.taskanaEngineImpl.returnConnection();
        }
        List<ScheduledJob> list3 = list2 = (list = availableJobs);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, list2);
        return list;
    }

    public void deleteJob(ScheduledJob job) {
        ScheduledJob scheduledJob = job;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)scheduledJob);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        try {
            this.taskanaEngineImpl.openConnection();
            this.jobMapper.delete(job);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Deleted job: {}", (Object)job);
            }
        }
        finally {
            this.taskanaEngineImpl.returnConnection();
        }
        Object var5_5 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var5_5);
    }

    private ScheduledJob initializeJobDefault(ScheduledJob job) {
        ScheduledJob scheduledJob;
        ScheduledJob scheduledJob2;
        ScheduledJob scheduledJob3 = job;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)scheduledJob3);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        job.setCreated(Instant.now());
        job.setState(ScheduledJob.State.READY);
        job.setPriority(JOB_DEFAULT_PRIORITY);
        if (job.getDue() == null) {
            job.setDue(Instant.now());
        }
        job.setRetryCount(this.taskanaEngineImpl.getEngine().getConfiguration().getMaxNumberOfJobRetries());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Job after initialization: {}", (Object)job);
        }
        ScheduledJob scheduledJob4 = scheduledJob2 = (scheduledJob = job);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)scheduledJob2);
        return scheduledJob;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("JobServiceImpl.java", JobServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createJob", "pro.taskana.common.internal.JobServiceImpl", "pro.taskana.common.api.ScheduledJob", "job", "", "pro.taskana.common.api.ScheduledJob"), 28);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteJobs", "pro.taskana.common.internal.JobServiceImpl", "pro.taskana.common.api.ScheduledJob$Type", "jobType", "", "void"), 43);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "lockJob", "pro.taskana.common.internal.JobServiceImpl", "pro.taskana.common.api.ScheduledJob:java.lang.String", "job:owner", "", "pro.taskana.common.api.ScheduledJob"), 55);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "findJobsToRun", "pro.taskana.common.internal.JobServiceImpl", "", "", "", "java.util.List"), 71);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteJob", "pro.taskana.common.internal.JobServiceImpl", "pro.taskana.common.api.ScheduledJob", "job", "", "void"), 85);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "initializeJobDefault", "pro.taskana.common.internal.JobServiceImpl", "pro.taskana.common.api.ScheduledJob", "job", "", "pro.taskana.common.api.ScheduledJob"), 97);
    }
}

