/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.common.internal.jobs;

import java.lang.reflect.InvocationTargetException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import pro.taskana.common.api.ScheduledJob;
import pro.taskana.common.api.TaskanaEngine;
import pro.taskana.common.internal.TaskanaEngineImpl;
import pro.taskana.common.internal.jobs.TaskanaJob;
import pro.taskana.common.internal.logging.LoggingAspect;
import pro.taskana.common.internal.transaction.TaskanaTransactionProvider;

public abstract class AbstractTaskanaJob
implements TaskanaJob {
    protected final Instant firstRun;
    protected final Duration runEvery;
    protected TaskanaEngineImpl taskanaEngineImpl;
    protected TaskanaTransactionProvider<Object> txProvider;
    protected ScheduledJob scheduledJob;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

    public AbstractTaskanaJob(TaskanaEngine taskanaEngine, TaskanaTransactionProvider<Object> txProvider, ScheduledJob job) {
        this.taskanaEngineImpl = (TaskanaEngineImpl)taskanaEngine;
        this.txProvider = txProvider;
        this.scheduledJob = job;
        this.firstRun = taskanaEngine.getConfiguration().getCleanupJobFirstRun();
        this.runEvery = this.taskanaEngineImpl.getConfiguration().getCleanupJobRunEvery();
    }

    public static TaskanaJob createFromScheduledJob(TaskanaEngine engine, TaskanaTransactionProvider<Object> txProvider, ScheduledJob job) throws ClassNotFoundException, IllegalAccessException, InstantiationException, InvocationTargetException {
        TaskanaJob taskanaJob;
        TaskanaJob taskanaJob2;
        TaskanaEngine taskanaEngine = engine;
        TaskanaTransactionProvider<Object> taskanaTransactionProvider = txProvider;
        ScheduledJob scheduledJob = job;
        Object[] objectArray = new Object[]{taskanaEngine, taskanaTransactionProvider, scheduledJob};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        TaskanaJob taskanaJob3 = taskanaJob2 = (taskanaJob = (TaskanaJob)Thread.currentThread().getContextClassLoader().loadClass(job.getType().getClazz()).getConstructors()[0].newInstance(engine, txProvider, job));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskanaJob2);
        return taskanaJob;
    }

    protected <T> List<List<T>> partition(Collection<T> members, int maxSize) {
        ArrayList<List<T>> arrayList;
        ArrayList<List<T>> arrayList2;
        Collection<T> collection = members;
        int n = maxSize;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, collection, (Object)Conversions.intObject((int)n));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ArrayList<List<T>> result = new ArrayList<List<T>>();
        ArrayList<T> internal = new ArrayList<T>();
        for (T member : members) {
            internal.add(member);
            if (internal.size() != maxSize) continue;
            result.add(internal);
            internal = new ArrayList();
        }
        if (!internal.isEmpty()) {
            result.add(internal);
        }
        ArrayList<List<T>> arrayList3 = arrayList2 = (arrayList = result);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, arrayList2);
        return arrayList;
    }

    protected Instant getNextDueForCleanupJob() {
        Instant instant;
        Instant instant2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Instant nextRun = this.firstRun;
        if (this.scheduledJob != null && this.scheduledJob.getDue() != null) {
            nextRun = this.scheduledJob.getDue();
        }
        while (nextRun.isBefore(Instant.now())) {
            nextRun = nextRun.plus(this.runEvery);
        }
        Instant instant3 = instant2 = (instant = nextRun);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)instant2);
        return instant;
    }

    static {
        AbstractTaskanaJob.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AbstractTaskanaJob.java", AbstractTaskanaJob.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "createFromScheduledJob", "pro.taskana.common.internal.jobs.AbstractTaskanaJob", "pro.taskana.common.api.TaskanaEngine:pro.taskana.common.internal.transaction.TaskanaTransactionProvider:pro.taskana.common.api.ScheduledJob", "engine:txProvider:job", "java.lang.ClassNotFoundException:java.lang.IllegalAccessException:java.lang.InstantiationException:java.lang.reflect.InvocationTargetException", "pro.taskana.common.internal.jobs.TaskanaJob"), 35);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "partition", "pro.taskana.common.internal.jobs.AbstractTaskanaJob", "java.util.Collection:int", "members:maxSize", "", "java.util.List"), 48);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getNextDueForCleanupJob", "pro.taskana.common.internal.jobs.AbstractTaskanaJob", "", "", "", "java.time.Instant"), 64);
    }
}

