/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.common.internal.jobs;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import javax.security.auth.Subject;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.common.api.ScheduledJob;
import pro.taskana.common.api.TaskanaEngine;
import pro.taskana.common.api.TaskanaRole;
import pro.taskana.common.api.exceptions.SystemException;
import pro.taskana.common.api.security.UserPrincipal;
import pro.taskana.common.internal.JobServiceImpl;
import pro.taskana.common.internal.jobs.AbstractTaskanaJob;
import pro.taskana.common.internal.jobs.TaskanaJob;
import pro.taskana.common.internal.logging.LoggingAspect;
import pro.taskana.common.internal.transaction.TaskanaTransactionProvider;

public class JobRunner {
    private static final Logger LOGGER;
    private final TaskanaEngine taskanaEngine;
    private final JobServiceImpl jobService;
    private TaskanaTransactionProvider<Object> txProvider;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;

    static {
        JobRunner.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(JobRunner.class);
    }

    public JobRunner(TaskanaEngine taskanaEngine) {
        this.taskanaEngine = taskanaEngine;
        this.jobService = (JobServiceImpl)taskanaEngine.getJobService();
    }

    public void registerTransactionProvider(TaskanaTransactionProvider<Object> txProvider) {
        TaskanaTransactionProvider<Object> taskanaTransactionProvider = txProvider;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, taskanaTransactionProvider);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.txProvider = txProvider;
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    public void runJobs() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        try {
            List<ScheduledJob> jobsToRun = this.findAndLockJobsToRun();
            for (ScheduledJob scheduledJob : jobsToRun) {
                this.runJobTransactionally(scheduledJob);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error occurred while running jobs: ", (Throwable)e);
        }
        Object var5_6 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var5_6);
    }

    private List<ScheduledJob> findAndLockJobsToRun() {
        ArrayList<ScheduledJob> arrayList;
        ArrayList<ScheduledJob> arrayList2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        List<ScheduledJob> availableJobs = this.jobService.findJobsToRun();
        ArrayList<ScheduledJob> lockedJobs = new ArrayList<ScheduledJob>();
        for (ScheduledJob job : availableJobs) {
            lockedJobs.add(this.lockJobTransactionally(job));
        }
        ArrayList<ScheduledJob> arrayList3 = arrayList2 = (arrayList = lockedJobs);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, arrayList2);
        return arrayList;
    }

    private ScheduledJob lockJobTransactionally(ScheduledJob job) {
        ScheduledJob scheduledJob;
        ScheduledJob scheduledJob2;
        ScheduledJob scheduledJob3 = job;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)scheduledJob3);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ScheduledJob lockedJob = this.txProvider != null ? (ScheduledJob)this.txProvider.executeInTransaction(() -> this.lockJob(job)) : this.lockJob(job);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Locked job: {}", (Object)lockedJob);
        }
        ScheduledJob scheduledJob4 = scheduledJob2 = (scheduledJob = lockedJob);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)scheduledJob2);
        return scheduledJob;
    }

    private ScheduledJob lockJob(ScheduledJob job) {
        ScheduledJob scheduledJob;
        ScheduledJob scheduledJob2;
        ScheduledJob scheduledJob3 = job;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)scheduledJob3);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String hostAddress = "UNKNOWN_ADDRESS";
        try {
            hostAddress = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {}
        job.setLockedBy(String.valueOf(hostAddress) + " - " + Thread.currentThread().getName());
        String owner = String.valueOf(hostAddress) + " - " + Thread.currentThread().getName();
        ScheduledJob scheduledJob4 = scheduledJob2 = (scheduledJob = this.jobService.lockJob(job, owner));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)scheduledJob2);
        return scheduledJob;
    }

    private void runJobTransactionally(ScheduledJob scheduledJob) {
        ScheduledJob scheduledJob2 = scheduledJob;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)scheduledJob2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        try {
            if (this.txProvider != null) {
                this.txProvider.executeInTransaction(() -> {
                    this.runScheduledJob(scheduledJob);
                    return null;
                });
            } else {
                this.runScheduledJob(scheduledJob);
            }
            this.jobService.deleteJob(scheduledJob);
        }
        catch (Exception e) {
            LOGGER.error("Processing of job {} failed. Trying to split it up into two pieces...", (Object)scheduledJob.getJobId(), (Object)e);
        }
        Object var5_5 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var5_5);
    }

    private void runScheduledJob(ScheduledJob scheduledJob) {
        ScheduledJob scheduledJob2 = scheduledJob;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)scheduledJob2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (this.taskanaEngine.isUserInRole(TaskanaRole.ADMIN)) {
            this.runScheduledJobImpl(scheduledJob);
        } else {
            try {
                PrivilegedExceptionAction<Void> action = () -> {
                    try {
                        this.runScheduledJobImpl(scheduledJob);
                    }
                    catch (Exception e) {
                        throw new SystemException(String.format("could not run Job %s.", scheduledJob), (Throwable)e);
                    }
                    return null;
                };
                Subject.doAs(this.getAdminSubject(), action);
            }
            catch (PrivilegedActionException e) {
                LOGGER.warn("Attempt to run job {} failed.", (Object)scheduledJob, (Object)e);
            }
        }
        Object var5_6 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var5_6);
    }

    private void runScheduledJobImpl(ScheduledJob scheduledJob) {
        ScheduledJob scheduledJob2 = scheduledJob;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)scheduledJob2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        try {
            TaskanaJob job = AbstractTaskanaJob.createFromScheduledJob(this.taskanaEngine, this.txProvider, scheduledJob);
            job.run();
        }
        catch (Exception e) {
            LOGGER.error("Error running job: {} ", (Object)scheduledJob.getType(), (Object)e);
            throw new SystemException("When attempting to load class " + (Object)((Object)scheduledJob.getType()) + " caught Exception " + e.getMessage(), (Throwable)e);
        }
        Object var5_6 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var5_6);
    }

    private Subject getAdminSubject() {
        Subject subject;
        Subject subject2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Subject subject3 = new Subject();
        ArrayList<UserPrincipal> principalList = new ArrayList<UserPrincipal>();
        try {
            principalList.add(new UserPrincipal(this.taskanaEngine.getConfiguration().getRoleMap().get(TaskanaRole.ADMIN).iterator().next()));
        }
        catch (Exception t) {
            LOGGER.warn("Could not determine a configured admin user.", (Throwable)t);
        }
        subject3.getPrincipals().addAll(principalList);
        Subject subject4 = subject2 = (subject = subject3);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)subject2);
        return subject;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("JobRunner.java", JobRunner.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "registerTransactionProvider", "pro.taskana.common.internal.jobs.JobRunner", "pro.taskana.common.internal.transaction.TaskanaTransactionProvider", "txProvider", "", "void"), 35);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "runJobs", "pro.taskana.common.internal.jobs.JobRunner", "", "", "", "void"), 39);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "findAndLockJobsToRun", "pro.taskana.common.internal.jobs.JobRunner", "", "", "", "java.util.List"), 50);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "lockJobTransactionally", "pro.taskana.common.internal.jobs.JobRunner", "pro.taskana.common.api.ScheduledJob", "job", "", "pro.taskana.common.api.ScheduledJob"), 59);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "lockJob", "pro.taskana.common.internal.jobs.JobRunner", "pro.taskana.common.api.ScheduledJob", "job", "", "pro.taskana.common.api.ScheduledJob"), 72);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "runJobTransactionally", "pro.taskana.common.internal.jobs.JobRunner", "pro.taskana.common.api.ScheduledJob", "scheduledJob", "", "void"), 84);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "runScheduledJob", "pro.taskana.common.internal.jobs.JobRunner", "pro.taskana.common.api.ScheduledJob", "scheduledJob", "", "void"), 104);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "runScheduledJobImpl", "pro.taskana.common.internal.jobs.JobRunner", "pro.taskana.common.api.ScheduledJob", "scheduledJob", "", "void"), 128);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getAdminSubject", "pro.taskana.common.internal.jobs.JobRunner", "", "", "", "javax.security.auth.Subject"), 144);
    }
}

