/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.monitor.internal.reports;

import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import pro.taskana.classification.api.ClassificationService;
import pro.taskana.classification.api.models.ClassificationSummary;
import pro.taskana.common.api.TaskanaRole;
import pro.taskana.common.api.exceptions.InvalidArgumentException;
import pro.taskana.common.api.exceptions.NotAuthorizedException;
import pro.taskana.common.internal.InternalTaskanaEngine;
import pro.taskana.common.internal.logging.LoggingAspect;
import pro.taskana.monitor.api.TaskTimestamp;
import pro.taskana.monitor.api.reports.ClassificationReport;
import pro.taskana.monitor.api.reports.header.TimeIntervalColumnHeader;
import pro.taskana.monitor.api.reports.item.DetailedMonitorQueryItem;
import pro.taskana.monitor.api.reports.item.MonitorQueryItem;
import pro.taskana.monitor.api.reports.row.Row;
import pro.taskana.monitor.internal.MonitorMapper;
import pro.taskana.monitor.internal.preprocessor.DaysToWorkingDaysReportPreProcessor;
import pro.taskana.monitor.internal.reports.TimeIntervalReportBuilderImpl;

public class ClassificationReportBuilderImpl
extends TimeIntervalReportBuilderImpl<ClassificationReport.Builder, MonitorQueryItem, TimeIntervalColumnHeader>
implements ClassificationReport.Builder {
    private final ClassificationService classificationService;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;

    public ClassificationReportBuilderImpl(InternalTaskanaEngine taskanaEngine, MonitorMapper monitorMapper) {
        super(taskanaEngine, monitorMapper);
        this.classificationService = taskanaEngine.getEngine().getClassificationService();
    }

    @Override
    public ClassificationReport buildReport() throws NotAuthorizedException, InvalidArgumentException {
        ClassificationReport classificationReport;
        ClassificationReport classificationReport2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ClassificationReport classificationReport3 = classificationReport2 = (classificationReport = this.buildReport(TaskTimestamp.DUE));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)classificationReport2);
        return classificationReport;
    }

    @Override
    public ClassificationReport buildReport(TaskTimestamp timestamp) throws InvalidArgumentException, NotAuthorizedException {
        ClassificationReport classificationReport;
        ClassificationReport classificationReport2;
        TaskTimestamp taskTimestamp = timestamp;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)((Object)taskTimestamp));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.taskanaEngine.getEngine().checkRoleMembership(TaskanaRole.MONITOR, TaskanaRole.ADMIN);
        try {
            this.taskanaEngine.openConnection();
            ClassificationReport report = new ClassificationReport(this.columnHeaders);
            List<MonitorQueryItem> monitorQueryItems = this.monitorMapper.getTaskCountOfClassifications(Instant.now(), this.workbasketIds, this.states, this.classificationCategory, this.domains, timestamp, this.classificationIds, this.excludedClassificationIds, this.customAttributeFilter);
            report.addItems(monitorQueryItems, new DaysToWorkingDaysReportPreProcessor(this.columnHeaders, this.converter, this.inWorkingDays));
            Map<String, String> displayMap = this.classificationService.createClassificationQuery().keyIn(report.getRows().isEmpty() ? null : report.getRows().keySet().toArray(new String[0])).domainIn(this.domains != null ? this.domains.toArray(new String[0]) : null).list().stream().collect(Collectors.toMap(ClassificationSummary::getKey, ClassificationSummary::getName, (a, b) -> a));
            report.augmentDisplayNames(displayMap);
            ClassificationReport classificationReport3 = report;
            classificationReport2 = classificationReport3;
        }
        finally {
            this.taskanaEngine.returnConnection();
        }
        ClassificationReport classificationReport4 = classificationReport = classificationReport2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)classificationReport);
        return classificationReport2;
    }

    @Override
    public ClassificationReport.DetailedClassificationReport buildDetailedReport() throws InvalidArgumentException, NotAuthorizedException {
        ClassificationReport.DetailedClassificationReport detailedClassificationReport;
        ClassificationReport.DetailedClassificationReport detailedClassificationReport2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ClassificationReport.DetailedClassificationReport detailedClassificationReport3 = detailedClassificationReport2 = (detailedClassificationReport = this.buildDetailedReport(TaskTimestamp.DUE));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)detailedClassificationReport2);
        return detailedClassificationReport;
    }

    @Override
    public ClassificationReport.DetailedClassificationReport buildDetailedReport(TaskTimestamp timestamp) throws InvalidArgumentException, NotAuthorizedException {
        ClassificationReport.DetailedClassificationReport detailedClassificationReport;
        ClassificationReport.DetailedClassificationReport detailedClassificationReport2;
        TaskTimestamp taskTimestamp = timestamp;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)((Object)taskTimestamp));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.taskanaEngine.getEngine().checkRoleMembership(TaskanaRole.MONITOR, TaskanaRole.ADMIN);
        try {
            this.taskanaEngine.openConnection();
            ClassificationReport.DetailedClassificationReport report = new ClassificationReport.DetailedClassificationReport(this.columnHeaders);
            List<DetailedMonitorQueryItem> detailedMonitorQueryItems = this.monitorMapper.getTaskCountOfDetailedClassifications(Instant.now(), this.workbasketIds, this.states, this.classificationCategory, this.domains, timestamp, this.classificationIds, this.excludedClassificationIds, this.customAttributeFilter);
            report.addItems(detailedMonitorQueryItems, new DaysToWorkingDaysReportPreProcessor(this.columnHeaders, this.converter, this.inWorkingDays));
            Stream<String> attachmentKeys = report.getRows().keySet().stream().map(report::getRow).flatMap(row -> row.getFoldableRows().values().stream()).map(Row::getKey);
            String[] keys = (String[])Stream.concat(attachmentKeys, report.getRows().keySet().stream()).toArray(String[]::new);
            Map<String, String> displayMap = this.classificationService.createClassificationQuery().keyIn(keys.length == 0 ? null : keys).domainIn(this.domains != null ? this.domains.toArray(new String[0]) : null).list().stream().collect(Collectors.toMap(ClassificationSummary::getKey, ClassificationSummary::getName, (a, b) -> a));
            report.augmentDisplayNames(displayMap);
            ClassificationReport.DetailedClassificationReport detailedClassificationReport3 = report;
            detailedClassificationReport2 = detailedClassificationReport3;
        }
        finally {
            this.taskanaEngine.returnConnection();
        }
        ClassificationReport.DetailedClassificationReport detailedClassificationReport4 = detailedClassificationReport = detailedClassificationReport2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)detailedClassificationReport);
        return detailedClassificationReport2;
    }

    @Override
    protected ClassificationReport.Builder _this() {
        ClassificationReportBuilderImpl classificationReportBuilderImpl;
        ClassificationReportBuilderImpl classificationReportBuilderImpl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ClassificationReportBuilderImpl classificationReportBuilderImpl3 = classificationReportBuilderImpl2 = (classificationReportBuilderImpl = this);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)classificationReportBuilderImpl2);
        return classificationReportBuilderImpl;
    }

    @Override
    protected String determineGroupedBy() {
        String string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String string2 = "CLASSIFICATION_KEY";
        String string3 = string = "CLASSIFICATION_KEY";
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string);
        return string2;
    }

    static {
        ClassificationReportBuilderImpl.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ClassificationReportBuilderImpl.java", ClassificationReportBuilderImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "buildReport", "pro.taskana.monitor.internal.reports.ClassificationReportBuilderImpl", "", "", "pro.taskana.common.api.exceptions.NotAuthorizedException:pro.taskana.common.api.exceptions.InvalidArgumentException", "pro.taskana.monitor.api.reports.ClassificationReport"), 40);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "buildReport", "pro.taskana.monitor.internal.reports.ClassificationReportBuilderImpl", "pro.taskana.monitor.api.TaskTimestamp", "timestamp", "pro.taskana.common.api.exceptions.InvalidArgumentException:pro.taskana.common.api.exceptions.NotAuthorizedException", "pro.taskana.monitor.api.reports.ClassificationReport"), 46);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "buildDetailedReport", "pro.taskana.monitor.internal.reports.ClassificationReportBuilderImpl", "", "", "pro.taskana.common.api.exceptions.InvalidArgumentException:pro.taskana.common.api.exceptions.NotAuthorizedException", "pro.taskana.monitor.api.reports.ClassificationReport$DetailedClassificationReport"), 88);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "buildDetailedReport", "pro.taskana.monitor.internal.reports.ClassificationReportBuilderImpl", "pro.taskana.monitor.api.TaskTimestamp", "timestamp", "pro.taskana.common.api.exceptions.InvalidArgumentException:pro.taskana.common.api.exceptions.NotAuthorizedException", "pro.taskana.monitor.api.reports.ClassificationReport$DetailedClassificationReport"), 94);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "_this", "pro.taskana.monitor.internal.reports.ClassificationReportBuilderImpl", "", "", "", "pro.taskana.monitor.api.reports.ClassificationReport$Builder"), 141);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "determineGroupedBy", "pro.taskana.monitor.internal.reports.ClassificationReportBuilderImpl", "", "", "", "java.lang.String"), 146);
    }
}

