/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.spi.routing.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Collectors;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.common.api.TaskanaEngine;
import pro.taskana.common.api.exceptions.SystemException;
import pro.taskana.common.internal.logging.LoggingAspect;
import pro.taskana.common.internal.util.LogSanitizer;
import pro.taskana.spi.routing.api.TaskRoutingProvider;
import pro.taskana.task.api.models.Task;

public final class TaskRoutingManager {
    private static final Logger LOGGER;
    private static TaskRoutingManager singleton;
    private final List<TaskRoutingProvider> theTaskRoutingProviders = new ArrayList<TaskRoutingProvider>();
    private final ServiceLoader<TaskRoutingProvider> serviceLoader = ServiceLoader.load(TaskRoutingProvider.class);
    private boolean enabled = false;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

    static {
        TaskRoutingManager.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(TaskRoutingManager.class);
    }

    private TaskRoutingManager(TaskanaEngine taskanaEngine) {
        for (TaskRoutingProvider router : this.serviceLoader) {
            router.initialize(taskanaEngine);
            this.theTaskRoutingProviders.add(router);
            LOGGER.info("Registered TaskRouter provider: {}", (Object)router.getClass().getName());
        }
        if (this.theTaskRoutingProviders.isEmpty()) {
            LOGGER.info("No TaskRouter provider found. Running without Task Routing.");
        } else {
            this.enabled = true;
        }
    }

    public static synchronized TaskRoutingManager getInstance(TaskanaEngine taskanaEngine) {
        TaskRoutingManager taskRoutingManager;
        TaskRoutingManager taskRoutingManager2;
        TaskanaEngine taskanaEngine2 = taskanaEngine;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null, (Object)taskanaEngine2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (singleton == null) {
            singleton = new TaskRoutingManager(taskanaEngine);
        }
        TaskRoutingManager taskRoutingManager3 = taskRoutingManager2 = (taskRoutingManager = singleton);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskRoutingManager2);
        return taskRoutingManager;
    }

    public static boolean isTaskRoutingEnabled() {
        boolean bl;
        boolean bl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, null, null);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        boolean bl3 = bl2 = Objects.nonNull(singleton) && TaskRoutingManager.singleton.enabled ? (bl = true) : (bl = false);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl2));
        return bl;
    }

    public String determineWorkbasketId(Task task) {
        String string;
        String string2;
        Task task2 = task;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)task2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String workbasketId = null;
        if (TaskRoutingManager.isTaskRoutingEnabled()) {
            Set workbasketIds = this.theTaskRoutingProviders.stream().map(rtr -> {
                try {
                    return rtr.determineWorkbasketId(task);
                }
                catch (Exception e) {
                    LOGGER.error(String.format("Caught Exception while trying to determine workbasket in class %s", rtr.getClass().getName()), (Throwable)e);
                    throw new SystemException(e.getMessage(), e.getCause());
                }
            }).filter(Objects::nonNull).collect(Collectors.toSet());
            if (workbasketIds.isEmpty()) {
                if (LOGGER.isErrorEnabled()) {
                    LOGGER.error("No TaskRouter determined a workbasket for task {}.", (Object)LogSanitizer.stripLineBreakingChars((Object)task));
                }
            } else if (workbasketIds.size() > 1) {
                if (LOGGER.isErrorEnabled()) {
                    LOGGER.error("The TaskRouters determined more than one workbasket for task {}", (Object)LogSanitizer.stripLineBreakingChars((Object)task));
                }
            } else {
                workbasketId = workbasketIds.stream().findFirst().orElse(null);
            }
        }
        String string3 = string2 = (string = workbasketId);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, string2);
        return string;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("TaskRoutingManager.java", TaskRoutingManager.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("29", "getInstance", "pro.taskana.spi.routing.internal.TaskRoutingManager", "pro.taskana.common.api.TaskanaEngine", "taskanaEngine", "", "pro.taskana.spi.routing.internal.TaskRoutingManager"), 45);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "isTaskRoutingEnabled", "pro.taskana.spi.routing.internal.TaskRoutingManager", "", "", "", "boolean"), 52);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "determineWorkbasketId", "pro.taskana.spi.routing.internal.TaskRoutingManager", "pro.taskana.task.api.models.Task", "task", "", "java.lang.String"), 65);
    }
}

