/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.task.internal;

import java.time.Instant;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Result;
import org.apache.ibatis.annotations.Results;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;
import org.apache.ibatis.type.ClobTypeHandler;
import pro.taskana.common.internal.persistence.MapTypeHandler;
import pro.taskana.common.internal.util.Pair;
import pro.taskana.task.internal.models.AttachmentImpl;
import pro.taskana.task.internal.models.AttachmentSummaryImpl;

public interface AttachmentMapper {
    @Insert(value={"INSERT INTO ATTACHMENT (ID, TASK_ID, CREATED, MODIFIED, CLASSIFICATION_KEY, CLASSIFICATION_ID, REF_COMPANY, REF_SYSTEM, REF_INSTANCE, REF_TYPE, REF_VALUE, CHANNEL, RECEIVED, CUSTOM_ATTRIBUTES) VALUES (#{att.id}, #{att.taskId}, #{att.created}, #{att.modified}, #{att.classificationSummary.key}, #{att.classificationSummary.id}, #{att.objectReference.company}, #{att.objectReference.system}, #{att.objectReference.systemInstance},  #{att.objectReference.type}, #{att.objectReference.value}, #{att.channel}, #{att.received}, #{att.customAttributes,jdbcType=CLOB,javaType=java.util.Map,typeHandler=pro.taskana.common.internal.persistence.MapTypeHandler} )"})
    public void insert(@Param(value="att") AttachmentImpl var1);

    @Select(value={"<script> SELECT ID, TASK_ID, CREATED, MODIFIED, CLASSIFICATION_KEY, CLASSIFICATION_ID, REF_COMPANY, REF_SYSTEM, REF_INSTANCE, REF_TYPE, REF_VALUE, CHANNEL, RECEIVED, CUSTOM_ATTRIBUTES FROM ATTACHMENT WHERE TASK_ID = #{taskId} <if test=\"_databaseId == 'db2'\">with UR </if> </script>"})
    @Results(value={@Result(property="id", column="ID"), @Result(property="taskId", column="TASK_ID"), @Result(property="created", column="CREATED"), @Result(property="modified", column="MODIFIED"), @Result(property="classificationSummaryImpl.key", column="CLASSIFICATION_KEY"), @Result(property="classificationSummaryImpl.id", column="CLASSIFICATION_ID"), @Result(property="objectReference.company", column="REF_COMPANY"), @Result(property="objectReference.system", column="REF_SYSTEM"), @Result(property="objectReference.systemInstance", column="REF_INSTANCE"), @Result(property="objectReference.type", column="REF_TYPE"), @Result(property="objectReference.value", column="REF_VALUE"), @Result(property="channel", column="CHANNEL"), @Result(property="received", column="RECEIVED"), @Result(property="customAttributes", column="CUSTOM_ATTRIBUTES", javaType=Map.class, typeHandler=MapTypeHandler.class)})
    public List<AttachmentImpl> findAttachmentsByTaskId(@Param(value="taskId") String var1);

    @Select(value={"<script>SELECT ID, TASK_ID, CREATED, MODIFIED, CLASSIFICATION_KEY, CLASSIFICATION_ID, REF_COMPANY, REF_SYSTEM, REF_INSTANCE, REF_TYPE, REF_VALUE, CHANNEL, RECEIVED FROM ATTACHMENT <where><choose><when  test='taskIds == null'> 1 = 2 </when><otherwise>TASK_ID IN (<foreach collection='taskIds' item='item' separator=',' >#{item}</foreach>) </otherwise></choose></where><if test=\"_databaseId == 'db2'\">with UR </if> </script>"})
    @Results(value={@Result(property="id", column="ID"), @Result(property="taskId", column="TASK_ID"), @Result(property="created", column="CREATED"), @Result(property="modified", column="MODIFIED"), @Result(property="classificationSummaryImpl.key", column="CLASSIFICATION_KEY"), @Result(property="classificationSummaryImpl.id", column="CLASSIFICATION_ID"), @Result(property="objectReference.company", column="REF_COMPANY"), @Result(property="objectReference.system", column="REF_SYSTEM"), @Result(property="objectReference.systemInstance", column="REF_INSTANCE"), @Result(property="objectReference.type", column="REF_TYPE"), @Result(property="objectReference.value", column="REF_VALUE"), @Result(property="channel", column="CHANNEL"), @Result(property="received", column="RECEIVED")})
    public List<AttachmentSummaryImpl> findAttachmentSummariesByTaskIds(@Param(value="taskIds") List<String> var1);

    @Delete(value={"DELETE FROM ATTACHMENT WHERE ID=#{attachmentId}"})
    public void delete(@Param(value="attachmentId") String var1);

    @Delete(value={"<script>DELETE FROM ATTACHMENT WHERE TASK_ID IN(<foreach item='item' collection='taskIds' separator=',' >#{item}</foreach>)</script>"})
    public void deleteMultipleByTaskIds(@Param(value="taskIds") List<String> var1);

    @Update(value={"UPDATE ATTACHMENT SET TASK_ID = #{taskId}, CREATED = #{created}, MODIFIED = #{modified}, CLASSIFICATION_KEY = #{classificationSummary.key}, CLASSIFICATION_ID = #{classificationSummary.id}, REF_COMPANY = #{objectReference.company}, REF_SYSTEM = #{objectReference.system}, REF_INSTANCE = #{objectReference.systemInstance}, REF_TYPE = #{objectReference.type}, REF_VALUE = #{objectReference.value}, CHANNEL = #{channel}, RECEIVED = #{received}, CUSTOM_ATTRIBUTES = #{customAttributes,jdbcType=CLOB,javaType=java.util.Map,typeHandler=pro.taskana.common.internal.persistence.MapTypeHandler} WHERE ID = #{id}"})
    public void update(AttachmentImpl var1);

    @Select(value={"<script> select CUSTOM_ATTRIBUTES from ATTACHMENT where id = #{attachmentId}<if test=\"_databaseId == 'db2'\">with UR </if> </script>"})
    @Result(property="customAttributes", column="CUSTOM_ATTRIBUTES", javaType=String.class, typeHandler=ClobTypeHandler.class)
    public String getCustomAttributesAsString(@Param(value="attachmentId") String var1);

    @Select(value={"<script> SELECT DISTINCT t.ID, t.PLANNED FROM TASK t LEFT JOIN ATTACHMENT AS a on a.TASK_ID = t.ID WHERE a.CLASSIFICATION_ID = #{classificationId} <if test=\"_databaseId == 'db2'\">with UR </if> </script>"})
    @Results(value={@Result(property="left", column="ID"), @Result(property="right", column="PLANNED")})
    public List<Pair<String, Instant>> findTaskIdsAndPlannedAffectedByClassificationChange(@Param(value="classificationId") String var1);
}

