/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.task.internal.jobs;

import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.common.api.BaseQuery;
import pro.taskana.common.api.BulkOperationResults;
import pro.taskana.common.api.ScheduledJob;
import pro.taskana.common.api.TaskanaEngine;
import pro.taskana.common.api.TimeInterval;
import pro.taskana.common.api.exceptions.InvalidArgumentException;
import pro.taskana.common.api.exceptions.NotAuthorizedException;
import pro.taskana.common.api.exceptions.TaskanaException;
import pro.taskana.common.internal.JobServiceImpl;
import pro.taskana.common.internal.jobs.AbstractTaskanaJob;
import pro.taskana.common.internal.logging.LoggingAspect;
import pro.taskana.common.internal.transaction.TaskanaTransactionProvider;
import pro.taskana.common.internal.util.CollectionUtil;
import pro.taskana.common.internal.util.LogSanitizer;
import pro.taskana.task.api.models.TaskSummary;

public class TaskCleanupJob
extends AbstractTaskanaJob {
    private static final Logger LOGGER;
    private static final BaseQuery.SortDirection ASCENDING;
    private final Duration minimumAge;
    private final int batchSize;
    private final boolean allCompletedSameParentBusiness;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;

    static {
        TaskCleanupJob.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(TaskCleanupJob.class);
        ASCENDING = BaseQuery.SortDirection.ASCENDING;
    }

    public TaskCleanupJob(TaskanaEngine taskanaEngine, TaskanaTransactionProvider<Object> txProvider, ScheduledJob scheduledJob) {
        super(taskanaEngine, txProvider, scheduledJob);
        this.minimumAge = taskanaEngine.getConfiguration().getCleanupJobMinimumAge();
        this.batchSize = taskanaEngine.getConfiguration().getMaxNumberOfUpdatesPerTransaction();
        this.allCompletedSameParentBusiness = taskanaEngine.getConfiguration().isTaskCleanupJobAllCompletedSameParentBusiness();
    }

    @Override
    public void run() throws TaskanaException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Instant completedBefore = Instant.now().minus(this.minimumAge);
        LOGGER.info("Running job to delete all tasks completed before ({})", (Object)completedBefore);
        try {
            try {
                List<TaskSummary> tasksCompletedBefore = this.getTasksCompletedBefore(completedBefore);
                int totalNumberOfTasksDeleted = CollectionUtil.partitionBasedOnSize(tasksCompletedBefore, (int)this.batchSize).stream().mapToInt(this::deleteTasksTransactionally).sum();
                LOGGER.info("Job ended successfully. {} tasks deleted.", (Object)totalNumberOfTasksDeleted);
            }
            catch (Exception e) {
                throw new TaskanaException("Error while processing TaskCleanupJob.", (Throwable)e);
            }
        }
        finally {
            this.scheduleNextCleanupJob();
        }
        Object var7_7 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var7_7);
    }

    public static void initializeSchedule(TaskanaEngine taskanaEngine) {
        TaskanaEngine taskanaEngine2 = taskanaEngine;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, null, null, (Object)taskanaEngine2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        JobServiceImpl jobService = (JobServiceImpl)taskanaEngine.getJobService();
        jobService.deleteJobs(ScheduledJob.Type.TASKCLEANUPJOB);
        TaskCleanupJob job = new TaskCleanupJob(taskanaEngine, null, null);
        job.scheduleNextCleanupJob();
        Object var5_5 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var5_5);
    }

    private List<TaskSummary> getTasksCompletedBefore(Instant untilDate) {
        List<TaskSummary> list;
        List<TaskSummary> list2;
        Instant instant = untilDate;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)instant);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        List<TaskSummary> tasksToDelete = this.taskanaEngineImpl.getTaskService().createTaskQuery().completedWithin(new TimeInterval(null, untilDate)).orderByBusinessProcessId(ASCENDING).list();
        if (this.allCompletedSameParentBusiness) {
            HashMap numberParentTasksShouldHave = new HashMap();
            HashMap countParentTask = new HashMap();
            tasksToDelete.forEach(task -> {
                if (!numberParentTasksShouldHave.containsKey(task.getParentBusinessProcessId())) {
                    numberParentTasksShouldHave.put(task.getParentBusinessProcessId(), this.taskanaEngineImpl.getTaskService().createTaskQuery().parentBusinessProcessIdIn(task.getParentBusinessProcessId()).count());
                }
                countParentTask.merge(task.getParentBusinessProcessId(), 1L, Long::sum);
            });
            List taskIdsNotAllCompletedSameParentBusiness = numberParentTasksShouldHave.entrySet().stream().filter(entry -> entry.getKey() != null).filter(entry -> !((String)entry.getKey()).isEmpty()).filter(entry -> !((Long)entry.getValue()).equals(countParentTask.get(entry.getKey()))).map(Map.Entry::getKey).collect(Collectors.toList());
            tasksToDelete = tasksToDelete.stream().filter(taskSummary -> !taskIdsNotAllCompletedSameParentBusiness.contains(taskSummary.getParentBusinessProcessId())).collect(Collectors.toList());
        }
        List<TaskSummary> list3 = list2 = (list = tasksToDelete);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)list2);
        return list;
    }

    private int deleteTasksTransactionally(List<TaskSummary> tasksToBeDeleted) {
        int n;
        int n2;
        int n3;
        List<TaskSummary> list = tasksToBeDeleted;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, list);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        int deletedTaskCount = 0;
        if (this.txProvider != null) {
            n2 = n3 = ((Integer)this.txProvider.executeInTransaction(() -> {
                try {
                    return this.deleteTasks(tasksToBeDeleted);
                }
                catch (Exception e) {
                    LOGGER.warn("Could not delete tasks.", (Throwable)e);
                    return 0;
                }
            })).intValue();
        } else {
            try {
                deletedTaskCount = this.deleteTasks(tasksToBeDeleted);
            }
            catch (Exception e) {
                LOGGER.warn("Could not delete tasks.", (Throwable)e);
            }
            n2 = n3 = deletedTaskCount;
        }
        int n4 = n = n2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.intObject((int)n));
        return n3;
    }

    private int deleteTasks(List<TaskSummary> tasksToBeDeleted) throws InvalidArgumentException, NotAuthorizedException {
        int n;
        int n2;
        List<TaskSummary> list = tasksToBeDeleted;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, list);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        List<String> tasksIdsToBeDeleted = tasksToBeDeleted.stream().map(TaskSummary::getId).collect(Collectors.toList());
        BulkOperationResults<String, TaskanaException> results = this.taskanaEngineImpl.getTaskService().deleteTasks(tasksIdsToBeDeleted);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("{} tasks deleted.", (Object)(tasksIdsToBeDeleted.size() - results.getFailedIds().size()));
        }
        for (String failedId : results.getFailedIds()) {
            if (!LOGGER.isWarnEnabled()) continue;
            LOGGER.warn("Task with id {} could not be deleted. Reason: {}", (Object)LogSanitizer.stripLineBreakingChars((Object)failedId), (Object)LogSanitizer.stripLineBreakingChars((Object)results.getErrorForId((Object)failedId)));
        }
        int n3 = n2 = (n = tasksIdsToBeDeleted.size() - results.getFailedIds().size());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.intObject((int)n2));
        return n;
    }

    private void scheduleNextCleanupJob() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ScheduledJob job = new ScheduledJob();
        job.setType(ScheduledJob.Type.TASKCLEANUPJOB);
        job.setDue(this.getNextDueForCleanupJob());
        this.taskanaEngineImpl.getJobService().createJob(job);
        Object var3_3 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var3_3);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("TaskCleanupJob.java", TaskCleanupJob.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "run", "pro.taskana.task.internal.jobs.TaskCleanupJob", "", "", "pro.taskana.common.api.exceptions.TaskanaException", "void"), 52);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "initializeSchedule", "pro.taskana.task.internal.jobs.TaskCleanupJob", "pro.taskana.common.api.TaskanaEngine", "taskanaEngine", "", "void"), 77);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getTasksCompletedBefore", "pro.taskana.task.internal.jobs.TaskCleanupJob", "java.time.Instant", "untilDate", "", "java.util.List"), 84);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "deleteTasksTransactionally", "pro.taskana.task.internal.jobs.TaskCleanupJob", "java.util.List", "tasksToBeDeleted", "", "int"), 132);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "deleteTasks", "pro.taskana.task.internal.jobs.TaskCleanupJob", "java.util.List", "tasksToBeDeleted", "pro.taskana.common.api.exceptions.InvalidArgumentException:pro.taskana.common.api.exceptions.NotAuthorizedException", "int"), 156);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "scheduleNextCleanupJob", "pro.taskana.task.internal.jobs.TaskCleanupJob", "", "", "", "void"), 177);
    }
}

