/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.spi.history.internal;

import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.common.api.TaskanaEngine;
import pro.taskana.common.api.exceptions.SystemException;
import pro.taskana.common.internal.logging.LoggingAspect;
import pro.taskana.spi.history.api.TaskanaHistory;
import pro.taskana.spi.history.api.events.classification.ClassificationHistoryEvent;
import pro.taskana.spi.history.api.events.task.TaskHistoryEvent;
import pro.taskana.spi.history.api.events.workbasket.WorkbasketHistoryEvent;

public final class HistoryEventManager {
    private static final Logger LOGGER;
    private static HistoryEventManager singleton;
    private final ServiceLoader<TaskanaHistory> serviceLoader = ServiceLoader.load(TaskanaHistory.class);
    private boolean enabled = false;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;

    static {
        HistoryEventManager.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(HistoryEventManager.class);
    }

    private HistoryEventManager(TaskanaEngine taskanaEngine) {
        for (TaskanaHistory history : this.serviceLoader) {
            history.initialize(taskanaEngine);
            LOGGER.info("Registered history provider: {}", (Object)history.getClass().getName());
            this.enabled = true;
        }
        if (!this.enabled) {
            LOGGER.info("No history provider found. Running without history.");
        }
    }

    public static synchronized HistoryEventManager getInstance(TaskanaEngine taskanaEngine) {
        HistoryEventManager historyEventManager;
        HistoryEventManager historyEventManager2;
        TaskanaEngine taskanaEngine2 = taskanaEngine;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null, (Object)taskanaEngine2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (singleton == null) {
            singleton = new HistoryEventManager(taskanaEngine);
        }
        HistoryEventManager historyEventManager3 = historyEventManager2 = (historyEventManager = singleton);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)historyEventManager2);
        return historyEventManager;
    }

    public static boolean isHistoryEnabled() {
        boolean bl;
        boolean bl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, null, null);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        boolean bl3 = bl2 = Objects.nonNull(singleton) && HistoryEventManager.singleton.enabled ? (bl = true) : (bl = false);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl2));
        return bl;
    }

    public void createEvent(TaskHistoryEvent event) {
        TaskHistoryEvent taskHistoryEvent = event;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)taskHistoryEvent);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Sending event to history service providers: {}", (Object)event);
        }
        this.serviceLoader.forEach(historyProvider -> {
            try {
                historyProvider.create(event);
            }
            catch (Exception e) {
                LOGGER.error(String.format("Caught an exception while trying to create TaskHistoryEvent in class %s", historyProvider.getClass().getName()), (Throwable)e);
                throw new SystemException(e.getMessage(), e.getCause());
            }
        });
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    public void createEvent(WorkbasketHistoryEvent event) {
        WorkbasketHistoryEvent workbasketHistoryEvent = event;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)workbasketHistoryEvent);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Sending event to history service providers: {}", (Object)event);
        }
        this.serviceLoader.forEach(historyProvider -> {
            try {
                historyProvider.create(event);
            }
            catch (Exception e) {
                LOGGER.error(String.format("Caught an exception while trying to create WorkbasketHistoryEvent in class %s", historyProvider.getClass().getName()), (Throwable)e);
                throw new SystemException(e.getMessage(), e.getCause());
            }
        });
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    public void createEvent(ClassificationHistoryEvent event) {
        ClassificationHistoryEvent classificationHistoryEvent = event;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)classificationHistoryEvent);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Sending event to history service providers: {}", (Object)event);
        }
        this.serviceLoader.forEach(historyProvider -> {
            try {
                historyProvider.create(event);
            }
            catch (Exception e) {
                LOGGER.error(String.format("Caught an exception while trying to create ClassificationHistoryEvent in class %s", historyProvider.getClass().getName()), (Throwable)e);
                throw new SystemException(e.getMessage(), e.getCause());
            }
        });
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    public void deleteEvents(List<String> taskIds) {
        List<String> list = taskIds;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, list);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Sending taskIds to history service providers: {}", taskIds);
        }
        this.serviceLoader.forEach(historyProvider -> {
            try {
                historyProvider.deleteHistoryEventsByTaskIds(taskIds);
            }
            catch (Exception e) {
                LOGGER.error(String.format("Caught an exception while trying to delete HistoryEvents in class %s", historyProvider.getClass().getName()), (Throwable)e);
                throw new SystemException(e.getMessage(), e.getCause());
            }
        });
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("HistoryEventManager.java", HistoryEventManager.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("29", "getInstance", "pro.taskana.spi.history.internal.HistoryEventManager", "pro.taskana.common.api.TaskanaEngine", "taskanaEngine", "", "pro.taskana.spi.history.internal.HistoryEventManager"), 36);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "isHistoryEnabled", "pro.taskana.spi.history.internal.HistoryEventManager", "", "", "", "boolean"), 43);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createEvent", "pro.taskana.spi.history.internal.HistoryEventManager", "pro.taskana.spi.history.api.events.task.TaskHistoryEvent", "event", "", "void"), 47);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createEvent", "pro.taskana.spi.history.internal.HistoryEventManager", "pro.taskana.spi.history.api.events.workbasket.WorkbasketHistoryEvent", "event", "", "void"), 66);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createEvent", "pro.taskana.spi.history.internal.HistoryEventManager", "pro.taskana.spi.history.api.events.classification.ClassificationHistoryEvent", "event", "", "void"), 85);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteEvents", "pro.taskana.spi.history.internal.HistoryEventManager", "java.util.List", "taskIds", "", "void"), 105);
    }
}

