/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.task.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.ibatis.exceptions.PersistenceException;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.classification.api.ClassificationService;
import pro.taskana.classification.api.exceptions.ClassificationNotFoundException;
import pro.taskana.classification.api.models.ClassificationSummary;
import pro.taskana.common.api.BulkOperationResults;
import pro.taskana.common.api.exceptions.InvalidArgumentException;
import pro.taskana.common.internal.logging.LoggingAspect;
import pro.taskana.common.internal.util.IdGenerator;
import pro.taskana.task.api.exceptions.AttachmentPersistenceException;
import pro.taskana.task.api.models.Attachment;
import pro.taskana.task.api.models.AttachmentSummary;
import pro.taskana.task.api.models.ObjectReference;
import pro.taskana.task.api.models.Task;
import pro.taskana.task.internal.AttachmentMapper;
import pro.taskana.task.internal.models.AttachmentImpl;
import pro.taskana.task.internal.models.TaskImpl;

public class AttachmentHandler {
    private static final Logger LOGGER;
    private final AttachmentMapper attachmentMapper;
    private final ClassificationService classificationService;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;

    static {
        AttachmentHandler.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(AttachmentHandler.class);
    }

    AttachmentHandler(AttachmentMapper attachmentMapper, ClassificationService classificationService) {
        this.attachmentMapper = attachmentMapper;
        this.classificationService = classificationService;
    }

    List<Attachment> augmentAttachmentsByClassification(List<AttachmentImpl> attachmentImpls, BulkOperationResults<String, Exception> bulkLog) {
        ArrayList<Attachment> arrayList;
        ArrayList<Attachment> arrayList2;
        ArrayList<Attachment> arrayList3;
        List<AttachmentImpl> list = attachmentImpls;
        BulkOperationResults<String, Exception> bulkOperationResults = bulkLog;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, list, bulkOperationResults);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ArrayList<Attachment> result = new ArrayList<Attachment>();
        if (attachmentImpls == null || attachmentImpls.isEmpty()) {
            arrayList2 = arrayList3 = result;
        } else {
            List classifications = this.classificationService.createClassificationQuery().idIn((String[])attachmentImpls.stream().map(t -> t.getClassificationSummary().getId()).distinct().toArray(String[]::new)).list();
            for (AttachmentImpl att : attachmentImpls) {
                ClassificationSummary classificationSummary = classifications.stream().filter(cl -> cl.getId().equals(att.getClassificationSummary().getId())).findFirst().orElse(null);
                if (classificationSummary == null) {
                    String id = att.getClassificationSummary().getId();
                    bulkLog.addError((Object)att.getClassificationSummary().getId(), (Exception)((Object)new ClassificationNotFoundException(id, String.format("When processing task updates due to change of classification, the classification with id %s was not found", id))));
                    continue;
                }
                att.setClassificationSummary(classificationSummary);
                result.add(att);
            }
            arrayList2 = arrayList3 = result;
        }
        ArrayList<Attachment> arrayList4 = arrayList = arrayList2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, arrayList);
        return arrayList3;
    }

    void insertAndDeleteAttachmentsOnTaskUpdate(TaskImpl newTaskImpl, TaskImpl oldTaskImpl) throws AttachmentPersistenceException {
        TaskImpl taskImpl = newTaskImpl;
        TaskImpl taskImpl2 = oldTaskImpl;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)taskImpl, (Object)taskImpl2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        List<Attachment> newAttachments = newTaskImpl.getAttachments().stream().filter(Objects::nonNull).collect(Collectors.toList());
        newTaskImpl.setAttachments(newAttachments);
        this.deleteRemovedAttachmentsOnTaskUpdate(newTaskImpl, oldTaskImpl);
        this.insertNewAttachmentsOnTaskUpdate(newTaskImpl, oldTaskImpl);
        this.updateModifiedAttachmentsOnTaskUpdate(newTaskImpl, oldTaskImpl);
        Object var7_7 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var7_7);
    }

    void updateModifiedAttachmentsOnTaskUpdate(TaskImpl newTaskImpl, TaskImpl oldTaskImpl) {
        TaskImpl taskImpl = newTaskImpl;
        TaskImpl taskImpl2 = oldTaskImpl;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)taskImpl, (Object)taskImpl2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        List<Attachment> newAttachments = newTaskImpl.getAttachments();
        List<Attachment> oldAttachments = oldTaskImpl.getAttachments();
        if (newAttachments != null && !newAttachments.isEmpty() && oldAttachments != null && !oldAttachments.isEmpty()) {
            Map oldAttachmentMap = oldAttachments.stream().collect(Collectors.toMap(AttachmentSummary::getId, Function.identity()));
            newAttachments.forEach(a -> {
                if (oldAttachmentMap.containsKey(a.getId()) && !a.equals(oldAttachmentMap.get(a.getId()))) {
                    this.attachmentMapper.update((AttachmentImpl)a);
                }
            });
        }
        Object var9_9 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var9_9);
    }

    void insertNewAttachmentsOnTaskUpdate(TaskImpl newTaskImpl, TaskImpl oldTaskImpl) throws AttachmentPersistenceException {
        TaskImpl taskImpl = newTaskImpl;
        TaskImpl taskImpl2 = oldTaskImpl;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)taskImpl, (Object)taskImpl2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        List oldAttachmentIds = oldTaskImpl.getAttachments().stream().map(AttachmentSummary::getId).collect(Collectors.toList());
        ArrayList exceptions = new ArrayList();
        newTaskImpl.getAttachments().forEach(a -> {
            if (!oldAttachmentIds.contains(a.getId())) {
                try {
                    this.insertNewAttachmentOnTaskUpdate(newTaskImpl, (Attachment)a);
                }
                catch (AttachmentPersistenceException excpt) {
                    exceptions.add(excpt);
                    LOGGER.warn("attempted to insert attachment {} and caught exception", a, (Object)excpt);
                }
            }
        });
        if (!exceptions.isEmpty()) {
            throw (AttachmentPersistenceException)((Object)exceptions.get(0));
        }
        Object var8_8 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var8_8);
    }

    void insertNewAttachmentsOnTaskCreation(TaskImpl task) throws InvalidArgumentException, AttachmentPersistenceException {
        TaskImpl taskImpl = task;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)taskImpl);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        List<Attachment> attachments = task.getAttachments();
        if (attachments != null) {
            for (Attachment attachment : attachments) {
                AttachmentImpl attachmentImpl = (AttachmentImpl)attachment;
                this.initializeAndInsertAttachment(task, attachmentImpl);
            }
        }
        Object var8_8 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var8_8);
    }

    void deleteRemovedAttachmentsOnTaskUpdate(TaskImpl newTaskImpl, TaskImpl oldTaskImpl) {
        List<Attachment> oldAttachments;
        TaskImpl taskImpl = newTaskImpl;
        TaskImpl taskImpl2 = oldTaskImpl;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)taskImpl, (Object)taskImpl2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        List<Attachment> newAttachments = newTaskImpl.getAttachments();
        List<Object> newAttachmentIds = new ArrayList();
        if (newAttachments != null && !newAttachments.isEmpty()) {
            newAttachmentIds = newAttachments.stream().map(AttachmentSummary::getId).collect(Collectors.toList());
        }
        if ((oldAttachments = oldTaskImpl.getAttachments()) != null && !oldAttachments.isEmpty()) {
            ArrayList newAttIds = newAttachmentIds;
            oldAttachments.forEach(a -> {
                if (!newAttIds.contains(a.getId())) {
                    this.attachmentMapper.delete(a.getId());
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("TaskService.updateTask() for TaskId={} DELETED an Attachment={}.", (Object)newTaskImpl.getId(), a);
                    }
                }
            });
        }
        Object var10_10 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var10_10);
    }

    void insertNewAttachmentOnTaskUpdate(TaskImpl newTaskImpl, Attachment attachment) throws AttachmentPersistenceException {
        TaskImpl taskImpl = newTaskImpl;
        Attachment attachment2 = attachment;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)taskImpl, (Object)attachment2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        AttachmentImpl attachmentImpl = (AttachmentImpl)attachment;
        this.initAttachment(attachmentImpl, newTaskImpl);
        try {
            this.attachmentMapper.insert(attachmentImpl);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("TaskService.updateTask() for TaskId={} INSERTED an Attachment={}.", (Object)newTaskImpl.getId(), (Object)attachmentImpl);
            }
        }
        catch (PersistenceException e) {
            throw new AttachmentPersistenceException(String.format("Cannot insert the Attachement %s for Task %s  because it already exists.", attachmentImpl.getId(), newTaskImpl.getId()), e.getCause());
        }
        Object var8_8 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var8_8);
    }

    void initAttachment(AttachmentImpl attachment, Task newTask) {
        AttachmentImpl attachmentImpl = attachment;
        Task task = newTask;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)attachmentImpl, (Object)task);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (attachment.getId() == null) {
            attachment.setId(IdGenerator.generateWithPrefix((String)"TAI"));
        }
        if (attachment.getCreated() == null) {
            attachment.setCreated(newTask.getModified());
        }
        if (attachment.getModified() == null) {
            attachment.setModified(attachment.getCreated());
        }
        if (attachment.getTaskId() == null) {
            attachment.setTaskId(newTask.getId());
        }
        Object var6_6 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var6_6);
    }

    private void initializeAndInsertAttachment(TaskImpl task, AttachmentImpl attachmentImpl) throws AttachmentPersistenceException, InvalidArgumentException {
        TaskImpl taskImpl = task;
        AttachmentImpl attachmentImpl2 = attachmentImpl;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object)taskImpl, (Object)attachmentImpl2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.initAttachment(attachmentImpl, task);
        ObjectReference objRef = attachmentImpl.getObjectReference();
        ObjectReference.validate(objRef, "ObjectReference", "Attachment");
        try {
            this.attachmentMapper.insert(attachmentImpl);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("TaskService.updateTask() for TaskId={} INSERTED an Attachment={}.", (Object)task.getId(), (Object)attachmentImpl);
            }
        }
        catch (PersistenceException e) {
            throw new AttachmentPersistenceException(String.format("Cannot insert the Attachement %s for Task %s  because it already exists.", attachmentImpl.getId(), task.getId()), e.getCause());
        }
        Object var8_8 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var8_8);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AttachmentHandler.java", AttachmentHandler.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "augmentAttachmentsByClassification", "pro.taskana.task.internal.AttachmentHandler", "java.util.List:pro.taskana.common.api.BulkOperationResults", "attachmentImpls:bulkLog", "", "java.util.List"), 38);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "insertAndDeleteAttachmentsOnTaskUpdate", "pro.taskana.task.internal.AttachmentHandler", "pro.taskana.task.internal.models.TaskImpl:pro.taskana.task.internal.models.TaskImpl", "newTaskImpl:oldTaskImpl", "pro.taskana.task.api.exceptions.AttachmentPersistenceException", "void"), 78);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "updateModifiedAttachmentsOnTaskUpdate", "pro.taskana.task.internal.AttachmentHandler", "pro.taskana.task.internal.models.TaskImpl:pro.taskana.task.internal.models.TaskImpl", "newTaskImpl:oldTaskImpl", "", "void"), 90);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "insertNewAttachmentsOnTaskUpdate", "pro.taskana.task.internal.AttachmentHandler", "pro.taskana.task.internal.models.TaskImpl:pro.taskana.task.internal.models.TaskImpl", "newTaskImpl:oldTaskImpl", "pro.taskana.task.api.exceptions.AttachmentPersistenceException", "void"), 110);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "insertNewAttachmentsOnTaskCreation", "pro.taskana.task.internal.AttachmentHandler", "pro.taskana.task.internal.models.TaskImpl", "task", "pro.taskana.common.api.exceptions.InvalidArgumentException:pro.taskana.task.api.exceptions.AttachmentPersistenceException", "void"), 135);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "deleteRemovedAttachmentsOnTaskUpdate", "pro.taskana.task.internal.AttachmentHandler", "pro.taskana.task.internal.models.TaskImpl:pro.taskana.task.internal.models.TaskImpl", "newTaskImpl:oldTaskImpl", "", "void"), 146);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "insertNewAttachmentOnTaskUpdate", "pro.taskana.task.internal.AttachmentHandler", "pro.taskana.task.internal.models.TaskImpl:pro.taskana.task.api.models.Attachment", "newTaskImpl:attachment", "pro.taskana.task.api.exceptions.AttachmentPersistenceException", "void"), 172);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "initAttachment", "pro.taskana.task.internal.AttachmentHandler", "pro.taskana.task.internal.models.AttachmentImpl:pro.taskana.task.api.models.Task", "attachment:newTask", "", "void"), 194);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "initializeAndInsertAttachment", "pro.taskana.task.internal.AttachmentHandler", "pro.taskana.task.internal.models.TaskImpl:pro.taskana.task.internal.models.AttachmentImpl", "task:attachmentImpl", "pro.taskana.task.api.exceptions.AttachmentPersistenceException:pro.taskana.common.api.exceptions.InvalidArgumentException", "void"), 209);
    }
}

