/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.monitor.internal;

import java.time.Instant;
import java.util.List;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Result;
import org.apache.ibatis.annotations.Results;
import org.apache.ibatis.annotations.SelectProvider;
import pro.taskana.monitor.api.CombinedClassificationFilter;
import pro.taskana.monitor.api.SelectedItem;
import pro.taskana.monitor.api.TaskTimestamp;
import pro.taskana.monitor.api.reports.TimeIntervalReportBuilder;
import pro.taskana.monitor.api.reports.item.DetailedMonitorQueryItem;
import pro.taskana.monitor.api.reports.item.MonitorQueryItem;
import pro.taskana.monitor.api.reports.item.TaskQueryItem;
import pro.taskana.monitor.api.reports.item.TimestampQueryItem;
import pro.taskana.monitor.internal.MonitorMapperSqlProvider;
import pro.taskana.task.api.TaskCustomField;
import pro.taskana.task.api.TaskState;

public interface MonitorMapper {
    @SelectProvider(type=MonitorMapperSqlProvider.class, method="getTaskCountOfWorkbaskets")
    @Results(value={@Result(column="WORKBASKET_KEY", property="key"), @Result(column="AGE_IN_DAYS", property="ageInDays"), @Result(column="NUMBER_OF_TASKS", property="numberOfTasks")})
    public List<MonitorQueryItem> getTaskCountOfWorkbaskets(@Param(value="now") Instant var1, @Param(value="timestamp") TaskTimestamp var2, @Param(value="report") TimeIntervalReportBuilder<?, ?, ?> var3);

    @SelectProvider(type=MonitorMapperSqlProvider.class, method="getTaskCountOfCategories")
    @Results(value={@Result(column="CLASSIFICATION_CATEGORY", property="key"), @Result(column="AGE_IN_DAYS", property="ageInDays"), @Result(column="NUMBER_OF_TASKS", property="numberOfTasks")})
    public List<MonitorQueryItem> getTaskCountOfCategories(@Param(value="now") Instant var1, @Param(value="timestamp") TaskTimestamp var2, @Param(value="report") TimeIntervalReportBuilder<?, ?, ?> var3);

    @SelectProvider(type=MonitorMapperSqlProvider.class, method="getTaskCountOfClassifications")
    @Results(value={@Result(column="CLASSIFICATION_KEY", property="key"), @Result(column="AGE_IN_DAYS", property="ageInDays"), @Result(column="NUMBER_OF_TASKS", property="numberOfTasks")})
    public List<MonitorQueryItem> getTaskCountOfClassifications(@Param(value="now") Instant var1, @Param(value="timestamp") TaskTimestamp var2, @Param(value="report") TimeIntervalReportBuilder<?, ?, ?> var3);

    @SelectProvider(type=MonitorMapperSqlProvider.class, method="getTaskCountOfDetailedClassifications")
    @Results(value={@Result(column="TASK_CLASSIFICATION_KEY", property="key"), @Result(column="ATTACHMENT_CLASSIFICATION_KEY", property="attachmentKey"), @Result(column="AGE_IN_DAYS", property="ageInDays"), @Result(column="NUMBER_OF_TASKS", property="numberOfTasks")})
    public List<DetailedMonitorQueryItem> getTaskCountOfDetailedClassifications(@Param(value="now") Instant var1, @Param(value="timestamp") TaskTimestamp var2, @Param(value="report") TimeIntervalReportBuilder<?, ?, ?> var3);

    @SelectProvider(type=MonitorMapperSqlProvider.class, method="getTaskCountOfTaskCustomFieldValues")
    @Results(value={@Result(column="CUSTOM_FIELD", property="key"), @Result(column="AGE_IN_DAYS", property="ageInDays"), @Result(column="NUMBER_OF_TASKS", property="numberOfTasks")})
    public List<MonitorQueryItem> getTaskCountOfTaskCustomFieldValues(@Param(value="now") Instant var1, @Param(value="timestamp") TaskTimestamp var2, @Param(value="report") TimeIntervalReportBuilder<?, ?, ?> var3);

    @SelectProvider(type=MonitorMapperSqlProvider.class, method="getTaskIdsForSelectedItems")
    public List<String> getTaskIdsForSelectedItems(@Param(value="now") Instant var1, @Param(value="report") TimeIntervalReportBuilder<?, ?, ?> var2, @Param(value="combinedClassificationFilter") List<CombinedClassificationFilter> var3, @Param(value="groupedBy") String var4, @Param(value="timestamp") TaskTimestamp var5, @Param(value="selectedItems") List<SelectedItem> var6, @Param(value="joinWithAttachments") boolean var7);

    @SelectProvider(type=MonitorMapperSqlProvider.class, method="getTasksCountByState")
    @Results(value={@Result(column="WORKBASKET_KEY", property="workbasketKey"), @Result(column="STATE", property="state"), @Result(column="COUNT", property="count")})
    public List<TaskQueryItem> getTasksCountByState(@Param(value="domains") List<String> var1, @Param(value="states") List<TaskState> var2, @Param(value="workbasketIds") List<String> var3, @Param(value="priorityMinimum") Integer var4);

    @SelectProvider(type=MonitorMapperSqlProvider.class, method="getCustomAttributeValuesForReport")
    public List<String> getCustomAttributeValuesForReport(@Param(value="report") TimeIntervalReportBuilder<?, ?, ?> var1, @Param(value="combinedClassificationFilter") List<CombinedClassificationFilter> var2, @Param(value="customField") TaskCustomField var3);

    @SelectProvider(type=MonitorMapperSqlProvider.class, method="getTasksCountForStatusGroupedByOrgLevel")
    @Results(value={@Result(column="STATUS", property="status"), @Result(column="AGE_IN_DAYS", property="ageInDays"), @Result(column="COUNT", property="count"), @Result(column="ORG_LEVEL_1", property="orgLevel1"), @Result(column="ORG_LEVEL_2", property="orgLevel2"), @Result(column="ORG_LEVEL_3", property="orgLevel3"), @Result(column="ORG_LEVEL_4", property="orgLevel4")})
    public List<TimestampQueryItem> getTasksCountForStatusGroupedByOrgLevel(@Param(value="now") Instant var1, @Param(value="status") TaskTimestamp var2, @Param(value="report") TimeIntervalReportBuilder<?, ?, ?> var3);
}

