/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.task.internal;

import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import pro.taskana.common.internal.logging.LoggingAspect;
import pro.taskana.common.internal.util.SqlProviderUtil;
import pro.taskana.task.api.TaskQueryColumnName;

public class TaskQuerySqlProvider {
    private static final String WILDCARD_LIKE_STATEMENT = "<if test='wildcardSearchValueLike != null and wildcardSearchFieldIn != null'>AND (<foreach item='item' collection='wildcardSearchFieldIn' separator=' OR '>UPPER(t.${item}) LIKE #{wildcardSearchValueLike}</foreach>)</if> ";
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;

    private TaskQuerySqlProvider() {
    }

    public static String queryTaskSummaries() {
        String string;
        String string2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String string3 = string2 = (string = "<script>SELECT <if test=\"useDistinctKeyword\">DISTINCT</if> " + TaskQuerySqlProvider.commonSelectFields() + "<if test=\"addAttachmentColumnsToSelectClauseForOrdering\">" + ", a.CLASSIFICATION_ID, a.CLASSIFICATION_KEY, a.CHANNEL, a.REF_VALUE, a.RECEIVED" + "</if>" + "<if test=\"addClassificationNameToSelectClauseForOrdering\">, c.NAME </if>" + "<if test=\"addAttachmentClassificationNameToSelectClauseForOrdering\">, ac.NAME </if>" + "<if test=\"addWorkbasketNameToSelectClauseForOrdering\">, w.NAME </if>" + "FROM TASK t " + "<if test=\"joinWithAttachments\">" + "LEFT JOIN ATTACHMENT AS a ON t.ID = a.TASK_ID " + "</if>" + "<if test=\"joinWithClassifications\">" + "LEFT JOIN CLASSIFICATION AS c ON t.CLASSIFICATION_ID = c.ID " + "</if>" + "<if test=\"joinWithAttachmentClassifications\">" + "LEFT JOIN CLASSIFICATION AS ac ON a.CLASSIFICATION_ID = ac.ID " + "</if>" + "<if test=\"joinWithWorkbaskets\">" + "LEFT JOIN WORKBASKET AS w ON t.WORKBASKET_ID = w.ID " + "</if>" + "<where>" + TaskQuerySqlProvider.checkForAuthorization() + TaskQuerySqlProvider.commonTaskWhereStatement() + WILDCARD_LIKE_STATEMENT + TaskQuerySqlProvider.commonTaskObjectReferenceWhereStatement() + "<if test='selectAndClaim == true'> AND t.STATE = 'READY' </if>" + "</where>" + "<if test='!orderBy.isEmpty()'>" + "ORDER BY <foreach item='item' collection='orderBy' separator=',' >${item}</foreach>" + "</if> " + "<if test='selectAndClaim == true'> " + "FETCH FIRST ROW ONLY FOR UPDATE " + "</if>" + "<if test=\"_databaseId == 'db2'\">WITH RS USE AND KEEP UPDATE LOCKS </if>" + "</script>");
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string2);
        return string;
    }

    public static String queryTaskSummariesDb2() {
        String string;
        String string2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, null, null);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String string3 = string2 = (string = "<script>WITH X (" + TaskQuerySqlProvider.db2selectFields() + ") AS (" + "SELECT <if test=\"useDistinctKeyword\">DISTINCT</if> " + TaskQuerySqlProvider.commonSelectFields() + "<if test=\"addAttachmentColumnsToSelectClauseForOrdering\">" + ", a.CLASSIFICATION_ID, a.CLASSIFICATION_KEY, a.CHANNEL, a.REF_VALUE, a.RECEIVED" + "</if>" + "<if test=\"addClassificationNameToSelectClauseForOrdering\">, c.NAME </if>" + "<if test=\"addAttachmentClassificationNameToSelectClauseForOrdering\">, ac.NAME </if>" + "<if test=\"addWorkbasketNameToSelectClauseForOrdering\">, w.NAME </if>" + "FROM TASK t " + "<if test=\"joinWithAttachments\">" + "LEFT JOIN ATTACHMENT a ON t.ID = a.TASK_ID " + "</if>" + "<if test=\"joinWithClassifications\">" + "LEFT JOIN CLASSIFICATION AS c ON t.CLASSIFICATION_ID = c.ID " + "</if>" + "<if test=\"joinWithAttachmentClassifications\">" + "LEFT JOIN CLASSIFICATION AS ac ON a.CLASSIFICATION_ID = ac.ID " + "</if>" + "<if test=\"joinWithWorkbaskets\">" + "LEFT JOIN WORKBASKET AS w ON t.WORKBASKET_ID = w.ID " + "</if>" + "<where>" + TaskQuerySqlProvider.commonTaskWhereStatement() + TaskQuerySqlProvider.commonTaskObjectReferenceWhereStatement() + WILDCARD_LIKE_STATEMENT + "</where>" + "), Y (" + TaskQuerySqlProvider.db2selectFields() + ", FLAG ) AS (" + "SELECT " + TaskQuerySqlProvider.db2selectFields() + ", (" + "SELECT 1 " + "FROM WORKBASKET_ACCESS_LIST s " + "WHERE " + "<if test='accessIdIn != null'> " + "s.ACCESS_ID IN " + "(<foreach item='item' collection='accessIdIn' separator=',' >#{item}</foreach>) " + "and </if>" + "s.WORKBASKET_ID = X.WORKBASKET_ID AND s.perm_read = 1 fetch first 1 rows only ) " + "FROM X )" + "SELECT " + TaskQuerySqlProvider.db2selectFields() + "FROM Y " + "WHERE FLAG = 1 " + "<if test='!orderBy.isEmpty()'>" + "ORDER BY <foreach item='item' collection='orderBy' separator=',' >${item}</foreach>" + "</if> " + "<if test='selectAndClaim == true'>" + "FETCH FIRST ROW ONLY FOR UPDATE WITH RS USE AND KEEP UPDATE LOCKS" + "</if>" + "<if test='selectAndClaim == false'> with UR</if>" + "</script>");
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string2);
        return string;
    }

    public static String countQueryTasks() {
        String string;
        String string2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, null, null);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String string3 = string2 = (string = "<script>SELECT COUNT( <if test=\"useDistinctKeyword\">DISTINCT</if> t.ID) FROM TASK t <if test=\"joinWithAttachments\">LEFT JOIN ATTACHMENT AS a ON t.ID = a.TASK_ID </if><if test=\"joinWithClassifications\">LEFT JOIN CLASSIFICATION AS c ON t.CLASSIFICATION_ID = c.ID </if><if test=\"joinWithAttachmentClassifications\">LEFT JOIN CLASSIFICATION AS ac ON a.CLASSIFICATION_ID = ac.ID </if><where>" + TaskQuerySqlProvider.checkForAuthorization() + TaskQuerySqlProvider.commonTaskWhereStatement() + TaskQuerySqlProvider.commonTaskObjectReferenceWhereStatement() + WILDCARD_LIKE_STATEMENT + "</where>" + "</script>");
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string2);
        return string;
    }

    public static String countQueryTasksDb2() {
        String string;
        String string2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, null, null);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String string3 = string2 = (string = "<script>WITH X (ID, WORKBASKET_ID) AS (SELECT <if test=\"useDistinctKeyword\">DISTINCT</if> t.ID, t.WORKBASKET_ID FROM TASK t <if test=\"joinWithAttachments\">LEFT JOIN ATTACHMENT AS a ON t.ID = a.TASK_ID </if><if test=\"joinWithClassifications\">LEFT JOIN CLASSIFICATION AS c ON t.CLASSIFICATION_ID = c.ID </if><if test=\"joinWithAttachmentClassifications\">LEFT JOIN CLASSIFICATION AS ac ON a.CLASSIFICATION_ID = ac.ID </if><where>" + TaskQuerySqlProvider.commonTaskWhereStatement() + TaskQuerySqlProvider.commonTaskObjectReferenceWhereStatement() + WILDCARD_LIKE_STATEMENT + "</where>" + "), Y (ID, FLAG) AS (" + "SELECT ID, (" + "SELECT 1 FROM WORKBASKET_ACCESS_LIST s " + "WHERE <if test='accessIdIn != null'> s.ACCESS_ID IN " + "(<foreach item='item' collection='accessIdIn' separator=',' >#{item}</foreach>) " + "and </if> " + "s.WORKBASKET_ID = X.WORKBASKET_ID AND s.perm_read = 1 fetch first 1 rows only ) " + "FROM X ) SELECT COUNT(*) " + "FROM Y WHERE FLAG = 1 with UR" + "</script>");
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string2);
        return string;
    }

    public static String queryTaskColumnValues() {
        String string;
        String string2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, null, null);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String string3 = string2 = (string = "<script>SELECT DISTINCT ${columnName} FROM TASK t <if test=\"joinWithAttachments\">LEFT JOIN ATTACHMENT AS a ON t.ID = a.TASK_ID </if><if test=\"joinWithClassifications\">LEFT JOIN CLASSIFICATION AS c ON t.CLASSIFICATION_ID = c.ID </if><if test=\"joinWithAttachmentClassifications\">LEFT JOIN CLASSIFICATION AS ac ON a.CLASSIFICATION_ID = ac.ID </if><where>" + TaskQuerySqlProvider.checkForAuthorization() + TaskQuerySqlProvider.commonTaskWhereStatement() + "</where>" + "<if test='!orderBy.isEmpty()'>" + "ORDER BY <foreach item='item' collection='orderBy' separator=',' >" + "<choose>" + "<when test=\"item.contains('TCLASSIFICATION_KEY ASC')\">" + "t.CLASSIFICATION_KEY ASC" + "</when>" + "<when test=\"item.contains('TCLASSIFICATION_KEY DESC')\">" + "t.CLASSIFICATION_KEY DESC" + "</when>" + "<when test=\"item.contains('ACLASSIFICATION_KEY ASC')\">" + "a.CLASSIFICATION_KEY ASC" + "</when>" + "<when test=\"item.contains('ACLASSIFICATION_KEY DESC')\">" + "a.CLASSIFICATION_KEY DESC" + "</when>" + "<when test=\"item.contains('ACLASSIFICATION_ID ASC')\">" + "a.CLASSIFICATION_ID ASC" + "</when>" + "<when test=\"item.contains('ACLASSIFICATION_ID DESC')\">" + "a.CLASSIFICATION_ID DESC" + "</when>" + "<when test=\"item.contains('CLASSIFICATION_NAME DESC')\">" + "c.NAME DESC" + "</when>" + "<when test=\"item.contains('CLASSIFICATION_NAME ASC')\">" + "c.NAME ASC" + "</when>" + "<when test=\"item.contains('A_CLASSIFICATION_NAME DESC')\">" + "ac.NAME DESC" + "</when>" + "<when test=\"item.contains('A_CLASSIFICATION_NAME ASC')\">" + "ac.NAME ASC" + "</when>" + "<otherwise>${item}</otherwise>" + "</choose>" + "</foreach>" + "</if> " + "<if test=\"_databaseId == 'db2'\">with UR </if> " + "</script>");
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string2);
        return string;
    }

    private static String commonSelectFields() {
        String string;
        String string2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, null, null);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String string3 = string2 = (string = Arrays.stream(TaskQueryColumnName.values()).map(TaskQueryColumnName::toString).filter(column -> column.startsWith("t")).collect(Collectors.joining(", ")));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string2);
        return string;
    }

    private static String db2selectFields() {
        String string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, null, null);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String string2 = "ID, EXTERNAL_ID, CREATED, CLAIMED, COMPLETED, MODIFIED, PLANNED, RECEIVED, DUE, NAME, CREATOR, DESCRIPTION, NOTE, PRIORITY, STATE, CLASSIFICATION_CATEGORY, TCLASSIFICATION_KEY, CLASSIFICATION_ID, WORKBASKET_ID, WORKBASKET_KEY, DOMAIN, BUSINESS_PROCESS_ID, PARENT_BUSINESS_PROCESS_ID, OWNER, POR_COMPANY, POR_SYSTEM, POR_INSTANCE, POR_TYPE, POR_VALUE, IS_READ, IS_TRANSFERRED, CUSTOM_1, CUSTOM_2, CUSTOM_3, CUSTOM_4, CUSTOM_5, CUSTOM_6, CUSTOM_7, CUSTOM_8, CUSTOM_9, CUSTOM_10, CUSTOM_11, CUSTOM_12, CUSTOM_13, CUSTOM_14, CUSTOM_15, CUSTOM_16<if test=\"addClassificationNameToSelectClauseForOrdering\">, CNAME</if><if test=\"addAttachmentClassificationNameToSelectClauseForOrdering\">, ACNAME</if><if test=\"addAttachmentColumnsToSelectClauseForOrdering\">, ACLASSIFICATION_ID, ACLASSIFICATION_KEY, CHANNEL, REF_VALUE, ARECEIVED</if><if test=\"addWorkbasketNameToSelectClauseForOrdering\">, WNAME</if>";
        String string3 = string = "ID, EXTERNAL_ID, CREATED, CLAIMED, COMPLETED, MODIFIED, PLANNED, RECEIVED, DUE, NAME, CREATOR, DESCRIPTION, NOTE, PRIORITY, STATE, CLASSIFICATION_CATEGORY, TCLASSIFICATION_KEY, CLASSIFICATION_ID, WORKBASKET_ID, WORKBASKET_KEY, DOMAIN, BUSINESS_PROCESS_ID, PARENT_BUSINESS_PROCESS_ID, OWNER, POR_COMPANY, POR_SYSTEM, POR_INSTANCE, POR_TYPE, POR_VALUE, IS_READ, IS_TRANSFERRED, CUSTOM_1, CUSTOM_2, CUSTOM_3, CUSTOM_4, CUSTOM_5, CUSTOM_6, CUSTOM_7, CUSTOM_8, CUSTOM_9, CUSTOM_10, CUSTOM_11, CUSTOM_12, CUSTOM_13, CUSTOM_14, CUSTOM_15, CUSTOM_16<if test=\"addClassificationNameToSelectClauseForOrdering\">, CNAME</if><if test=\"addAttachmentClassificationNameToSelectClauseForOrdering\">, ACNAME</if><if test=\"addAttachmentColumnsToSelectClauseForOrdering\">, ACLASSIFICATION_ID, ACLASSIFICATION_KEY, CHANNEL, REF_VALUE, ARECEIVED</if><if test=\"addWorkbasketNameToSelectClauseForOrdering\">, WNAME</if>";
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string);
        return string2;
    }

    private static String checkForAuthorization() {
        String string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, null, null);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String string2 = "<if test='accessIdIn != null'> AND t.WORKBASKET_ID IN (SELECT WID FROM (SELECT WORKBASKET_ID as WID, MAX(PERM_READ::int) as MAX_READ FROM WORKBASKET_ACCESS_LIST AS s where ACCESS_ID IN (<foreach item='item' collection='accessIdIn' separator=',' >#{item}</foreach>) GROUP by WORKBASKET_ID) as f WHERE MAX_READ = 1) </if>";
        String string3 = string = "<if test='accessIdIn != null'> AND t.WORKBASKET_ID IN (SELECT WID FROM (SELECT WORKBASKET_ID as WID, MAX(PERM_READ::int) as MAX_READ FROM WORKBASKET_ACCESS_LIST AS s where ACCESS_ID IN (<foreach item='item' collection='accessIdIn' separator=',' >#{item}</foreach>) GROUP by WORKBASKET_ID) as f WHERE MAX_READ = 1) </if>";
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string);
        return string2;
    }

    private static String commonTaskObjectReferenceWhereStatement() {
        String string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, null, null);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String string2 = "<if test='objectReferences != null'>AND (<foreach item='item' collection='objectReferences' separator=' OR '> <if test='item.company != null'>t.POR_COMPANY = #{item.company} </if><if test='item.system != null'> <if test='item.company != null'>AND</if> t.POR_SYSTEM = #{item.system} </if><if test='item.systemInstance != null'> <if test='item.company != null or item.system != null'>AND</if> t.POR_INSTANCE = #{item.systemInstance} </if><if test='item.type != null'> <if test='item.company != null or item.system != null or item.systemInstance != null'>AND</if> t.POR_TYPE = #{item.type} </if><if test='item.value != null'> <if test='item.company != null or item.system != null or item.systemInstance != null or item.type != null'>AND</if> t.POR_VALUE = #{item.value} </if></foreach>)</if>";
        String string3 = string = "<if test='objectReferences != null'>AND (<foreach item='item' collection='objectReferences' separator=' OR '> <if test='item.company != null'>t.POR_COMPANY = #{item.company} </if><if test='item.system != null'> <if test='item.company != null'>AND</if> t.POR_SYSTEM = #{item.system} </if><if test='item.systemInstance != null'> <if test='item.company != null or item.system != null'>AND</if> t.POR_INSTANCE = #{item.systemInstance} </if><if test='item.type != null'> <if test='item.company != null or item.system != null or item.systemInstance != null'>AND</if> t.POR_TYPE = #{item.type} </if><if test='item.value != null'> <if test='item.company != null or item.system != null or item.systemInstance != null or item.type != null'>AND</if> t.POR_VALUE = #{item.value} </if></foreach>)</if>";
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string);
        return string2;
    }

    private static String commonTaskWhereStatement() {
        String string;
        String string2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, null, null);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        StringBuilder sb = new StringBuilder();
        SqlProviderUtil.whereIn((String)"taskIds", (String)"t.ID", (StringBuilder)sb);
        SqlProviderUtil.whereIn((String)"priority", (String)"PRIORITY", (StringBuilder)sb);
        SqlProviderUtil.whereIn((String)"externalIdIn", (String)"t.EXTERNAL_ID", (StringBuilder)sb);
        SqlProviderUtil.whereIn((String)"nameIn", (String)"t.NAME", (StringBuilder)sb);
        SqlProviderUtil.whereIn((String)"creatorIn", (String)"CREATOR", (StringBuilder)sb);
        SqlProviderUtil.whereIn((String)"stateIn", (String)"STATE", (StringBuilder)sb);
        SqlProviderUtil.whereIn((String)"callbackStateIn", (String)"t.CALLBACK_STATE", (StringBuilder)sb);
        SqlProviderUtil.whereIn((String)"workbasketIdIn", (String)"WORKBASKET_ID", (StringBuilder)sb);
        SqlProviderUtil.whereIn((String)"classificationKeyIn", (String)"t.CLASSIFICATION_KEY", (StringBuilder)sb);
        SqlProviderUtil.whereIn((String)"classificationIdIn", (String)"t.CLASSIFICATION_ID", (StringBuilder)sb);
        SqlProviderUtil.whereIn((String)"classificationCategoryIn", (String)"CLASSIFICATION_CATEGORY", (StringBuilder)sb);
        SqlProviderUtil.whereIn((String)"classificationNameIn", (String)"c.NAME", (StringBuilder)sb);
        SqlProviderUtil.whereIn((String)"attachmentClassificationNameIn", (String)"ac.NAME", (StringBuilder)sb);
        SqlProviderUtil.whereIn((String)"ownerIn", (String)"OWNER", (StringBuilder)sb);
        SqlProviderUtil.whereIn((String)"porCompanyIn", (String)"POR_COMPANY", (StringBuilder)sb);
        SqlProviderUtil.whereIn((String)"porSystemIn", (String)"POR_SYSTEM", (StringBuilder)sb);
        SqlProviderUtil.whereIn((String)"porSystemInstanceIn", (String)"POR_INSTANCE", (StringBuilder)sb);
        SqlProviderUtil.whereIn((String)"porTypeIn", (String)"POR_TYPE", (StringBuilder)sb);
        SqlProviderUtil.whereIn((String)"porValueIn", (String)"POR_VALUE", (StringBuilder)sb);
        SqlProviderUtil.whereIn((String)"parentBusinessProcessIdIn", (String)"PARENT_BUSINESS_PROCESS_ID", (StringBuilder)sb);
        SqlProviderUtil.whereIn((String)"businessProcessIdIn", (String)"BUSINESS_PROCESS_ID", (StringBuilder)sb);
        SqlProviderUtil.whereIn((String)"attachmentClassificationKeyIn", (String)"a.CLASSIFICATION_KEY", (StringBuilder)sb);
        SqlProviderUtil.whereIn((String)"attachmentClassificationIdIn", (String)"a.CLASSIFICATION_ID", (StringBuilder)sb);
        SqlProviderUtil.whereIn((String)"attachmentChannelIn", (String)"a.CHANNEL", (StringBuilder)sb);
        SqlProviderUtil.whereIn((String)"attachmentReferenceIn", (String)"a.REF_VALUE", (StringBuilder)sb);
        SqlProviderUtil.whereInTime((String)"createdIn", (String)"t.CREATED", (StringBuilder)sb);
        SqlProviderUtil.whereInTime((String)"claimedIn", (String)"t.CLAIMED", (StringBuilder)sb);
        SqlProviderUtil.whereInTime((String)"completedIn", (String)"t.COMPLETED", (StringBuilder)sb);
        SqlProviderUtil.whereInTime((String)"modifiedIn", (String)"t.MODIFIED", (StringBuilder)sb);
        SqlProviderUtil.whereInTime((String)"plannedIn", (String)"t.PLANNED", (StringBuilder)sb);
        SqlProviderUtil.whereInTime((String)"receivedIn", (String)"t.RECEIVED", (StringBuilder)sb);
        SqlProviderUtil.whereInTime((String)"dueIn", (String)"t.DUE", (StringBuilder)sb);
        SqlProviderUtil.whereInTime((String)"attachmentReceivedIn", (String)"a.RECEIVED", (StringBuilder)sb);
        SqlProviderUtil.whereNotIn((String)"classificationKeyNotIn", (String)"t.CLASSIFICATION_KEY", (StringBuilder)sb);
        SqlProviderUtil.whereLike((String)"externalIdLike", (String)"t.EXTERNAL_ID", (StringBuilder)sb);
        SqlProviderUtil.whereLike((String)"nameLike", (String)"t.NAME", (StringBuilder)sb);
        SqlProviderUtil.whereLike((String)"creatorLike", (String)"CREATOR", (StringBuilder)sb);
        SqlProviderUtil.whereLike((String)"noteLike", (String)"NOTE", (StringBuilder)sb);
        SqlProviderUtil.whereLike((String)"classificationKeyLike", (String)"t.CLASSIFICATION_KEY", (StringBuilder)sb);
        SqlProviderUtil.whereLike((String)"classificationCategoryLike", (String)"CLASSIFICATION_CATEGORY", (StringBuilder)sb);
        SqlProviderUtil.whereLike((String)"classificationNameLike", (String)"c.NAME", (StringBuilder)sb);
        SqlProviderUtil.whereLike((String)"attachmentClassificationNameLike", (String)"ac.NAME", (StringBuilder)sb);
        SqlProviderUtil.whereLike((String)"ownerLike", (String)"OWNER", (StringBuilder)sb);
        SqlProviderUtil.whereLike((String)"porCompanyLike", (String)"POR_COMPANY", (StringBuilder)sb);
        SqlProviderUtil.whereLike((String)"porSystemLike", (String)"POR_SYSTEM", (StringBuilder)sb);
        SqlProviderUtil.whereLike((String)"porSystemInstanceLike", (String)"POR_INSTANCE", (StringBuilder)sb);
        SqlProviderUtil.whereLike((String)"porTypeLike", (String)"POR_TYPE", (StringBuilder)sb);
        SqlProviderUtil.whereLike((String)"porValueLike", (String)"POR_VALUE", (StringBuilder)sb);
        SqlProviderUtil.whereLike((String)"parentBusinessProcessIdLike", (String)"PARENT_BUSINESS_PROCESS_ID", (StringBuilder)sb);
        SqlProviderUtil.whereLike((String)"businessProcessIdLike", (String)"BUSINESS_PROCESS_ID", (StringBuilder)sb);
        SqlProviderUtil.whereLike((String)"attachmentClassificationKeyLike", (String)"a.CLASSIFICATION_KEY", (StringBuilder)sb);
        SqlProviderUtil.whereLike((String)"attachmentClassificationIdLike", (String)"a.CLASSIFICATION_ID", (StringBuilder)sb);
        SqlProviderUtil.whereLike((String)"attachmentChannelLike", (String)"a.CHANNEL", (StringBuilder)sb);
        SqlProviderUtil.whereLike((String)"attachmentReferenceLike", (String)"a.REF_VALUE", (StringBuilder)sb);
        SqlProviderUtil.whereLike((String)"description", (String)"DESCRIPTION", (StringBuilder)sb);
        TaskQuerySqlProvider.whereCustomStatements(sb);
        sb.append("<if test='isRead != null'>AND IS_READ = #{isRead}</if> ");
        sb.append("<if test='isTransferred != null'>AND IS_TRANSFERRED = #{isTransferred}</if> ");
        sb.append("<if test='workbasketKeyDomainIn != null'>AND (<foreach item='item' collection='workbasketKeyDomainIn' separator=' OR '>(WORKBASKET_KEY = #{item.key} AND DOMAIN = #{item.domain})</foreach>)</if> ");
        String string3 = string2 = (string = sb.toString());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string2);
        return string;
    }

    private static void whereCustomStatements(StringBuilder sb) {
        StringBuilder stringBuilder = sb;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, null, null, (Object)stringBuilder);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        IntStream.rangeClosed(1, 16).forEach(x -> {
            String collectionIn = "custom" + x + "In";
            String collectionNotIn = "custom" + x + "NotIn";
            String collectionLike = "custom" + x + "Like";
            String column = "CUSTOM_" + x;
            SqlProviderUtil.whereIn((String)collectionIn, (String)column, (StringBuilder)sb);
            SqlProviderUtil.whereLike((String)collectionLike, (String)column, (StringBuilder)sb);
            SqlProviderUtil.whereNotIn((String)collectionNotIn, (String)column, (StringBuilder)sb);
        });
        Object var3_3 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var3_3);
    }

    static {
        TaskQuerySqlProvider.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("TaskQuerySqlProvider.java", TaskQuerySqlProvider.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "queryTaskSummaries", "pro.taskana.task.internal.TaskQuerySqlProvider", "", "", "", "java.lang.String"), 30);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "queryTaskSummariesDb2", "pro.taskana.task.internal.TaskQuerySqlProvider", "", "", "", "java.lang.String"), 71);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "whereCustomStatements", "pro.taskana.task.internal.TaskQuerySqlProvider", "java.lang.StringBuilder", "sb", "", "void"), 374);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "countQueryTasks", "pro.taskana.task.internal.TaskQuerySqlProvider", "", "", "", "java.lang.String"), 132);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "countQueryTasksDb2", "pro.taskana.task.internal.TaskQuerySqlProvider", "", "", "", "java.lang.String"), 155);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "queryTaskColumnValues", "pro.taskana.task.internal.TaskQuerySqlProvider", "", "", "", "java.lang.String"), 187);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "commonSelectFields", "pro.taskana.task.internal.TaskQuerySqlProvider", "", "", "", "java.lang.String"), 245);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "db2selectFields", "pro.taskana.task.internal.TaskQuerySqlProvider", "", "", "", "java.lang.String"), 253);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "checkForAuthorization", "pro.taskana.task.internal.TaskQuerySqlProvider", "", "", "", "java.lang.String"), 271);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "commonTaskObjectReferenceWhereStatement", "pro.taskana.task.internal.TaskQuerySqlProvider", "", "", "", "java.lang.String"), 283);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "commonTaskWhereStatement", "pro.taskana.task.internal.TaskQuerySqlProvider", "", "", "", "java.lang.String"), 307);
    }
}

